/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.util;

import java.io.File;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean elanaiDodgeEnabled;
    public static boolean elanaiDodgeCompat;
    public static int elanaiDodgeMainHandFeatherCost;
    public static int elanaiDodgeOffHandFeatherCost;
    public static boolean addDamageSourceToTippedArrows;
    public static boolean blockFireProjectiles;
    public static boolean healingArrowNoDamage;
    public static float dragonboneBowWitherDamage;
    public static float harmingArrowAmplifier;
    public static float healingArrowAmplifier;
    public static double rangedSilverDamageMultiplier;
    public static boolean tippedArrowFix;
    public static double addedSwingTickCooldown;
    public static double baseAttackDamage;
    public static double baseAttackSpeed;
    public static double baseKnockback;
    public static double baseReachDistance;
    public static int minimumAttackSpeedTicks;
    public static ArrayList<CustomAxe> axes;
    private static String[] axeList;
    public static ArrayList<CustomBow> bows;
    private static String[] bowList;
    public static boolean autoCritOnSneakAttacks;
    public static double baseCritPercentChance;
    public static double baseCritPercentDamage;
    public static double jumpCrits;
    public static double luckCritModifier;
    public static double offHandEfficiency;
    public static boolean sneakingDisablesOffhandAttack;
    public static double versatileFatigueAmount;
    public static boolean gourmandEnchantmentEnabled;
    public static boolean lightningEnchantmentEnabled;
    public static float lightningEnchantmentBaseDamage;
    public static float lightningEnchantmentDamagePerLevel;
    public static float lightningEnchantmentWetModifier;
    public static boolean webbingEnchantmentEnabled;
    public static boolean revitalizeEnchantmentEnabled;
    public static float revitalizePercentPerLevel;
    public static boolean sorceryEnchantmentEnabled;
    public static float sorceryPercentPerLevel;
    public static boolean moreSprint;
    public static double inertiaOnAttack;
    public static boolean fastEquipHotbarOnly;
    public static boolean fastEquipOffhandWeaponsOrShieldsOnly;
    public static double extraAttackHeight;
    public static double extraAttackWidth;
    public static float nauseaAffectsMobs;
    public static double miningFatigueDamageReduction;
    public static float silverArmorDamagesUndeadAttackers;
    public static boolean grassPathingRequiresAnimation;
    public static boolean tillingRequiresAnimation;
    public static boolean strippingBarkRequiresAnimation;
    public static boolean cancelSpartanWeaponryFatigue;
    public static int parryingItemDamage;
    public static boolean cutGrass;
    public static boolean betterKnockback;
    public static double knockUpStrengthMultiplier;
    public static double knockbackStrengthMultiplier;
    public static double sprintingKnockbackAmount;
    private static ArrayList<Class> entityBlackArray;
    private static String[] entityBlacklist;
    private static ArrayList<Class> itemClassWhiteArray;
    private static String[] itemClassWhitelist;
    private static ArrayList<Class> itemClassBlackArray;
    private static String[] itemClassBlacklist;
    private static String[] itemBlacklist;
    public static float alchemizedAmplifier;
    public static double critChancePotionAmplifier;
    public static double critDamagePotionAmplifier;
    public static boolean customPotionEffectsWorkOnSweep;
    public static double strengthPotionMultiplier;
    public static double weaknessPotionMultiplier;
    public static double extraSplashPotionWidth;
    public static double extraSplashPotionHeight;
    public static float bleedingDamagePerTick;
    public static boolean bleedingDurationExtendedIfWet;
    public static boolean bleedingDamageIncreasedIfSprinting;
    public static boolean stackableBleeds;
    private static ArrayList<Class> bleedingPotionEntityArray;
    private static String[] bleedingPotionEntityBlacklist;
    public static ArrayList<Potion> bleedingPotionImmunityPotionArray;
    private static String[] bleedingPotionImmunityPotionEffects;
    public static float bowThudSoundVolume;
    public static float bowStrikeSoundVolume;
    public static boolean playArrowHitSound;
    public static float shieldBashSoundVolume;
    public static float shieldBlockSoundVolume;
    public static float weaponHitSoundVolume;
    public static float weaponSwingSoundVolume;
    public static float weaponEquipAndSheatheSoundVolume;
    public static String[] nonMetalList;
    public static boolean showCritChanceTooltip;
    public static boolean showCritChanceTooltipAsTotal;
    public static boolean showCritDamageTooltip;
    public static boolean showCritDamageTooltipAsTotal;
    public static boolean showKnockbackTooltip;
    public static boolean showKnockbackTooltipAsTotal;
    public static boolean showPotionEffectTooltip;
    public static boolean showReachTooltip;
    public static boolean showReachTooltipAsTotal;
    public static boolean showSweepTooltip;
    public static double fistAndNonWeaponDamageReduction;
    public static double fistAndNonWeaponAttackSpeed;
    public static double fistAndNonWeaponKnockbackReduction;
    public static double fistAndNonWeaponReachReduction;
    public static boolean aetherealizedDamageParticles;
    public static float breathingAnimationIntensity;
    public static float breathingAnimationSpeed;
    public static float cameraPitchSwing;
    public static float rotationYawSwing;
    public static boolean damageParticles;
    public static boolean attackSweepParticles;
    public static boolean attackSweepOverlay;
    public static boolean showShieldCooldownCrosshair;
    public static boolean showDefaultCrosshair;
    public static boolean inverseDamageTiltAngle;
    public static double critsDisableShield;
    public static double parryChanceEffectivness;
    public static boolean enableParrying;
    public static float parryKnockbackAmount;
    public static boolean disableBlockingWhileAttacking;
    public static boolean disableBlockingWhileShieldBashing;
    public static float shieldSilverDamageMultiplier;
    public static boolean shieldBashingTaunts;
    public static ArrayList<CustomShield> shields;
    private static String[] shieldList;
    private static String[] twoDimensionalShieldList;
    public static ArrayList<CustomSword> swords;
    private static String[] swordList;
    public static ArrayList<ConfigWeapon> weapons;
    private static String[] weaponList;
    public static final ConfigWeapon DEFAULT_CUSTOM_WEAPON;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile, Integer.toString(11));
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        String ELANAI = "Elanai";
        elanaiDodgeCompat = config.getBoolean("Elani Dodge 2 Feather Compat", ELANAI, true, "Enable Elaina Dodge 2 feathers compatability");
        elanaiDodgeMainHandFeatherCost = config.getInt("Main Hand Feather Cost", ELANAI, 1, 0, 20, "Mainhand attacks will drain this amount of feathers. Once feathers are depleated, attack speed is halved.");
        elanaiDodgeOffHandFeatherCost = config.getInt("Off Hand Feather Cost", ELANAI, 1, 0, 20, "Offhand attacks will drain this amount of feathers. Once feathers are depleated, attack speed is halved.");
        String ARROWS = "Arrows";
        addDamageSourceToTippedArrows = config.getBoolean("Add Damage Source To Tipped Arrows", ARROWS, true, "If set to true, this setting fixes the bug where Tipped Arrows do not have a damage source. This fix allows Tipped Arrows to have their damage increased through player enchantments that increase Magic Damage, for example.");
        blockFireProjectiles = config.getBoolean("Block Flaming Projectiles", ARROWS, true, "If set to true, flaming projectiles & arrows not set the blocker on fire when blocked (blocking flaming projectiles normally ignites the blocker).");
        healingArrowNoDamage = config.getBoolean("Healing Arrows Deals No Damage", ARROWS, true, "Enable to have Tipped Arrows that cause 'Healing' (including the healing done from 'Harming' arrows against undead) to deal no damage.");
        dragonboneBowWitherDamage = config.getFloat("Dragonbone Wither", ARROWS, 12.0f, 0.0f, 256.0f, "The Dragonbone Arrows do the same damage as a normal arrows. This setting adds magic damage in the form of Wither to the arrows to compensate. Set to 0.0F to disable.");
        harmingArrowAmplifier = config.getFloat("Harming Arrow Amplifier", ARROWS, 6.0f, 0.0f, 256.0f, "How much damage arrows of 'Harming' deal, per level. ");
        healingArrowAmplifier = config.getFloat("Harming Arrow Amplifier", ARROWS, 6.0f, 0.0f, 256.0f, "How much health arrows of 'Healing' restore, per level. ");
        rangedSilverDamageMultiplier = config.getFloat("Ranged Silver Damage", ARROWS, 1.5f, 0.0f, 256.0f, "Damage multiplier for ranged silver weapons and arrows against undead. Set to 1.0F to disable.");
        tippedArrowFix = config.getBoolean("Harming/Healing Arrow Fix", ARROWS, true, "Set to true to remove the following vanilla feature that makes 'Harming' & 'Healing' tipped arrows essentially useless: In vanilla, 'Arrows of Harming' (and 'Arrows of Healing' when used against undead mobs) do not add any amount of damage to the arrow. Instead, the arrow damage is first calculated, then checked to see if it is below 12 damage. If the arrow's damage is less than 12, the 'Harming' effect of the arrow makes up the difference to ensure the arrow does exactly 12 damage. Therefore, an unenchanted bow cannot deal more than 12 damage using 'Harming' (or 'Healing' to undead) arrows. However, if the arrow would deal more than 12 damage, the harming effect is entirely neutralized. This means that bows enchanted with Power I through Power III very rarely utilize the arrow at full charge, and any Power level above III never utilizes 'Arrows of Harming' effectively at full charge when against unarmored mobs/players.");
        String ATTRIBUTES = "Attributes (Advanced settings)";
        addedSwingTickCooldown = config.get(ATTRIBUTES, "Added Attack Speed Tick Cooldown", 0.5, "Add partial ticks to all attack swing cooldown. This defaults to 0.5, which rounds up all swing cooldowns. A swing cooldown of 12.5 ticks would instead become 13 ticks.").getDouble();
        baseAttackDamage = config.get(ATTRIBUTES, "Attribute Base Attack Damage", 1.0, "Base ATTACK_DAMAGE attribute for the player. Vanilla is 1.0F. If you want to nerf unarmed & non-weapon damage, instead adjust the setting 'Unarmed & Non-Weapon Damage'.").getDouble();
        baseAttackSpeed = config.get(ATTRIBUTES, "Attribute Base Weapon Attack Speed", 4.0, "Base ATTACK_SPEED attribute for the player. Vanilla is 4.0F. This value does NOT affect unarmed and non-weapons. An attack speed of 4.0 means 4 attacks per second. Higher values mean faster attack swing recovery. Attack speed formula --> 20 / attackSpeed. For example, a 1.6 attack speed takes 12.5 ticks to recover after an attack swing, which means 1.6 attacks per second. 0.8 means 25 ticks to recover after an attack swing. 4.0 means 5 ticks to recover after an attack.").getDouble();
        baseCritPercentChance = config.get(ATTRIBUTES, "Base Critical Percent Chance", 0.05, "Base chance of landing a critical strike with an attack. Default 0.05, meaining 5% critical strike chance. Set to a negative number to disable random crit chance and return to the vanilla ways.").getDouble();
        baseCritPercentDamage = config.get(ATTRIBUTES, "Base Critical Percent Damage", 1.5, "How much damage crits do (multiplier). Default 1.5F, meaning crits do 50% extra damage (150% of total damage).").getDouble();
        baseReachDistance = config.get(ATTRIBUTES, "Attribute Base Reach Distance", 4.0, "Base REACH_DISTANCE attribute for the player. Vanilla is 4.0F in singleplayer, and increased to 5.0F in multiplayer to account for latency. This reach distance config is only for attacking distance, not mining distance. Set to 0.0 to disable this setting completely and instead use the vanilla reach distance value instead.").getDouble();
        minimumAttackSpeedTicks = config.getInt("Minimum Attack Speed Tick Cooldown", ATTRIBUTES, 8, 5, 20, "The minimum cooldown (in ticks) for an attack swing cooldown. The default for this setting is 8, which means the minimum attack speed cooldown is 8 ticks. This translates to the maximum attack speed of a weapon being 2.5 and any attack speed value higher than 2.5 will not affect how fast the weapon attacks (unless the player attack speed is slowed or affected by mining fatigue, then higher attack speed values counteract the debuff).");
        String CRITICAL = "Critical Strikes";
        autoCritOnSneakAttacks = config.getBoolean("Auto Critical On Sneak Attacks", CRITICAL, true, "Automatically critical strike a mob when you are not their attack target or revenge target.");
        critsDisableShield = config.get(CRITICAL, "Critical Strikes Disable Shields", 3.0, "Critical strikes with any weapon disable shields, similar to how axes disable shields for 100 ticks. The shield disable duration is based off of damage, for example, having this setting at 3.0, an attack dealing 7.0 damage to a blocker would disable a shield for 21 ticks. Set to 0.0 to disable this feature.").getDouble();
        jumpCrits = config.get(CRITICAL, "Add Critical Chance On Falling", 0.1, "Adds additional critical strike chance when the player is falling, like in vanilla. Set to 0.0F to disable.").getDouble();
        luckCritModifier = config.get(CRITICAL, "Luck Affects Critical Chance", 0.1, "This setting allows the LUCK attribute to affect critical strike chance. Formula = ( LUCK * luckCritModifier ). If luckCritModifier is 0.1 then 2 LUCK would give 20% crit chance. Set to 0.0 to disable.").getDouble();
        String DUALWIELD = "Dual-Wielding";
        offHandEfficiency = config.get(DUALWIELD, "Offhand Efficiency", 0.75, "The percent efficiency of an attack with offhanded weapon    -->   damage * efficiency.").getDouble();
        sneakingDisablesOffhandAttack = config.getBoolean("Sneaking Disables Offhand Attack", DUALWIELD, true, "If set to true, attacking with your offhand is disabled while sneaking. The purpose of this is to add compatibility to mods such as 'CarryOn' or 'Effortless Building' where you need to use certian right-click functionality.");
        versatileFatigueAmount = config.get(DUALWIELD, "Versatile Fatigue Amount", 0.3, "How much of a slow to attack speed is applied when dual-wielding with one VERSATILE weapon. Default 0.3, which translates to a 30% slower attack speed. Dual-weilding with two VERSATILE weapons will slow attack speed by 45%.").getDouble();
        miningFatigueDamageReduction = config.get(DUALWIELD, "Mining Fatigue Damage Reduction", 0.0, "Reduces the damage dealt of an attack per level of Mining Fatigue. For example, if this setting is set to 0.25, then Mining Fatigue II reduces player damage by 50%. Set 0.0 to disable.").getDouble();
        String ENCHANTMENTS = "Enchantments";
        gourmandEnchantmentEnabled = config.getBoolean("Gourmand Enchantment Enabled", ENCHANTMENTS, true, "Set to true to enable the Gourmand enchantment.");
        lightningEnchantmentEnabled = config.getBoolean("Lightning Enchantment Enabled", ENCHANTMENTS, true, "Set to true to enable the Lightning enchantment.");
        lightningEnchantmentBaseDamage = config.getFloat("Lightning Enchantment Base Damage", ENCHANTMENTS, 3.0f, 0.0f, 256.0f, "Lightning enchantment base damage. A base of 3 and 2 per level means Lightning I deals 5 damage.");
        lightningEnchantmentDamagePerLevel = config.getFloat("Lightning Enchantment Damage Per Level", ENCHANTMENTS, 2.0f, 0.0f, 256.0f, "Lightning enchantment damage per level. A base of 3 and 2 per level means Lightning V deals 13 damage.");
        lightningEnchantmentWetModifier = config.getFloat("Lightning Enchantment Wet Modifier", ENCHANTMENTS, 1.5f, 0.0f, 256.0f, "This number is multiplied by the total lightning damage when targets are wet. 1.5F means 50% more damage.");
        revitalizeEnchantmentEnabled = config.getBoolean("Revitalize Enchantment Enabled", ENCHANTMENTS, true, "Set to true to enable the Revitalize enchantment.");
        revitalizePercentPerLevel = config.getFloat("Revitalize Healing Percentage Per Level", ENCHANTMENTS, 0.2f, 0.0f, 16.0f, "The damage multipler for the Revitalize enchantment, per level. 0.2F means a 20% increase in healing received per level.");
        sorceryEnchantmentEnabled = config.getBoolean("Sorcery Enchantment Enabled", ENCHANTMENTS, true, "Set to true to enable the Sorcery enchantment.");
        sorceryPercentPerLevel = config.getFloat("Sorcery Damage Percentage Per Level", ENCHANTMENTS, 0.1f, 0.0f, 16.0f, "The damage multipler for the Sorcery enchantment, per level. 0.1F means a 10% increase in magic damage per level.");
        webbingEnchantmentEnabled = config.getBoolean("Webbing Enchantment Enabled", ENCHANTMENTS, true, "Set to true to enable the Webbing enchantment.");
        String OTHER = "Other";
        moreSprint = config.getBoolean("Attack & Sprint", OTHER, true, "Attacking an enemy while sprinting will no longer interrupt your sprint.");
        inertiaOnAttack = config.get(OTHER, "Intertia on Attack", 0.5, "Multiplies the player speed by this amount when they swing a weapon. Set to 1.0 to disable.").getDouble();
        fastEquipHotbarOnly = config.getBoolean("Fast Equip Hotbar Only", OTHER, false, "Set to true to have Fast Equip use only items in the hotbar instead of the entire inventory. The Fast Equip keybind is set to X, check the minecraft keybind settings to change this.");
        fastEquipOffhandWeaponsOrShieldsOnly = config.getBoolean("Fast Equip Offhand Weapons Or Shields Only", OTHER, false, "Set to true to have Fast Equip only find weapons or shields, and not tools, for the offhand. Tools will still be found and equipped in the mainhand if no weapons are found. The Fast Equip keybind is set to X, check the minecraft keybind settings to change this.");
        extraAttackWidth = config.get(OTHER, "Extra Attack Width", 0.5, "How wide, in blocks, the hitbox will be extended for melee attacks. Increase the value of this setting to make the XZ-accuracy of attacks more forgiving. 1.0 is equal to an additional block width on XZ sides.").getDouble();
        extraAttackHeight = config.get(OTHER, "Extra Attack Height", 1.0, "How high, in blocks, the hitbox will be extended for melee attacks. Increase the value of this setting to make the Y-accuracy of attacks more forgiving. 1.0 is equal to an additional block height above the entity.").getDouble();
        nauseaAffectsMobs = config.getFloat("Nausea Affects Mobs", OTHER, 2.2f, 0.0f, 256.0f, "Setting to have Nausea & Blindness affect mobs. If a mob has a height equal to or less than this value, it will be affected by Blindess and Nausea potion effects, which causes them to often lose their target and stumble around. Set to 0.0F to disable.");
        silverArmorDamagesUndeadAttackers = config.getFloat("Silver Armor Damage", OTHER, 1.5f, 0.0f, 256.0f, "Thorns, but for undead. How much damage undead attackers will take against an entity wearing Silver armor per piece of Silver armor. Setting this to 1.5F and wearing 2 pieces of Silver armor deals 3.0F damage to undead attackers. Silver weapons get a damage bonus, so why not add a special interaction with Silver armor? Set to 0.0F to disable.");
        grassPathingRequiresAnimation = config.getBoolean("Digging Grass Paths Requires Animation", OTHER, true, "If set to true, shoveling grass paths requires an animation. Shovels with a faster attack speed will path land faster.");
        tillingRequiresAnimation = config.getBoolean("Tilling Land Requires Animation", OTHER, true, "If set to true, tilling land requires an animation. Hoes with a faster attack speed till land faster.");
        strippingBarkRequiresAnimation = config.getBoolean("Stripping Bark Requires Animation", OTHER, false, "CURRENTLY NOT WORKING. If set to true, stripping bark requires an animation. Axes with a faster attack speed strip bark faster. Enable this setting if you have future MC installed which allows stripping of bark.");
        cancelSpartanWeaponryFatigue = config.getBoolean("Cancel Spartan Weaponry Fatigue", OTHER, true, "Set to true to disable weapon fatigue from Spartan Weaponry, this mod instead handles two-handed and versatile weapons.");
        parryingItemDamage = config.getInt("Parrying Item Damage", OTHER, 1, 0, 256, "How much damage is dealt to the weapon when an attack is parried.");
        cutGrass = config.getBoolean("Cut Grass", OTHER, true, "Cut grass when attacking, disable to prevent grief on protection servers.");
        String KNOCKBACK = "Knockback";
        betterKnockback = config.getBoolean("Better Knockback", KNOCKBACK, true, "Enable have the KNOCKBACK_RESISTANCE attribute instead reduce the strength of knockback effects, rather than reducing the chance to not be knocked back. (By default in Minecraft, a knockback_resistance of 0.6 means a 60% chance for that entity to NOT be knocked back from an attack. However, if this setting is true, a knockback_resistance of 0.6 instead means the distance/effect of being knocked back are 60% less far/powerful for that entity.");
        knockUpStrengthMultiplier = config.get(KNOCKBACK, "knock Up Strength Multiplier", 0.4, "Multiply the motionY amount of knockback by this amount. Set to 0.5 by default to reduce the motionY by 50%. Does nothing if betterKnockback is disabled.").getDouble();
        knockbackStrengthMultiplier = config.get(KNOCKBACK, "knockback Strength Multiplier", 1.0, "Multiply the motionXZ amount of knockback by this amount. This setting is pretty sensitive, and values below 0.5 have almost no visible knockback.").getDouble();
        sprintingKnockbackAmount = config.get(KNOCKBACK, "Sprinting Knockback Amount", 0.4, "Increases the knockback of an attack when sprinting. For example, setting this to 2.0F is the same knockback amount as Knockback II.").getDouble();
        String PARRYING = "Parrying";
        parryChanceEffectivness = config.get(PARRYING, "Parry Chance Effectivness", 2.0, "Incoming attacks with attack damage less than the attack damage of a parrying weapon are ALWAYS blocked. The attack damage of a weapon is used to calculate the chance of parrying an attack. This setting counts as a multiplier to attack damage for determining the chance to parry an attack. The higher the ATTACK_DAMAGE you have (whether from buffs or your weapon), the higher chances of parrying. This essentially increases the effectivness of parrying with two-handed weapons which often have higher base attack damage. This also lets weapon material tiers scale to difficulty! Higher damage incoming attacks have a lower the chance of parried. For example, if this setting is set at 2.0 and the parrying weapon has 5 attack damage, an incoming attack of 7 damage has a 7/(2.0*5) or 70% chance of NOT being parried. If this setting is set to 2.0, then a weapon with 5 attack damage can block an attack of up to 10 damage, however, those chances are very unlikely.").getDouble();
        parryKnockbackAmount = config.getFloat("Parry Knockback Amount", PARRYING, 0.5f, 0.0f, 1.0f, "How far the attacker is knockbacked after a parry. Setting this to 2.0F is the same knockback amount as Knockback II. This value is affected by knockbackStrengthMultiplier and knockUptrengthMultiplier when betterKnockback is enabled.");
        enableParrying = config.getBoolean("Enable Parrying", PARRYING, true, "Set to false to disable all parrying mechanics from this mod. If enabled, you must specify which weapons can and can not parry in the Custom Weapon Tweaker config.");
        String POTIONS = "Potions";
        alchemizedAmplifier = config.getFloat("Aetherealized Potion Damage", POTIONS, 0.2f, 0.0f, 1.0f, "The percentage of your physical damage that is converted to magical by the Aetherealized potion, per level. 0.2 means 20% of your physical damage (per level) is converted to magic damage.");
        critChancePotionAmplifier = config.get(POTIONS, "Percision Potion Chance", 0.1, "The additive percent increase to your critical strike chance that the Percision potion adds, per level. 0.1 means add 10% critical strike chance (per level) to your base critical strike chance.").getDouble();
        critDamagePotionAmplifier = config.get(POTIONS, "Brutality Potion Damage", 0.1, "The additive percent increase to your critical strike damage that the Brutality potion adds, per level. 0.1 means add 10% critical strike damage (per level) to your base critical strike damage.").getDouble();
        customPotionEffectsWorkOnSweep = config.getBoolean("Weapon Potion Effects Work With Sweep", POTIONS, true, "Enable have custom Potion Effects from custom weapons work with Sweep and apply on swept targets.");
        strengthPotionMultiplier = config.get(POTIONS, "Strength Potion Damage", 0.05, "Changes the Strength potion to be a percentage damage increase instead of a flat increase. If set to 0.05, then a Potion of Strength (+3 Attack Damage) will instead increase damage dealt by 15%. Set to 0.0 to disable.").getDouble();
        weaknessPotionMultiplier = config.get(POTIONS, "Weakness Potion Damage", 0.1, "Changes the Weakness potion to be a percentage damage decrease instead of a flat decrease. If set to 0.1, then a Potion of Weakness (-4 Attack Damage) will instead decrease damage dealt by 40%. Set to 0.0 to disable.").getDouble();
        extraSplashPotionWidth = config.get(POTIONS, "Extra Splash Potion Width", 0.0, "Additional splash potion width.").getDouble();
        extraSplashPotionHeight = config.get(POTIONS, "Extra Splash Potion Height", 0.2, "Additional splash potion height.").getDouble();
        bleedingDamagePerTick = config.getFloat("Bleeding Damage Per Tick", POTIONS, 0.5f, 0.0f, 256.0f, "The amount of damage bleeding does, per level, per second.");
        stackableBleeds = config.getBoolean("Stackable Bleeds", POTIONS, true, "Enable to have bleeds applied to bleeding targets refresh their duration and add their amplifier.");
        bleedingDurationExtendedIfWet = config.getBoolean("Bleeding Duration Extended If Wet", POTIONS, true, "If true, being submerged in water or wet from rain extends the current bleeding duration on that entity.");
        bleedingDamageIncreasedIfSprinting = config.getBoolean("Bleeding Duration Extended If Wet", POTIONS, true, "If true, sprinting has a small chance to increase the current bleeding damage on that entity.");
        bleedingPotionEntityBlacklist = config.getStringList("Bleeding Potion - (Class) Entity Blacklist", POTIONS, bleedingPotionEntityBlacklist, "Entity Class Blacklist for the Bleeding Potion Effect.\nBlacklisted entity classes for the bleeding effect. Any entity that extends this class is immune to bleeding!");
        bleedingPotionImmunityPotionEffects = config.getStringList("Bleeding Potion - (Resource Location) Potion Effect Immunity", POTIONS, bleedingPotionEntityBlacklist, "Potion Effect Resource Location for immunity to the Bleeding Potion Effect.\nIf an entity is under the effect by a potion listed here, that entity will not take damage from bleeding.");
        String SOUND = "Sound";
        bowThudSoundVolume = config.getFloat("Bow Thud Sound Volume", SOUND, 1.0f, 0.0f, 2.0f, "The volume of the 'thud' sound that plays when you land a fully-charged hit.");
        bowStrikeSoundVolume = config.getFloat("Bow Strike Sound Volume", SOUND, 1.0f, 0.0f, 2.0f, "The volume of the 'strike' sound that plays when you land a hit.");
        weaponSwingSoundVolume = config.getFloat("Weapon Swing Sound Volume", SOUND, 1.0f, 0.0f, 2.0f, "The volume of the sound when you swing your weapon.");
        weaponHitSoundVolume = config.getFloat("Weapon Hit Sound Volume", SOUND, 1.0f, 0.0f, 2.0f, "The volume of the sound that plays when you land a weapon hit.");
        weaponEquipAndSheatheSoundVolume = config.getFloat("Weapon Equip and Sheate Sound Volume", SOUND, 1.0f, 0.0f, 2.0f, "The volume of the sound that plays when you equip or sheathe a weapon.");
        shieldBashSoundVolume = config.getFloat("Shield Bash Sound Volume", SOUND, 1.0f, 0.0f, 2.0f, "The volume of the sound that plays when you shield bash.");
        shieldBlockSoundVolume = config.getFloat("Shield Block Sound Volume", SOUND, 1.0f, 0.0f, 2.0f, "The volume of the sound that plays when block with a shield.");
        playArrowHitSound = config.getBoolean("Arrow Impact Sound", SOUND, true, "Arrows will make an impact sound when they hit an entity, regardless of range.");
        nonMetalList = config.getStringList("Non Metal List", SOUND, nonMetalList, "Weapons that are considered non-metal for swinging and hitting sound purposes. If the weapon contains the string, such as 'wood' or 'stone' it will not make a metal sound.");
        String TOOLTIPS = "Tooltips";
        showCritChanceTooltip = config.getBoolean("Show Crit Chance Tooltip", TOOLTIPS, true, "If set to true, display Critical Chance on weapon tooltips.");
        showCritChanceTooltipAsTotal = config.getBoolean("Show Crit Chance Tooltip As Total", TOOLTIPS, true, "If set to true, display Critical Chance as the total weapon Critical Chance (25% Critical Chance), instead of additional Critical Chance (+15% Critical Chance).");
        showCritDamageTooltip = config.getBoolean("Show Crit Damage Tooltip", TOOLTIPS, true, "If set to true, display Critical Damage on weapon tooltips.");
        showCritDamageTooltipAsTotal = config.getBoolean("Show Crit Damage Tooltip As Total", TOOLTIPS, false, "If set to true, display Critical Chance as the total weapon Critical Damage (200% Critical Damage), instead of additional Critical Damage (+50% Critical Damage).");
        showPotionEffectTooltip = config.getBoolean("Show Potion Effect Tooltip", TOOLTIPS, true, "If set to true, display custom Potion Effects on weapon tooltips.");
        showKnockbackTooltip = config.getBoolean("Show Knockback Tooltip", TOOLTIPS, true, "If set to true, display Knockback amount on weapon tooltips.");
        showKnockbackTooltipAsTotal = config.getBoolean("Show Knockback Tooltip As Total", TOOLTIPS, true, "If set to true, display Knockback as the total weapon Knockback (1.5 Knockback), instead of additional Reach Distance (+0.5 Knockback).");
        showReachTooltip = config.getBoolean("Show Reach Tooltip", TOOLTIPS, true, "If set to true, display Reach Distance on weapon tooltips. For advanced modpack makers, if another mod is adding Reach Distance on a weapon, I recommend blanking out the fields you want gone in the lang file of that mod using Resource Loader.");
        showReachTooltipAsTotal = config.getBoolean("Show Reach Tooltip As Total", TOOLTIPS, false, "If set to true, display Reach Distance as the total weapon Reach Distance (5.0 Reach Distance), instead of additional Reach Distance (+1.0 Reach Distance).");
        showSweepTooltip = config.getBoolean("Show Sweep Tooltip", TOOLTIPS, true, "If set to true, display the Sweep tooltip. For advanced modpack makers, if another mod is adding Reach Distance on a weapon, I recommend blanking out the fields you want gone in the lang file of that mod using Resource Loader.");
        String UNARMED = "Unarmed";
        fistAndNonWeaponAttackSpeed = config.get(UNARMED, "Unarmed & Non-Weapon Attack Speed", 2.0, "Attack speed for unarmed and non-weapon attacks. In vanilla, the attack speed of an unarmed and non-weapon attack is 4.0 (4 attacks per second). Setting this config value to 2.0 equals 2 attacks per second. This config is to lower the DPS of unarmed and non-weapon attacks, as they technically have a higher DPS than wooden tools when 'Hurt Resistant Time' is removed, so unarmed and non-weapon attack speed should be decreased.", 0.1, 4.0).getDouble();
        fistAndNonWeaponDamageReduction = config.get(UNARMED, "Unarmed & Non-Weapon Damage Reduction", 0.0, "Reduce damage from unarmed and non-weapon attacks. The damage of unarmed and non-weapons is reduced by this flat amount.", 0.0, baseAttackDamage).getDouble();
        fistAndNonWeaponKnockbackReduction = config.get(UNARMED, "Unarmed & Non-Weapon Knockback Reduction", 0.5, "Reduce the knockback from unarmed and non-weapon attacks. The knockback of unarmed and non-weapons is reduced by this flat amount.", 0.0, baseKnockback).getDouble();
        fistAndNonWeaponReachReduction = config.get(UNARMED, "Unarmed & Non-Weapon Reach Reduction", 0.5, "Reduce the attack range from unarmed and non-weapon attacks. The range of unarmed and non-weapons is reduced by this flat amount.", 0.0, 4.0).getDouble();
        String VISUAL = "Visual";
        aetherealizedDamageParticles = config.getBoolean("Aetherealized Damage Particles", VISUAL, true, "Enable to have the Aetherealized potion create a ring of particles around the target when struck.");
        breathingAnimationIntensity = config.getFloat("Breathing Animation Intensity", VISUAL, 0.02f, 0.0f, 1.0f, "How fast items move up and down for the breathing animation.");
        breathingAnimationSpeed = config.getFloat("Breathing Animation Speed", VISUAL, 0.02f, 0.0f, 1.0f, "How far items move up and down for the breathing animation.");
        showShieldCooldownCrosshair = config.getBoolean("Show Shield Cooldown on Crosshair", VISUAL, false, "Set to true to show the shield cooldown/energy indicator. This setting does nothing when showDefaultCrosshair is set to true.");
        inverseDamageTiltAngle = config.getBoolean("Inverse Blocking/Parrying Tilt", VISUAL, true, "Inverse the angle for Damage Tilt for blocking and parrying.");
        showDefaultCrosshair = config.getBoolean("Show Default Crosshair", VISUAL, false, "Set to true to completely disable the new crosshair, and show the default crosshair. The attack energy/cooldown indicator can also be enabled/disabled in the Minecraft settings.");
        cameraPitchSwing = config.getFloat("Camera Vertical Swing", VISUAL, 0.06f, 0.0f, 1.0f, "This value controls the up-and-down (vertical) rotation of the camera when you swing a weapon. May cause slight motion sickness if set too high. Set to 0.0F to disable.");
        rotationYawSwing = config.getFloat("Camera Horizontal Swing", VISUAL, 0.16f, 0.0f, 1.0f, "This value controls the left-to-right (horizontal) rotation of the camera when you swing a weapon. May cause slight motion sickness if set too high. Set to 0.0F to disable.");
        damageParticles = config.getBoolean("3D Damage Particles", VISUAL, true, "Display heart damage particles (this is a vanilla feature, this option is here for those who wish to disable it).");
        attackSweepParticles = config.getBoolean("3D Attack Sweep Particles", VISUAL, true, "Display 3D sweep particles on a successful attack.");
        attackSweepOverlay = config.getBoolean("2D Attack Sweep Overlay", VISUAL, true, "Display 2D attack lines across the screen when you swing a weapon.");
        String AXE = "Axes";
        axeList = config.getStringList("Axe Tweaker", AXE, axeList, "Adjust the axes/weapons that have are able to disable shields.[Axe Substring=battleaxe_]\t\t[Disable Duration=90]\n\nThe [Axe Substring] field can be simply 'battleaxe_' so that all weapons containing the word 'battleaxe_' will be affected, such as 'spartanweaponry:battleaxe_wooden' or 'spartanweaponry:battleaxe_'\nThe [Disable Duration] field is how long a shield will be disabled for if struck by this axe/weapon.'\n");
        String BOW = "Bows";
        bowList = config.getStringList("Bow Tweaker", BOW, bowList, "Adjust the base damage and velocity of all arrows shot from specific bows, or adjust the draw speed ticks of bows. Example below:\n\n[Bow=minecraft:bow]    [Damage Multiplier=1.00]    [Velocity Multiplier=0.90]    [Ticks=0]\n\n[Bow] must include both the resource domain and path for the bow, such as 'minecraft:bow' or 'spartanweaponry:longbow_iron'\n[Damage Multiplier] multiplies the damage of arrows.\nThe base damage of an arrow is 2, and a fully charged shot deals between 8 and 10 damage.\nThe formula for the final damage of a bow (using a vanilla flint arrow with 2 baseDamage) is    -->    (baseVelocity * baseDamage]) + random.nextInt(baseVelocity * baseDamage / 2) + 2    -->    (~3 * 2) + random.nextInt(~3 * 2 / 2) + 2\nFor example, if you set [Damage Multiplier] to 1.5 (meaning the damage of a vanilla flint arrow would now be 3 instead of 2) the final damage of that fully-charged shot would be 11 to 14.5 damage.\n[Velocity Multiplier] multiplies the velocity of arrows.\nThe velocity of a fully-charged arrow (meaning a critical, with a trail of particles) averages 3.\nFor example, if you set [Velocity] to 1.2 (meaning the velocity of all arrows shot from this bow is now 3.6 instead of 3) the final damage of that fully-charged shot (with a base damage of 2) would be 9.2 to 11.8 damage. Velocity affects damage!\nThe following entry    -->    [Bow=spartanweaponry:crossbow_wood]    [Damage Multiplier=0.80]    [Velocity=1.25]    [Ticks=0]    -->    would cut the base damage of crossbow by 20%, but increase the velocity of the arrows/bolts shot by it by 25%.\nThis entry would keep the damage of a fully-charged shot roughly the same, however, the velocity would be greatly increased.\nThe maximum velocity multiplier is 1.5, anything over this value will do nothing! The reason being is that the arrow travels too fast, leading to visual anomalies.\nIf the arrows look like they are swerving off to the side, it means the velocity is too high and you'll have to lower it.\nLongbows from SpartanWeaponry already have a velocity multiplier of 1.2, try not to increase velocity much more.\nCrossbows from SpartanWeaponry already have a velocity multiplier of 1.5, do not increase it any further!\nSpartanWeaponry now has a config that fuctions very similar to this one, so use this bow tweaker config for other mods that add bows or for editing the vanilla bow.\n[Ticks] adds or subtracts ticks from the draw speed of bows. The draw speed in ticks of a vanilla bow is 20.\nSetting [Ticks] to 20 would Float the amount of time it takes to fully draw back a vanilla bow.\nSetting [Ticks] to -10 would reduce the amount of time it takes to fully draw back a vanilla bow by half.\n\nMore info on bows can be found here   ->   https://minecraft.fandom.com/wiki/Bow#Weapon");
        String WEAPON = "Custom Weapons";
        weaponList = config.getStringList("Custom Weapon Tweaker", WEAPON, weaponList, "Adjust the properties of melee weapons, such as animation, property, sweep, reach, critical strike chance, critical strike damage, and on-hit potion effects. The [Potion Effect] field is optional. Example below:\n\n[Weapon Substring=pike_]    [Sound Type=POLEARM]    [Animation=STAB]    [Property=TWOHAND]    [Sweep=0]    [Additional Reach=1.0]    [Crit Chance=10]    [Additional Additional Crit Damage=0]    [Potion Effect=minecraft:poison,1,60]\n\nThe [Weapon Substring] field can be simply 'pike_' so that all weapons containing the word 'pike_' will be affected, such as 'spartanweaponry:pike_wooden' or 'spartanweaponry:pike_iron'\nIf you would rather adjust properties of a specific weapon, you may put the resource path such as 'glaive_diamond' (do not include the resource domain such as 'spartanweaponry:')\nThe order in this list is important, as it is greedy and will find the first string match! The instance [Weapon Substring=glaive_diamond] should be above the instance [Weapon Substring=pike_] for example.\n\nThe [Sound Type] field takes the values BLADE, BLUNT, AXE, POLEARM and changes how the weapon sounds.\nBLADE should be assigned to bladed weapons such as swords, sabers, and rapiers.\nBLUNT should be assigned to heavy blunt weapons such as maces, warhammers, and hammers.\nAXE should be assigned to weapons such as axes, battleaxes, and pickaxes, and shovels, and hoes.\nPOLEARM should be assigned to all polearms, such as spears, pikes, glaives, and staves.\n\n The [Animation] field takes the values SWEEP, CHOP, or STAB and changes the attack animations of weapons.\nSWEEP is an animation that sweeps across the lower screen. Additionally, it increases the width of the attack's hitbox based off the weapon's sweep level. This animation is best on weapons with [Sweep].\nCHOP is very similar to minecraft's default attack animation, and works well with weapons such as axes, hammers, or pickaxes.\nSTAB is an animation that rotates the weapon and then extends it forwards. This animation is best suited for weapons such as spears, pikes, rapiers, and lances.\n\nThe [Sweep] field adds sweep to a weapon.\nSet [Sweep] to 0 to disable sweep on a weapon.\nSet [Sweep] to 1 to have that weapon deal 1.0 damage to sweep targets.\nSet [Sweep] to 2 to have that weapon deal 25% damage to sweep targets.\nSet [Sweep] to 3 to have that weapon deal 50% damage to sweep targets.\nSet [Sweep] to 4 to have that weapon deal 75% damage to sweep targets.\nSet [Sweep] to 5 to have that weapon deal 100% of the damage dealt to the main target to the other sweep targets.\nFor each level of sweep above 1, the weapon deals 25% of the main target damage to sweep targets, with a minimum of 1.0 damage.\nA sweep level higher than 5 (through this config or through the Sweeping enchantmet) does not do any sweep damage, however, it still increases the sweep radius.\n\nThe [Property] field takes the values ONEHAND, VERSATILE, MAINHAND, or TWOHAND.\nONEHAND can attack in either hand and incur no fatigue penalties.\nVERSATILE can attack in either hand, however, incurs a fatigue penalty if both hands are occupied.\nMAINHAND can only attack in the main hand. This is used for weapons such as spears, where a shield/ spear combination makes sense but dual-weilding spears does not.\nTWOHAND disables the other hand when it is equipped.\n\nThe [Additional Reach] field is the reach distance for weapons.\nSetting [Additional Reach] to 1.0 for a weapon would mean a reach distance of 5.0 (1.0 + base reach distance) blocks for that weapon.\n\nThe [Crit Chance] field is the critical chance for weapons.\nSetting [Crit Chance] to 0.1 for a weapon would mean critical strike chance is 10%.\n\nThe [Additional Crit Damage] field is the critical damage multiplier for weapons.\nSetting [Additional Crit Damage] to 50 for a weapon would mean critical strike damage deals an additional 50% damage.\n\nThe [Parry] field enables or disables parrying.\nThe setting 'Disable Parrying' must be set to false in the config to allow weapons to parry.\nSetting [Parry] to true allows the weapon to parry, and setting [Parry] to false disables parrying for that weapon.\n\nThe [Potion Effect] field is optional! It gives weapons a chance to apply a potion effect when you attack an entity with a weapon.\nOnly one potion effect is supported. The order goes for the potion effect  ->  chance, afflict/receive, resource location, power, duration, ambient, show particles.\nThe 'Chance on hit:' tag for weapons can instead be changed to 'Critical Strike:' if chance is set to the value CRIT or 0.0. Instead of a chance on hit, the potion effect is applied on a critical strike. This setting allows for some interesting crit builds.\nSetting afflict/receive to AFFLICT causes the victim to gain the potion effect. Setting afflict/receive to RECEIVE causes the attacker gain the potion effect.\nDuration is in ticks. There are 20 ticks per second. A duration of 100 would apply the potion effect for 5 seconds.\n\n[Potion Effect=1.0,AFFLICT,minecraft:poison,2,600,false,true] -> 100% Chance on hit: Afflict Poison II for 30 seconds.\n[Potion Effect=0.5,AFFLICT,minecraft:instant_damage,3,0,false,true] -> 50% Chance on hit: Afflict Harming III.\n[Potion Effect=0.1,AFFLICT,minecraft:slowness,1,100,false,true] -> 10% Chance on hit: Afflict Slowness I for 5 seconds.\n[Potion Effect=0.2,RECEIVE,minecraft:swiftness,2,160,false,true] -> 20% Chance on hit: Receive Swiftness II for 8 seconds.\n[Potion Effect=0.01,RECEIVE,minecraft:instant_health,2,0,false,true] -> 1% Chance on hit: Receive Instant Health II.\n[Potion Effect=CRIT,AFFLICT,bettercombat:bleeding,1,100,false,false] -> Critical strike: Afflict Bleeding I for 5 seconds.\n[Potion Effect=CRIT,RECEIVE,bettercombat:brutality,1,200,false,false] -> Critical strike: Receive Brutality I for 10 seconds.\n");
        String SHIELD = "Custom Shields";
        shieldBashingTaunts = config.getBoolean("Shield Bashing Taunts", SHIELD, true, "Shield bashing an enemy taunts them, setting the attacker as the attack target.");
        disableBlockingWhileAttacking = config.getBoolean("Disable Blocking While Attacking", SHIELD, true, "Disable blocking while attacking with the mainhand.");
        disableBlockingWhileShieldBashing = config.getBoolean("Disable Blocking While Shield Bashing", SHIELD, false, "Disable blocking while shield bash is on cooldown.");
        shieldSilverDamageMultiplier = config.getFloat("Shield Silver Damage", SHIELD, 1.5f, 0.0f, 256.0f, "Multiplier for silver shield bash against undead. Set to 1.0F to disable.");
        shieldList = config.getStringList("Shield Tweaker", SHIELD, shieldList, "Adjust the damage, knockback amount, and cooldown on shield bashing. Example below:\n\n\n\n[Shield=minecraft:shield]    [Damage=1.0]    [Knockback=1.0]    [Cooldown=30]\n\nThe [Shield] field must include both the resource domain and path for the shield, such as 'minecraft:shield' or 'spartanshields:shield_basic_wood'\nThe [Damage] field is clamped be between 0.0 and 326.0, and is the amount of damage bashing with a shield does to a target.\nThe [Knockback] field is clamped between 0.0 and 326.0 and determines how far back the enemy is thrown when shield bashed.\nThe [Cooldown] field is clamped between 0 and 255, and is how long the shield is put on cooldown after a shield bash.");
        twoDimensionalShieldList = config.getStringList("2D Shield String List", SHIELD, twoDimensionalShieldList, "2D shields list. This setting helps position 2D shields from other mods correctly.");
        String SWORD = "Swords";
        swordList = config.getStringList("Sword Tweaker", SWORD, swordList, "Adjust the Attack Speed of vanilla swords.\n\nThis setting only for vanilla swords! The mod 'Material Changer' allows you change the Attack Speed on all weapons except swords.\nIf a mod does not allow you to adjust the Attack Speed on their custom modded swords, you may use this config to do so.\nThe [Sword Substring] field can be simply '_sword' so that all weapons containing the word '_sword' will be affected, such as 'minecraft:diamond_sword' or 'minecraft:iron_sword'\nIf you would rather adjust properties of a specific sword, you may put the resource path such as 'diamond_sword' (do not include the resource domain such as 'minecraft:')\nThe order in this list is important, as it is greedy and will find the first string match! The instance [Sword Substring=diamond_sword] should be above the instance [Sword Substring=_sword] for example.\n\nThe [Additional Attack Speed=0.2] field is a value added to the sword Attack Speed.\nFor example, if this field is set to 0.2, a matched sword would have the Attack Speed value increased by 0.2.\nIf that sword had an Attack Speed of 1.6, it would become 1.8. This field can also accept negative values, such as -0.6.");
        String BWLISTS = "White/Black Lists";
        itemClassWhitelist = config.getStringList("(Class) Item Weapon Whitelist", BWLISTS, itemClassWhitelist, "(Class) Item Whitelist.\nWhitelisted item classes for attacking. This is an advanced setting. If an item is added to this list, it will function as an Immersive Combat weapon. The Custom Weapons config is for editing the values and attributes of weapons. The class net.minecraft.item.ItemSword and anything that extends it is added by default. If a weapon from a mod is not behaving like an Immersive Combat weapon, add the class to this list.");
        itemClassBlacklist = config.getStringList("(Class) Item Left/Right Click Blacklist", BWLISTS, itemClassBlacklist, "(Class) Item Blacklist.\nBlacklisted item classes. This setting allows the items to have their default left-click and right-click functionality. This is an advanced setting, as it requires you to look through the source code of the mod that you are trying to add the class from. If an item is added to this list, it will have the default left-click and right-click behavior. This setting is useful for gun mods, or items that need to have their default left-click and right-click functionality. Example config value:    vazkii.akashictome.TomeItem    com.flansmod.common.guns.ItemGun    com.mrcrayfish.guns.item.ItemGun    techguns.items.guns.GenericGun    com.paneedah.mwc.weapons.Guns    com.jozufozu.yoyos.common.ItemYoyo");
        itemBlacklist = config.getStringList("(Resource Location) Item Left/Right Click Blacklist", BWLISTS, itemBlacklist, "(Resource Location) Item Blacklist.\nBlacklisted items. This setting allows the items to have their default left-click and right-click functionality. Use CraftTweaker to get the syntax of the item in your hand. The command is /ct hand). This is similar to Item Class Blacklist, however, it instead uses a resource location for specific items, such as:    mrcrayfish:gun");
        entityBlacklist = config.getStringList("(Class) Entity Offhand Blacklist", BWLISTS, entityBlacklist, "Entity Class Blacklist.\nBlacklisted entity classes for attacking with offhand or sweep. You will not be able to attack any entity that extends this class with your offhand, and they will not be hit by sweep! This is to prevent you from accidentally attacking or killing certain entities. Please note that entities extending IEntityOwnable are by default blacklisted, when the entity is owned by the attacker.");
        ConfigurationHandler.setDefaultConfigWeaponVariables();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void postConfig() throws Exception {
        String[] list;
        String CONFIG_REGEX = "([=]|(\\]\\s*\\[)|[\\]])";
        for (String s : shieldList) {
            try {
                list = s.split(CONFIG_REGEX);
                CustomShield spartanShield = new CustomShield();
                spartanShield.shield = Item.func_111206_d((String)list[1]);
                spartanShield.damage = MathHelper.func_151237_a((double)Double.parseDouble(list[3]), (double)0.0, (double)326.0);
                spartanShield.knockback = MathHelper.func_151237_a((double)Double.parseDouble(list[5]), (double)0.0, (double)326.0);
                spartanShield.cooldown = MathHelper.func_76125_a((int)Integer.parseInt(list[7]), (int)0, (int)255);
                shields.add(spartanShield);
            }
            catch (Exception e) {
                throw new Exception("\n\n================================================================\n|                        Immersive Combat                      |\n================================================================\n\nError:     Invalid bettercombat.cfg entry\n\nLocation:  Custom Shield Tweaker\n\nCause:     " + e.getCause() + "\n\nDetails:   " + s + "\n\nFix:       Remove the line listed for 'Custom Shield Tweaker' or reset your config by deleting bettercombat.cfg\n\n================================================================\n================================================================\n\n");
            }
        }
        for (String s : axeList) {
            try {
                list = s.split(CONFIG_REGEX);
                CustomAxe axe = new CustomAxe();
                axe.name = list[1];
                axe.disableDuration = Integer.parseInt(list[3]);
                axes.add(axe);
            }
            catch (Exception e) {
                throw new Exception("\n\n================================================================\n|                        Immersive Combat                      |\n================================================================\n\nError:     Invalid bettercombat.cfg entry\n\nLocation:  Custom Axe Tweaker\n\nCause:     " + e.getCause() + "\n\nDetails:   " + s + "\n\nFix:       Remove the line listed for 'Custom Axe Tweaker' or reset your config by deleting bettercombat.cfg\n\n================================================================\n================================================================\n\n");
            }
        }
        for (String s : swordList) {
            try {
                list = s.split(CONFIG_REGEX);
                CustomSword sword = new CustomSword();
                sword.name = list[1];
                sword.attackSpeed = MathHelper.func_76131_a((float)Float.parseFloat(list[3]), (float)-4.0f, (float)4.0f);
                swords.add(sword);
            }
            catch (Exception e) {
                throw new Exception("\n\n================================================================\n|                        Immersive Combat                      |\n================================================================\n\nError:     Invalid bettercombat.cfg entry\n\nLocation:  Custom Sword Tweaker\n\nCause:     " + e.getCause() + "\n\nDetails:   " + s + "\n\nFix:       Remove the line listed for 'Custom Sword Tweaker' or reset your config by deleting bettercombat.cfg\n\n================================================================\n================================================================\n\n");
            }
        }
        for (String s : weaponList) {
            ConfigWeapon configWeapon;
            block27: {
                int potionEffectSplit;
                list = s.split(CONFIG_REGEX);
                configWeapon = new ConfigWeapon();
                try {
                    configWeapon.name = list[1];
                    configWeapon.soundType = SoundType.valueOf(list[3]);
                    configWeapon.animation = Animation.valueOf(list[5]);
                    configWeapon.property = WeaponProperty.valueOf(list[7]);
                    configWeapon.sweepMod = Integer.parseInt(list[9]);
                    configWeapon.additionalReachMod = Double.parseDouble(list[11]);
                    configWeapon.knockbackMod = Double.parseDouble(list[13]);
                    configWeapon.critChanceMod = Double.parseDouble(list[15]);
                    configWeapon.additionalCritDamageMod = Double.parseDouble(list[17]);
                }
                catch (Exception e) {
                    throw new Exception("\n\n================================================================\n|                        Immersive Combat                      |\n================================================================\n\nError:     Invalid bettercombat.cfg entry\n\nLocation:  Custom Weapon Tweaker\n\nCause:     " + e.getCause() + "\n\nDetails:   " + s + "\n\nFix:       There was an error for the line in the 'Custom Weapon Tweaker' config. Remove the line or reset your config by deleting bettercombat.cfg\n\n================================================================\n================================================================\n\n");
                }
                try {
                    configWeapon.parry = Boolean.parseBoolean(list[19]);
                    if (!enableParrying) {
                        configWeapon.parry = false;
                    }
                    potionEffectSplit = 21;
                }
                catch (Exception e) {
                    configWeapon.parry = enableParrying;
                    potionEffectSplit = 19;
                }
                try {
                    String[] potionEffectList = list[potionEffectSplit].split(",");
                    try {
                        if (potionEffectList == null) break block27;
                        ConfigWeaponPotionEffect customPotionEffect = new ConfigWeaponPotionEffect();
                        customPotionEffect.potionEffect = Potion.func_180142_b((String)potionEffectList[2]);
                        if (customPotionEffect.potionEffect == null) {
                            throw new NullPointerException("\n\n================================================================\n|                        Immersive Combat                      |\n================================================================\n\nError:     Invalid bettercombat.cfg entry\n\nLocation:  Custom Weapon Tweaker\n\nCause:     NullPointerException\n\nDetails:   " + s + "\n\nFix:       The [Potion Effect] resource location listed in 'Details' for 'Custom Weapon Tweaker' does not exist, make sure it is a valid resource location!\n\n================================================================\n================================================================\n\n");
                        }
                        customPotionEffect.potionChance = ConfigurationHandler.getPotionChance(potionEffectList[0]);
                        customPotionEffect.afflict = potionEffectList[1].toLowerCase().equals("afflict");
                        customPotionEffect.potionPower = Integer.parseInt(potionEffectList[3]);
                        customPotionEffect.potionDuration = Integer.parseInt(potionEffectList[4]);
                        try {
                            customPotionEffect.ambient = Boolean.parseBoolean(potionEffectList[5]);
                        }
                        catch (Exception e) {
                            customPotionEffect.ambient = false;
                        }
                        try {
                            customPotionEffect.showParticles = Boolean.parseBoolean(potionEffectList[6]);
                        }
                        catch (Exception e) {
                            customPotionEffect.showParticles = false;
                        }
                        configWeapon.configWeaponPotionEffect = customPotionEffect;
                    }
                    catch (Exception e) {
                        throw new Exception("\n\n================================================================\n|                        Immersive Combat                      |\n================================================================\n\nError:     Invalid bettercombat.cfg entry\n\nLocation:  Custom Weapon Tweaker\n\nCause:     " + e.getCause() + "\n\nDetails:   " + s + "\n\nThe [Potion Effect] field for the line in 'Custom Weapon Tweaker' is incorrectly set up. Remove the [Potion Effect] field, or review the [Potion Effect] information in the 'Custom Weapon Tweaker' config to set it up correctly.\n\n================================================================\n================================================================\n\n");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            weapons.add(configWeapon);
        }
        for (String s : bowList) {
            try {
                list = s.split(CONFIG_REGEX);
                CustomBow spartanBow = new CustomBow();
                spartanBow.bow = Item.func_111206_d((String)list[1]);
                spartanBow.damage = Double.parseDouble(list[3]);
                spartanBow.velocity = MathHelper.func_151237_a((double)Double.parseDouble(list[5]), (double)0.15, (double)1.5);
                spartanBow.additionalDrawSpeed = Integer.parseInt(list[7]);
                bows.add(spartanBow);
            }
            catch (Exception e) {
                throw new Exception("\n\n================================================================\n|                        Immersive Combat                      |\n================================================================\n\nError:     Invalid bettercombat.cfg entry\n\nLocation:  Custom Bow Tweaker\n\nCause:     " + e.getCause() + "\n\nDetails:   " + s + "\n\nFix:       Remove the line listed in 'Custom Bow Tweaker' or reset your config by deleting bettercombat.cfg\n\n================================================================\n================================================================\n\n");
            }
        }
        elanaiDodgeEnabled = Loader.isModLoaded((String)"elenaidodge2") & elanaiDodgeCompat;
    }

    private static float getPotionChance(String potionEffectList) {
        try {
            return Float.parseFloat(potionEffectList);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static void setDefaultConfigWeaponVariables() {
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.name = "";
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.animation = Animation.CHOP;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.soundType = SoundType.AXE;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.property = WeaponProperty.ONEHAND;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.sweepMod = 0;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.additionalReachMod = 0.0;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.knockbackMod = baseKnockback;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.critChanceMod = baseCritPercentChance;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.additionalCritDamageMod = 0.0;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.configWeaponPotionEffect = null;
        ConfigurationHandler.DEFAULT_CUSTOM_WEAPON.parry = enableParrying;
    }

    public static void createInstLists() {
        for (String className : itemClassWhitelist) {
            try {
                itemClassWhiteArray.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (String className : itemClassBlacklist) {
            try {
                itemClassBlackArray.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (String className : entityBlacklist) {
            try {
                entityBlackArray.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (String className : bleedingPotionEntityBlacklist) {
            try {
                bleedingPotionEntityArray.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (String potion : bleedingPotionImmunityPotionEffects) {
            try {
                bleedingPotionImmunityPotionArray.add(Potion.func_180142_b((String)potion));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isShield2D(String name) {
        for (String s : twoDimensionalShieldList) {
            if (!name.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfigWeapon(Item item) {
        return ConfigurationHandler.isItemClassWhiteList(item) && !ConfigurationHandler.isBlacklisted(item);
    }

    public static boolean isBlacklisted(Item item) {
        return ConfigurationHandler.isItemClassBlackList(item) || ConfigurationHandler.isItemBlackList(item);
    }

    private static boolean isItemClassWhiteList(Item item) {
        for (Class clazz : itemClassWhiteArray) {
            if (!clazz.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    private static boolean isItemClassBlackList(Item item) {
        for (Class clazz : itemClassBlackArray) {
            if (!clazz.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    private static boolean isItemBlackList(Item item) {
        for (String blackListed : itemBlacklist) {
            if (!blackListed.equals(item.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean rightClickAttackable(EntityPlayer player, Entity entity) {
        EntityLiving el;
        if (entity instanceof EntityLiving && (el = (EntityLiving)entity).func_70638_az() != null && el.func_70638_az().equals((Object)player)) {
            return true;
        }
        if (entity instanceof IEntityOwnable && ((IEntityOwnable)entity).func_70902_q() != null && ((IEntityOwnable)entity).func_70902_q().equals((Object)player)) {
            return false;
        }
        for (Class clazz : entityBlackArray) {
            if (!clazz.isInstance(entity)) continue;
            return false;
        }
        return true;
    }

    public static boolean canBleed(EntityLivingBase entity) {
        for (Class clazz : bleedingPotionEntityArray) {
            if (!clazz.isInstance(entity)) continue;
            return false;
        }
        for (Potion potion : bleedingPotionImmunityPotionArray) {
            if (!entity.func_70644_a(potion)) continue;
            return false;
        }
        return true;
    }

    static {
        elanaiDodgeCompat = true;
        elanaiDodgeMainHandFeatherCost = 1;
        elanaiDodgeOffHandFeatherCost = 1;
        addDamageSourceToTippedArrows = true;
        blockFireProjectiles = true;
        healingArrowNoDamage = true;
        dragonboneBowWitherDamage = 12.0f;
        harmingArrowAmplifier = 6.0f;
        healingArrowAmplifier = 6.0f;
        rangedSilverDamageMultiplier = 1.5;
        tippedArrowFix = true;
        addedSwingTickCooldown = 0.5;
        baseAttackDamage = 1.0;
        baseAttackSpeed = 4.0;
        baseKnockback = 1.0;
        baseReachDistance = 4.0;
        minimumAttackSpeedTicks = 8;
        axes = new ArrayList();
        axeList = new String[]{"[Axe Substring=battleaxe_]\t\t[Disable Duration=90]", "[Axe Substring=halberd_]\t\t[Disable Duration=60]", "[Axe Substring=_axe]\t\t\t[Disable Duration=30]"};
        bows = new ArrayList();
        bowList = new String[]{"[Bow=minecraft:bow]\t[Damage Multiplier=1.00]\t[Velocity=0.90]\t[Ticks=0]"};
        autoCritOnSneakAttacks = true;
        baseCritPercentChance = 0.05;
        baseCritPercentDamage = 1.5;
        jumpCrits = 0.1;
        luckCritModifier = 0.1;
        offHandEfficiency = 0.75;
        sneakingDisablesOffhandAttack = true;
        versatileFatigueAmount = 0.3;
        gourmandEnchantmentEnabled = true;
        lightningEnchantmentEnabled = true;
        lightningEnchantmentBaseDamage = 3.0f;
        lightningEnchantmentDamagePerLevel = 2.0f;
        lightningEnchantmentWetModifier = 1.5f;
        webbingEnchantmentEnabled = true;
        revitalizeEnchantmentEnabled = true;
        revitalizePercentPerLevel = 0.2f;
        sorceryEnchantmentEnabled = true;
        sorceryPercentPerLevel = 0.1f;
        moreSprint = true;
        inertiaOnAttack = 0.5;
        fastEquipHotbarOnly = false;
        fastEquipOffhandWeaponsOrShieldsOnly = true;
        extraAttackHeight = 1.0;
        extraAttackWidth = 0.5;
        nauseaAffectsMobs = 2.2f;
        miningFatigueDamageReduction = 0.0;
        silverArmorDamagesUndeadAttackers = 1.5f;
        grassPathingRequiresAnimation = true;
        tillingRequiresAnimation = true;
        strippingBarkRequiresAnimation = false;
        cancelSpartanWeaponryFatigue = true;
        parryingItemDamage = 4;
        cutGrass = true;
        betterKnockback = true;
        knockUpStrengthMultiplier = 0.4;
        knockbackStrengthMultiplier = 1.0;
        sprintingKnockbackAmount = 0.4;
        entityBlackArray = new ArrayList();
        entityBlacklist = new String[]{"net.minecraft.entity.passive.EntityHorse", "net.minecraft.entity.item.EntityArmorStand", "net.minecraft.entity.passive.EntityVillager", "net.torocraft.toroquest.entities.creatures.ICitizen"};
        itemClassWhiteArray = new ArrayList();
        itemClassWhitelist = new String[]{"net.minecraft.item.ItemSword", "net.minecraft.item.ItemTool", "net.minecraft.item.ItemHoe", "com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon"};
        itemClassBlackArray = new ArrayList();
        itemClassBlacklist = new String[0];
        itemBlacklist = new String[0];
        alchemizedAmplifier = 0.2f;
        critChancePotionAmplifier = 0.1;
        critDamagePotionAmplifier = 0.1;
        customPotionEffectsWorkOnSweep = true;
        strengthPotionMultiplier = 0.05;
        weaknessPotionMultiplier = 0.1;
        extraSplashPotionWidth = 0.0;
        extraSplashPotionHeight = 2.0;
        bleedingDamagePerTick = 0.5f;
        bleedingDurationExtendedIfWet = true;
        bleedingDamageIncreasedIfSprinting = true;
        stackableBleeds = true;
        bleedingPotionEntityArray = new ArrayList();
        bleedingPotionEntityBlacklist = new String[]{"net.minecraft.entity.monster.AbstractSkeleton", "net.minecraft.entity.monster.EntityGolem", "net.minecraft.entity.monster.EntityGuardian", "net.minecraft.entity.boss.EntityWither", "net.minecraft.entity.boss.EntityDragon", "net.minecraft.entity.monster.EntityBlaze", "net.minecraft.entity.monster.EntityEnderman", "net.minecraft.entity.monster.EntityEndermite", "net.minecraft.entity.monster.EntitySilverfish", "net.minecraft.entity.monster.EntityCreeper"};
        bleedingPotionImmunityPotionArray = new ArrayList();
        bleedingPotionImmunityPotionEffects = new String[]{"potioncore:iron_skin", "potioncore:diamond_skin"};
        bowThudSoundVolume = 1.0f;
        bowStrikeSoundVolume = 1.0f;
        playArrowHitSound = true;
        shieldBashSoundVolume = 1.0f;
        shieldBlockSoundVolume = 1.0f;
        weaponHitSoundVolume = 1.0f;
        weaponSwingSoundVolume = 1.0f;
        weaponEquipAndSheatheSoundVolume = 1.0f;
        nonMetalList = new String[]{"wood", "stone", "bone", "staff", "club", "caestus"};
        showCritChanceTooltip = true;
        showCritChanceTooltipAsTotal = true;
        showCritDamageTooltip = true;
        showCritDamageTooltipAsTotal = false;
        showKnockbackTooltip = true;
        showKnockbackTooltipAsTotal = true;
        showPotionEffectTooltip = true;
        showReachTooltip = true;
        showReachTooltipAsTotal = false;
        showSweepTooltip = true;
        fistAndNonWeaponDamageReduction = 0.0;
        fistAndNonWeaponAttackSpeed = 2.0;
        fistAndNonWeaponKnockbackReduction = 0.5;
        fistAndNonWeaponReachReduction = 0.5;
        aetherealizedDamageParticles = true;
        breathingAnimationIntensity = 0.02f;
        breathingAnimationSpeed = 0.02f;
        cameraPitchSwing = 0.06f;
        rotationYawSwing = 0.16f;
        damageParticles = true;
        attackSweepParticles = true;
        attackSweepOverlay = true;
        showShieldCooldownCrosshair = true;
        showDefaultCrosshair = false;
        inverseDamageTiltAngle = true;
        critsDisableShield = 3.0;
        parryChanceEffectivness = 2.0;
        enableParrying = true;
        parryKnockbackAmount = 0.5f;
        disableBlockingWhileAttacking = true;
        disableBlockingWhileShieldBashing = false;
        shieldSilverDamageMultiplier = 1.5f;
        shieldBashingTaunts = true;
        shields = new ArrayList();
        shieldList = new String[]{"[Shield=minecraft:shield]\t\t\t\t\t\t[Damage=3.0]\t[Knockback=1.0]\t[Cooldown=30]", "[Shield=spartanshields:shield_basic_diamond]\t[Damage=7.0]\t[Knockback=2.0]\t[Cooldown=25]", "[Shield=spartanshields:shield_basic_gold]\t\t[Damage=3.0]\t[Knockback=1.0]\t[Cooldown=10]", "[Shield=spartanshields:shield_basic_iron]\t\t[Damage=5.0]\t[Knockback=1.0]\t[Cooldown=20]", "[Shield=spartanshields:shield_basic_obsidian]\t[Damage=5.0]\t[Knockback=1.5]\t[Cooldown=50]", "[Shield=spartanshields:shield_basic_silver]\t\t[Damage=5.0]\t[Knockback=1.0]\t[Cooldown=20]", "[Shield=spartanshields:shield_basic_stone]\t\t[Damage=2.0]\t[Knockback=0.5]\t[Cooldown=40]", "[Shield=spartanshields:shield_basic_wood]\t\t[Damage=1.0]\t[Knockback=0.5]\t[Cooldown=40]", "[Shield=spartanshields:shield_tower_diamond]\t[Damage=7.0]\t[Knockback=2.5]\t[Cooldown=35]", "[Shield=spartanshields:shield_tower_gold]\t\t[Damage=3.0]\t[Knockback=1.5]\t[Cooldown=20]", "[Shield=spartanshields:shield_tower_iron]\t\t[Damage=5.0]\t[Knockback=1.5]\t[Cooldown=30]", "[Shield=spartanshields:shield_tower_obsidian]\t[Damage=5.0]\t[Knockback=2.0]\t[Cooldown=60]", "[Shield=spartanshields:shield_tower_silver]\t\t[Damage=5.0]\t[Knockback=1.5]\t[Cooldown=30]", "[Shield=spartanshields:shield_tower_stone]\t\t[Damage=2.0]\t[Knockback=1.0]\t[Cooldown=50]", "[Shield=spartanshields:shield_tower_wood]\t\t[Damage=1.0]\t[Knockback=1.0]\t[Cooldown=50]"};
        twoDimensionalShieldList = new String[]{"shield_basic_"};
        swords = new ArrayList();
        swordList = new String[]{"[Sword Substring=golden_sword]\t\t[Additional Attack Speed=0.2]", "[Sword Substring=wooden_sword]\t\t[Additional Attack Speed=0.1]"};
        weapons = new ArrayList();
        weaponList = new String[]{"[Weapon Substring=pike_] [Sound Type=POLEARM] [Animation=STAB] [Property=TWOHAND] [Sweep=0] [Additional Reach=2.0] [Knockback=0.2] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=glaive_] [Sound Type=POLEARM] [Animation=SWEEP] [Property=TWOHAND] [Sweep=2] [Additional Reach=1.0] [Knockback=0.5] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=spear_] [Sound Type=POLEARM] [Animation=STAB] [Property=MAINHAND] [Sweep=0] [Additional Reach=1.0] [Knockback=0.2] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=lance_] [Sound Type=POLEARM] [Animation=STAB] [Property=MAINHAND] [Sweep=0] [Additional Reach=1.0] [Knockback=1.0] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=halberd_] [Sound Type=POLEARM] [Animation=CHOP] [Property=TWOHAND] [Sweep=0] [Additional Reach=1.0] [Knockback=0.8] [Crit Chance=0.25] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=staff] [Sound Type=POLEARM] [Animation=SWEEP] [Property=TWOHAND] [Sweep=2] [Additional Reach=1.0] [Knockback=1.0] [Crit Chance=0.1] [Additional Crit Damage=0.5] [Parry=true] [Potion Effect=CRIT,RECEIVE,minecraft:speed,2,160,false,false]", "[Weapon Substring=warhammer_] [Sound Type=BLUNT] [Animation=CHOP] [Property=VERSATILE] [Sweep=0] [Additional Reach=0.0] [Knockback=1.0][Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=hammer_] [Sound Type=BLUNT] [Animation=CHOP] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=1.5] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true] [Potion Effect=CRIT,AFFLICT,minecraft:nausea,1,100,false,true]", "[Weapon Substring=mace_] [Sound Type=BLUNT] [Animation=CHOP] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.8] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=club_] [Sound Type=BLUNT] [Animation=CHOP] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.8] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=caestus] [Sound Type=BLUNT] [Animation=STAB] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.2] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=greatsword_] [Sound Type=BLADE] [Animation=SWEEP] [Property=TWOHAND] [Sweep=3] [Additional Reach=1.0] [Knockback=0.5][Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=katana_] [Sound Type=BLADE] [Animation=CHOP] [Property=VERSATILE] [Sweep=0] [Additional Reach=0.0] [Knockback=0.5] [Crit Chance=0.1] [Additional Crit Damage=0.5] [Parry=true]", "[Weapon Substring=longsword_] [Sound Type=BLADE] [Animation=SWEEP] [Property=VERSATILE] [Sweep=1] [Additional Reach=0.0] [Knockback=0.5] Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=saber_] [Sound Type=BLADE] [Animation=SWEEP] [Property=ONEHAND] [Sweep=1] [Additional Reach=0.0] [Knockback=0.2] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=rapier_] [Sound Type=BLADE] [Animation=STAB] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.0] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true] [Potion Effect=CRIT,AFFLICT,bettercombat:bleeding,1,100,false,false]", "[Weapon Substring=battleaxe_] [Sound Type=AXE] [Animation=CHOP] [Property=VERSATILE] [Sweep=0] [Additional Reach=0.0] [Knockback=0.8] [Crit Chance=0.25] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=_shovel] [Sound Type=AXE] [Animation=CHOP] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.5] [Crit Chance=0.05] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=_sword] [Sound Type=BLADE] [Animation=SWEEP] [Property=ONEHAND] [Sweep=1] [Additional Reach=0.0] [Knockback=0.2] [Crit Chance=0.1] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=_pickaxe] [Sound Type=AXE] [Animation=CHOP] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.5] [Crit Chance=0.05] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=_axe] [Sound Type=AXE] [Animation=CHOP] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.8] [Crit Chance=0.25] [Additional Crit Damage=0.0] [Parry=true]", "[Weapon Substring=_hoe] [Sound Type=AXE] [Animation=CHOP] [Property=ONEHAND] [Sweep=0] [Additional Reach=0.0] [Knockback=0.2] [Crit Chance=0.05] [Additional Crit Damage=0.0] [Parry=true]"};
        DEFAULT_CUSTOM_WEAPON = new ConfigWeapon();
    }

    public static class CustomBow {
        public Item bow;
        public double damage;
        public double velocity;
        public int additionalDrawSpeed;
    }

    public static class CustomShield {
        public Item shield;
        public double damage;
        public double knockback;
        public int cooldown;
    }

    public static class ConfigWeaponPotionEffect {
        public float potionChance;
        public boolean afflict;
        private Potion potionEffect;
        public int potionPower;
        public int potionDuration;
        public boolean ambient;
        public boolean showParticles;

        public Potion getPotion() {
            return this.potionEffect;
        }
    }

    public static class ConfigWeapon {
        public String name;
        public Animation animation;
        public SoundType soundType;
        public WeaponProperty property;
        public int sweepMod;
        public double additionalReachMod;
        public double knockbackMod;
        public double critChanceMod;
        public double additionalCritDamageMod;
        public boolean parry;
        public ConfigWeaponPotionEffect configWeaponPotionEffect = null;
    }

    public static enum SoundType {
        NONE,
        BLADE,
        BLUNT,
        AXE,
        POLEARM;

    }

    public static enum Animation {
        NONE,
        SWEEP,
        CHOP,
        STAB,
        BLOCK;

    }

    public static enum WeaponProperty {
        ONEHAND,
        VERSATILE,
        MAINHAND,
        TWOHAND;

    }

    public static class CustomSword {
        public String name;
        public float attackSpeed;
    }

    public static class CustomAxe {
        public String name;
        public int disableDuration;
    }
}

