/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.server;

import bettercombat.mod.client.ClientProxy;
import bettercombat.mod.client.SoundHandler;
import bettercombat.mod.enchantment.BetterCombatEnchantments;
import bettercombat.mod.enchantment.EnchantmentLightning;
import bettercombat.mod.enchantment.EnchantmentWebbing;
import bettercombat.mod.network.PacketHandler;
import bettercombat.mod.network.client.PacketDamageTilt;
import bettercombat.mod.network.client.PacketParried;
import bettercombat.mod.network.server.PacketParrying;
import bettercombat.mod.potion.BetterCombatPotions;
import bettercombat.mod.potion.PotionAetherealized;
import bettercombat.mod.server.EntityAINausea;
import bettercombat.mod.util.ConfigurationHandler;
import bettercombat.mod.util.Helpers;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlers {
    public static final IAttribute CRIT_CHANCE = new RangedAttribute(null, "bettercombat.critChance", ConfigurationHandler.baseCritPercentChance, 0.0, 1.0).func_111117_a("Critical strike chance").func_111112_a(true);
    public static final IAttribute CRIT_DAMAGE = new RangedAttribute(null, "bettercombat.critDamage", ConfigurationHandler.baseCritPercentDamage, 0.0, Double.MAX_VALUE).func_111117_a("Critical strike damage").func_111112_a(true);

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void cancelAttackEntityEvent(AttackEntityEvent event) {
        if (event.getEntityPlayer().func_184614_ca().func_190926_b() && event.getEntityPlayer().func_184592_cb().func_190926_b() || !ConfigurationHandler.isBlacklisted(event.getEntityPlayer().func_184614_ca().func_77973_b())) {
            if (event.getTarget() instanceof EntityLivingBase) {
                event.getTarget().field_70172_ad = ((EntityLivingBase)event.getTarget()).field_70771_an;
            }
            event.getEntityLiving().func_85031_j((Entity)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            EntityPlayer p;
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer && (p = (EntityPlayer)arrow.field_70250_c).func_184587_cr()) {
                ItemStack stack;
                ItemStack itemStack = stack = p.func_184600_cs() == EnumHand.MAIN_HAND ? p.func_184614_ca() : p.func_184592_cb();
                if (!stack.func_190926_b()) {
                    NBTTagList nbttaglist = stack.func_77986_q();
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        short id = nbttaglist.func_150305_b(i).func_74765_d("id");
                        short lvl = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                        if (ConfigurationHandler.lightningEnchantmentEnabled && Enchantment.func_185258_b((Enchantment)BetterCombatEnchantments.LIGHTNING) == id) {
                            arrow.func_184211_a("lightning~" + lvl);
                            arrow.func_184195_f(true);
                        }
                        if (!ConfigurationHandler.webbingEnchantmentEnabled || Enchantment.func_185258_b((Enchantment)BetterCombatEnchantments.WEBBING) != id) continue;
                        arrow.func_184211_a("webbing");
                    }
                }
            }
        } else if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigurationHandler.baseAttackDamage);
            player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(ConfigurationHandler.baseAttackSpeed);
            this.registerCritAttributes(player);
            if (player.field_70170_p.field_72995_K && player == ClientProxy.EHC_INSTANCE.mc.field_71439_g) {
                ClientProxy.EHC_INSTANCE.checkItemstacksChanged(true);
                ClientProxy.EHC_INSTANCE.resetMainhandCooldown(ClientProxy.EHC_INSTANCE.mc.field_71439_g);
                ClientProxy.EHC_INSTANCE.resetOffhandCooldown(ClientProxy.EHC_INSTANCE.mc.field_71439_g);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        this.registerCritAttributes(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            this.registerCritAttributes(player);
        }
    }

    public void registerCritAttributes(EntityPlayer player) {
        try {
            player.func_110140_aT().func_111150_b(CRIT_CHANCE).func_111128_a(ConfigurationHandler.baseCritPercentChance);
            player.func_110140_aT().func_111150_b(CRIT_DAMAGE).func_111128_a(ConfigurationHandler.baseCritPercentDamage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void knockBack(LivingKnockBackEvent event) {
        if (ConfigurationHandler.betterKnockback && !event.isCanceled() && event.getEntityLiving() != null) {
            double strength = event.getStrength();
            double xRatio = event.getRatioX();
            double zRatio = event.getRatioZ();
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            double knockbackResistance = entityLivingBase.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            if (knockbackResistance < 1.0) {
                strength *= (1.0 - knockbackResistance) * ConfigurationHandler.knockbackStrengthMultiplier;
                entityLivingBase.field_70160_al = true;
                entityLivingBase.field_70159_w *= 0.5;
                entityLivingBase.field_70179_y *= 0.5;
                double d = Math.sqrt(xRatio * xRatio + zRatio * zRatio);
                if (d > 0.0) {
                    entityLivingBase.field_70159_w -= xRatio / d * strength;
                    entityLivingBase.field_70179_y -= zRatio / d * strength;
                }
                if (entityLivingBase.field_70122_E) {
                    entityLivingBase.field_70181_x = strength * ConfigurationHandler.knockUpStrengthMultiplier;
                    if (entityLivingBase.field_70181_x > 0.4) {
                        entityLivingBase.field_70181_x = 0.4;
                    }
                }
                entityLivingBase.field_70133_I = true;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void potionApplicable(PotionEvent.PotionApplicableEvent event) {
        if (ConfigurationHandler.cancelSpartanWeaponryFatigue && event.getEntityLiving() instanceof EntityPlayer && event.getPotionEffect().func_76459_b() == 20 && event.getPotionEffect().func_188419_a().equals(MobEffects.field_76419_f)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getPotionEffect().func_188419_a().equals(BetterCombatPotions.BLEEDING)) {
            if (!ConfigurationHandler.canBleed(event.getEntityLiving())) {
                event.setResult(Event.Result.DENY);
            }
        } else if (event.getEntityLiving().func_70644_a(BetterCombatPotions.BLEEDING)) {
            Potion potionApplicable = event.getPotionEffect().func_188419_a();
            for (Potion potionImmunity : ConfigurationHandler.bleedingPotionImmunityPotionArray) {
                if (!potionApplicable.equals(potionImmunity)) continue;
                event.getEntityLiving().func_184596_c(BetterCombatPotions.BLEEDING);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void potionAdded(PotionEvent.PotionAddedEvent event) {
        if (event.getEntityLiving() instanceof EntityCreature && ConfigurationHandler.nauseaAffectsMobs > 0.0f) {
            EntityCreature creature = (EntityCreature)event.getEntityLiving();
            if (creature.field_70131_O <= ConfigurationHandler.nauseaAffectsMobs && (creature.func_70644_a(MobEffects.field_76431_k) || creature.func_70644_a(MobEffects.field_76440_q))) {
                boolean flag = false;
                for (EntityAITasks.EntityAITaskEntry task : creature.field_70714_bg.field_75782_a) {
                    if (!task.getClass().equals(EntityAINausea.class)) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    creature.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAINausea(creature));
                } else if (creature.field_70170_p.field_73012_v.nextBoolean()) {
                    creature.func_70624_b(null);
                }
            }
        }
        if (event.getPotionEffect().func_188419_a().equals(BetterCombatPotions.BLEEDING) && event.getEntityLiving().func_70644_a(BetterCombatPotions.BLEEDING) && ConfigurationHandler.stackableBleeds) {
            PotionEffect newBleed = event.getPotionEffect();
            PotionEffect currentBleed = event.getEntityLiving().func_70660_b(BetterCombatPotions.BLEEDING);
            event.getEntityLiving().func_184589_d(currentBleed.func_188419_a());
            event.getEntityLiving().func_70690_d(new PotionEffect(BetterCombatPotions.BLEEDING, newBleed.func_76459_b() > currentBleed.func_76459_b() ? newBleed.func_76459_b() : currentBleed.func_76459_b(), newBleed.func_76458_c() + currentBleed.func_76458_c(), currentBleed.func_82720_e(), currentBleed.func_188418_e()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void onHeal(LivingHealEvent event) {
        int level;
        if (event.getEntityLiving() != null && ConfigurationHandler.revitalizeEnchantmentEnabled && (level = EnchantmentHelper.func_185284_a((Enchantment)BetterCombatEnchantments.REVITALIZE, (EntityLivingBase)event.getEntityLiving())) > 0) {
            event.setAmount(event.getAmount() * (1.0f + ConfigurationHandler.revitalizePercentPerLevel * (float)level));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void livingHurtHigh(LivingHurtEvent event) {
        int level;
        PotionEffect potionEffect;
        if (event.getEntityLiving() == null) {
            return;
        }
        if (event.getSource() == null) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker.func_70644_a(BetterCombatPotions.AETHEREALIZED) && !event.getSource().func_82725_o() && !event.getSource().func_76347_k() && !event.getSource().func_94541_c() && (potionEffect = attacker.func_70660_b(BetterCombatPotions.AETHEREALIZED)) != null) {
            float magicDamage = event.getAmount() * (float)potionEffect.func_76458_c() * ConfigurationHandler.alchemizedAmplifier;
            event.setAmount(event.getAmount() - magicDamage);
            event.getEntityLiving().field_70172_ad = 0;
            event.getEntityLiving().func_70097_a(DamageSource.func_76354_b((Entity)event.getEntityLiving().func_70643_av(), (Entity)event.getEntityLiving().func_70643_av()), magicDamage);
            event.getEntityLiving().field_70172_ad = 0;
            PotionAetherealized.playAetherealizedEffect((Entity)event.getEntityLiving(), potionEffect.func_76458_c());
        }
        if (event.getSource().field_76373_n.equals("arrow")) {
            event.getSource().func_76349_b();
        }
        if (ConfigurationHandler.sorceryEnchantmentEnabled && event.getSource().func_82725_o() && (level = EnchantmentHelper.func_185284_a((Enchantment)BetterCombatEnchantments.SORCERY, (EntityLivingBase)attacker)) > 0) {
            event.setAmount(event.getAmount() * (1.0f + ConfigurationHandler.sorceryPercentPerLevel * (float)level));
        }
        if (ConfigurationHandler.silverArmorDamagesUndeadAttackers > 0.0f && attacker.func_70662_br() && !event.getEntityLiving().func_70662_br() && !event.getSource().func_76352_a() && (double)attacker.func_70032_d((Entity)event.getEntityLiving()) < 4.0) {
            int armorPieces = 0;
            for (ItemStack piece : event.getEntityLiving().func_184209_aF()) {
                if (piece.func_190926_b() || !piece.func_77973_b().getRegistryName().toString().contains("silver_metal")) continue;
                ++armorPieces;
            }
            if (armorPieces > 0) {
                attacker.field_70172_ad = 0;
                attacker.func_70097_a(DamageSource.func_76354_b((Entity)event.getEntityLiving(), (Entity)event.getEntityLiving()), ConfigurationHandler.silverArmorDamagesUndeadAttackers * (float)armorPieces);
                attacker.field_70172_ad = 0;
                Helpers.silverArmorParticles((Entity)attacker);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (this.cancelTools(event.getEntityPlayer(), event.getEntityPlayer().func_130014_f_().func_180495_p(event.getPos()).func_177230_c())) {
            event.setCanceled(true);
        }
    }

    private boolean cancelTools(EntityPlayer entityPlayer, Block block) {
        if (ConfigurationHandler.grassPathingRequiresAnimation && block instanceof BlockGrass) {
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemSpade) {
                return true;
            }
            if (entityPlayer.func_184592_cb().func_77973_b() instanceof ItemSpade) {
                return true;
            }
        }
        if (ConfigurationHandler.tillingRequiresAnimation && (block instanceof BlockDirt || block instanceof BlockGrass || block instanceof BlockGrassPath)) {
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemHoe) {
                return true;
            }
            if (entityPlayer.func_184592_cb().func_77973_b() instanceof ItemHoe) {
                return true;
            }
        }
        if (ConfigurationHandler.strippingBarkRequiresAnimation && block instanceof BlockLog) {
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemAxe) {
                return true;
            }
            if (entityPlayer.func_184592_cb().func_77973_b() instanceof ItemAxe) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void livingHurtLow(LivingHurtEvent event) {
        if (ConfigurationHandler.addDamageSourceToTippedArrows) {
            if (event.getEntityLiving() == null) {
                return;
            }
            if (event.getSource() == null) {
                return;
            }
            if (!(event.getSource().func_76346_g() instanceof EntityLivingBase)) {
                return;
            }
            if (event.getSource().func_76346_g() == null && event.getSource().func_82725_o() && event.getEntityLiving().func_70643_av() instanceof EntityPlayer) {
                event.getEntityLiving().field_70172_ad = 0;
                event.getEntityLiving().func_70097_a(DamageSource.func_76354_b((Entity)event.getEntityLiving().func_70643_av(), (Entity)event.getEntityLiving().func_70643_av()), event.getAmount());
                event.getEntityLiving().field_70172_ad = 0;
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void livingAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() == null || event.getSource() == null) {
            return;
        }
        if (event.getAmount() > 0.0f && !this.parryAttack(event)) {
            this.blockAttack(event);
        }
    }

    private boolean parryAttack(LivingAttackEvent event) {
        if (this.canParryDamageSource(event.getSource(), event.getEntityLiving()) && event.getEntityLiving() instanceof EntityPlayerMP && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            EntityLivingBase source = (EntityLivingBase)event.getSource().func_76346_g();
            if (player.func_184600_cs().equals((Object)EnumHand.MAIN_HAND) && player.getEntityData().func_74764_b("isParrying") && player.getEntityData().func_74767_n("isParrying") && ConfigurationHandler.isConfigWeapon(player.func_184614_ca().func_77973_b())) {
                double attackDamage = Helpers.getMainhandAttackDamage((EntityPlayer)player, player.func_184614_ca());
                PacketHandler.instance.sendTo((IMessage)new PacketDamageTilt(PacketDamageTilt.getDamageTilt((EntityLivingBase)player, source)), player);
                if ((double)event.getAmount() > attackDamage && (double)event.getAmount() > (double)player.field_70170_p.field_73012_v.nextFloat() * ConfigurationHandler.parryChanceEffectivness * attackDamage) {
                    player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), (int)((double)event.getAmount() * ConfigurationHandler.critsDisableShield));
                    PacketHandler.instance.sendTo((IMessage)new PacketParrying(false), player);
                    PacketHandler.instance.sendTo((IMessage)new PacketParried(false), player);
                } else {
                    event.setCanceled(true);
                    player.func_184609_a(EnumHand.MAIN_HAND);
                    PacketHandler.instance.sendTo((IMessage)new PacketParried(true), player);
                    SoundHandler.playImpactArmorMetalSound(event.getEntityLiving(), SoundHandler.getRandomShieldBlockVolume(), SoundHandler.getRandomImpactPitch());
                    player.func_70653_a(event.getSource().func_76346_g(), ConfigurationHandler.parryKnockbackAmount * 0.2f, (double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)))), (double)MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))));
                    if (player.field_70170_p instanceof WorldServer && (double)event.getAmount() >= 1.0) {
                        int k = 3 + (int)(event.getAmount() * 0.5f);
                        ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.CRIT, player.field_70165_t + (double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)))), player.field_70163_u + (double)(player.field_70131_O * 0.6f), player.field_70161_v + (double)MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))), k, 0.2, 0.1, 0.2, 0.25, new int[0]);
                    }
                }
                player.func_184614_ca().func_77972_a(ConfigurationHandler.parryingItemDamage, (EntityLivingBase)player);
                source.func_70653_a((Entity)player, ConfigurationHandler.parryKnockbackAmount, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                return true;
            }
        }
        return false;
    }

    private boolean blockAttack(LivingAttackEvent event) {
        if (this.canBlockDamageSource(event.getSource(), event.getEntityLiving())) {
            float f;
            if (event.getEntityLiving() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
                if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
                    EntityLivingBase source = (EntityLivingBase)event.getSource().func_76346_g();
                    PacketHandler.instance.sendTo((IMessage)new PacketDamageTilt(PacketDamageTilt.getDamageTilt((EntityLivingBase)player, source)), player);
                } else {
                    PacketHandler.instance.sendTo((IMessage)new PacketDamageTilt(player.field_70177_z), player);
                }
            }
            if ((f = event.getEntityLiving().func_110138_aP() * 0.25f) > 0.0f && event.getAmount() / f > event.getEntityLiving().field_70170_p.field_73012_v.nextFloat()) {
                SoundHandler.blockMetalHeavy(event.getEntityLiving(), SoundHandler.getRandomShieldBlockVolume(), SoundHandler.getRandomImpactPitch());
            } else {
                SoundHandler.blockMetalLight(event.getEntityLiving(), SoundHandler.getRandomShieldBlockVolume(), SoundHandler.getRandomImpactPitch());
            }
            return true;
        }
        return false;
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn, EntityLivingBase elb) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && elb.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = elb.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(elb.field_70165_t, elb.field_70163_u, elb.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private boolean canParryDamageSource(DamageSource damageSourceIn, EntityLivingBase elb) {
        Vec3d vec3d;
        if (!(damageSourceIn.func_76363_c() || damageSourceIn.func_76352_a() || damageSourceIn.func_82725_o() || damageSourceIn.func_76346_g() == null || (vec3d = damageSourceIn.func_188404_v()) == null)) {
            Vec3d vec3d1 = elb.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(elb.field_70165_t, elb.field_70163_u, elb.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void livingHurtLow(LivingDamageEvent event) {
        EntityPlayer player;
        if (ConfigurationHandler.gourmandEnchantmentEnabled && event.getEntityLiving() instanceof EntityPlayer && EnchantmentHelper.func_185284_a((Enchantment)BetterCombatEnchantments.GOURMAND, (EntityLivingBase)(player = (EntityPlayer)event.getEntityLiving())) > 0) {
            int hunger = player.func_71024_bL().func_75116_a();
            float saturation = player.func_71024_bL().func_75115_e();
            float damage = event.getAmount();
            if (damage > (float)hunger + saturation) {
                event.setAmount(damage - (float)hunger - saturation);
                player.func_71024_bL().func_75114_a(0);
                player.func_71024_bL().func_75119_b(0.0f);
            } else {
                int intDamage = (int)damage;
                float floatDamage = damage - (float)intDamage;
                hunger -= intDamage;
                if ((saturation -= floatDamage) < 0.0f) {
                    --hunger;
                    saturation += 1.0f;
                }
                event.setAmount(0.0f);
                player.func_71024_bL().func_75114_a(hunger);
                player.func_71024_bL().func_75119_b(saturation);
            }
        }
    }

    @Nullable
    private BlockPos getRandPos(World worldIn, Entity entityIn, int horizontalRange, int verticalRange) {
        BlockPos blockpos = new BlockPos(entityIn);
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177956_o();
        int k = blockpos.func_177952_p();
        float f = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos blockpos1 = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = i - horizontalRange; l <= i + horizontalRange; ++l) {
            for (int i1 = j - verticalRange; i1 <= j + verticalRange; ++i1) {
                for (int j1 = k - horizontalRange; j1 <= k + horizontalRange; ++j1) {
                    float f1;
                    blockpos$mutableblockpos.func_181079_c(l, i1, j1);
                    IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                    if (iblockstate.func_185904_a() != Material.field_151586_h || !((f1 = (float)((l - i) * (l - i) + (i1 - j) * (i1 - j) + (j1 - k) * (j1 - k))) < f)) continue;
                    f = f1;
                    blockpos1 = new BlockPos((Vec3i)blockpos$mutableblockpos);
                }
            }
        }
        return blockpos1;
    }

    @SubscribeEvent
    public void adjustBowTicksStart(LivingEntityUseItemEvent.Start event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack heldItem = player.func_184614_ca();
            if (!(heldItem.func_77973_b() instanceof ItemBow)) {
                heldItem = player.func_184592_cb();
            }
            if (heldItem.func_77973_b() instanceof ItemBow) {
                for (ConfigurationHandler.CustomBow CustomBow2 : ConfigurationHandler.bows) {
                    if (CustomBow2.bow != heldItem.func_77973_b()) continue;
                    if (CustomBow2.additionalDrawSpeed > 0) {
                        event.setDuration(event.getDuration() + CustomBow2.additionalDrawSpeed);
                        continue;
                    }
                    if (CustomBow2.additionalDrawSpeed >= -6) continue;
                    event.setDuration(event.getDuration() + 6 + CustomBow2.additionalDrawSpeed);
                }
            }
        }
    }

    @SubscribeEvent
    public void adjustBowTicks(LivingEntityUseItemEvent event) {
        EntityPlayer player;
        ItemStack activeItem;
        if (event.getEntityLiving() instanceof EntityPlayer && (activeItem = (player = (EntityPlayer)event.getEntityLiving()).func_184607_cu()).func_77973_b() instanceof ItemBow) {
            for (ConfigurationHandler.CustomBow CustomBow2 : ConfigurationHandler.bows) {
                int mod;
                if (CustomBow2.bow != activeItem.func_77973_b() || CustomBow2.additionalDrawSpeed >= 0) continue;
                switch (CustomBow2.additionalDrawSpeed) {
                    case -1: {
                        mod = 15;
                        break;
                    }
                    case -2: {
                        mod = 10;
                        break;
                    }
                    case -3: {
                        mod = 6;
                        break;
                    }
                    case -4: {
                        mod = 5;
                        break;
                    }
                    case -5: {
                        mod = 4;
                        break;
                    }
                    default: {
                        mod = 3;
                    }
                }
                if ((activeItem.func_77988_m() - event.getDuration()) % mod != 0) continue;
                event.setDuration(event.getDuration() - 1);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (world == null || entity == null) {
            return;
        }
        if (entity instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)entity;
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase p = (EntityLivingBase)arrow.field_70250_c;
                try {
                    Item item = p.func_184586_b(p.func_184600_cs()).func_77973_b();
                    String name = item.getRegistryName().toString();
                    for (ConfigurationHandler.CustomBow CustomBow2 : ConfigurationHandler.bows) {
                        if (CustomBow2.bow != item) continue;
                        if (CustomBow2.velocity != 1.0) {
                            arrow.field_70159_w *= CustomBow2.velocity;
                            arrow.field_70181_x *= CustomBow2.velocity;
                            arrow.field_70179_y *= CustomBow2.velocity;
                            arrow.field_70133_I = true;
                        }
                        if (CustomBow2.damage != 1.0) {
                            double damage = arrow.func_70242_d() * CustomBow2.damage;
                            if (damage < 0.0) {
                                damage = 0.0;
                            }
                            arrow.func_70239_b(damage);
                        }
                        if (name.contains("silver")) {
                            arrow.func_184211_a("silver");
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void arrowImpact(ProjectileImpactEvent event) {
        block59: {
            block57: {
                EntityArrow arrow;
                block58: {
                    EntityPlayer player;
                    EntityLivingBase victim;
                    block56: {
                        Object vec3d;
                        Vec3d vec3d2;
                        EntityLivingBase victim2;
                        if (ConfigurationHandler.blockFireProjectiles && event.getEntity() != null && event.getEntity().func_70027_ad() && event.getRayTraceResult().field_72308_g instanceof EntityLivingBase && (victim2 = (EntityLivingBase)event.getRayTraceResult().field_72308_g).func_184585_cz() && (vec3d2 = event.getEntity().func_174791_d()) != null) {
                            Vec3d vec3d1 = victim2.func_70676_i(1.0f);
                            Vec3d vec3d22 = vec3d2.func_72444_a(new Vec3d(victim2.field_70165_t, victim2.field_70163_u, victim2.field_70161_v)).func_72432_b();
                            vec3d22 = new Vec3d(vec3d22.field_72450_a, 0.0, vec3d22.field_72449_c);
                            if (vec3d22.func_72430_b(vec3d1) < 0.0) {
                                event.getEntity().func_70066_B();
                            }
                        }
                        if (!(event.getEntity() instanceof EntityArrow)) break block57;
                        arrow = (EntityArrow)event.getEntity();
                        if (!(event.getRayTraceResult().field_72308_g instanceof EntityLivingBase)) break block58;
                        victim = (EntityLivingBase)event.getRayTraceResult().field_72308_g;
                        if (victim.func_184585_cz() && (vec3d = event.getEntity().func_174791_d()) != null) {
                            Vec3d vec3d1 = victim.func_70676_i(1.0f);
                            Vec3d vec3d23 = vec3d.func_72444_a(new Vec3d(victim.field_70165_t, victim.field_70163_u, victim.field_70161_v)).func_72432_b();
                            vec3d23 = new Vec3d(vec3d23.field_72450_a, 0.0, vec3d23.field_72449_c);
                            if (vec3d23.func_72430_b(vec3d1) < 0.0) {
                                return;
                            }
                        }
                        for (String t : arrow.func_184216_O()) {
                            float healAmount;
                            Integer i2;
                            if (t.equals("silver")) {
                                if (ConfigurationHandler.rangedSilverDamageMultiplier == 1.0 || !victim.func_70662_br()) continue;
                                arrow.func_70239_b(arrow.func_70242_d() * ConfigurationHandler.rangedSilverDamageMultiplier);
                                Helpers.silverArrowParticles((Entity)arrow);
                                continue;
                            }
                            if (t.contains("lightning~")) {
                                try {
                                    i2 = Integer.valueOf(t.substring(10));
                                    EnchantmentLightning.doLightning(arrow.field_70250_c, (Entity)victim, i2);
                                    arrow.func_70106_y();
                                }
                                catch (Exception i2) {}
                                continue;
                            }
                            if (t.equals("webbing")) {
                                try {
                                    arrow.func_70240_a(0);
                                    EnchantmentWebbing.doWebbing(arrow, arrow.field_70250_c, (Entity)victim);
                                    arrow.func_70106_y();
                                }
                                catch (Exception i2) {}
                                continue;
                            }
                            if (t.contains("instant_harming~")) {
                                try {
                                    i2 = Integer.valueOf(t.substring(16));
                                    if (victim.func_70662_br()) {
                                        if (ConfigurationHandler.healingArrowNoDamage) {
                                            arrow.func_70239_b(0.0);
                                        }
                                        healAmount = (float)i2.intValue() * ConfigurationHandler.healingArrowAmplifier;
                                        victim.func_70691_i(healAmount);
                                        Helpers.healParticles((Entity)victim, Math.round(healAmount));
                                        continue;
                                    }
                                    if (arrow.field_70250_c == null) {
                                        victim.field_70172_ad = 0;
                                        victim.func_70097_a(DamageSource.field_76376_m, (float)i2.intValue() * ConfigurationHandler.harmingArrowAmplifier);
                                        victim.field_70172_ad = 0;
                                        continue;
                                    }
                                    victim.field_70172_ad = 0;
                                    victim.func_70097_a(DamageSource.func_76354_b((Entity)arrow.field_70250_c, (Entity)arrow.field_70250_c), (float)i2.intValue() * ConfigurationHandler.harmingArrowAmplifier);
                                    victim.field_70172_ad = 0;
                                }
                                catch (Exception i3) {}
                                continue;
                            }
                            if (!t.contains("instant_healing~")) continue;
                            try {
                                i2 = Integer.valueOf(t.substring(16));
                                if (victim.func_70662_br()) {
                                    if (arrow.field_70250_c == null) {
                                        victim.field_70172_ad = 0;
                                        victim.func_70097_a(DamageSource.field_76376_m, (float)i2.intValue() * ConfigurationHandler.harmingArrowAmplifier);
                                        victim.field_70172_ad = 0;
                                        continue;
                                    }
                                    victim.field_70172_ad = 0;
                                    victim.func_70097_a(DamageSource.func_76354_b((Entity)arrow.field_70250_c, (Entity)arrow.field_70250_c), (float)i2.intValue() * ConfigurationHandler.harmingArrowAmplifier);
                                    victim.field_70172_ad = 0;
                                    continue;
                                }
                                if (ConfigurationHandler.healingArrowNoDamage) {
                                    arrow.func_70239_b(0.0);
                                }
                                healAmount = (float)i2.intValue() * ConfigurationHandler.healingArrowAmplifier;
                                victim.func_70691_i(healAmount);
                                Helpers.healParticles((Entity)victim, Math.round(healAmount));
                            }
                            catch (Exception i4) {}
                        }
                        if (arrow instanceof EntityTippedArrow && ConfigurationHandler.tippedArrowFix) {
                            EntityTippedArrow tippedArrow = (EntityTippedArrow)arrow;
                            try {
                                Field field = ObfuscationReflectionHelper.findField(tippedArrow.getClass(), (String)"potion");
                                PotionType potion = (PotionType)field.get(tippedArrow);
                                if (potion == PotionTypes.field_185250_v || potion == PotionTypes.field_185251_w) {
                                    try {
                                        Integer i = ((PotionEffect)potion.func_185170_a().get(0)).func_76458_c();
                                        field.set(tippedArrow, PotionTypes.field_185229_a);
                                        if (victim.func_70662_br()) {
                                            if (arrow.field_70250_c == null) {
                                                victim.field_70172_ad = 0;
                                                victim.func_70097_a(DamageSource.field_76376_m, (float)i.intValue() * ConfigurationHandler.harmingArrowAmplifier);
                                                victim.field_70172_ad = 0;
                                            } else {
                                                victim.field_70172_ad = 0;
                                                victim.func_70097_a(DamageSource.func_76354_b((Entity)arrow.field_70250_c, (Entity)arrow.field_70250_c), (float)i.intValue() * ConfigurationHandler.harmingArrowAmplifier);
                                                victim.field_70172_ad = 0;
                                            }
                                            break block56;
                                        }
                                        if (ConfigurationHandler.healingArrowNoDamage) {
                                            arrow.func_70239_b(0.0);
                                        }
                                        float healAmount = (float)i.intValue() * ConfigurationHandler.healingArrowAmplifier;
                                        victim.func_70691_i(healAmount);
                                        Helpers.healParticles((Entity)victim, Math.round(healAmount));
                                    }
                                    catch (Exception i) {}
                                    break block56;
                                }
                                if (potion == PotionTypes.field_185252_x || potion == PotionTypes.field_185253_y) {
                                    try {
                                        Integer i = ((PotionEffect)potion.func_185170_a().get(0)).func_76458_c();
                                        field.set(tippedArrow, PotionTypes.field_185229_a);
                                        if (victim.func_70662_br()) {
                                            if (arrow.field_70250_c == null) {
                                                victim.field_70172_ad = 0;
                                                victim.func_70097_a(DamageSource.field_76376_m, (float)i.intValue() * ConfigurationHandler.healingArrowAmplifier);
                                                victim.field_70172_ad = 0;
                                            } else {
                                                victim.field_70172_ad = 0;
                                                victim.func_70097_a(DamageSource.func_76354_b((Entity)arrow.field_70250_c, (Entity)arrow.field_70250_c), (float)i.intValue() * ConfigurationHandler.healingArrowAmplifier);
                                                victim.field_70172_ad = 0;
                                            }
                                            break block56;
                                        }
                                        if (ConfigurationHandler.healingArrowNoDamage) {
                                            arrow.func_70239_b(0.0);
                                        }
                                        float healAmount = (float)i.intValue() * ConfigurationHandler.healingArrowAmplifier;
                                        victim.func_70691_i(healAmount);
                                        Helpers.healParticles((Entity)victim, Math.round(healAmount));
                                    }
                                    catch (Exception i) {}
                                    break block56;
                                }
                                if (potion != PotionTypes.field_185220_C && potion != PotionTypes.field_185221_D && potion != PotionTypes.field_185222_E) break block56;
                                try {
                                    if (!victim.func_70662_br() && ConfigurationHandler.healingArrowNoDamage) {
                                        arrow.func_70239_b(0.0);
                                    }
                                }
                                catch (Exception i) {}
                            }
                            catch (Exception field) {
                                // empty catch block
                            }
                        }
                    }
                    if (ConfigurationHandler.dragonboneBowWitherDamage > 0.0f && arrow.getClass().getSimpleName().equals("EntityDragonArrow")) {
                        victim.field_70172_ad = 0;
                        victim.func_70097_a(DamageSource.field_82727_n, ConfigurationHandler.dragonboneBowWitherDamage);
                        victim.field_70172_ad = 0;
                        Helpers.dragonArrowParticles((Entity)arrow);
                        arrow.func_70106_y();
                    }
                    if (!ConfigurationHandler.playArrowHitSound || !(arrow.field_70250_c instanceof EntityPlayer) || (player = (EntityPlayer)arrow.field_70250_c) == victim && arrow.getClass().toString().equals("EntityBoomerang") || arrow.field_70170_p.field_72995_K) break block59;
                    SoundHandler.playSound((Entity)player, SoundHandler.IMPACT_RANGED_0, 0.5f * ConfigurationHandler.bowStrikeSoundVolume, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                    break block59;
                }
                for (String t : arrow.func_184216_O()) {
                    if (!t.contains("lightning~")) continue;
                    try {
                        Integer i = Integer.valueOf(t.substring(10));
                        EnchantmentLightning.doLightning(arrow.field_70250_c, (Entity)arrow, i);
                        arrow.func_70106_y();
                    }
                    catch (Exception i) {}
                }
                break block59;
            }
            if (event.getEntity() instanceof EntityPotion) {
                EntityPotion entityPotion = (EntityPotion)event.getEntity();
                BlockPos pos = event.getRayTraceResult().func_178782_a();
                if (pos == null) {
                    pos = event.getRayTraceResult().field_72308_g.func_180425_c();
                }
                if (pos == null) {
                    return;
                }
                if (ConfigurationHandler.extraSplashPotionWidth > 0.0 || ConfigurationHandler.extraSplashPotionHeight > 0.0) {
                    AxisAlignedBB axisalignedbb0 = entityPotion.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                    AxisAlignedBB axisalignedbb1 = entityPotion.func_174813_aQ().func_72314_b(4.0 + ConfigurationHandler.extraSplashPotionWidth, 2.0 + ConfigurationHandler.extraSplashPotionHeight, 4.0 + ConfigurationHandler.extraSplashPotionWidth);
                    List list0 = entityPotion.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb0);
                    List list1 = entityPotion.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb1);
                    list1.removeAll(list0);
                    if (!list1.isEmpty()) {
                        for (EntityLivingBase entitylivingbase : list1) {
                            if (!entitylivingbase.func_184603_cC()) continue;
                            double d0 = entityPotion.func_70068_e((Entity)entitylivingbase);
                            double r = 4.0 + ConfigurationHandler.extraSplashPotionWidth + ConfigurationHandler.extraSplashPotionHeight;
                            if (!(d0 < (r *= r))) continue;
                            double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                            if (entitylivingbase == event.getRayTraceResult().field_72308_g) {
                                d1 = 1.0;
                            }
                            for (PotionEffect potioneffect : PotionUtils.func_185189_a((ItemStack)entityPotion.func_184543_l())) {
                                Potion potion = potioneffect.func_188419_a();
                                if (potion.func_76403_b()) {
                                    potion.func_180793_a((Entity)entityPotion, (Entity)entityPotion.func_85052_h(), entitylivingbase, potioneffect.func_76458_c(), d1);
                                    continue;
                                }
                                int i = (int)(d1 * (double)potioneffect.func_76459_b() + 0.5);
                                if (i <= 20) continue;
                                entitylivingbase.func_70690_d(new PotionEffect(potion, i, potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
                            }
                        }
                    }
                }
            }
        }
    }
}

