/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.potion;

import bettercombat.mod.client.ParticleBlood;
import bettercombat.mod.network.PacketHandler;
import bettercombat.mod.network.client.PacketBleeding;
import bettercombat.mod.potion.BetterCombatPotions;
import bettercombat.mod.util.ConfigurationHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionBleeding
extends Potion {
    public ResourceLocation TEXTURE = new ResourceLocation("bettercombat:textures/gui/bleeding.png");
    public static DamageSource DAMAGE_SOURCE = new DamageSource("bleeding").func_76348_h();

    protected PotionBleeding() {
        super(false, 0xFF6066);
        this.setRegistryName("bettercombat", "bleeding");
        this.func_76390_b("bettercombat.effect.bleeding");
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        super.renderInventoryEffect(x, y, effect, mc);
        mc.field_71446_o.func_110577_a(this.TEXTURE);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        super.renderHUDEffect(x, y, effect, mc, alpha);
        mc.field_71446_o.func_110577_a(this.TEXTURE);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    public boolean func_76398_f() {
        return true;
    }

    public void func_76394_a(EntityLivingBase entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn.field_70173_aa % 20 == 10) {
            PotionEffect bleeding;
            if (ConfigurationHandler.bleedingDurationExtendedIfWet && entityLivingBaseIn.func_70026_G() && !entityLivingBaseIn.func_70648_aU() && (bleeding = entityLivingBaseIn.func_70660_b(BetterCombatPotions.BLEEDING)) != null) {
                entityLivingBaseIn.func_184589_d(bleeding.func_188419_a());
                entityLivingBaseIn.func_70690_d(new PotionEffect(BetterCombatPotions.BLEEDING, bleeding.func_76459_b() + 10, amplifier, bleeding.func_82720_e(), bleeding.func_188418_e()));
            }
            if (ConfigurationHandler.bleedingDamageIncreasedIfSprinting && entityLivingBaseIn.func_70051_ag() && entityLivingBaseIn.field_70170_p.field_73012_v.nextFloat() < 0.2f && (bleeding = entityLivingBaseIn.func_70660_b(BetterCombatPotions.BLEEDING)) != null) {
                entityLivingBaseIn.func_184589_d(bleeding.func_188419_a());
                entityLivingBaseIn.func_70690_d(new PotionEffect(BetterCombatPotions.BLEEDING, bleeding.func_76459_b() + 20, amplifier, bleeding.func_82720_e(), bleeding.func_188418_e()));
            }
            if (entityLivingBaseIn.func_110143_aJ() > 0.0f) {
                entityLivingBaseIn.field_70172_ad = 0;
                entityLivingBaseIn.func_70097_a(DAMAGE_SOURCE, ConfigurationHandler.bleedingDamagePerTick * (float)(1 + amplifier));
                entityLivingBaseIn.field_70737_aN = 0;
                entityLivingBaseIn.field_70738_aO = 0;
                entityLivingBaseIn.field_70172_ad = 0;
            }
            this.bleedParticles(entityLivingBaseIn, MathHelper.func_76125_a((int)(amplifier * 8 + 16), (int)16, (int)127));
        }
    }

    private void bleedParticles(EntityLivingBase entityLivingBaseIn, int numberOfParticles) {
        if (!entityLivingBaseIn.field_70170_p.field_72995_K) {
            PacketHandler.instance.sendToAllAround((IMessage)new PacketBleeding(entityLivingBaseIn.func_145782_y(), numberOfParticles), new NetworkRegistry.TargetPoint(entityLivingBaseIn.field_70170_p.field_73011_w.getDimension(), entityLivingBaseIn.field_70165_t, entityLivingBaseIn.field_70163_u, entityLivingBaseIn.field_70161_v, 16.0));
        } else {
            while (--numberOfParticles >= 0) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a(new ParticleBlood.Factory().func_178902_a(0, entityLivingBaseIn.field_70170_p, entityLivingBaseIn.field_70165_t, entityLivingBaseIn.field_70163_u, entityLivingBaseIn.field_70161_v, 0.0, 0.0, 0.0, new int[0]));
            }
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }
}

