/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.network.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOnItemUse
implements IMessage {
    private int x;
    private int y;
    private int z;
    private boolean mainhand;
    private Integer sideHit;

    public PacketOnItemUse() {
    }

    public PacketOnItemUse(int posX, int posY, int posZ, boolean mh, EnumFacing sideHit) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.mainhand = mh;
        this.sideHit = sideHit.func_176745_a();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readBoolean() ? -ByteBufUtils.readVarInt((ByteBuf)buf, (int)4) : ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.y = buf.readBoolean() ? -ByteBufUtils.readVarInt((ByteBuf)buf, (int)2) : ByteBufUtils.readVarInt((ByteBuf)buf, (int)2);
        this.z = buf.readBoolean() ? -ByteBufUtils.readVarInt((ByteBuf)buf, (int)4) : ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        this.mainhand = buf.readBoolean();
        this.sideHit = ByteBufUtils.readVarInt((ByteBuf)buf, (int)1);
    }

    public void toBytes(ByteBuf buf) {
        if (this.x < 0) {
            buf.writeBoolean(true);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(-this.x), (int)4);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.x, (int)4);
        }
        if (this.y < 0) {
            buf.writeBoolean(true);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(-this.y), (int)2);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.y, (int)2);
        }
        if (this.z < 0) {
            buf.writeBoolean(true);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(-this.z), (int)4);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.z, (int)4);
        }
        buf.writeBoolean(this.mainhand);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.sideHit, (int)1);
    }

    public static class Handler
    implements IMessageHandler<PacketOnItemUse, IMessage> {
        public IMessage onMessage(PacketOnItemUse message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> Handler.handle(message, ctx));
            return null;
        }

        private static void handle(PacketOnItemUse message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            BlockPos blockPos = new BlockPos(message.x, message.y, message.z);
            EnumActionResult result = message.mainhand ? player.func_184614_ca().func_77973_b().func_180614_a((EntityPlayer)player, (World)player.func_71121_q(), blockPos, EnumHand.MAIN_HAND, EnumFacing.func_82600_a((int)message.sideHit), 0.0f, 0.0f, 0.0f) : player.func_184592_cb().func_77973_b().func_180614_a((EntityPlayer)player, (World)player.func_71121_q(), blockPos, EnumHand.OFF_HAND, EnumFacing.func_82600_a((int)message.sideHit), 0.0f, 0.0f, 0.0f);
            if (result.equals((Object)EnumActionResult.SUCCESS)) {
                Block block = player.func_71121_q().func_180495_p(blockPos).func_177230_c();
                if (block == null || block instanceof BlockAir) {
                    return;
                }
                if (block instanceof BlockLog) {
                    player.func_71121_q().func_175739_a(EnumParticleTypes.BLOCK_DUST, (double)message.x, (double)message.y, (double)message.z, 32, 1.0, 1.0, 1.0, 0.02, new int[]{Block.func_176210_f((IBlockState)block.func_176223_P())});
                    player.func_71121_q().func_184133_a(null, blockPos, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else {
                    player.func_71121_q().func_175739_a(EnumParticleTypes.BLOCK_DUST, (double)message.x + 0.3, (double)message.y + 1.0, (double)message.z + 0.3, 16, 0.4, 0.1, 0.4, 0.015, new int[]{Block.func_176210_f((IBlockState)block.func_176223_P())});
                    player.func_71121_q().func_184133_a(null, blockPos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }
}

