/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.network.client;

import bettercombat.mod.util.ConfigurationHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDamageTilt
implements IMessage {
    private float attackedAtYaw;

    public PacketDamageTilt() {
    }

    public PacketDamageTilt(float f) {
        this.attackedAtYaw = f;
    }

    public void fromBytes(ByteBuf buf) {
        this.attackedAtYaw = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.attackedAtYaw);
    }

    public static float getDamageTilt(EntityLivingBase player, EntityLivingBase source) {
        float attackYaw;
        double deltaX = player.field_70165_t - source.field_70165_t;
        double deltaZ = player.field_70161_v - source.field_70161_v;
        player.field_70739_aP = attackYaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - player.field_70177_z;
        return player.field_70739_aP;
    }

    public static class Handler
    implements IMessageHandler<PacketDamageTilt, IMessage> {
        public IMessage onMessage(PacketDamageTilt message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> Handler.handle(message, ctx));
            return null;
        }

        private static void handle(PacketDamageTilt message, MessageContext ctx) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.field_70739_aP = ConfigurationHandler.inverseDamageTiltAngle ? message.attackedAtYaw : -message.attackedAtYaw;
                player.field_70738_aO = 10;
                player.field_70737_aN = 6;
            }
        }
    }
}

