/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.enchantment;

import bettercombat.mod.enchantment.BetterCombatEnchantments;
import bettercombat.mod.util.ConfigurationHandler;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class EnchantmentLightning
extends Enchantment {
    public EnchantmentLightning() {
        super(Enchantment.Rarity.VERY_RARE, BetterCombatEnchantments.RANGED_WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        String NAME = "lightning";
        this.func_77322_b(NAME);
        this.setRegistryName("bettercombat", NAME);
        if (ConfigurationHandler.lightningEnchantmentEnabled) {
            BetterCombatEnchantments.ENCHANTMENTS.add(this);
        }
    }

    public int func_77325_b() {
        return 5;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 20 + enchantmentLevel * 2;
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 50;
    }

    public static boolean canActuallySeeSky(Entity victim) {
        try {
            for (int i = 0; i < 127; ++i) {
                if (i > 16) {
                    i += 16;
                }
                IBlockState iblockstate = victim.field_70170_p.func_180495_p(victim.func_180425_c().func_177981_b(i));
                boolean flag = false;
                if (iblockstate.func_177230_c() instanceof BlockAir || iblockstate.func_177230_c() instanceof BlockLiquid) {
                    flag = true;
                    continue;
                }
                if (!flag) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void doLightning(Entity attacker, Entity victim, int lvl) {
        if (lvl > 0 && EnchantmentLightning.canActuallySeeSky(victim)) {
            for (int i = 0; i < lvl; ++i) {
                EntityLightningBolt bolt = new EntityLightningBolt(victim.field_70170_p, victim.field_70165_t + (double)(victim.field_70170_p.field_73012_v.nextBoolean() ? (float)victim.field_70170_p.field_73012_v.nextInt(lvl) * 0.5f : (float)(-victim.field_70170_p.field_73012_v.nextInt(lvl)) * 0.5f), victim.field_70163_u, victim.field_70161_v + (double)(victim.field_70170_p.field_73012_v.nextBoolean() ? (float)victim.field_70170_p.field_73012_v.nextInt(lvl) * 0.5f : (float)(-victim.field_70170_p.field_73012_v.nextInt(lvl)) * 0.5f), true);
                try {
                    Field field = ObfuscationReflectionHelper.findField(bolt.getClass(), (String)"lightningState");
                    field.setInt(bolt, 1);
                }
                catch (Exception field) {
                    // empty catch block
                }
                victim.field_70170_p.func_72942_c((Entity)bolt);
            }
            victim.func_70015_d(1);
            float a = 0.8f + victim.field_70170_p.field_73012_v.nextFloat() * 0.2f;
            float b = 0.8f + victim.field_70170_p.field_73012_v.nextFloat() * 0.2f;
            victim.field_70170_p.func_184148_a((EntityPlayer)attacker, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.HOSTILE, 1.0f, a);
            victim.field_70170_p.func_184148_a((EntityPlayer)attacker, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, SoundEvents.field_187754_de, SoundCategory.HOSTILE, 1.0f, b);
            if (attacker instanceof EntityPlayer) {
                attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.HOSTILE, 1.0f, a);
                attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundEvents.field_187754_de, SoundCategory.HOSTILE, 1.0f, b);
            }
            float r = 0.4f + (float)lvl * 0.4f;
            List livingList = victim.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(victim.func_180425_c()).func_72314_b((double)r, (double)r, (double)r));
            for (EntityLivingBase elb : livingList) {
                if (victim == elb) continue;
                elb.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 13, 1, true, false));
                elb.field_70172_ad = 0;
                elb.func_70097_a(DamageSource.func_76354_b((Entity)attacker, (Entity)attacker), victim.func_70026_G() ? (ConfigurationHandler.lightningEnchantmentBaseDamage + (float)lvl * ConfigurationHandler.lightningEnchantmentDamagePerLevel) * ConfigurationHandler.lightningEnchantmentWetModifier : ConfigurationHandler.lightningEnchantmentBaseDamage + (float)lvl * ConfigurationHandler.lightningEnchantmentDamagePerLevel);
                elb.field_70172_ad = 0;
            }
            if (victim instanceof EntityLivingBase) {
                victim.field_70172_ad = 0;
                ((EntityLivingBase)victim).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 13, 1, true, false));
                victim.field_70172_ad = 0;
            }
            if (attacker != null) {
                victim.field_70172_ad = 0;
                victim.func_70097_a(DamageSource.func_76354_b((Entity)attacker, (Entity)attacker), victim.func_70026_G() ? (ConfigurationHandler.lightningEnchantmentBaseDamage + (float)lvl * ConfigurationHandler.lightningEnchantmentDamagePerLevel) * ConfigurationHandler.lightningEnchantmentWetModifier : ConfigurationHandler.lightningEnchantmentBaseDamage + (float)lvl * ConfigurationHandler.lightningEnchantmentDamagePerLevel);
                victim.field_70172_ad = 0;
            } else {
                victim.field_70172_ad = 0;
                victim.func_70097_a(DamageSource.field_180137_b.func_82726_p(), victim.func_70026_G() ? (ConfigurationHandler.lightningEnchantmentBaseDamage + (float)lvl * ConfigurationHandler.lightningEnchantmentDamagePerLevel) * ConfigurationHandler.lightningEnchantmentWetModifier : ConfigurationHandler.lightningEnchantmentBaseDamage + (float)lvl * ConfigurationHandler.lightningEnchantmentDamagePerLevel);
                victim.field_70172_ad = 0;
            }
        }
    }
}

