/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client;

import bettercombat.mod.client.AnimationHandler;
import bettercombat.mod.client.BetterCombatHand;
import bettercombat.mod.client.ClientProxy;
import bettercombat.mod.client.SoundHandler;
import bettercombat.mod.network.PacketHandler;
import bettercombat.mod.network.server.PacketBreakBlock;
import bettercombat.mod.network.server.PacketFastEquip;
import bettercombat.mod.network.server.PacketMainhandAttack;
import bettercombat.mod.network.server.PacketOffhandAttack;
import bettercombat.mod.network.server.PacketOnItemUse;
import bettercombat.mod.network.server.PacketParrying;
import bettercombat.mod.network.server.PacketShieldBash;
import bettercombat.mod.network.server.PacketStopActiveHand;
import bettercombat.mod.server.CommonProxy;
import bettercombat.mod.util.ConfigurationHandler;
import bettercombat.mod.util.Helpers;
import bettercombat.mod.util.Reflections;
import com.elenai.elenaidodge2.api.FeathersHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EventHandlersClient {
    public final Minecraft mc;
    public ItemStack itemStackMainhand = ItemStack.field_190927_a;
    public ItemStack itemStackOffhand = ItemStack.field_190927_a;
    public int itemStackMainhandSlot = -1;
    public int itemStackOffhandSlot = -1;
    public final BetterCombatHand betterCombatMainhand = new BetterCombatHand();
    public final BetterCombatHand betterCombatOffhand = new BetterCombatHand();
    public int offhandCooldown = 0;
    public int mainhandCooldown = 0;
    public static final String EMPTY = "";
    public static final String BLANK_SPACE = " ";
    public static final String SW_DASH = "- ";
    public static final String attackSpeedString = I18n.func_135052_a((String)"attribute.name.generic.attackSpeed", (Object[])new Object[0]);
    public static final String attackDamageString = I18n.func_135052_a((String)"attribute.name.generic.attackDamage", (Object[])new Object[0]);
    public static final String ATTACK_SPEED_REGEX = "(([0-9]+\\.*[0-9]*)( *" + attackSpeedString + "))";
    public static final String ATTACK_DAMAGE_REGEX = "(([0-9]+\\.*[0-9]*)( *" + attackDamageString + "))";
    public static final String mainhandString = I18n.func_135052_a((String)"item.modifiers.mainhand", (Object[])new Object[0]);
    private double hX = 0.0;
    private double hZ = 0.0;
    private int tickCounter = 0;
    public float featherLevelBreathingIntensity = 1.0f;
    private int parryingTimer = 0;
    public boolean parrying = false;
    public int leftClickResultType = 0;
    public boolean holdingLeftClick = false;
    public static final float PI_FLOAT = (float)Math.PI;
    public static final double SQRT_2_DOUBLE = MathHelper.field_180189_a;
    public static final double RADIAN_TO_DEGREE = 57.29577951308232;

    public EventHandlersClient() {
        this.mc = Minecraft.func_71410_x();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean overwriteLeftClick(boolean checkBlocks) {
        if (Reflections.getLeftClickCounter(this.mc) > 0 && !this.mc.field_71442_b.func_78758_h()) {
            return true;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (this.invalidPlayer(player)) {
            return true;
        }
        if (ConfigurationHandler.isBlacklisted(this.itemStackMainhand.func_77973_b())) {
            return false;
        }
        if (this.checkItemstacksChanged(false)) {
            return true;
        }
        if (!player.func_184607_cu().func_190926_b()) {
            if (this.betterCombatMainhand.getWeaponProperty() != ConfigurationHandler.WeaponProperty.TWOHAND && Helpers.isHandActive((EntityPlayer)player, EnumHand.OFF_HAND)) {
                Item shield = player.func_184607_cu().func_77973_b();
                if (player.func_184811_cZ().func_185141_a(shield)) {
                    return true;
                }
                int bashCooldown = -1;
                for (ConfigurationHandler.CustomShield s : ConfigurationHandler.shields) {
                    if (!shield.equals(s.shield)) continue;
                    bashCooldown = s.cooldown;
                    break;
                }
                if (bashCooldown >= 0) {
                    this.offhandCooldown = bashCooldown;
                    this.betterCombatOffhand.attackCooldown = bashCooldown;
                    player.func_184811_cZ().func_185145_a(shield, bashCooldown);
                    this.sendStopActiveHandPacket();
                    this.betterCombatOffhand.setShieldBashing();
                    if (Reflections.getLeftClickCounter(this.mc) < 10) {
                        Reflections.setLeftClickCounter(this.mc, 10);
                    }
                    this.leftClickResultType = 0;
                    return true;
                }
            }
            this.leftClickResultType = 0;
            return true;
        }
        if (checkBlocks && this.leftClickResultType <= 0) {
            RayTraceResult mov = this.mc.field_71476_x;
            if (mov == null) {
                return true;
            }
            if (this.leftClickResultType < 0) {
                if (!this.mainhandMouseoverHasEntity() || this.betterCombatMainhand.getSwingTimer() > 0) return false;
                this.leftClickResultType = 1;
            } else if (mov.field_72313_a == RayTraceResult.Type.BLOCK && mov.func_178782_a() != null && mov.func_178782_a() != BlockPos.field_177992_a && !this.isCuttable(player.field_70170_p.func_180495_p(mov.func_178782_a()).func_177230_c())) {
                if (this.itemStackMainhand.func_77973_b() instanceof ItemTool && this.betterCombatMainhand.getSwingTimer() <= 0) {
                    ItemTool tool = (ItemTool)this.itemStackMainhand.func_77973_b();
                    float efficiency = Reflections.getEfficiency(tool).floatValue();
                    if (tool instanceof ItemSpade) {
                        this.betterCombatMainhand.startMining(MathHelper.func_76125_a((int)(22 - (int)(efficiency * 0.33f)), (int)13, (int)22));
                    } else if (tool instanceof ItemAxe) {
                        this.betterCombatMainhand.startMining(MathHelper.func_76125_a((int)(15 - (int)(efficiency * 0.5f)), (int)6, (int)15));
                    } else if (tool instanceof ItemPickaxe) {
                        this.betterCombatMainhand.startMining(MathHelper.func_76125_a((int)(17 - (int)(efficiency * 0.5f)), (int)8, (int)17));
                    } else {
                        this.betterCombatMainhand.startMining(MathHelper.func_76125_a((int)(15 - (int)(efficiency * 0.5f)), (int)6, (int)15));
                    }
                    this.leftClickResultType = -1;
                    return false;
                }
                if (!this.isMainhandAttackReady() && this.betterCombatMainhand.hasConfigWeapon() || this.betterCombatMainhand.getSwingTimer() > 0) return true;
                this.betterCombatMainhand.startMining(12);
                this.leftClickResultType = -1;
                return false;
            }
        }
        if (!this.isMainhandAttackReady()) {
            return true;
        }
        this.leftClickResultType = 1;
        this.resetMainhandCooldown(player);
        this.betterCombatMainhand.initiateAnimation(this.mainhandCooldown);
        if (Reflections.getLeftClickCounter(this.mc) >= this.mainhandCooldown) return true;
        Reflections.setLeftClickCounter(this.mc, this.mainhandCooldown);
        return true;
    }

    public boolean isHittingBlock() {
        return this.mc.field_71476_x != null && this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK;
    }

    private void sendStopActiveHandPacket() {
        this.mc.field_71439_g.func_184597_cx();
        PacketHandler.instance.sendToServer((IMessage)new PacketStopActiveHand());
    }

    public void mainhandAttack() {
        if (this.mainhandHitEntity(this.getMainhandMouseover())) {
            return;
        }
        if (this.mainhandHitBlock(this.mc.field_71476_x)) {
            return;
        }
        PacketHandler.instance.sendToServer((IMessage)new PacketMainhandAttack());
    }

    private boolean mainhandHitBlock(RayTraceResult rayTraceResults) {
        if (rayTraceResults != null && rayTraceResults.field_72313_a == RayTraceResult.Type.BLOCK && rayTraceResults.func_178782_a() != null && rayTraceResults.func_178782_a() != BlockPos.field_177992_a && !this.itemStackMainhand.func_190926_b() && this.toolCanInteractWithBlock(this.itemStackMainhand.func_77973_b()) && this.itemStackMainhand.func_77973_b().func_180614_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71439_g.field_70170_p, rayTraceResults.func_178782_a(), EnumHand.MAIN_HAND, rayTraceResults.field_178784_b, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS) {
            PacketHandler.instance.sendToServer((IMessage)new PacketOnItemUse(rayTraceResults.func_178782_a().func_177958_n(), rayTraceResults.func_178782_a().func_177956_o(), rayTraceResults.func_178782_a().func_177952_p(), true, rayTraceResults.field_178784_b));
            return true;
        }
        return false;
    }

    private boolean mainhandHitEntity(RayTraceResult rayTraceResults) {
        if (rayTraceResults != null && rayTraceResults.field_72308_g != null) {
            PacketHandler.instance.sendToServer((IMessage)new PacketMainhandAttack(rayTraceResults.field_72308_g.func_145782_y()));
            return true;
        }
        return false;
    }

    private boolean toolCanInteractWithBlock(Item item) {
        return ConfigurationHandler.tillingRequiresAnimation && item instanceof ItemHoe || ConfigurationHandler.grassPathingRequiresAnimation && item instanceof ItemSpade || ConfigurationHandler.strippingBarkRequiresAnimation && item instanceof ItemAxe;
    }

    @Nullable
    private RayTraceResult getMainhandMouseover() {
        return this.getMouseOverExtended(this.mc.field_71439_g, Helpers.getMainhandReach((EntityPlayer)this.mc.field_71439_g, this.betterCombatMainhand.getAdditionalReach()), this.getExtraSweepWidth(this.betterCombatMainhand.getSweep()), RayTraceResult.Type.ENTITY);
    }

    private boolean mainhandMouseoverHasEntity() {
        return this.getMouseOverExtended(this.mc.field_71439_g, Helpers.getMainhandReach((EntityPlayer)this.mc.field_71439_g, this.betterCombatMainhand.getAdditionalReach()), this.getExtraSweepWidth(this.betterCombatMainhand.getSweep()), RayTraceResult.Type.BLOCK) != null;
    }

    public float getExtraSweepWidth(int sweep) {
        return sweep > 0 ? MathHelper.func_76131_a((float)((3.0f + (float)sweep) * 0.1f), (float)0.0f, (float)0.8f) : 0.0f;
    }

    public void offhandAttack() {
        if (!this.itemStackOffhand.func_190926_b() && this.itemStackOffhand.func_77973_b() instanceof ItemTool) {
            if (this.offhandHitBlock(this.mc.field_71476_x)) {
                return;
            }
            if (this.offhandHitBlock(this.getOffhandMouseover())) {
                return;
            }
        } else {
            if (this.offhandHitEntity(this.getOffhandMouseover())) {
                return;
            }
            if (this.offhandHitBlock(this.mc.field_71476_x)) {
                return;
            }
        }
        PacketHandler.instance.sendToServer((IMessage)new PacketOffhandAttack());
    }

    private boolean offhandHitBlock(RayTraceResult rayTraceResults) {
        if (rayTraceResults != null && rayTraceResults.field_72313_a == RayTraceResult.Type.BLOCK && rayTraceResults.func_178782_a() != null && rayTraceResults.func_178782_a() != BlockPos.field_177992_a && !this.itemStackOffhand.func_190926_b() && this.toolCanInteractWithBlock(this.itemStackOffhand.func_77973_b()) && this.itemStackOffhand.func_77973_b().func_180614_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71439_g.field_70170_p, rayTraceResults.func_178782_a(), EnumHand.OFF_HAND, rayTraceResults.field_178784_b, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS) {
            PacketHandler.instance.sendToServer((IMessage)new PacketOnItemUse(rayTraceResults.func_178782_a().func_177958_n(), rayTraceResults.func_178782_a().func_177956_o(), rayTraceResults.func_178782_a().func_177952_p(), true, rayTraceResults.field_178784_b));
            return true;
        }
        return false;
    }

    private boolean offhandHitEntity(RayTraceResult rayTraceResults) {
        if (rayTraceResults != null && rayTraceResults.field_72308_g != null && ConfigurationHandler.rightClickAttackable((EntityPlayer)this.mc.field_71439_g, rayTraceResults.field_72308_g)) {
            if (this.itemStackOffhand.func_77973_b() instanceof ItemShield) {
                PacketHandler.instance.sendToServer((IMessage)new PacketShieldBash(rayTraceResults.field_72308_g.func_145782_y()));
                return true;
            }
            PacketHandler.instance.sendToServer((IMessage)new PacketOffhandAttack(rayTraceResults.field_72308_g.func_145782_y()));
            return true;
        }
        return false;
    }

    @Nullable
    private RayTraceResult getOffhandMouseover() {
        return this.getMouseOverExtended(this.mc.field_71439_g, Helpers.getOffhandReach((EntityPlayer)this.mc.field_71439_g, this.betterCombatOffhand.getAdditionalReach(), this.itemStackOffhand, this.itemStackMainhand), this.getExtraSweepWidth(this.betterCombatOffhand.getSweep()), RayTraceResult.Type.ENTITY);
    }

    private boolean offhandMouseoverHasEntity() {
        return this.getMouseOverExtended(this.mc.field_71439_g, Helpers.getOffhandReach((EntityPlayer)this.mc.field_71439_g, this.betterCombatOffhand.getAdditionalReach(), this.itemStackOffhand, this.itemStackMainhand), this.getExtraSweepWidth(this.betterCombatOffhand.getSweep()), RayTraceResult.Type.BLOCK) != null;
    }

    private boolean isCuttable(Block block) {
        return block instanceof IPlantable || block instanceof IShearable;
    }

    private boolean cutGrass(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        Block block = this.mc.field_71439_g.field_70170_p.func_180495_p(pos).func_177230_c();
        if (this.isCuttable(block)) {
            PacketHandler.instance.sendToServer((IMessage)new PacketBreakBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            this.mc.field_71439_g.field_70170_p.func_175698_g(pos);
            Helpers.sweepParticlesClient((EntityPlayer)this.mc.field_71439_g, pos.func_177958_n(), pos.func_177952_p());
            while (this.mc.field_71439_g.func_130014_f_().func_180495_p(pos).func_185890_d((IBlockAccess)this.mc.field_71439_g.func_130014_f_(), pos) != Block.field_185506_k) {
                pos = pos.func_177984_a();
                block = this.mc.field_71439_g.field_70170_p.func_180495_p(pos).func_177230_c();
                if (pos == null || !this.isCuttable(block)) break;
                PacketHandler.instance.sendToServer((IMessage)new PacketBreakBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                this.mc.field_71439_g.field_70170_p.func_175698_g(pos);
            }
            return true;
        }
        return false;
    }

    public boolean overwriteRightClick() {
        if (this.invalidPlayer(this.mc.field_71439_g)) {
            return true;
        }
        this.checkItemstacksChanged(false);
        RayTraceResult mov = this.mc.field_71476_x;
        if (mov == null) {
            return true;
        }
        if (this.itemStackMainhand.func_190926_b() && (this.itemStackOffhand.func_190926_b() || ConfigurationHandler.isBlacklisted(this.itemStackOffhand.func_77973_b()))) {
            return false;
        }
        if (this.betterCombatMainhand.getWeaponProperty() == ConfigurationHandler.WeaponProperty.TWOHAND) {
            if (this.itemStackMainhand.func_77975_n() == EnumAction.NONE) {
                if (this.rightClickInteract(EnumHand.MAIN_HAND)) {
                    return true;
                }
                if (this.canParry(false)) {
                    this.parrying = true;
                }
            }
            Reflections.setRightClickDelayTimer(this.mc, 4);
            return true;
        }
        if (this.betterCombatOffhand.getWeaponProperty() == ConfigurationHandler.WeaponProperty.TWOHAND || this.betterCombatOffhand.getWeaponProperty() == ConfigurationHandler.WeaponProperty.MAINHAND) {
            if (mov.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = mov.func_178782_a();
                if (pos == null || pos == BlockPos.field_177992_a) {
                    return true;
                }
                Block block = this.mc.field_71439_g.field_70170_p.func_180495_p(pos).func_177230_c();
                if (this.useToolsMainhandOnly(this.mc.field_71439_g, block)) {
                    return true;
                }
            }
            if (this.itemStackMainhand.func_77975_n() == EnumAction.NONE) {
                if (this.rightClickInteract(EnumHand.MAIN_HAND)) {
                    return true;
                }
                if (this.canParry(false)) {
                    this.parrying = true;
                }
            } else if (this.rightClickInteract(EnumHand.MAIN_HAND)) {
                return true;
            }
            Reflections.setRightClickDelayTimer(this.mc, 4);
            return true;
        }
        if (this.itemStackMainhand.func_77975_n() != EnumAction.NONE || this.itemStackOffhand.func_77975_n() != EnumAction.NONE) {
            if (this.itemStackOffhand.func_77975_n() == EnumAction.BLOCK && (!this.isOffhandAttackReady() || ConfigurationHandler.disableBlockingWhileAttacking && !this.isMainhandAttackReady())) {
                this.sendStopActiveHandPacket();
            }
            return false;
        }
        if (mov.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = mov.func_178782_a();
            if (pos == null || pos == BlockPos.field_177992_a) {
                return true;
            }
            IBlockState state = this.mc.field_71439_g.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!this.offhandMouseoverHasEntity() || this.mc.field_71439_g.field_70170_p.field_72995_K && block.func_180639_a(this.mc.field_71439_g.field_70170_p, pos, state, (EntityPlayer)this.mc.field_71439_g, EnumHand.OFF_HAND, this.mc.field_71476_x.field_178784_b, (float)this.mc.field_71476_x.field_178784_b.func_82601_c(), (float)this.mc.field_71476_x.field_178784_b.func_96559_d(), (float)this.mc.field_71476_x.field_178784_b.func_82599_e())) {
                if ((block instanceof IPlantable || block instanceof IShearable) && (this.betterCombatOffhand.hasConfigWeapon() || this.itemStackMainhand.func_77973_b() instanceof ItemHoe || this.itemStackOffhand.func_77973_b() instanceof ItemHoe)) {
                    if (this.itemStackMainhand.func_77973_b() instanceof ItemHoe || this.itemStackOffhand.func_77973_b() instanceof ItemHoe) {
                        return false;
                    }
                } else {
                    if (!this.betterCombatMainhand.hasConfigWeapon() && !this.betterCombatOffhand.hasConfigWeapon()) {
                        return false;
                    }
                    if (this.rightClickInteract(EnumHand.MAIN_HAND) || this.rightClickInteract(EnumHand.OFF_HAND)) {
                        return true;
                    }
                    if (this.useTools(this.mc.field_71439_g, block)) {
                        return true;
                    }
                }
            }
        } else {
            if (!this.betterCombatMainhand.hasConfigWeapon() && !this.betterCombatOffhand.hasConfigWeapon()) {
                return false;
            }
            if (mov.field_72308_g != null && !ConfigurationHandler.rightClickAttackable((EntityPlayer)this.mc.field_71439_g, mov.field_72308_g)) {
                return false;
            }
        }
        if (this.mc.field_71439_g.func_70093_af() && ConfigurationHandler.sneakingDisablesOffhandAttack) {
            return false;
        }
        if (!this.isOffhandAttackReady()) {
            return true;
        }
        return this.initiateOffhandAttack(this.mc.field_71439_g);
    }

    private boolean canParry(boolean checkOffhand) {
        return this.betterCombatMainhand.canWeaponParry() && this.betterCombatMainhand.hasConfigWeapon() && (!checkOffhand || this.itemStackOffhand.func_190926_b()) && this.isMainhandAttackReady() && !this.mc.field_71439_g.func_184811_cZ().func_185141_a(this.itemStackMainhand.func_77973_b());
    }

    private boolean useTools(EntityPlayerSP player, Block block) {
        if (ConfigurationHandler.grassPathingRequiresAnimation && block instanceof BlockGrass) {
            if (this.itemStackMainhand.func_77973_b() instanceof ItemSpade) {
                if (this.isMainhandAttackReady()) {
                    this.overwriteLeftClick(false);
                }
                return true;
            }
            if (this.itemStackOffhand.func_77973_b() instanceof ItemSpade) {
                if (this.isOffhandAttackReady()) {
                    this.initiateOffhandAttack(player);
                }
                return true;
            }
        }
        if (ConfigurationHandler.tillingRequiresAnimation && (block instanceof BlockDirt || block instanceof BlockGrass || block instanceof BlockGrassPath)) {
            if (this.itemStackMainhand.func_77973_b() instanceof ItemHoe) {
                if (this.isMainhandAttackReady()) {
                    this.overwriteLeftClick(false);
                }
                return true;
            }
            if (this.itemStackOffhand.func_77973_b() instanceof ItemHoe) {
                if (this.isOffhandAttackReady()) {
                    this.initiateOffhandAttack(player);
                }
                return true;
            }
        }
        if (ConfigurationHandler.strippingBarkRequiresAnimation && block instanceof BlockLog) {
            if (this.itemStackMainhand.func_77973_b() instanceof ItemAxe) {
                if (this.isMainhandAttackReady()) {
                    this.overwriteLeftClick(false);
                }
                return true;
            }
            if (this.itemStackOffhand.func_77973_b() instanceof ItemAxe) {
                if (this.isOffhandAttackReady()) {
                    this.initiateOffhandAttack(player);
                }
                return true;
            }
        }
        return false;
    }

    private boolean useToolsMainhandOnly(EntityPlayerSP player, Block block) {
        if (ConfigurationHandler.grassPathingRequiresAnimation && block instanceof BlockGrass && this.itemStackMainhand.func_77973_b() instanceof ItemSpade) {
            if (this.isMainhandAttackReady()) {
                this.overwriteLeftClick(false);
            }
            return true;
        }
        if (ConfigurationHandler.tillingRequiresAnimation && (block instanceof BlockDirt || block instanceof BlockGrass || block instanceof BlockGrassPath) && this.itemStackMainhand.func_77973_b() instanceof ItemHoe) {
            if (this.isMainhandAttackReady()) {
                this.overwriteLeftClick(false);
            }
            return true;
        }
        if (ConfigurationHandler.strippingBarkRequiresAnimation && block instanceof BlockLog && this.itemStackMainhand.func_77973_b() instanceof ItemAxe) {
            if (this.isMainhandAttackReady()) {
                this.overwriteLeftClick(false);
            }
            return true;
        }
        return false;
    }

    private boolean initiateOffhandAttack(EntityPlayerSP player) {
        if (this.betterCombatOffhand.hasConfigWeapon()) {
            this.resetOffhandCooldown(player);
            this.betterCombatOffhand.initiateAnimation(this.offhandCooldown);
            return true;
        }
        if (this.canParry(true)) {
            this.parrying = true;
        }
        return false;
    }

    private boolean rightClickInteract(EnumHand enumhand) {
        if (Reflections.getRightClickDelayTimer(this.mc) > 0) {
            return true;
        }
        if (!this.mc.field_71442_b.func_181040_m() && !this.mc.field_71439_g.func_184838_M()) {
            ItemStack itemstack = this.mc.field_71439_g.func_184586_b(enumhand);
            if (this.mc.field_71476_x != null) {
                switch (this.mc.field_71476_x.field_72313_a) {
                    case ENTITY: {
                        if (this.mc.field_71442_b.func_187102_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71476_x.field_72308_g, this.mc.field_71476_x, enumhand) == EnumActionResult.SUCCESS) {
                            Reflections.setRightClickDelayTimer(this.mc, 4);
                            return true;
                        }
                        if (this.mc.field_71442_b.func_187097_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71476_x.field_72308_g, enumhand) != EnumActionResult.SUCCESS) break;
                        Reflections.setRightClickDelayTimer(this.mc, 4);
                        return true;
                    }
                    case BLOCK: {
                        BlockPos blockpos = this.mc.field_71476_x.func_178782_a();
                        if (this.mc.field_71441_e.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) break;
                        int i = itemstack.func_190916_E();
                        if (this.toolCanInteractWithBlock(itemstack.func_77973_b())) {
                            return false;
                        }
                        EnumActionResult enumactionresult = this.mc.field_71442_b.func_187099_a(this.mc.field_71439_g, this.mc.field_71441_e, blockpos, this.mc.field_71476_x.field_178784_b, this.mc.field_71476_x.field_72307_f, enumhand);
                        if (enumactionresult != EnumActionResult.SUCCESS) break;
                        this.mc.field_71439_g.func_184609_a(enumhand);
                        if (!itemstack.func_190926_b() && (itemstack.func_190916_E() != i || this.mc.field_71442_b.func_78758_h())) {
                            this.mc.field_71460_t.field_78516_c.func_187460_a(enumhand);
                        }
                        Reflections.setRightClickDelayTimer(this.mc, 4);
                        return true;
                    }
                }
            }
            if (itemstack.func_190926_b() && (this.mc.field_71476_x == null || this.mc.field_71476_x.field_72313_a == RayTraceResult.Type.MISS)) {
                ForgeHooks.onEmptyClick((EntityPlayer)this.mc.field_71439_g, (EnumHand)enumhand);
                Reflections.setRightClickDelayTimer(this.mc, 4);
                return true;
            }
            if (!itemstack.func_190926_b() && this.mc.field_71442_b.func_187101_a((EntityPlayer)this.mc.field_71439_g, (World)this.mc.field_71441_e, enumhand) == EnumActionResult.SUCCESS) {
                this.mc.field_71460_t.field_78516_c.func_187460_a(enumhand);
                Reflections.setRightClickDelayTimer(this.mc, 4);
                return true;
            }
        }
        return false;
    }

    public void stopBreaking() {
        KeyBinding.func_74510_a((int)this.mc.field_71474_y.field_74312_F.func_151463_i(), (boolean)false);
        this.mc.field_71442_b.func_78767_c();
        this.mc.field_71476_x = new RayTraceResult(RayTraceResult.Type.MISS, this.mc.field_71439_g.func_70040_Z(), EnumFacing.UP, BlockPos.field_177992_a);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseEvent(MouseEvent event) {
        KeyBinding rightClick = this.mc.field_71474_y.field_74313_G;
        if (event.isButtonstate() && event.getButton() == rightClick.func_151463_i() + 100 && this.overwriteRightClick()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            if (Reflections.getRightClickDelayTimer(this.mc) <= 0) {
                Reflections.setRightClickDelayTimer(this.mc, 4);
            }
            KeyBinding.func_74510_a((int)rightClick.func_151463_i(), (boolean)true);
        }
        KeyBinding leftClick = this.mc.field_71474_y.field_74312_F;
        if (event.isButtonstate() && event.getButton() == leftClick.func_151463_i() + 100 && this.overwriteLeftClick(true)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            KeyBinding.func_74510_a((int)leftClick.func_151463_i(), (boolean)true);
        }
    }

    public void stopClick() {
        this.stopBreaking();
        if (Reflections.getLeftClickCounter(this.mc) <= 0) {
            Reflections.setLeftClickCounter(this.mc, 4);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (ClientProxy.fastEquip.func_151470_d() && this.isMainhandAttackReady() && this.isOffhandAttackReady()) {
            PacketHandler.instance.sendToServer((IMessage)new PacketFastEquip());
        }
        if ((this.mc.field_71474_y.field_74313_G.func_151468_f() || this.mc.field_71474_y.field_74313_G.func_151470_d()) && this.mc.field_71474_y.field_74313_G.func_151463_i() != -99 && this.overwriteRightClick()) {
            if (Reflections.getRightClickDelayTimer(this.mc) <= 0) {
                Reflections.setRightClickDelayTimer(this.mc, 4);
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
        if ((this.mc.field_71474_y.field_74312_F.func_151468_f() || this.mc.field_71474_y.field_74312_F.func_151470_d()) && this.mc.field_71474_y.field_74312_F.func_151463_i() != -100 && this.overwriteLeftClick(true)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    public static float calculateFeatherLevelBreathingIntensity(EntityPlayerSP player) {
        if (ConfigurationHandler.elanaiDodgeEnabled) {
            float healthLevelModifier;
            float featherLevelModifier = 3.0f - (float)FeathersHelper.getFeatherLevel((EntityPlayerSP)player) * 0.1f;
            return featherLevelModifier > (healthLevelModifier = 3.0f - player.func_110143_aJ() / player.func_110138_aP() * 2.0f) ? featherLevelModifier : healthLevelModifier;
        }
        return 3.0f - player.func_110143_aJ() / player.func_110138_aP() * 2.0f;
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void tickEventLow(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.mc.field_71439_g != null) {
            this.checkItemstacksChanged(false);
            if (this.tickCounter++ > 20) {
                if (Minecraft.func_175610_ah() < 30) {
                    ClientProxy.AH_INSTANCE.partialTicks = 0.6666667f;
                } else {
                    float f = ClientProxy.AH_INSTANCE.partialTicks = Minecraft.func_175610_ah() <= 0 ? 1.0f : 20.0f / (float)Minecraft.func_175610_ah();
                }
                if (this.mc.field_71439_g != null && !this.mc.field_71439_g.isAddedToWorld()) {
                    this.featherLevelBreathingIntensity = EventHandlersClient.calculateFeatherLevelBreathingIntensity(this.mc.field_71439_g);
                }
                this.tickCounter = 0;
            }
            if (this.mc.field_71439_g.func_70051_ag()) {
                ClientProxy.AH_INSTANCE.mainhandSprinting = ClientProxy.AH_INSTANCE.equippedProgressMainhand != -1.0f && !AnimationHandler.isMainhandAttacking();
                ClientProxy.AH_INSTANCE.offhandSprinting = ClientProxy.AH_INSTANCE.equippedProgressOffhand != -1.0f && !AnimationHandler.isOffhandAttacking();
            } else {
                ClientProxy.AH_INSTANCE.mainhandSprinting = false;
                ClientProxy.AH_INSTANCE.offhandSprinting = false;
            }
            ClientProxy.AH_INSTANCE.blocking = this.itemStackOffhand.func_77973_b() instanceof ItemShield && Helpers.isHandActive((EntityPlayer)this.mc.field_71439_g, EnumHand.OFF_HAND) && (!ConfigurationHandler.disableBlockingWhileAttacking || this.isMainhandAttackReady());
            if (this.mc.field_71476_x != null) {
                if (this.mc.field_71476_x.field_72307_f != null) {
                    this.hX = this.mc.field_71439_g.field_70165_t - this.mc.field_71476_x.field_72307_f.field_72450_a;
                    this.hZ = this.mc.field_71439_g.field_70161_v - this.mc.field_71476_x.field_72307_f.field_72449_c;
                    this.calculateWallAwarePositioning();
                } else if (this.mc.field_71476_x.field_72308_g != null) {
                    this.hX = this.mc.field_71439_g.field_70165_t - (this.mc.field_71476_x.field_72308_g.field_70165_t + (double)this.mc.field_71476_x.field_72308_g.field_70130_N * 0.5);
                    this.hZ = this.mc.field_71439_g.field_70161_v - (this.mc.field_71476_x.field_72308_g.field_70161_v + (double)this.mc.field_71476_x.field_72308_g.field_70130_N * 0.5);
                    this.calculateWallAwarePositioning();
                }
            }
            if (this.mc.field_71474_y.field_74312_F.func_151468_f() || this.mc.field_71474_y.field_74312_F.func_151470_d()) {
                if (this.overwriteLeftClick(true)) {
                    // empty if block
                }
                this.holdingLeftClick = true;
            } else {
                if (this.leftClickResultType != 0 || this.holdingLeftClick) {
                    this.stopClick();
                }
                this.leftClickResultType = 0;
                this.holdingLeftClick = false;
            }
            if (this.mc.field_71474_y.field_74313_G.func_151468_f() || this.mc.field_71474_y.field_74313_G.func_151470_d()) {
                if (!this.mc.field_71439_g.func_184587_cr()) {
                    this.overwriteRightClick();
                }
                if (this.betterCombatMainhand.getWeaponProperty() == ConfigurationHandler.WeaponProperty.TWOHAND) {
                    Reflections.setRightClickDelayTimer(this.mc, 2);
                }
            } else {
                if (this.parryingTimer > 0) {
                    --this.parryingTimer;
                }
                if (this.parrying) {
                    this.parrying = false;
                    PacketHandler.instance.sendToServer((IMessage)new PacketParrying(false));
                }
            }
            if (this.parrying) {
                if (this.mc.field_71439_g.field_70122_E) {
                    this.mc.field_71439_g.func_70031_b(false);
                    this.mc.field_71439_g.field_70159_w *= 0.2;
                    this.mc.field_71439_g.field_70179_y *= 0.2;
                    this.mc.field_71439_g.field_70133_I = true;
                }
                if (this.parryingTimer < 10 && this.parryingTimer++ == 5) {
                    PacketHandler.instance.sendToServer((IMessage)new PacketParrying(true));
                }
            }
            if (this.betterCombatMainhand.isSwinging()) {
                this.betterCombatMainhand.tick();
                if (!this.betterCombatMainhand.isMining()) {
                    if (this.betterCombatMainhand.damageReady()) {
                        this.mainhandAttack();
                    } else if (this.betterCombatMainhand.soundReady()) {
                        this.mainhandSwingSound();
                    }
                }
                if (ConfigurationHandler.disableBlockingWhileAttacking && Helpers.isHandActive((EntityPlayer)this.mc.field_71439_g, EnumHand.OFF_HAND)) {
                    this.sendStopActiveHandPacket();
                }
            } else if (this.betterCombatMainhand.equipSoundTimer > 0 && --this.betterCombatMainhand.equipSoundTimer <= 0) {
                this.mainhandEquipSound();
                if (this.betterCombatOffhand.equipSoundTimer == 1) {
                    this.betterCombatOffhand.equipSoundTimer = -1;
                }
            }
            if (this.betterCombatOffhand.getSwingTimer() > 0) {
                this.betterCombatOffhand.tick();
                if (!this.betterCombatOffhand.isMining()) {
                    if (this.betterCombatOffhand.damageReady()) {
                        this.offhandAttack();
                    } else if (this.betterCombatOffhand.soundReady()) {
                        this.offhandSwingSound();
                    }
                }
                if (ConfigurationHandler.disableBlockingWhileShieldBashing && Helpers.isHandActive((EntityPlayer)this.mc.field_71439_g, EnumHand.OFF_HAND)) {
                    this.sendStopActiveHandPacket();
                }
            } else if (this.betterCombatOffhand.equipSoundTimer > 0 && --this.betterCombatOffhand.equipSoundTimer <= 0 && this.betterCombatOffhand.getWeaponProperty() != ConfigurationHandler.WeaponProperty.TWOHAND && this.betterCombatOffhand.getWeaponProperty() != ConfigurationHandler.WeaponProperty.MAINHAND) {
                this.offhandEquipSound();
            }
            if (this.mainhandCooldown > 0) {
                --this.mainhandCooldown;
            }
            if (this.offhandCooldown > 0) {
                --this.offhandCooldown;
            }
        }
    }

    public void calculateWallAwarePositioning() {
        this.hX *= this.hX;
        this.hZ *= this.hZ;
        if (this.hX < 1.0 && this.hZ < 1.0) {
            if (this.hX < this.hZ) {
                this.hZ *= 0.1;
            } else {
                this.hX *= 0.1;
            }
            ClientProxy.AH_INSTANCE.tooCloseCap = MathHelper.func_151237_a((double)(0.6 - (this.hX + this.hZ) * 3.0), (double)0.1, (double)0.6);
        } else {
            ClientProxy.AH_INSTANCE.tooCloseCap = 0.0;
        }
    }

    public static double clamp(double d0, double d1) {
        if (d0 > d1) {
            return d1;
        }
        return d0;
    }

    public boolean checkItemstacksChanged(boolean force) {
        if (this.checkItemstackChangedOffhand(force)) {
            Reflections.unpressKey(this.mc.field_71474_y.field_74313_G);
            if (this.checkItemstackChangedMainhand(force)) {
                Reflections.unpressKey(this.mc.field_71474_y.field_74312_F);
                this.resetMainhandCooldown(this.mc.field_71439_g);
                ClientProxy.AH_INSTANCE.reequipAnimationMainhand();
                this.stopClick();
            }
            this.resetOffhandCooldown(this.mc.field_71439_g);
            ClientProxy.AH_INSTANCE.reequipAnimationOffhand();
            this.leftClickResultType = 0;
            return true;
        }
        if (this.checkItemstackChangedMainhand(force)) {
            Reflections.unpressKey(this.mc.field_71474_y.field_74312_F);
            this.resetMainhandCooldown(this.mc.field_71439_g);
            ClientProxy.AH_INSTANCE.reequipAnimationMainhand();
            this.leftClickResultType = 0;
            this.stopClick();
            return true;
        }
        return false;
    }

    public boolean checkItemstackChangedMainhand(boolean force) {
        if (force || this.itemStackMainhandSlot != this.mc.field_71439_g.field_71071_by.field_70461_c || !this.areBaseItemsEqual(this.itemStackMainhand, this.mc.field_71439_g.func_184614_ca())) {
            if (!force && this.betterCombatMainhand.equipSoundTimer <= 0 && this.betterCombatOffhand.equipSoundTimer >= 0 && this.betterCombatMainhand.hasConfigWeapon()) {
                SoundHandler.playSheatheSoundRight((EntityLivingBase)this.mc.field_71439_g, this.betterCombatMainhand, this.itemStackMainhand, this.betterCombatMainhand.getAttackCooldown(), Helpers.isMetalItem(this.itemStackMainhand));
            }
            if (!this.itemStackMainhand.func_190926_b()) {
                try {
                    this.mc.field_71439_g.func_110140_aT().func_111148_a(this.itemStackMainhand.func_111283_C(EntityEquipmentSlot.MAINHAND));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.betterCombatOffhand.hasConfigWeapon() && this.betterCombatMainhand.getWeaponProperty().equals((Object)ConfigurationHandler.WeaponProperty.TWOHAND)) {
                    this.resetOffhandCooldown(this.mc.field_71439_g);
                }
            }
            this.itemStackMainhand = this.mc.field_71439_g.func_184614_ca();
            this.itemStackMainhandSlot = this.mc.field_71439_g.field_71071_by.field_70461_c;
            if (!this.itemStackMainhand.func_190926_b()) {
                try {
                    this.mc.field_71439_g.func_110140_aT().func_111147_b(this.itemStackMainhand.func_111283_C(EntityEquipmentSlot.MAINHAND));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.betterCombatMainhand.resetBetterCombatWeapon();
            ClientProxy.AH_INSTANCE.resetMiningEnergy();
            this.stopParrying();
            if (ConfigurationHandler.isConfigWeapon(this.itemStackMainhand.func_77973_b())) {
                String mainhandString = Helpers.getRegistryNameFromItem(this.itemStackMainhand);
                for (ConfigurationHandler.ConfigWeapon weapon : ConfigurationHandler.weapons) {
                    if (!mainhandString.contains(weapon.name)) continue;
                    this.betterCombatMainhand.setBetterCombatWeapon(this.mc.field_71439_g, weapon, this.itemStackMainhand, this.itemStackOffhand, true);
                    if (this.betterCombatOffhand.hasConfigWeapon() && this.betterCombatMainhand.getWeaponProperty().equals((Object)ConfigurationHandler.WeaponProperty.TWOHAND)) {
                        this.resetOffhandCooldown(this.mc.field_71439_g);
                    }
                    return true;
                }
                this.betterCombatMainhand.setBetterCombatWeapon(this.mc.field_71439_g, ConfigurationHandler.DEFAULT_CUSTOM_WEAPON, this.itemStackMainhand, this.itemStackOffhand, true);
                if (this.betterCombatOffhand.hasConfigWeapon() && this.betterCombatMainhand.getWeaponProperty().equals((Object)ConfigurationHandler.WeaponProperty.TWOHAND)) {
                    this.resetOffhandCooldown(this.mc.field_71439_g);
                }
                return true;
            }
            if (this.itemStackMainhand.func_77973_b() instanceof ItemShield) {
                this.betterCombatMainhand.equipSoundTimer = 5;
            }
            return true;
        }
        return false;
    }

    private void stopParrying() {
        this.parrying = false;
        PacketHandler.instance.sendToServer((IMessage)new PacketParrying(false));
    }

    public boolean areBaseItemsEqual(ItemStack a, ItemStack b) {
        return a.func_190926_b() && b.func_190926_b() || !a.func_190926_b() && !b.func_190926_b() && a.func_77973_b() == b.func_77973_b();
    }

    public boolean checkItemstackChangedOffhand(boolean force) {
        if (force || !ItemStack.func_185132_d((ItemStack)this.itemStackOffhand, (ItemStack)this.mc.field_71439_g.func_184592_cb())) {
            if (!force && this.betterCombatOffhand.equipSoundTimer <= 0 && this.betterCombatOffhand.hasConfigWeapon()) {
                SoundHandler.playSheatheSoundLeft((EntityLivingBase)this.mc.field_71439_g, this.betterCombatOffhand, this.itemStackOffhand, this.betterCombatOffhand.getAttackCooldown(), Helpers.isMetalItem(this.itemStackOffhand));
                this.betterCombatOffhand.equipSoundTimer = -1;
            }
            this.itemStackOffhand = this.mc.field_71439_g.func_184592_cb();
            this.betterCombatOffhand.resetBetterCombatWeapon();
            if (ConfigurationHandler.isConfigWeapon(this.itemStackOffhand.func_77973_b())) {
                String offhandString = Helpers.getRegistryNameFromItem(this.itemStackOffhand);
                for (ConfigurationHandler.ConfigWeapon weapon : ConfigurationHandler.weapons) {
                    if (!offhandString.contains(weapon.name)) continue;
                    this.betterCombatOffhand.setBetterCombatWeapon(this.mc.field_71439_g, weapon, this.itemStackMainhand, this.itemStackOffhand, false);
                    return true;
                }
                this.betterCombatOffhand.setBetterCombatWeapon(this.mc.field_71439_g, ConfigurationHandler.DEFAULT_CUSTOM_WEAPON, this.itemStackMainhand, this.itemStackOffhand, false);
                return true;
            }
            if (this.itemStackOffhand.func_77973_b() instanceof ItemShield) {
                this.betterCombatOffhand.equipSoundTimer = 5;
            }
            return true;
        }
        return false;
    }

    public void mainhandSwingSound() {
        this.mc.field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
        SoundHandler.playSwingSoundRight((EntityLivingBase)this.mc.field_71439_g, this.betterCombatMainhand, this.itemStackMainhand, this.betterCombatMainhand.getAttackCooldown());
    }

    public void offhandSwingSound() {
        this.mc.field_71439_g.func_184609_a(EnumHand.OFF_HAND);
        SoundHandler.playSwingSoundLeft((EntityLivingBase)this.mc.field_71439_g, this.betterCombatOffhand, this.itemStackOffhand, this.betterCombatOffhand.getAttackCooldown());
    }

    private void mainhandEquipSound() {
        SoundHandler.playEquipSoundRight((EntityLivingBase)this.mc.field_71439_g, this.betterCombatMainhand, this.itemStackMainhand, this.betterCombatMainhand.getAttackCooldown());
    }

    private void offhandEquipSound() {
        SoundHandler.playEquipSoundLeft((EntityLivingBase)this.mc.field_71439_g, this.betterCombatOffhand, this.itemStackOffhand, this.betterCombatOffhand.getAttackCooldown());
    }

    public boolean isMainhandAttackReady() {
        return this.mainhandCooldown <= 0;
    }

    public float getMainhandCooledAttackStrength() {
        return 1.0f - MathHelper.func_76131_a((float)((float)(1 + this.mainhandCooldown) / (float)this.betterCombatMainhand.getAttackCooldown()), (float)0.0f, (float)1.0f);
    }

    public boolean isOffhandAttackReady() {
        return this.offhandCooldown <= 0;
    }

    public float getOffhandCooledAttackStrength() {
        return 1.0f - MathHelper.func_76131_a((float)((float)(1 + this.offhandCooldown) / (float)this.betterCombatOffhand.getAttackCooldown()), (float)0.0f, (float)1.0f);
    }

    public void resetMainhandCooldown(EntityPlayerSP player) {
        this.mc.field_71439_g.func_184821_cY();
        this.mainhandCooldown = this.betterCombatMainhand.setAttackCooldown(this.getMainhandCooldown((EntityPlayer)player, this.itemStackMainhand, this.itemStackOffhand));
    }

    public void resetOffhandCooldown(EntityPlayerSP player) {
        this.offhandCooldown = this.betterCombatOffhand.setAttackCooldown(this.getOffhandCooldown((EntityPlayer)player, this.itemStackOffhand, this.itemStackMainhand));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void itemTooltipEventHigh(ItemTooltipEvent event) {
        if (ConfigurationHandler.isConfigWeapon(event.getItemStack().func_77973_b())) {
            for (ConfigurationHandler.ConfigWeapon s : ConfigurationHandler.weapons) {
                if (!Helpers.getRegistryNameFromItem(event.getItemStack()).contains(s.name)) continue;
                this.updateBetterCombatTooltipHigh(s, event);
                return;
            }
            this.updateBetterCombatTooltipHigh(ConfigurationHandler.DEFAULT_CUSTOM_WEAPON, event);
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ItemShield) {
            for (ConfigurationHandler.CustomShield s : ConfigurationHandler.shields) {
                if (!event.getItemStack().func_77973_b().equals(s.shield)) continue;
                event.getToolTip().add(EMPTY);
                event.getToolTip().add(I18n.func_135052_a((String)"bettercombat.info.property.offhand.text", (Object[])new Object[0]));
                event.getToolTip().add(BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + s.damage + I18n.func_135052_a((String)"bettercombat.info.bash.damage.text", (Object[])new Object[0]));
                event.getToolTip().add(BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + s.knockback + I18n.func_135052_a((String)"bettercombat.info.bash.knockback.text", (Object[])new Object[0]));
                event.getToolTip().add(BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + s.cooldown + I18n.func_135052_a((String)"bettercombat.info.bash.cooldown.text", (Object[])new Object[0]));
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void itemTooltipEventLow(ItemTooltipEvent event) {
        this.removeDuplicateEmptyLines(event);
    }

    private void removeDuplicateEmptyLines(ItemTooltipEvent event) {
        ArrayList<String> tooltips = new ArrayList<String>();
        boolean previousLineIsEmpty = false;
        for (String tag : event.getToolTip()) {
            if (tag.isEmpty() || tag.equals(BLANK_SPACE)) {
                if (!previousLineIsEmpty) {
                    tooltips.add(tag);
                }
                previousLineIsEmpty = true;
                continue;
            }
            if (tag.contains(mainhandString) || this.isEmptySWDash(tag)) continue;
            tooltips.add(tag);
            previousLineIsEmpty = false;
        }
        event.getToolTip().clear();
        event.getToolTip().addAll(tooltips);
    }

    private boolean isEmptySWDash(String tag) {
        return tag.endsWith(SW_DASH);
    }

    private void updateBetterCombatTooltipHigh(ConfigurationHandler.ConfigWeapon s, ItemTooltipEvent event) {
        if (ConfigurationHandler.showKnockbackTooltip && ConfigurationHandler.showKnockbackTooltipAsTotal) {
            event.getToolTip().add(BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + s.knockbackMod + I18n.func_135052_a((String)"bettercombat.info.knockback.text", (Object[])new Object[0]));
        }
        if (ConfigurationHandler.showReachTooltip && ConfigurationHandler.showReachTooltipAsTotal) {
            event.getToolTip().add(BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + (s.additionalReachMod + Helpers.getBaseReach((EntityPlayer)this.mc.field_71439_g)) + I18n.func_135052_a((String)"bettercombat.info.reachDistance.text", (Object[])new Object[0]));
        }
        if (ConfigurationHandler.showCritChanceTooltip && ConfigurationHandler.baseCritPercentChance >= 0.0 && ConfigurationHandler.showCritChanceTooltipAsTotal) {
            event.getToolTip().add(BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + (int)(s.critChanceMod * 100.0) + "%" + I18n.func_135052_a((String)"bettercombat.info.critChance.text", (Object[])new Object[0]));
        }
        if (ConfigurationHandler.showCritDamageTooltip && ConfigurationHandler.showCritDamageTooltipAsTotal) {
            event.getToolTip().add(BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + (int)((s.additionalCritDamageMod + ConfigurationHandler.baseCritPercentDamage) * 100.0) + "%" + I18n.func_135052_a((String)"bettercombat.info.critDamage.text", (Object[])new Object[0]));
        }
        int mainhandStringIndex = -1;
        boolean formattedAttackSpeed = false;
        boolean formattedAttackDamage = false;
        int i = 0;
        for (String tag : event.getToolTip()) {
            if (tag.contains(mainhandString)) {
                if (mainhandStringIndex < 0) {
                    mainhandStringIndex = i;
                }
            } else if (!formattedAttackSpeed && tag.contains(attackSpeedString)) {
                if (event.getItemStack().func_77973_b() instanceof ItemSword && !ConfigurationHandler.swords.isEmpty()) {
                    String str = Helpers.getRegistryNameFromItem(event.getItemStack());
                    for (ConfigurationHandler.CustomSword sword : ConfigurationHandler.swords) {
                        if (!str.contains(sword.name)) continue;
                        try {
                            Matcher matcher = Pattern.compile(ATTACK_SPEED_REGEX).matcher(tag);
                            if (!matcher.find()) break;
                            formattedAttackSpeed = true;
                            event.getToolTip().set(i, BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + String.format("%.1f", (double)sword.attackSpeed + Double.parseDouble(matcher.group(2))) + BLANK_SPACE + attackSpeedString);
                        }
                        catch (Exception e) {
                            formattedAttackSpeed = true;
                            event.getToolTip().set(i, I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + tag);
                        }
                        break;
                    }
                    if (!formattedAttackSpeed) {
                        formattedAttackSpeed = true;
                        this.reformatAttackString(event, i, ATTACK_SPEED_REGEX, tag, attackSpeedString);
                    }
                } else {
                    formattedAttackSpeed = true;
                    this.reformatAttackString(event, i, ATTACK_SPEED_REGEX, tag, attackSpeedString);
                }
            } else if (!formattedAttackDamage && tag.contains(attackDamageString)) {
                formattedAttackDamage = true;
                this.reformatAttackString(event, i, ATTACK_DAMAGE_REGEX, tag, attackDamageString);
            }
            ++i;
        }
        if (mainhandStringIndex >= 0) {
            switch (s.property) {
                case ONEHAND: {
                    event.getToolTip().set(mainhandStringIndex, I18n.func_135052_a((String)"bettercombat.info.property.onehand.text", (Object[])new Object[0]));
                    break;
                }
                case VERSATILE: {
                    event.getToolTip().set(mainhandStringIndex, I18n.func_135052_a((String)"bettercombat.info.property.versatile.text", (Object[])new Object[0]));
                    break;
                }
                case MAINHAND: {
                    event.getToolTip().set(mainhandStringIndex, I18n.func_135052_a((String)"bettercombat.info.property.mainhand.text", (Object[])new Object[0]));
                    break;
                }
                case TWOHAND: {
                    event.getToolTip().set(mainhandStringIndex, I18n.func_135052_a((String)"bettercombat.info.property.twohand.text", (Object[])new Object[0]));
                    break;
                }
                default: {
                    event.getToolTip().set(mainhandStringIndex, I18n.func_135052_a((String)"bettercombat.info.property.onehand.text", (Object[])new Object[0]));
                }
            }
        }
        boolean flag = false;
        if (ConfigurationHandler.showKnockbackTooltip && !ConfigurationHandler.showKnockbackTooltipAsTotal && s.knockbackMod != ConfigurationHandler.baseKnockback) {
            if (!flag) {
                event.getToolTip().add(EMPTY);
            }
            event.getToolTip().add((s.knockbackMod > ConfigurationHandler.baseKnockback ? I18n.func_135052_a((String)"bettercombat.info.positive.color", (Object[])new Object[0]) : I18n.func_135052_a((String)"bettercombat.info.negative.color", (Object[])new Object[0])) + (s.knockbackMod - ConfigurationHandler.baseKnockback) + I18n.func_135052_a((String)"bettercombat.info.knockback.text", (Object[])new Object[0]));
            flag = true;
        }
        if (ConfigurationHandler.showReachTooltip && !ConfigurationHandler.showReachTooltipAsTotal && s.additionalReachMod != 0.0) {
            if (!flag) {
                event.getToolTip().add(EMPTY);
            }
            event.getToolTip().add((s.additionalReachMod > 0.0 ? I18n.func_135052_a((String)"bettercombat.info.positive.color", (Object[])new Object[0]) : I18n.func_135052_a((String)"bettercombat.info.negative.color", (Object[])new Object[0])) + s.additionalReachMod + I18n.func_135052_a((String)"bettercombat.info.reachDistance.text", (Object[])new Object[0]));
            flag = true;
        }
        if (ConfigurationHandler.showCritChanceTooltip && ConfigurationHandler.baseCritPercentChance >= 0.0 && !ConfigurationHandler.showCritChanceTooltipAsTotal && s.critChanceMod != ConfigurationHandler.baseCritPercentChance) {
            if (!flag) {
                event.getToolTip().add(EMPTY);
            }
            event.getToolTip().add((s.critChanceMod > 0.0 ? I18n.func_135052_a((String)"bettercombat.info.positive.color", (Object[])new Object[0]) : I18n.func_135052_a((String)"bettercombat.info.negative.color", (Object[])new Object[0])) + (int)((s.critChanceMod - ConfigurationHandler.baseCritPercentChance) * 100.0) + "%" + I18n.func_135052_a((String)"bettercombat.info.critChance.text", (Object[])new Object[0]));
            flag = true;
        }
        if (ConfigurationHandler.showCritDamageTooltip && !ConfigurationHandler.showCritDamageTooltipAsTotal && s.additionalCritDamageMod != 0.0) {
            if (!flag) {
                event.getToolTip().add(EMPTY);
            }
            event.getToolTip().add((s.additionalCritDamageMod > 0.0 ? I18n.func_135052_a((String)"bettercombat.info.positive.color", (Object[])new Object[0]) : I18n.func_135052_a((String)"bettercombat.info.negative.color", (Object[])new Object[0])) + (int)(s.additionalCritDamageMod * 100.0) + "%" + I18n.func_135052_a((String)"bettercombat.info.critDamage.text", (Object[])new Object[0]));
            flag = true;
        }
        if (ConfigurationHandler.showSweepTooltip && s.sweepMod > 0) {
            event.getToolTip().add(EMPTY);
            event.getToolTip().add(I18n.func_135052_a((String)"bettercombat.info.sweep.text", (Object[])new Object[0]) + Helpers.integerToRoman(s.sweepMod));
            flag = true;
        }
        if (ConfigurationHandler.showPotionEffectTooltip && s.configWeaponPotionEffect != null) {
            event.getToolTip().add(EMPTY);
            if (s.configWeaponPotionEffect.potionChance > 0.0f) {
                event.getToolTip().add((int)(s.configWeaponPotionEffect.potionChance * 100.0f) + "%" + I18n.func_135052_a((String)"bettercombat.info.potionEffect.chance.text", (Object[])new Object[0]));
            } else {
                event.getToolTip().add(I18n.func_135052_a((String)"bettercombat.info.potionEffect.crit.text", (Object[])new Object[0]));
            }
            double seconds = (double)Math.round((double)s.configWeaponPotionEffect.potionDuration * 0.5) * 0.1;
            String str = seconds % 1.0 == 0.0 ? (int)seconds + I18n.func_135052_a((String)"bettercombat.info.potionEffect.second.text", (Object[])new Object[0]) + ((int)seconds == 1 ? EMPTY : "s") : seconds + I18n.func_135052_a((String)"bettercombat.info.potionEffect.second.text", (Object[])new Object[0]);
            event.getToolTip().add((s.configWeaponPotionEffect.afflict ? I18n.func_135052_a((String)"bettercombat.info.potionEffect.negative.text", (Object[])new Object[0]) : I18n.func_135052_a((String)"bettercombat.info.potionEffect.positive.text", (Object[])new Object[0])) + I18n.func_135052_a((String)s.configWeaponPotionEffect.getPotion().func_76393_a(), (Object[])new Object[0]) + BLANK_SPACE + Helpers.integerToRoman(s.configWeaponPotionEffect.potionPower) + (s.configWeaponPotionEffect.potionDuration > 0 ? I18n.func_135052_a((String)"bettercombat.info.potionEffect.for.text", (Object[])new Object[0]) + str : EMPTY));
        }
    }

    private void reformatAttackString(ItemTooltipEvent event, int i, String regex, String tag, String s) {
        try {
            Matcher matcher = Pattern.compile(regex).matcher(tag);
            if (matcher.find()) {
                event.getToolTip().set(i, BLANK_SPACE + I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + String.format("%.1f", Double.parseDouble(matcher.group(2))) + BLANK_SPACE + s);
            }
        }
        catch (Exception e) {
            event.getToolTip().set(i, I18n.func_135052_a((String)"bettercombat.info.attribute.color", (Object[])new Object[0]) + tag);
        }
    }

    public static boolean isEntityInViewCone(Entity in, Entity target, int bounds) {
        double rotation = (Math.atan2(target.field_70161_v - in.field_70161_v, target.field_70165_t - in.field_70165_t) * 57.29577951308232 + 360.0) % 360.0 - (double)((in.func_70079_am() + 450.0f) % 360.0f);
        return rotation <= (double)(bounds >>= 1) && rotation >= (double)(-bounds) || rotation >= (double)(360 - bounds) || rotation <= (double)(bounds - 360);
    }

    public static boolean isEntityInView(Entity in, Entity target) {
        double rotation = (Math.atan2(target.field_70161_v - in.field_70161_v, target.field_70165_t - in.field_70165_t) * 57.29577951308232 + 360.0) % 360.0 - (double)((in.func_70079_am() + 450.0f) % 360.0f);
        return rotation <= 50.0 && rotation >= -50.0 || rotation >= 310.0 || rotation <= -310.0;
    }

    public RayTraceResult getMouseOverExtended(EntityPlayerSP player, double reach, double sweepWidth, RayTraceResult.Type checkType) {
        RayTraceResult pointedRayTraceResult;
        reach *= reach;
        Vec3d lookEyes = player.func_184187_bx() == null ? player.func_174824_e(this.mc.func_184121_ak()) : player.func_174824_e(this.mc.func_184121_ak()).func_72441_c(0.0, player.func_184187_bx().func_70042_X(), 0.0);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d lookTarget = lookEyes.func_178787_e(lookVec.func_186678_a(reach));
        if (checkType != RayTraceResult.Type.BLOCK && ConfigurationHandler.cutGrass) {
            pointedRayTraceResult = player.field_70170_p.func_147447_a(lookEyes, lookTarget, false, false, false);
            if (pointedRayTraceResult != null && pointedRayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && player.func_70092_e(pointedRayTraceResult.field_72307_f.field_72450_a, pointedRayTraceResult.field_72307_f.field_72448_b, pointedRayTraceResult.field_72307_f.field_72449_c) < reach) {
                this.cutGrass(pointedRayTraceResult.func_178782_a());
            }
            pointedRayTraceResult = player.field_70170_p.func_147447_a(lookEyes, lookTarget, false, false, false);
        } else {
            pointedRayTraceResult = player.field_70170_p.func_147447_a(lookEyes, lookTarget, false, true, false);
        }
        HashSet entities = new HashSet();
        if (pointedRayTraceResult != null && pointedRayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            entities.addAll(this.mc.field_71441_e.func_72839_b((Entity)player, new AxisAlignedBB(pointedRayTraceResult.field_72307_f, pointedRayTraceResult.field_72307_f)));
        }
        double closestLookDistanceSq = reach;
        entities.addAll(this.mc.field_71441_e.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach)));
        for (Entity entity : entities) {
            double distanceSq;
            if (entity instanceof MultiPartEntityPart && ((MultiPartEntityPart)entity).field_70259_a instanceof Entity) {
                entity = (Entity)((MultiPartEntityPart)entity).field_70259_a;
            }
            if (this.checkParent(entity)) {
                entity = this.getParent(entity);
            }
            if (!entity.func_70089_S() || entity == player.func_184187_bx() || !entity.func_70075_an() || !this.canPVP(entity, (EntityPlayer)this.mc.field_71439_g) || !EventHandlersClient.isEntityInView((Entity)player, entity) || (distanceSq = player.func_70068_e(entity)) > reach || !EventHandlersClient.canEntityBeSeen((Entity)player, entity)) continue;
            if (checkType == RayTraceResult.Type.BLOCK && pointedRayTraceResult != null && pointedRayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                return pointedRayTraceResult;
            }
            double lookDistanceSq = this.distanceToLook(entity, lookEyes, lookVec, reach, distanceSq);
            if (lookDistanceSq > closestLookDistanceSq) continue;
            double width = (double)entity.func_70111_Y() + ConfigurationHandler.extraAttackWidth + sweepWidth;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b(width, (double)entity.func_70111_Y(), width).func_72321_a(0.0, ConfigurationHandler.extraAttackHeight, 0.0);
            if (axisalignedbb.func_72318_a(lookEyes)) {
                pointedRayTraceResult = new RayTraceResult(entity, lookEyes);
                closestLookDistanceSq = lookDistanceSq;
                continue;
            }
            RayTraceResult rayTraceResult = axisalignedbb.func_72327_a(lookEyes, lookTarget);
            if (rayTraceResult == null) continue;
            pointedRayTraceResult = new RayTraceResult(entity, rayTraceResult.field_72307_f);
            closestLookDistanceSq = lookDistanceSq;
        }
        if (pointedRayTraceResult != null && pointedRayTraceResult.field_72313_a == RayTraceResult.Type.ENTITY) {
            return pointedRayTraceResult;
        }
        return this.ridingMouseOverEntity(player);
    }

    public static boolean canEntityBeSeen(Entity in, Entity target) {
        Vec3d inVec3d = new Vec3d(in.field_70165_t, in.field_70163_u + (double)in.func_70047_e(), in.field_70161_v);
        return in.field_70170_p.func_147447_a(inVec3d, new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v), false, true, false) == null || in.field_70170_p.func_147447_a(inVec3d, new Vec3d(target.field_70165_t, target.field_70163_u + (double)target.field_70131_O - (double)target.func_70047_e(), target.field_70161_v), false, true, false) == null;
    }

    private double distanceToLook(Entity entity, Vec3d lookEyes, Vec3d lookVec, double reach, double distanceSq) {
        Vec3d entityCenter = entity.func_174791_d().func_72441_c(0.0, (double)entity.field_70131_O * 0.5, 0.0);
        Vec3d eyeToEntity = entityCenter.func_178788_d(lookEyes);
        double projection = eyeToEntity.func_72430_b(lookVec);
        projection = MathHelper.func_151237_a((double)projection, (double)0.0, (double)distanceSq);
        Vec3d closestPoint = lookEyes.func_178787_e(lookVec.func_186678_a(projection));
        return entityCenter.func_72438_d(closestPoint) + Math.sqrt(distanceSq);
    }

    public boolean checkParent(Entity entity) {
        if (CommonProxy.partEntityClass != null) {
            return CommonProxy.partEntityClass.isInstance(entity);
        }
        return false;
    }

    public EntityLiving getParent(Object partEntity) {
        try {
            Field field = CommonProxy.partEntityClass.getDeclaredField("parent");
            field.setAccessible(true);
            Object fieldValue = field.get(partEntity);
            return (EntityLiving)fieldValue;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RayTraceResult ridingMouseOverEntity(EntityPlayerSP player) {
        Iterator iterator;
        if (player.func_184218_aH() && player.func_184187_bx() instanceof IMob) {
            return new RayTraceResult(player.func_184187_bx());
        }
        if (player.func_184207_aI() && (iterator = player.func_184188_bt().iterator()).hasNext()) {
            Entity passenger = (Entity)iterator.next();
            return new RayTraceResult(passenger);
        }
        return null;
    }

    public boolean invalidPlayer(EntityPlayerSP player) {
        return player == null || player.func_175149_v() || !player.func_70089_S() || player.func_110143_aJ() <= 0.0f;
    }

    public boolean canPVP(Entity entityHit, EntityPlayer player) {
        if (entityHit instanceof EntityPlayerMP) {
            return Helpers.execNullable(entityHit.func_184102_h(), MinecraftServer::func_71219_W, false);
        }
        return true;
    }

    public int getMainhandCooldown(EntityPlayer player, ItemStack mh, ItemStack oh) {
        double speed = this.betterCombatMainhand.hasConfigWeapon() ? player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b() : ConfigurationHandler.fistAndNonWeaponAttackSpeed;
        double multiply_base = 1.0;
        double multiply = 1.0;
        for (AttributeModifier attribute : player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111122_c()) {
            switch (attribute.func_111169_c()) {
                case 0: {
                    speed += attribute.func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base += attribute.func_111164_d();
                    break;
                }
                case 2: {
                    multiply *= 1.0 + attribute.func_111164_d();
                }
            }
        }
        if (mh.func_77973_b() instanceof ItemSword && !ConfigurationHandler.swords.isEmpty()) {
            String s = Helpers.getRegistryNameFromItem(mh);
            for (ConfigurationHandler.CustomSword sword : ConfigurationHandler.swords) {
                if (!s.contains(sword.name)) continue;
                speed += (double)sword.attackSpeed;
                break;
            }
        }
        if (!mh.func_190926_b() && !oh.func_190926_b()) {
            double mhFatigue = this.betterCombatMainhand.getFatigue();
            double ohFatigue = this.betterCombatOffhand.getFatigue();
            if (mhFatigue > 0.0 || ohFatigue > 0.0) {
                speed /= 1.0 + mhFatigue + ohFatigue / 2.0;
            }
        }
        return this.calculateAttackSpeedTicks(speed, multiply_base, multiply);
    }

    private int calculateAttackSpeedTicks(double speed, double multiply_base, double multiply) {
        return (int)(20.0 / MathHelper.func_151237_a((double)Helpers.calculateAttribute(speed, multiply_base, multiply), (double)0.1, (double)20.0) + ConfigurationHandler.addedSwingTickCooldown);
    }

    public int getOffhandCooldown(EntityPlayer player, ItemStack oh, ItemStack mh) {
        String attributeName;
        AttributeModifier modifier;
        int j;
        NBTTagList attributeList;
        NBTTagCompound tag;
        double speed = player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
        double multiply_base = 1.0;
        double multiply = 1.0;
        for (AttributeModifier attribute : player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111122_c()) {
            if (attribute.func_111167_a().equals(Helpers.weaponModifierUUID)) continue;
            switch (attribute.func_111169_c()) {
                case 0: {
                    speed += attribute.func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base += attribute.func_111164_d();
                    break;
                }
                case 2: {
                    multiply *= 1.0 + attribute.func_111164_d();
                }
            }
        }
        for (Map.Entry modifier2 : mh.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (!((String)modifier2.getKey()).contains(Helpers.ATTACK_SPEED) || ((AttributeModifier)modifier2.getValue()).func_111167_a().equals(Helpers.weaponModifierUUID)) continue;
            switch (((AttributeModifier)modifier2.getValue()).func_111169_c()) {
                case 0: {
                    speed -= ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base -= ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 2: {
                    multiply /= 1.0 + ((AttributeModifier)modifier2.getValue()).func_111164_d();
                }
            }
        }
        for (Map.Entry modifier2 : oh.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (!((String)modifier2.getKey()).contains(Helpers.ATTACK_SPEED)) continue;
            switch (((AttributeModifier)modifier2.getValue()).func_111169_c()) {
                case 0: {
                    speed += ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 1: {
                    multiply_base += ((AttributeModifier)modifier2.getValue()).func_111164_d();
                    break;
                }
                case 2: {
                    multiply *= 1.0 + ((AttributeModifier)modifier2.getValue()).func_111164_d();
                }
            }
        }
        if (mh.func_77942_o() && mh.func_77978_p().func_150297_b(Helpers.QUALITY, 10)) {
            tag = mh.func_179543_a(Helpers.QUALITY);
            attributeList = tag.func_150295_c(Helpers.ATTRIBUTE_MODIFIERS, 10);
            block28: for (j = 0; j < attributeList.func_74745_c(); ++j) {
                modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(j));
                attributeName = attributeList.func_150305_b(j).func_74779_i(Helpers.ATTRIBUTE_NAME);
                if (!attributeName.contains(Helpers.ATTACK_SPEED)) continue;
                switch (modifier.func_111169_c()) {
                    case 0: {
                        speed -= modifier.func_111164_d();
                        continue block28;
                    }
                    case 1: {
                        multiply_base -= modifier.func_111164_d();
                        continue block28;
                    }
                    case 2: {
                        multiply /= 1.0 + modifier.func_111164_d();
                    }
                }
            }
        }
        if (oh.func_77942_o() && oh.func_77978_p().func_150297_b(Helpers.QUALITY, 10)) {
            tag = oh.func_179543_a(Helpers.QUALITY);
            attributeList = tag.func_150295_c(Helpers.ATTRIBUTE_MODIFIERS, 10);
            block29: for (j = 0; j < attributeList.func_74745_c(); ++j) {
                modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(j));
                attributeName = attributeList.func_150305_b(j).func_74779_i(Helpers.ATTRIBUTE_NAME);
                if (!attributeName.contains(Helpers.ATTACK_SPEED)) continue;
                switch (modifier.func_111169_c()) {
                    case 0: {
                        speed += modifier.func_111164_d();
                        continue block29;
                    }
                    case 1: {
                        multiply_base += modifier.func_111164_d();
                        continue block29;
                    }
                    case 2: {
                        multiply *= 1.0 + modifier.func_111164_d();
                    }
                }
            }
        }
        if (oh.func_77973_b() instanceof ItemSword && !ConfigurationHandler.swords.isEmpty()) {
            String s = Helpers.getRegistryNameFromItem(oh);
            for (ConfigurationHandler.CustomSword sword : ConfigurationHandler.swords) {
                if (!s.contains(sword.name)) continue;
                speed += (double)sword.attackSpeed;
                break;
            }
        }
        if (!mh.func_190926_b() && !oh.func_190926_b()) {
            double mhFatigue = this.betterCombatMainhand.getFatigue();
            double ohFatigue = this.betterCombatOffhand.getFatigue();
            if (mhFatigue > 0.0 || ohFatigue > 0.0) {
                speed /= 1.0 + ohFatigue + mhFatigue / 2.0;
            }
        }
        return this.calculateAttackSpeedTicks(speed, multiply_base, multiply);
    }
}

