/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client;

import bettercombat.mod.client.ClientProxy;
import bettercombat.mod.util.ConfigurationHandler;
import com.elenai.elenaidodge2.api.FeathersHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BetterCombatHand {
    ConfigurationHandler.ConfigWeapon configWeapon = null;
    private boolean canWeaponParry = false;
    public int attackCooldown = ConfigurationHandler.minimumAttackSpeedTicks;
    private int sweep = 0;
    private int swingTimer = 0;
    private int swingTimerCap = 0;
    private float swingTimerIncrement = 0.0f;
    public int equipSoundTimer = -1;
    private float equipTimerIncrement = 1.0f;
    private int swingTimestampSound = 0;
    private int swingTimestampDamage = 0;
    private boolean mining = false;
    public float moveRightVariance = 1.0f;
    public float moveUpVariance = 1.0f;
    public float moveCloseVariance = 1.0f;
    public float rotateUpVariance = 1.0f;
    public float rotateCounterClockwiseVariance = 1.0f;
    public float rotateLeftVariance = 1.0f;
    public boolean alternateAnimation = false;
    private final Random rand = new Random();

    public BetterCombatHand() {
        this.resetBetterCombatWeapon();
    }

    public void setBetterCombatWeapon(EntityPlayerSP player, ConfigurationHandler.ConfigWeapon configWeapon, ItemStack mh, ItemStack oh, boolean mainhand) {
        this.configWeapon = configWeapon;
        if (mainhand) {
            this.setAttackCooldown(ClientProxy.EHC_INSTANCE.getMainhandCooldown((EntityPlayer)player, mh, oh));
            this.sweep = this.getSweepMod(configWeapon, mh);
        } else {
            this.setAttackCooldown(ClientProxy.EHC_INSTANCE.getOffhandCooldown((EntityPlayer)player, mh, oh));
            this.sweep = this.getSweepMod(configWeapon, oh);
        }
        this.equipTimerIncrement = 2.0f / (float)this.getAttackCooldown();
        this.equipSoundTimer = this.getAttackCooldown() >> 1;
        this.canWeaponParry = configWeapon.parry;
    }

    public int getSweepMod(ConfigurationHandler.ConfigWeapon configWeapon, ItemStack itemStack) {
        int sweepMod = configWeapon.sweepMod;
        NBTTagList nbttaglist = itemStack.func_77986_q();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            Enchantment enchantment = Enchantment.func_185262_c((int)nbttagcompound.func_74765_d("id"));
            short j = nbttagcompound.func_74765_d("lvl");
            if (enchantment != Enchantments.field_191530_r || j <= 0) continue;
            sweepMod += j;
        }
        return sweepMod;
    }

    public boolean hasConfigWeapon() {
        return this.configWeapon != null;
    }

    public void tick() {
        --this.swingTimer;
    }

    public ConfigurationHandler.WeaponProperty getWeaponProperty() {
        if (this.hasConfigWeapon()) {
            return this.getConfigWeapon().property;
        }
        return ConfigurationHandler.WeaponProperty.ONEHAND;
    }

    private ConfigurationHandler.ConfigWeapon getConfigWeapon() {
        return this.configWeapon;
    }

    public ConfigurationHandler.Animation getAnimation() {
        if (this.hasConfigWeapon()) {
            return this.getConfigWeapon().animation;
        }
        return ConfigurationHandler.Animation.NONE;
    }

    public ConfigurationHandler.SoundType getSoundType() {
        if (this.hasConfigWeapon()) {
            return this.getConfigWeapon().soundType;
        }
        return ConfigurationHandler.SoundType.NONE;
    }

    public double getFatigue() {
        if (this.hasConfigWeapon() && this.getConfigWeapon().property == ConfigurationHandler.WeaponProperty.VERSATILE) {
            return ConfigurationHandler.versatileFatigueAmount;
        }
        return 0.0;
    }

    public double getAdditionalReach() {
        if (this.hasConfigWeapon()) {
            return this.getConfigWeapon().additionalReachMod;
        }
        return -ConfigurationHandler.fistAndNonWeaponReachReduction;
    }

    public boolean canWeaponParry() {
        return this.canWeaponParry;
    }

    public int getSweep() {
        return this.sweep;
    }

    public float getEquipTimerIncrement() {
        return this.equipTimerIncrement;
    }

    public void resetBetterCombatWeapon() {
        this.configWeapon = null;
        this.canWeaponParry = false;
        this.sweep = 0;
        this.resetSwingTimer();
        this.swingTimerCap = 0;
        this.swingTimerIncrement = 0.0f;
        this.attackCooldown = ConfigurationHandler.minimumAttackSpeedTicks;
        this.equipSoundTimer = -1;
        this.equipTimerIncrement = 1.0f;
        this.swingTimestampSound = 0;
        this.swingTimestampDamage = 0;
        this.mining = false;
    }

    public void randomizeVariances() {
        this.moveRightVariance = this.randomMoveVariance();
        this.moveUpVariance = this.randomMoveVariance();
        this.moveCloseVariance = this.randomMoveVariance();
        this.rotateUpVariance = this.randomPreciseRotationVariance();
        this.rotateCounterClockwiseVariance = this.randomRotationVariance();
        this.rotateLeftVariance = this.randomRotationVariance();
    }

    public float randomMoveVariance() {
        return 1.06f - this.rand.nextFloat() * 0.12f;
    }

    public float randomRotationVariance() {
        return 1.03f - this.rand.nextFloat() * 0.06f;
    }

    public float randomPreciseRotationVariance() {
        return 1.015f - this.rand.nextFloat() * 0.03f;
    }

    public void stopAttack() {
        this.resetSwingTimer();
    }

    public void resetSwingTimer() {
        this.swingTimer = 0;
    }

    public boolean isSwinging() {
        return this.swingTimer > 0;
    }

    public boolean soundReady() {
        return this.swingTimer == this.swingTimestampSound;
    }

    public boolean damageReady() {
        return this.swingTimer == this.getSwingTimestampDamage();
    }

    public void initiateAnimation(int i) {
        if (this.hasConfigWeapon()) {
            switch (this.getConfigWeapon().animation) {
                case SWEEP: {
                    this.setSweeping(i);
                    return;
                }
                case STAB: {
                    this.setStabbing(i);
                    return;
                }
                case CHOP: {
                    this.setChopping(i);
                    return;
                }
            }
            this.setPunching(i);
            return;
        }
        this.setPunching(i);
    }

    public void setSweeping(int i) {
        this.mining = false;
        this.swingTimerCap = this.swingTimer = MathHelper.func_76125_a((int)i, (int)ConfigurationHandler.minimumAttackSpeedTicks, (int)14) - 2;
        this.swingTimerIncrement = 1.0f / (float)this.swingTimer;
        this.alternateAnimation = this.rand.nextBoolean();
        if (this.alternateAnimation) {
            this.swingTimestampSound = Math.round((float)this.swingTimer * 0.5f);
            this.swingTimestampDamage = this.swingTimestampSound - 1;
        } else {
            this.swingTimestampSound = Math.round((float)this.swingTimer * 0.8f);
            this.swingTimestampDamage = this.swingTimestampSound - 1;
        }
        this.moveRightVariance = this.randomMoveVariance();
        this.moveUpVariance = this.randomMoveVariance();
        this.moveCloseVariance = this.randomMoveVariance();
        this.rotateUpVariance = this.randomPreciseRotationVariance();
        this.rotateCounterClockwiseVariance = this.randomRotationVariance();
        this.rotateLeftVariance = this.randomRotationVariance();
    }

    public void setStabbing(int i) {
        this.mining = false;
        this.swingTimerCap = this.swingTimer = MathHelper.func_76125_a((int)i, (int)ConfigurationHandler.minimumAttackSpeedTicks, (int)13) - 1;
        this.swingTimerIncrement = 1.0f / (float)this.swingTimer;
        this.swingTimestampSound = Math.round((float)this.swingTimer * 0.8f);
        this.swingTimestampDamage = this.swingTimestampSound - 1;
        this.randomizeVariances();
    }

    public void setChopping(int i) {
        this.mining = false;
        this.swingTimerCap = this.swingTimer = MathHelper.func_76125_a((int)i, (int)ConfigurationHandler.minimumAttackSpeedTicks, (int)14) - 2;
        this.swingTimerIncrement = 1.0f / (float)this.swingTimer;
        this.swingTimestampSound = Math.round((float)this.swingTimer * 0.8f);
        this.swingTimestampDamage = this.swingTimestampSound - 1;
        this.randomizeVariances();
    }

    public void setPunching(int i) {
        this.mining = false;
        this.swingTimerCap = this.swingTimer = MathHelper.func_76125_a((int)i, (int)ConfigurationHandler.minimumAttackSpeedTicks, (int)14) - 2;
        this.swingTimerIncrement = 1.0f / (float)this.swingTimer;
        this.swingTimestampSound = Math.round((float)this.swingTimer * 0.8f);
        this.swingTimestampDamage = this.swingTimestampSound - 1;
    }

    public void startMining(int i) {
        this.mining = true;
        this.swingTimerCap = this.swingTimer = i;
        this.swingTimerIncrement = 1.0f / (float)this.swingTimer;
        this.swingTimestampSound = 0;
        this.swingTimestampDamage = 0;
        this.randomizeVariances();
    }

    public void setShieldBashing() {
        this.mining = false;
        this.swingTimerCap = this.swingTimer = 10;
        this.swingTimerIncrement = 0.1f;
        this.swingTimestampSound = 5;
        this.swingTimestampDamage = 7;
    }

    public int getSwingTimer() {
        return this.swingTimer;
    }

    public float getSwingTimerIncrement() {
        return this.swingTimerIncrement;
    }

    public void stopMining() {
        this.mining = false;
    }

    public boolean isMining() {
        return this.mining;
    }

    public int getSwingTimestampDamage() {
        return this.swingTimestampDamage;
    }

    public int getSwingTimerCap() {
        return this.swingTimerCap;
    }

    public void setSwingTimer(int i) {
        this.swingTimer = i;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public int setAttackCooldown(int cd) {
        if (ConfigurationHandler.elanaiDodgeEnabled && FeathersHelper.getFeatherLevel((EntityPlayerSP)Minecraft.func_71410_x().field_71439_g) - FeathersHelper.getWeight((EntityPlayerSP)Minecraft.func_71410_x().field_71439_g) <= ConfigurationHandler.elanaiDodgeMainHandFeatherCost) {
            cd <<= 1;
        }
        this.attackCooldown = cd < ConfigurationHandler.minimumAttackSpeedTicks ? ConfigurationHandler.minimumAttackSpeedTicks : cd;
        return this.attackCooldown;
    }
}

