/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client;

import bettercombat.mod.client.ClientProxy;
import bettercombat.mod.util.ConfigurationHandler;
import bettercombat.mod.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnimationHandler {
    public final GuiCrosshairsBC gc = new GuiCrosshairsBC();
    public final RenderItem itemRenderer;
    public float equippedProgressMainhand = 0.0f;
    public float equippedProgressOffhand = 0.0f;
    public float mainhandEnergy = 0.0f;
    public float offhandEnergy = 0.0f;
    public float breatheTicks = 0.0f;
    public float mainhandSprintingEnergy = 0.0f;
    public boolean mainhandSprinting = false;
    public float offhandSprintingEnergy = 0.0f;
    public boolean offhandSprinting = false;
    public boolean tooClose = false;
    public float tooCloseTicker = 0.0f;
    public float tooCloseTimer = 0.0f;
    public float tooCloseEnergy = 0.0f;
    public float blockingEnergy = 0.0f;
    public float parryingAnimationEnergy = 0.0f;
    public float parriedEnergy = 0.0f;
    public static final float PI = (float)Math.PI;
    public float miningEnergy = 0.0f;
    public float partialTicks = 0.6666667f;
    boolean breathingApplied = false;
    public boolean blocking = false;
    public double tooCloseCap = 0.0;
    private float miningEnergyFadeIn = 0.0f;

    public AnimationHandler() {
        this.itemRenderer = ClientProxy.EHC_INSTANCE.mc.func_175599_af();
    }

    @SubscribeEvent
    public void disableVanillaHandRender(RenderSpecificHandEvent event) {
        if (event.getHand() == EnumHand.MAIN_HAND) {
            this.breatheTicks += ConfigurationHandler.breathingAnimationSpeed * ClientProxy.EHC_INSTANCE.featherLevelBreathingIntensity * this.partialTicks;
            this.mainhandSprintingEnergy = this.mainhandSprinting ? (this.mainhandSprintingEnergy >= 20.0f ? 20.0f : (this.mainhandSprintingEnergy += this.partialTicks * 4.0f)) : (this.mainhandSprintingEnergy <= 0.0f ? 0.0f : (this.mainhandSprintingEnergy -= this.partialTicks * 3.0f));
            this.offhandSprintingEnergy = this.offhandSprinting ? (this.offhandSprintingEnergy >= 20.0f ? 20.0f : (this.offhandSprintingEnergy += this.partialTicks * 4.0f)) : (this.offhandSprintingEnergy <= 0.0f ? 0.0f : (this.offhandSprintingEnergy -= this.partialTicks * 3.0f));
            if (this.tooCloseCap > 0.0) {
                if ((double)this.tooCloseEnergy < this.tooCloseCap * 0.8) {
                    this.tooCloseEnergy += this.partialTicks * 0.04f;
                } else if ((double)this.tooCloseEnergy > this.tooCloseCap * 1.2) {
                    this.tooCloseEnergy -= this.partialTicks * 0.03f;
                }
            } else if (this.tooCloseEnergy > 0.0f) {
                float f;
                this.tooCloseEnergy -= this.partialTicks * 0.05f;
                if (f <= 0.0f) {
                    this.tooCloseEnergy = 0.0f;
                }
            }
            if (ClientProxy.EHC_INSTANCE.parrying) {
                if (this.parryingAnimationEnergy < 10.0f) {
                    float f;
                    this.parryingAnimationEnergy += this.partialTicks * 3.0f;
                    if (f > 10.0f) {
                        this.parryingAnimationEnergy = 10.0f;
                    }
                }
            } else if (this.parryingAnimationEnergy > 0.0f) {
                float f;
                this.parryingAnimationEnergy -= this.partialTicks * 3.0f;
                if (f < 0.0f) {
                    this.parryingAnimationEnergy = 0.0f;
                }
            }
            if (this.parriedEnergy > 0.0f) {
                float f;
                this.parriedEnergy -= this.partialTicks;
                if (f < 0.0f) {
                    this.parriedEnergy = 0.0f;
                }
            }
            if (ClientProxy.EHC_INSTANCE.betterCombatMainhand.hasConfigWeapon()) {
                if (Helpers.isHandActive((EntityPlayer)ClientProxy.EHC_INSTANCE.mc.field_71439_g, EnumHand.MAIN_HAND)) {
                    this.positionBreathingMainhand();
                    return;
                }
                this.customMainhandRender(event);
                return;
            }
            this.breathingApplied = true;
            this.positionBreathingMainhand();
            return;
        }
        if (event.getHand() == EnumHand.OFF_HAND) {
            if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.getWeaponProperty() == ConfigurationHandler.WeaponProperty.TWOHAND || ClientProxy.EHC_INSTANCE.betterCombatMainhand.getWeaponProperty() == ConfigurationHandler.WeaponProperty.TWOHAND || ClientProxy.EHC_INSTANCE.betterCombatOffhand.getWeaponProperty() == ConfigurationHandler.WeaponProperty.MAINHAND) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
                return;
            }
            if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.hasConfigWeapon()) {
                this.customOffhandRender(event);
                this.breathingApplied = false;
                return;
            }
            if (ClientProxy.EHC_INSTANCE.itemStackOffhand.func_77973_b() instanceof ItemShield) {
                if (this.blocking) {
                    if (this.blockingEnergy < 10.0f) {
                        float f;
                        this.blockingEnergy += this.partialTicks * 3.0f;
                        if (f > 10.0f) {
                            this.blockingEnergy = 10.0f;
                        }
                    }
                } else if (this.blockingEnergy > 0.0f) {
                    float f;
                    this.blockingEnergy -= this.partialTicks * 2.0f;
                    if (f < 0.0f) {
                        this.blockingEnergy = 0.0f;
                    }
                }
                this.customShieldRender(event);
                this.breathingApplied = false;
                return;
            }
            this.blockingEnergy = -1.0f;
            this.positionBreathingOffhand();
            this.breathingApplied = false;
            return;
        }
    }

    private void animationSweepCameraMainhand() {
        float f = (float)ClientProxy.EHC_INSTANCE.betterCombatMainhand.getSwingTimerCap() * this.partialTicks;
        float rotation = MathHelper.func_76126_a((float)(-0.3f + this.mainhandEnergy * 2.095493f * (float)Math.PI));
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * f;
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70177_z -= rotation * ConfigurationHandler.rotationYawSwing * f;
    }

    private void animationStabCameraMainhand() {
        float f = (float)ClientProxy.EHC_INSTANCE.betterCombatMainhand.getSwingTimerCap() * this.partialTicks;
        float rotation = MathHelper.func_76126_a((float)(-1.8f + this.mainhandEnergy * (float)Math.PI));
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT += rotation * ConfigurationHandler.cameraPitchSwing * f;
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70177_z -= rotation * ConfigurationHandler.rotationYawSwing * f;
    }

    private void animationChopCameraMainhand() {
        float f = (float)ClientProxy.EHC_INSTANCE.betterCombatMainhand.getSwingTimerCap() * this.partialTicks;
        float rotation = MathHelper.func_76134_b((float)(1.0f + this.mainhandEnergy * 2.18169f * (float)Math.PI));
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT = rotation > 0.0f ? (ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * f) : (ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * 2.0f * f);
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70177_z += rotation * ConfigurationHandler.rotationYawSwing * 0.2f * f;
    }

    private void animationSweepCameraOffhand() {
        float f = (float)ClientProxy.EHC_INSTANCE.betterCombatOffhand.getSwingTimerCap() * this.partialTicks;
        float rotation = MathHelper.func_76126_a((float)(-0.3f + this.offhandEnergy * 2.095493f * (float)Math.PI));
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * f;
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70177_z += rotation * ConfigurationHandler.rotationYawSwing * f;
    }

    private void animationStabCameraOffhand() {
        float f = (float)ClientProxy.EHC_INSTANCE.betterCombatOffhand.getSwingTimerCap() * this.partialTicks;
        float rotation = MathHelper.func_76126_a((float)(-1.8f + this.offhandEnergy * (float)Math.PI));
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * f;
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70177_z += rotation * ConfigurationHandler.rotationYawSwing * f;
    }

    private void animationChopCameraOffhand() {
        float f = (float)ClientProxy.EHC_INSTANCE.betterCombatOffhand.getSwingTimerCap() * this.partialTicks;
        float rotation = MathHelper.func_76134_b((float)(1.0f + this.offhandEnergy * 2.18169f * (float)Math.PI));
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT = rotation > 0.0f ? (ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * f) : (ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * 2.0f * f);
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70177_z -= rotation * ConfigurationHandler.rotationYawSwing * 0.2f * f;
    }

    private void animationShieldBashCameraOffhand() {
        float f = (float)ClientProxy.EHC_INSTANCE.betterCombatOffhand.getSwingTimerCap() * this.partialTicks;
        float rotation = MathHelper.func_76134_b((float)(-0.4f + this.offhandEnergy * 2.0f * (float)Math.PI));
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70726_aT -= rotation * ConfigurationHandler.cameraPitchSwing * f;
        ClientProxy.EHC_INSTANCE.mc.field_71439_g.field_70177_z += rotation * ConfigurationHandler.rotationYawSwing * f * 2.0f;
    }

    public static boolean isMainhandAttacking() {
        return ClientProxy.EHC_INSTANCE.betterCombatMainhand.isSwinging();
    }

    private void customMainhandRender(RenderSpecificHandEvent event) {
        event.setCanceled(true);
        event.setResult(Event.Result.DENY);
        GlStateManager.func_179094_E();
        this.positionMainWeapon();
        this.positionMainhandAwayIfOffhandAttacking();
        this.positionBreathingMainhand();
        if (ClientProxy.EHC_INSTANCE.betterCombatMainhand.isMining() && (AnimationHandler.isMainhandAttacking() || ClientProxy.EHC_INSTANCE.leftClickResultType < 0 || ClientProxy.EHC_INSTANCE.holdingLeftClick || this.miningEnergy > 0.0f)) {
            this.resetMainhandEnergy();
            Item tool = ClientProxy.EHC_INSTANCE.itemStackMainhand.func_77973_b();
            if (tool instanceof ItemSpade) {
                this.calculateMiningEnergy(event);
                this.animationDiggingMainhand(event);
                this.noReequipAnimationMainhand();
            } else if (tool instanceof ItemAxe) {
                this.calculateMiningEnergy(event);
                this.animationWoodcuttingMainhand(event);
                this.reequipAnimationMainhand();
            } else {
                this.calculateMiningEnergy(event);
                this.animationMiningMainhand(event);
                this.noReequipAnimationMainhand();
            }
        } else if (AnimationHandler.isMainhandAttacking()) {
            switch (ClientProxy.EHC_INSTANCE.betterCombatMainhand.getAnimation()) {
                case SWEEP: {
                    if (ClientProxy.EHC_INSTANCE.betterCombatMainhand.alternateAnimation) {
                        this.animationSweepMainhand2(this.calculateMainhandEnergy(event));
                    } else {
                        this.animationSweepMainhand1(this.calculateMainhandEnergy(event));
                    }
                    this.animationSweepCameraMainhand();
                    this.reequipAnimationMainhand();
                    break;
                }
                case CHOP: {
                    this.animationChopMainhand(this.calculateMainhandEnergy(event));
                    this.animationChopCameraMainhand();
                    this.reequipAnimationMainhand();
                    break;
                }
                case STAB: {
                    this.animationStabMainhand(this.calculateMainhandEnergy(event));
                    this.animationStabCameraMainhand();
                    this.noReequipAnimationMainhand();
                    break;
                }
                default: {
                    this.animationChopMainhand(this.calculateMainhandEnergy(event));
                    this.animationChopCameraMainhand();
                    this.reequipAnimationMainhand();
                }
            }
            this.resetMiningEnergy();
        } else {
            if (this.parryingAnimationEnergy > 0.0f) {
                float x = this.parryingAnimationEnergy < 5.0f ? (1.0f - MathHelper.func_76134_b((float)(this.parryingAnimationEnergy * (float)Math.PI * 0.1f))) * 0.5f : (2.0f - MathHelper.func_76126_a((float)(this.parryingAnimationEnergy * (float)Math.PI * 0.1f))) * 0.5f;
                GlStateManager.func_179114_b((float)(x * 40.0f), (float)-15.0f, (float)50.0f, (float)85.0f);
                GlStateManager.func_179109_b((float)(-x * 0.35f), (float)(x * 0.2f), (float)(x * 0.01f));
            }
            if (this.parriedEnergy > 0.0f) {
                GlStateManager.func_179109_b((float)0.0f, (float)(-MathHelper.func_76126_a((float)(this.parriedEnergy * (float)Math.PI / 10.0f)) * 0.2f), (float)0.0f);
            }
            this.resetMainhandEnergy();
            this.resetMiningEnergy();
            this.positionEquippedProgressMainhand();
        }
        this.renderMainWeapon();
        GlStateManager.func_179121_F();
    }

    protected void positionMainWeapon() {
        GlStateManager.func_179109_b((float)0.685f, (float)-0.6f, (float)-1.0f);
        if (ClientProxy.EHC_INSTANCE.betterCombatMainhand.getAnimation().equals((Object)ConfigurationHandler.Animation.CHOP)) {
            GlStateManager.func_179114_b((float)(-11.0f - this.mainhandSprintingEnergy), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.02f, (float)0.08f, (float)0.0f);
            GlStateManager.func_179114_b((float)-16.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-8.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (ClientProxy.EHC_INSTANCE.betterCombatMainhand.getAnimation().equals((Object)ConfigurationHandler.Animation.STAB)) {
            GlStateManager.func_179114_b((float)(-44.0f - this.mainhandSprintingEnergy), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-this.tooCloseEnergy), (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(-13.0f - this.mainhandSprintingEnergy), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-13.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-13.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.isBlocking()) {
            GlStateManager.func_179109_b((float)(this.blockingEnergy * 0.016f), (float)(-this.blockingEnergy * 0.012f), (float)0.0f);
        }
    }

    private void positionMainhandAwayIfOffhandAttacking() {
        if (AnimationHandler.isOffhandAttacking()) {
            float f = MathHelper.func_76126_a((float)(this.offhandEnergy * (float)Math.PI));
            GlStateManager.func_179109_b((float)(f * 0.0625f), (float)(-f * 0.025f), (float)0.0f);
        }
    }

    private void positionEquippedProgressMainhand() {
        if (this.equippedProgressMainhand < 0.0f) {
            float f;
            this.equippedProgressMainhand += ClientProxy.EHC_INSTANCE.betterCombatMainhand.getEquipTimerIncrement() * this.partialTicks;
            if (f >= 0.0f) {
                this.equippedProgressMainhand = 0.0f;
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)this.equippedProgressMainhand, (float)(this.equippedProgressMainhand * -0.25f));
            }
        }
    }

    protected float calculateMainhandEnergy(RenderSpecificHandEvent event) {
        this.mainhandEnergy = 1.0f + (event.getPartialTicks() - (float)ClientProxy.EHC_INSTANCE.betterCombatMainhand.getSwingTimer()) * ClientProxy.EHC_INSTANCE.betterCombatMainhand.getSwingTimerIncrement();
        return this.mainhandEnergy;
    }

    protected void resetMainhandEnergy() {
        this.mainhandEnergy = 0.0f;
    }

    protected float calculateMiningEnergy(RenderSpecificHandEvent event) {
        return this.miningEnergy += ClientProxy.EHC_INSTANCE.betterCombatMainhand.getSwingTimerIncrement() * this.partialTicks;
    }

    protected void resetMiningEnergy() {
        this.miningEnergy = 0.0f;
    }

    private void renderMainWeapon() {
        GlStateManager.func_179152_a((float)1.36f, (float)1.36f, (float)1.36f);
        if (!ClientProxy.EHC_INSTANCE.itemStackMainhand.func_190926_b()) {
            boolean flag;
            boolean bl = flag = this.itemRenderer.func_175050_a(ClientProxy.EHC_INSTANCE.itemStackMainhand) && Block.func_149634_a((Item)ClientProxy.EHC_INSTANCE.itemStackMainhand.func_77973_b()).func_180664_k() == BlockRenderLayer.TRANSLUCENT;
            if (flag) {
                GlStateManager.func_179132_a((boolean)false);
            }
            this.itemRenderer.func_184392_a(ClientProxy.EHC_INSTANCE.itemStackMainhand, (EntityLivingBase)ClientProxy.EHC_INSTANCE.mc.field_71439_g, ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, false);
            if (flag) {
                GlStateManager.func_179132_a((boolean)true);
            }
        }
    }

    private void miningFadeIn() {
        this.miningEnergyFadeIn += this.partialTicks * 0.33f;
        if (this.miningEnergyFadeIn > 1.0f) {
            this.miningEnergyFadeIn = 1.0f;
        }
    }

    private void miningFadeOut() {
        this.miningEnergyFadeIn -= this.partialTicks * 0.33f;
        if (this.miningEnergyFadeIn < 0.0f) {
            this.miningEnergyFadeIn = 0.0f;
        }
    }

    private void animationMiningMainhand(RenderSpecificHandEvent event) {
        if (!ClientProxy.EHC_INSTANCE.isHittingBlock()) {
            if (this.miningEnergy > 1.0f) {
                this.miningEnergy = 1.0f;
            }
        } else if (ClientProxy.EHC_INSTANCE.holdingLeftClick) {
            this.miningFadeIn();
            if (this.miningEnergy >= 0.7f) {
                this.miningEnergy = (1.0f - this.miningEnergy) * 0.33333334f;
                this.calculateMiningEnergy(event);
            }
        } else {
            if (this.miningEnergy >= 0.7f) {
                this.miningFadeOut();
            } else {
                this.miningFadeIn();
            }
            if (this.miningEnergy > 1.0f) {
                this.resetMiningEnergy();
            }
        }
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = this.miningEnergyFadeIn * 5.0f;
        float rotateLeft = this.miningEnergyFadeIn * 25.0f;
        float closeCap = this.tooCloseEnergy - 0.5f;
        if (this.miningEnergy > 0.2f) {
            if (this.miningEnergy > 0.4f) {
                float f = this.miningEnergy - 0.4f;
                float ff = 1.0f - MathHelper.func_76126_a((float)(f * (float)Math.PI * 0.8333333f));
                moveRight = ff * -0.7f;
                moveClose = ff * closeCap;
                moveUp = 0.2f - f * 0.33333334f;
                rotateUp = ff * -105.0f;
                float fff = MathHelper.func_76134_b((float)(f * (float)Math.PI * 0.8333333f));
                rotateCounterClockwise = fff * 5.0f;
                rotateLeft = fff * 25.0f;
            } else {
                float f = MathHelper.func_76126_a((float)((this.miningEnergy - 0.2f) * (float)Math.PI * 5.0f));
                moveRight = -0.7f;
                moveClose = closeCap + f * 0.01f;
                rotateUp = -105.0f + f * 5.0f;
                moveUp = 0.2f;
            }
        } else {
            float f = 1.0f - MathHelper.func_76134_b((float)(this.miningEnergy * (float)Math.PI * 2.5f));
            moveRight = f * -0.7f;
            moveClose = f * closeCap;
            moveUp = f * 0.2f;
            rotateUp = f * -105.0f;
            float ff = MathHelper.func_76126_a((float)(this.miningEnergy * (float)Math.PI * 2.5f));
            rotateCounterClockwise = ff * 5.0f;
            rotateLeft = ff * 25.0f;
        }
        GlStateManager.func_179109_b((float)(1.2f * moveRight + this.tooCloseEnergy * 0.4f), (float)moveUp, (float)moveClose);
        GlStateManager.func_179114_b((float)rotateUp, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotateCounterClockwise, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotateLeft, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationDiggingMainhand(RenderSpecificHandEvent event) {
        if (!ClientProxy.EHC_INSTANCE.isHittingBlock()) {
            if (this.miningEnergy > 1.0f) {
                this.miningEnergy = 1.0f;
            }
        } else if (ClientProxy.EHC_INSTANCE.holdingLeftClick) {
            if (this.miningEnergy > 0.75f) {
                this.miningEnergy = 1.0f - this.miningEnergy;
                this.calculateMiningEnergy(event);
            }
        } else if (this.miningEnergy > 1.0f) {
            this.resetMiningEnergy();
        }
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float twist = 0.0f;
        float sway = 0.0f;
        float scoop = 0.0f;
        float closeCap = 0.5f - this.tooCloseEnergy;
        if (this.miningEnergy > 0.25f) {
            if (this.miningEnergy > 0.45f) {
                if (this.miningEnergy > 0.55f) {
                    if (this.miningEnergy > 0.75f) {
                        float f = this.miningEnergy - 0.75f;
                        moveClose = (0.25f - f) * (closeCap * 2.5f);
                        moveRight = -0.55f + f * 2.2f;
                        moveUp = 0.25f - f;
                        twist = -110.0f + f * 440.0f;
                        sway = 70.0f - f * 280.0f;
                        scoop = 80.0f - f * 320.0f;
                    } else {
                        float f = this.miningEnergy - 0.35f;
                        float ff = MathHelper.func_76126_a((float)(f * (float)Math.PI * 2.5f));
                        ff *= ff;
                        moveRight = -0.55f - ff * 0.2f;
                        moveUp = 0.25f - ff * 0.2f;
                        twist = -110.0f - ff * 20.0f;
                        sway = 70.0f - ff * 20.0f;
                        scoop = 80.0f - ff * 15.0f;
                        moveClose = (0.25f - ff * 0.5f) * (closeCap * 2.5f);
                    }
                } else {
                    moveRight = -0.75f;
                    moveUp = 0.05f;
                    twist = -130.0f;
                    sway = 50.0f;
                    scoop = 65.0f;
                    moveClose = -0.25f * (closeCap * 2.5f);
                }
            } else {
                float f = this.miningEnergy - 0.25f;
                float ff = MathHelper.func_76126_a((float)(f * (float)Math.PI * 2.5f));
                moveRight = -0.55f - ff * 0.2f;
                moveUp = 0.25f - ff * 0.2f;
                twist = -110.0f - ff * 20.0f;
                sway = 70.0f - ff * 20.0f;
                scoop = 80.0f - ff * 15.0f;
                ff *= ff;
                moveClose = (0.25f - ff * 0.5f) * (closeCap * 2.5f);
            }
        } else {
            moveClose = this.miningEnergy * (closeCap * 2.5f);
            moveRight = -this.miningEnergy * 2.2f;
            moveUp = this.miningEnergy;
            twist = -this.miningEnergy * 440.0f;
            sway = this.miningEnergy * 280.0f;
            scoop = this.miningEnergy * 320.0f;
        }
        GlStateManager.func_179109_b((float)moveRight, (float)(0.4f * moveUp), (float)moveClose);
        GlStateManager.func_179114_b((float)twist, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)sway, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)scoop, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationWoodcuttingMainhand(RenderSpecificHandEvent event) {
        if (!ClientProxy.EHC_INSTANCE.isHittingBlock()) {
            if (this.miningEnergy > 1.0f) {
                this.miningEnergy = 0.0f;
            }
        } else if (this.miningEnergy > 1.0f) {
            this.resetMiningEnergy();
        }
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 0.2f - this.tooCloseEnergy;
        rotateUp = -AnimationHandler.clampMultiplier(this.miningEnergy, 6.0f, 140.0f + closeCap * 50.0f);
        rotateCounterClockwise = AnimationHandler.clampMultiplier(this.miningEnergy, 12.0f, 150.0f) - AnimationHandler.clampMultiplier(this.miningEnergy, 3.0f, 50.0f + closeCap * 100.0f) - this.miningEnergy * 15.0f;
        rotateLeft = AnimationHandler.clampMultiplier(this.miningEnergy, 6.0f, 85.0f);
        moveRight = AnimationHandler.clampMultiplier(this.miningEnergy, 12.0f, 3.5f) + 0.5f;
        moveUp = AnimationHandler.clamp(this.miningEnergy * 10.0f, 0.47f);
        moveClose = -AnimationHandler.clamp(this.miningEnergy * 10.0f, closeCap);
        if (this.miningEnergy > 0.6f) {
            moveRight -= 4.5f + closeCap - (1.0f - MathHelper.func_76126_a((float)(this.miningEnergy * (float)Math.PI))) * 0.3f;
            if (this.miningEnergy > 0.85f) {
                moveUp -= MathHelper.func_76126_a((float)(this.miningEnergy - 0.85f)) * 6.0f;
                moveClose += MathHelper.func_76126_a((float)(this.miningEnergy - 0.85f)) * 6.0f;
                moveRight += (this.miningEnergy - 0.85f) * 5.5f;
            }
        } else {
            moveRight -= AnimationHandler.clamp(MathHelper.func_76126_a((float)(this.miningEnergy * (float)Math.PI)) * 5.5f, 4.5f + closeCap);
        }
        GlStateManager.func_179109_b((float)(1.2f * moveRight), (float)(1.1f * moveUp), (float)moveClose);
        GlStateManager.func_179114_b((float)rotateUp, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotateCounterClockwise, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotateLeft, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationSweepMainhand1(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 0.4f - this.tooCloseEnergy;
        rotateUp = -AnimationHandler.clampMultiplier(energy, 6.0f, 140.0f + closeCap * 40.0f);
        rotateCounterClockwise = AnimationHandler.clampMultiplier(energy, 12.0f, 150.0f) - AnimationHandler.clampMultiplier(energy, 3.0f, 50.0f + closeCap * 100.0f) - energy * 15.0f;
        rotateLeft = AnimationHandler.clampMultiplier(energy, 6.0f, 85.0f);
        moveRight = AnimationHandler.clampMultiplier(energy, 12.0f, 3.5f) + 0.5f;
        moveUp = AnimationHandler.clamp(energy * 10.0f, 0.47f);
        moveClose = -AnimationHandler.clamp(energy * 10.0f, closeCap);
        if (energy > 0.6f) {
            moveRight -= 4.5f + closeCap - (1.0f - MathHelper.func_76126_a((float)(energy * (float)Math.PI))) * 0.3f;
            if (energy > 0.85f) {
                float f = energy - 0.85f;
                moveUp -= MathHelper.func_76126_a((float)f) * 6.0f;
                moveClose += MathHelper.func_76126_a((float)f) * 6.0f;
                moveRight += f * 5.5f;
            }
        } else {
            moveRight -= AnimationHandler.clamp(MathHelper.func_76126_a((float)(energy * (float)Math.PI)) * 5.5f, 4.5f + closeCap);
        }
        GlStateManager.func_179109_b((float)(1.2f * moveRight * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveRightVariance), (float)(1.1f * moveUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationSweepMainhand2(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 1.0f - this.tooCloseEnergy * 2.5f;
        if (energy > 0.2f) {
            if (energy > 0.6f) {
                float f = energy - 0.6f;
                rotateCounterClockwise = f * -400.0f;
                moveUp = 0.2f - f * 0.5f;
                moveRight = -1.55f + f * 30.0f;
                rotateLeft = 83.0f + f * 12.5f;
                moveClose = -f * 3.0f * closeCap;
            } else if (energy > 0.4f) {
                float f = energy - 0.4f;
                moveUp = 0.2f;
                moveRight = -1.5f - f * 0.25f;
                rotateLeft = 75.0f + f * 40.0f;
                moveClose = (0.2f - f) * closeCap;
            } else {
                float f = energy - 0.2f;
                moveUp = -0.2f + MathHelper.func_76126_a((float)(f * (float)Math.PI * 2.5f)) * 0.4f;
                moveRight = -1.2f - MathHelper.func_76126_a((float)(f * (float)Math.PI * 2.5f)) * 0.3f;
                rotateLeft = 25.0f + f * 250.0f;
                moveClose = energy * 0.5f * closeCap;
            }
        } else {
            moveUp = -energy;
            moveRight = energy * -6.0f;
            rotateLeft = energy * 125.0f;
            moveClose = energy * 0.5f * closeCap;
        }
        GlStateManager.func_179109_b((float)(0.75f * moveRight * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveRightVariance), (float)(1.15f * moveUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationChopMainhand(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = AnimationHandler.clamp(energy * 300.0f, 15.0f) - energy * 15.0f;
        float rotateLeft = AnimationHandler.clamp(energy * 100.0f, 30.0f);
        float closeCap = this.tooCloseEnergy - 0.4f;
        if (energy > 0.2f) {
            if (energy > 0.7f) {
                float f = energy - 0.7f;
                moveUp = -f;
                moveRight = -0.7f + f * 2.0f;
                moveClose = closeCap + f * 6.0f;
                rotateUp = -95.0f;
            } else {
                moveRight = -0.7f;
                moveClose = closeCap;
                rotateUp = -95.0f;
                if (energy < 0.4f) {
                    rotateUp += MathHelper.func_76126_a((float)((energy - 0.2f) * (float)Math.PI * 5.0f)) * 5.0f;
                }
            }
        } else {
            float f = 1.0f - MathHelper.func_76134_b((float)(energy * (float)Math.PI * 2.5f));
            moveRight = f * -0.7f;
            moveClose = f * closeCap;
            rotateUp = f * -95.0f;
        }
        if (energy <= 0.22f) {
            moveUp = MathHelper.func_76126_a((float)(energy * (float)Math.PI * 4.6f)) * 0.2f;
        }
        GlStateManager.func_179109_b((float)(1.1f * moveRight * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveRightVariance), (float)(moveUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationStabMainhand(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 0.6f - this.tooCloseEnergy;
        rotateUp = -AnimationHandler.clamp(energy * 240.0f, 60.0f);
        rotateCounterClockwise = AnimationHandler.clamp(energy * 125.0f, 50.0f) - energy * 10.0f;
        rotateLeft = AnimationHandler.clamp(energy * 75.0f, 30.0f) - energy * 10.0f;
        if (energy > 0.2f) {
            if (energy > 0.4f) {
                if (energy > 0.8f) {
                    float f = energy - 0.8f;
                    moveRight = moveClose = -closeCap + f * 2.5f;
                    moveUp = -moveClose;
                    f *= f;
                    rotateUp += AnimationHandler.clampMultiplier(f, 25.0f, 70.0f);
                    rotateCounterClockwise -= AnimationHandler.clampMultiplier(f, 25.0f, 30.0f);
                    rotateLeft -= AnimationHandler.clampMultiplier(f, 25.0f, 10.0f);
                } else {
                    moveRight = moveClose = -closeCap * (energy * 0.25f + 0.9f);
                    moveUp = -moveClose;
                }
            } else {
                moveRight = moveClose = (0.2f - energy) * closeCap * 5.0f;
                moveUp = -moveClose - 0.25f * closeCap;
            }
        } else {
            moveClose = MathHelper.func_76126_a((float)(energy * (float)Math.PI * 5.0f)) * 0.2f;
            moveUp = -energy * closeCap * 2.5f;
        }
        GlStateManager.func_179109_b((float)(moveRight * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveRightVariance), (float)(1.3f * moveUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatMainhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatMainhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void customShieldRender(RenderSpecificHandEvent event) {
        event.setCanceled(true);
        event.setResult(Event.Result.DENY);
        if (AnimationHandler.isOffhandAttacking()) {
            this.calculateOffhandEnergy(event);
        } else {
            this.resetOffhandEnergy();
        }
        GlStateManager.func_179094_E();
        this.positionOffShield();
        this.positionBreathingOffhandShield();
        this.positionEquippedProgressOffhand();
        this.renderOffShield();
        GlStateManager.func_179121_F();
    }

    private void positionOffShield() {
        this.positionOffhandAwayIfMainhandAttacking();
        if (this.offhandEnergy > 0.0f) {
            float shieldBashProgress = MathHelper.func_76126_a((float)(this.offhandEnergy * (float)Math.PI)) * 1.25f;
            if (shieldBashProgress > 1.0f) {
                shieldBashProgress = 1.0f;
            }
            GlStateManager.func_179114_b((float)(shieldBashProgress * 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-shieldBashProgress * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(shieldBashProgress * 1.5f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(shieldBashProgress * 0.05f), (float)(-shieldBashProgress * 1.25f));
            this.animationShieldBashCameraOffhand();
        }
        if (this.blockingEnergy > 0.0f) {
            GlStateManager.func_179114_b((float)(-this.blockingEnergy * 0.75f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.blockingEnergy * 1.25f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.blockingEnergy * 1.5f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(this.blockingEnergy * 0.06f), (float)(this.blockingEnergy * 0.008f), (float)(this.blockingEnergy * 0.04f));
        }
        GlStateManager.func_179114_b((float)210.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (ConfigurationHandler.isShield2D(Helpers.getRegistryNameFromItem(ClientProxy.EHC_INSTANCE.itemStackOffhand))) {
            GlStateManager.func_179109_b((float)0.27f, (float)-0.9f, (float)1.3f);
        } else {
            GlStateManager.func_179109_b((float)1.0f, (float)-0.52f, (float)1.8f);
        }
    }

    public void reequipAnimationMainhand() {
        this.equippedProgressMainhand = -1.0f;
    }

    public void noReequipAnimationMainhand() {
        this.equippedProgressMainhand = 0.0f;
    }

    public void reequipAnimationOffhand() {
        this.equippedProgressOffhand = -1.0f;
    }

    public void noReequipAnimationOffhand() {
        this.equippedProgressOffhand = 0.0f;
    }

    public boolean isBlocking() {
        return this.blockingEnergy > 0.0f;
    }

    private void positionBreathingMainhand() {
        GlStateManager.func_179109_b((float)0.0f, (float)(MathHelper.func_76126_a((float)this.breatheTicks) * ConfigurationHandler.breathingAnimationIntensity), (float)(this.tooCloseEnergy * 0.6f));
    }

    private void positionBreathingOffhand() {
        if (!this.breathingApplied) {
            this.positionBreathingMainhand();
        }
    }

    private void positionBreathingOffhandShield() {
        if (!this.breathingApplied) {
            GlStateManager.func_179109_b((float)0.0f, (float)(MathHelper.func_76126_a((float)this.breatheTicks) * ConfigurationHandler.breathingAnimationIntensity), (float)(-this.tooCloseEnergy * 0.6f));
        }
    }

    public static boolean isOffhandAttacking() {
        return ClientProxy.EHC_INSTANCE.betterCombatOffhand.isSwinging();
    }

    public void customOffhandRender(RenderSpecificHandEvent event) {
        event.setCanceled(true);
        event.setResult(Event.Result.DENY);
        GlStateManager.func_179094_E();
        this.positionOffhandWeapon();
        if (!ClientProxy.EHC_INSTANCE.betterCombatMainhand.isMining()) {
            this.positionOffhandAwayIfMainhandAttacking();
        }
        this.positionBreathingOffhand();
        if (AnimationHandler.isOffhandAttacking()) {
            switch (ClientProxy.EHC_INSTANCE.betterCombatOffhand.getAnimation()) {
                case SWEEP: {
                    if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.alternateAnimation) {
                        this.animationSweepOffhand2(this.calculateOffhandEnergy(event));
                    } else {
                        this.animationSweepOffhand1(this.calculateOffhandEnergy(event));
                    }
                    this.animationSweepCameraOffhand();
                    this.reequipAnimationOffhand();
                    break;
                }
                case CHOP: {
                    this.animationChopOffhand(this.calculateOffhandEnergy(event));
                    this.animationChopCameraOffhand();
                    this.reequipAnimationOffhand();
                    break;
                }
                case STAB: {
                    this.animationStabOffhand(this.calculateOffhandEnergy(event));
                    this.animationStabCameraOffhand();
                    this.noReequipAnimationOffhand();
                    break;
                }
                default: {
                    this.animationChopOffhand(this.calculateOffhandEnergy(event));
                    this.animationChopCameraOffhand();
                    this.reequipAnimationOffhand();
                    break;
                }
            }
        } else {
            this.resetOffhandEnergy();
            this.positionEquippedProgressOffhand();
        }
        this.renderOffWeapon();
        GlStateManager.func_179121_F();
    }

    private void renderOffWeapon() {
        GlStateManager.func_179152_a((float)1.36f, (float)1.36f, (float)1.36f);
        if (!ClientProxy.EHC_INSTANCE.itemStackOffhand.func_190926_b()) {
            boolean flag;
            boolean bl = flag = this.itemRenderer.func_175050_a(ClientProxy.EHC_INSTANCE.itemStackOffhand) && Block.func_149634_a((Item)ClientProxy.EHC_INSTANCE.itemStackOffhand.func_77973_b()).func_180664_k() == BlockRenderLayer.TRANSLUCENT;
            if (flag) {
                GlStateManager.func_179132_a((boolean)false);
            }
            this.itemRenderer.func_184392_a(ClientProxy.EHC_INSTANCE.itemStackOffhand, (EntityLivingBase)ClientProxy.EHC_INSTANCE.mc.field_71439_g, ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, true);
            if (flag) {
                GlStateManager.func_179132_a((boolean)true);
            }
        }
    }

    private void renderOffShield() {
        GlStateManager.func_179152_a((float)1.36f, (float)1.36f, (float)1.36f);
        this.itemRenderer.func_184392_a(ClientProxy.EHC_INSTANCE.itemStackOffhand, (EntityLivingBase)ClientProxy.EHC_INSTANCE.mc.field_71439_g, ItemCameraTransforms.TransformType.NONE, true);
    }

    private void positionOffhandWeapon() {
        GlStateManager.func_179109_b((float)-0.7f, (float)-0.6f, (float)-1.0f);
        if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.getAnimation().equals((Object)ConfigurationHandler.Animation.CHOP)) {
            GlStateManager.func_179114_b((float)(-11.0f - this.offhandSprintingEnergy), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.02f, (float)0.08f, (float)0.0f);
            GlStateManager.func_179114_b((float)16.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)8.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.getAnimation().equals((Object)ConfigurationHandler.Animation.STAB)) {
            GlStateManager.func_179114_b((float)(-44.0f - this.offhandSprintingEnergy), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(-this.tooCloseEnergy), (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(-13.0f - this.offhandSprintingEnergy), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)13.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)13.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    private void positionOffhandAwayIfMainhandAttacking() {
        if (AnimationHandler.isMainhandAttacking()) {
            float f = MathHelper.func_76126_a((float)(this.mainhandEnergy * (float)Math.PI));
            GlStateManager.func_179109_b((float)(-f * 0.125f), (float)(-f * 0.05f), (float)0.0f);
        }
    }

    private void positionEquippedProgressOffhand() {
        if (this.equippedProgressOffhand < 0.0f) {
            float f;
            this.equippedProgressOffhand += ClientProxy.EHC_INSTANCE.betterCombatOffhand.getEquipTimerIncrement() * this.partialTicks;
            if (f >= 0.0f) {
                this.equippedProgressOffhand = 0.0f;
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)this.equippedProgressOffhand, (float)(this.equippedProgressOffhand * -0.25f));
            }
        }
    }

    protected float calculateOffhandEnergy(RenderSpecificHandEvent event) {
        this.offhandEnergy = 1.0f + (event.getPartialTicks() - (float)ClientProxy.EHC_INSTANCE.betterCombatOffhand.getSwingTimer() - 0.5f) * ClientProxy.EHC_INSTANCE.betterCombatOffhand.getSwingTimerIncrement();
        return this.offhandEnergy;
    }

    protected void resetOffhandEnergy() {
        this.offhandEnergy = 0.0f;
    }

    private void animationChopOffhand(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = AnimationHandler.clamp(energy * 300.0f, 15.0f) - energy * 15.0f;
        float rotateLeft = AnimationHandler.clamp(energy * 100.0f, 30.0f);
        float closeCap = this.tooCloseEnergy - 0.4f;
        if (energy > 0.2f) {
            if (energy > 0.7f) {
                float f = energy - 0.7f;
                moveUp = -f;
                moveRight = -0.7f + f * 2.0f;
                moveClose = closeCap + f * 6.0f;
                rotateUp = -95.0f;
            } else {
                moveRight = -0.7f;
                moveClose = closeCap;
                rotateUp = -95.0f;
                if (energy < 0.4f) {
                    rotateUp += MathHelper.func_76126_a((float)((energy - 0.2f) * (float)Math.PI * 5.0f)) * 5.0f;
                }
            }
        } else {
            float f = 1.0f - MathHelper.func_76134_b((float)(energy * (float)Math.PI * 2.5f));
            moveRight = f * -0.7f;
            moveClose = f * closeCap;
            rotateUp = f * -95.0f;
        }
        if (energy <= 0.22f) {
            moveUp = MathHelper.func_76126_a((float)(energy * (float)Math.PI * 4.6f)) * 0.2f;
        }
        GlStateManager.func_179109_b((float)(-1.1f * moveRight * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveRightVariance), (float)(moveUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationSweepOffhand1(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 0.4f - this.tooCloseEnergy;
        rotateUp = -AnimationHandler.clampMultiplier(energy, 6.0f, 140.0f + closeCap * 40.0f);
        rotateCounterClockwise = AnimationHandler.clampMultiplier(energy, 12.0f, 150.0f) - AnimationHandler.clampMultiplier(energy, 3.0f, 50.0f + closeCap * 100.0f) - energy * 15.0f;
        rotateLeft = AnimationHandler.clampMultiplier(energy, 6.0f, 85.0f);
        moveRight = AnimationHandler.clampMultiplier(energy, 12.0f, 3.5f) + 0.5f;
        moveUp = AnimationHandler.clamp(energy * 10.0f, 0.47f);
        moveClose = -AnimationHandler.clamp(energy * 10.0f, closeCap);
        if (energy > 0.6f) {
            moveRight -= 4.5f + closeCap - (1.0f - MathHelper.func_76126_a((float)(energy * (float)Math.PI))) * 0.3f;
            if (energy > 0.85f) {
                float f = energy - 0.85f;
                moveUp -= MathHelper.func_76126_a((float)f) * 6.0f;
                moveClose += MathHelper.func_76126_a((float)f) * 6.0f;
                moveRight += f * 5.5f;
            }
        } else {
            moveRight -= AnimationHandler.clamp(MathHelper.func_76126_a((float)(energy * (float)Math.PI)) * 5.5f, 4.5f + closeCap);
        }
        GlStateManager.func_179109_b((float)(1.2f * -moveRight * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveRightVariance), (float)(1.1f * moveUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationSweepOffhand2(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 1.0f - this.tooCloseEnergy * 2.5f;
        if (energy > 0.2f) {
            if (energy > 0.6f) {
                float f = energy - 0.6f;
                rotateCounterClockwise = f * -400.0f;
                moveUp = 0.2f - f * 0.5f;
                moveRight = -1.55f + f * 30.0f;
                rotateLeft = 83.0f + f * 12.5f;
                moveClose = -f * 3.0f * closeCap;
            } else if (energy > 0.4f) {
                float f = energy - 0.4f;
                moveUp = 0.2f;
                moveRight = -1.5f - f * 0.25f;
                rotateLeft = 75.0f + f * 40.0f;
                moveClose = (0.2f - f) * closeCap;
            } else {
                float f = energy - 0.2f;
                moveUp = -0.2f + MathHelper.func_76126_a((float)(f * (float)Math.PI * 2.5f)) * 0.4f;
                moveRight = -1.2f - MathHelper.func_76126_a((float)(f * (float)Math.PI * 2.5f)) * 0.3f;
                rotateLeft = 25.0f + f * 250.0f;
                moveClose = energy * 0.5f * closeCap;
            }
        } else {
            moveUp = -energy;
            moveRight = energy * -6.0f;
            rotateLeft = energy * 125.0f;
            moveClose = energy * 0.5f * closeCap;
        }
        GlStateManager.func_179109_b((float)(0.75f * -moveRight * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveRightVariance), (float)(1.15f * moveUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void animationStabOffhand(float energy) {
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 0.6f - this.tooCloseEnergy;
        rotateUp = -AnimationHandler.clamp(energy * 240.0f, 60.0f);
        rotateCounterClockwise = AnimationHandler.clamp(energy * 125.0f, 50.0f) - energy * 10.0f;
        rotateLeft = AnimationHandler.clamp(energy * 75.0f, 30.0f) - energy * 10.0f;
        if (energy > 0.2f) {
            if (energy > 0.4f) {
                if (energy > 0.8f) {
                    float f = energy - 0.8f;
                    moveRight = moveClose = -closeCap + f * 2.5f;
                    moveUp = -moveClose;
                    f *= f;
                    rotateUp += AnimationHandler.clampMultiplier(f, 25.0f, 70.0f);
                    rotateCounterClockwise -= AnimationHandler.clampMultiplier(f, 25.0f, 30.0f);
                    rotateLeft -= AnimationHandler.clampMultiplier(f, 25.0f, 10.0f);
                } else {
                    moveRight = moveClose = -closeCap * (energy * 0.25f + 0.9f);
                    moveUp = -moveClose;
                }
            } else {
                moveRight = moveClose = (0.2f - energy) * closeCap * 5.0f;
                moveUp = -moveClose - 0.25f * closeCap;
            }
        } else {
            moveClose = MathHelper.func_76126_a((float)(energy * (float)Math.PI * 5.0f)) * 0.2f;
            moveUp = -energy * closeCap * 2.5f;
        }
        GlStateManager.func_179109_b((float)(-moveRight * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveRightVariance), (float)(1.3f * moveUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveUpVariance), (float)(moveClose * ClientProxy.EHC_INSTANCE.betterCombatOffhand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateCounterClockwise * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rotateLeft * ClientProxy.EHC_INSTANCE.betterCombatOffhand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public static float clamp(float f0, float f1) {
        if (f0 > f1) {
            return f1;
        }
        return f0;
    }

    public static float negativeClamp(float f0, float f1) {
        if (f0 < f1) {
            return f1;
        }
        return f0;
    }

    public static float clampMultiplier(float base, float multiplier, float cap) {
        float f = base * multiplier * cap;
        if (f > cap) {
            return cap;
        }
        return f;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        switch (event.getType()) {
            case CROSSHAIRS: {
                float partialTicks = Minecraft.func_71410_x().func_184121_ak();
                ScaledResolution scaledRes = new ScaledResolution(Minecraft.func_71410_x());
                if (!event.isCanceled() && !ConfigurationHandler.showDefaultCrosshair) {
                    event.setCanceled(true);
                    this.gc.renderAttackIndicator(partialTicks, scaledRes);
                    MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post((RenderGameOverlayEvent)event, event.getType()));
                }
                if (!ConfigurationHandler.attackSweepOverlay) break;
                this.gc.renderSweepOverlay(scaledRes);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class GuiCrosshairsBC
    extends Gui {
        public final ResourceLocation field_110324_m = new ResourceLocation("bettercombat:textures/gui/icons.png");
        private float currentFrameMainhand = 0.0f;
        private float currentFrameOffhand = 0.0f;
        private final ResourceLocation MAINHAND_SWEEP_1 = new ResourceLocation("bettercombat", "textures/gui/mainhand_sweep_1.png");
        private final ResourceLocation MAINHAND_SWEEP_2 = new ResourceLocation("bettercombat", "textures/gui/mainhand_sweep_2.png");
        private final ResourceLocation OFFHAND_SWEEP_1 = new ResourceLocation("bettercombat", "textures/gui/offhand_sweep_1.png");
        private final ResourceLocation OFFHAND_SWEEP_2 = new ResourceLocation("bettercombat", "textures/gui/offhand_sweep_2.png");
        private final int FRAME_SIZE_X = 64;
        private final int FRAME_SIZE_Y = 32;

        public void renderAttackIndicator(float partTicks, ScaledResolution scaledRes) {
            this.field_73735_i = 200.0f;
            ClientProxy.EHC_INSTANCE.mc.func_110434_K().func_110577_a(this.field_110324_m);
            if (!(ClientProxy.EHC_INSTANCE.itemStackOffhand.func_190926_b() || ClientProxy.EHC_INSTANCE.betterCombatMainhand.getWeaponProperty() != ConfigurationHandler.WeaponProperty.TWOHAND && ClientProxy.EHC_INSTANCE.betterCombatOffhand.getWeaponProperty() != ConfigurationHandler.WeaponProperty.TWOHAND && ClientProxy.EHC_INSTANCE.betterCombatOffhand.getWeaponProperty() != ConfigurationHandler.WeaponProperty.MAINHAND)) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                this.func_73729_b(scaledRes.func_78326_a() - 236 >> 1, scaledRes.func_78328_b() - 19, 16, 0, 16, 16);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (ClientProxy.EHC_INSTANCE.mc.field_71442_b.func_78747_a() && ClientProxy.EHC_INSTANCE.mc.field_147125_j == null) {
                RayTraceResult rtRes = ClientProxy.EHC_INSTANCE.mc.field_71476_x;
                if (rtRes == null || rtRes.field_72313_a != RayTraceResult.Type.BLOCK) {
                    return;
                }
                BlockPos blockpos = rtRes.func_178782_a();
                IBlockState state = ClientProxy.EHC_INSTANCE.mc.field_71441_e.func_180495_p(blockpos);
                if (!state.func_177230_c().hasTileEntity(state) || !(ClientProxy.EHC_INSTANCE.mc.field_71441_e.func_175625_s(blockpos) instanceof IInventory)) {
                    return;
                }
            }
            if (ClientProxy.EHC_INSTANCE.mc.field_71474_y.field_74330_P && !ClientProxy.EHC_INSTANCE.mc.field_71474_y.field_74319_N && !ClientProxy.EHC_INSTANCE.mc.field_71439_g.func_175140_cp() && !ClientProxy.EHC_INSTANCE.mc.field_71474_y.field_178879_v) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(scaledRes.func_78326_a() >> 1), (float)(scaledRes.func_78328_b() >> 1), (float)this.field_73735_i);
                Entity entity = ClientProxy.EHC_INSTANCE.mc.func_175606_aa();
                if (entity == null) {
                    return;
                }
                GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partTicks), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partTicks), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                OpenGlHelper.func_188785_m((int)10);
                GlStateManager.func_179121_F();
            } else {
                this.showPlusCrosshair(scaledRes);
                if (ClientProxy.EHC_INSTANCE.mc.field_71474_y.field_186716_M == 1) {
                    if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.hasConfigWeapon()) {
                        this.showMainhandCrosshair(scaledRes);
                        this.showOffhandCrosshair(scaledRes);
                    } else if (ConfigurationHandler.showShieldCooldownCrosshair && ClientProxy.EHC_INSTANCE.itemStackOffhand.func_77973_b() instanceof ItemShield) {
                        this.showMainhandCrosshair(scaledRes);
                        this.showShieldCrosshair(scaledRes);
                    } else {
                        this.showDefaultCrosshair(scaledRes);
                    }
                }
            }
        }

        public void renderSweepOverlay(ScaledResolution scaledRes) {
            if (!ClientProxy.EHC_INSTANCE.betterCombatMainhand.isMining() && ClientProxy.EHC_INSTANCE.betterCombatMainhand.getAnimation() == ConfigurationHandler.Animation.SWEEP && AnimationHandler.isMainhandAttacking()) {
                if (ClientProxy.EHC_INSTANCE.betterCombatMainhand.alternateAnimation) {
                    if (ClientProxy.AH_INSTANCE.mainhandEnergy > 0.625f) {
                        if (this.currentFrameMainhand < 16.0f) {
                            this.renderSweepOverlay2(scaledRes, (int)this.currentFrameMainhand, this.MAINHAND_SWEEP_2, -18, -42, 14.0f);
                            this.currentFrameMainhand += 1.0f;
                        }
                    } else {
                        this.currentFrameMainhand = 0.0f;
                    }
                } else if (ClientProxy.AH_INSTANCE.mainhandEnergy > 0.25f) {
                    if (this.currentFrameMainhand < 16.0f) {
                        this.renderSweepOverlay1(scaledRes, (int)this.currentFrameMainhand, this.MAINHAND_SWEEP_1, -2, -10);
                        this.currentFrameMainhand += 1.0f;
                    }
                } else {
                    this.currentFrameMainhand = 0.0f;
                }
            }
            if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.getAnimation() == ConfigurationHandler.Animation.SWEEP && AnimationHandler.isOffhandAttacking()) {
                if (ClientProxy.EHC_INSTANCE.betterCombatOffhand.alternateAnimation) {
                    if (ClientProxy.AH_INSTANCE.offhandEnergy > 0.625f) {
                        if (this.currentFrameOffhand < 16.0f) {
                            this.renderSweepOverlay2(scaledRes, (int)this.currentFrameOffhand, this.OFFHAND_SWEEP_2, -56, 13, -14.0f);
                            this.currentFrameOffhand += 1.0f;
                        }
                    } else {
                        this.currentFrameOffhand = 0.0f;
                    }
                } else if (ClientProxy.AH_INSTANCE.offhandEnergy > 0.25f) {
                    if (this.currentFrameOffhand < 16.0f) {
                        this.renderSweepOverlay1(scaledRes, (int)this.currentFrameOffhand, this.OFFHAND_SWEEP_1, -62, -13);
                        this.currentFrameOffhand += 1.0f;
                    }
                } else {
                    this.currentFrameOffhand = 0.0f;
                }
            }
        }

        private void showPlusCrosshair(ScaledResolution scaledRes) {
            GlStateManager.func_179141_d();
            this.func_73729_b((scaledRes.func_78326_a() >> 1) - 7, (scaledRes.func_78328_b() >> 1) - 7, 0, 0, 16, 16);
        }

        private void showDefaultCrosshair(ScaledResolution scaledRes) {
            if (ClientProxy.EHC_INSTANCE.mainhandCooldown > 0) {
                int i = (scaledRes.func_78328_b() >> 1) - 7;
                int j = (scaledRes.func_78326_a() >> 1) - 7;
                int k = (int)(ClientProxy.EHC_INSTANCE.getMainhandCooledAttackStrength() * 18.0f);
                this.func_73729_b(j - 1, i + 12, 68, 94, 17, 8);
                this.func_73729_b(j - 1, i + 12, 68, 102, k, 8);
            }
        }

        private void showMainhandCrosshair(ScaledResolution scaledRes) {
            if (ClientProxy.EHC_INSTANCE.mainhandCooldown > 0) {
                int i = (scaledRes.func_78328_b() >> 1) - 7;
                int j = (scaledRes.func_78326_a() >> 1) - 7;
                int k = (int)(ClientProxy.EHC_INSTANCE.getMainhandCooledAttackStrength() * 18.0f);
                this.func_73729_b(j + 15, i, 51, 94, 8, 17);
                this.func_73729_b(j + 15, i + 17 - k, 59, 111 - k, 8, k);
            }
        }

        private void showOffhandCrosshair(ScaledResolution scaledRes) {
            if (ClientProxy.EHC_INSTANCE.offhandCooldown > 0) {
                int i = (scaledRes.func_78328_b() >> 1) - 7;
                int j = (scaledRes.func_78326_a() >> 1) - 7;
                int k = (int)(ClientProxy.EHC_INSTANCE.getOffhandCooledAttackStrength() * 18.0f);
                this.func_73729_b(j - 8, i, 35, 94, 8, 17);
                this.func_73729_b(j - 8, i + 17 - k, 43, 111 - k, 8, k);
            }
        }

        private void showShieldCrosshair(ScaledResolution scaledRes) {
            float cooldown = 1.0f - ClientProxy.EHC_INSTANCE.mc.field_71439_g.func_184811_cZ().func_185143_a(ClientProxy.EHC_INSTANCE.itemStackOffhand.func_77973_b(), 0.0f);
            if (cooldown < 1.0f) {
                int i = (scaledRes.func_78328_b() >> 1) - 7;
                int j = (scaledRes.func_78326_a() >> 1) - 7;
                int k = (int)(cooldown * 18.0f);
                this.func_73729_b(j - 8, i, 35, 94, 8, 17);
                this.func_73729_b(j - 8, i + 17 - k, 43, 111 - k, 8, k);
            }
        }

        private void renderSweepOverlay1(ScaledResolution scaledRes, int currentFrame, ResourceLocation texture, int offsetX, int offsetY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ClientProxy.EHC_INSTANCE.mc.func_110434_K().func_110577_a(texture);
            float factor = (float)ClientProxy.EHC_INSTANCE.mc.field_71440_d / 128.0f;
            float scale = factor / (float)scaledRes.func_78325_e();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            scale = 2.0f * factor / (float)scaledRes.func_78325_e();
            int startX = currentFrame % 4 * 64;
            int startY = (int)(Math.ceil((double)(currentFrame + 1) / 4.0) - 1.0) * 32;
            this.func_175174_a((float)scaledRes.func_78326_a() / scale + (float)offsetX, (float)scaledRes.func_78328_b() / scale + (float)offsetY, startX, startY, 64, 32);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }

        private void renderSweepOverlay2(ScaledResolution scaledRes, int currentFrame, ResourceLocation texture, int offsetX, int offsetY, float rotation) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ClientProxy.EHC_INSTANCE.mc.func_110434_K().func_110577_a(texture);
            float factor = (float)ClientProxy.EHC_INSTANCE.mc.field_71440_d / 128.0f;
            float scale = factor / (float)scaledRes.func_78325_e();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            scale = 2.0f * factor / (float)scaledRes.func_78325_e();
            int startX = currentFrame % 4 * 64;
            int startY = (int)(Math.ceil((double)(currentFrame + 1) / 4.0) - 1.0) * 32;
            this.func_175174_a((float)scaledRes.func_78326_a() / scale + (float)offsetX, (float)scaledRes.func_78328_b() / scale + (float)offsetY, startX, startY, 64, 32);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }
}

