/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.tileentity;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ModTileEntity
extends TileEntity {
    protected static final Random rng = new Random();

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onBlockBroken(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void onBlockHarvested(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
    }

    protected abstract void readAllModDataNBT(NBTTagCompound var1);

    protected abstract void writeAllModDataNBT(NBTTagCompound var1);

    protected abstract void writeModSyncDataNBT(NBTTagCompound var1);

    protected abstract void readModSyncDataNBT(NBTTagCompound var1);

    protected void dropInventory(ItemStackHandler handler) {
        if (!this.func_145831_w().field_72995_K && this.func_145831_w().func_82736_K().func_82766_b("doTileDrops")) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack is = handler.getStackInSlot(i);
                if (is.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)is);
            }
        }
    }

    public void syncToClient() {
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readAllModDataNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound ret = super.func_189515_b(tag);
        this.writeAllModDataNBT(ret);
        return ret;
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeModSyncDataNBT(tag);
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readModSyncDataNBT(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

