/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.capability;

import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.tuple.Pair;
import zabi.minecraft.minerva.common.capability.CapabilityMessage;
import zabi.minecraft.minerva.common.entity.UUIDs;
import zabi.minecraft.minerva.common.mod.MLog;
import zabi.minecraft.minerva.common.utils.annotation.DontSync;
import zabi.minecraft.minerva.common.utils.annotation.Ignore;

public abstract class SimpleCapability {
    private static final boolean sc_dbg = System.getProperty("simplecapabilitydebug") != null;
    private static final HashMap<String, Pair<Reader, Writer>> handlers = new HashMap();
    private static final HashMap<String, Field[]> fieldCache = new HashMap();
    private static final ArrayList<Tuple<SimpleCapability, Capability<? extends SimpleCapability>>> capabilities = new ArrayList();
    private static int nextId = 0;
    private static SimpleNetworkWrapper net = null;
    protected static final Random rng = new Random();
    @Ignore
    protected byte dirty = 0;
    @Ignore
    protected int id = -1;

    public static void setup(SimpleNetworkWrapper netHandler) {
        net = netHandler;
    }

    public static <C extends SimpleCapability> void preInit(Class<C> capabilityClass) {
        Objects.requireNonNull(capabilityClass);
        CapabilityManager.INSTANCE.register(capabilityClass, new SimpleStorage(), () -> (SimpleCapability)capabilityClass.newInstance());
    }

    public static <C extends SimpleCapability> void init(Class<C> capabilityClass, String modId, Capability<C> capabilityObj, C capInstance) {
        Objects.requireNonNull(capabilityClass);
        Objects.requireNonNull(capabilityObj);
        Objects.requireNonNull(capInstance);
        Objects.requireNonNull(modId);
        capInstance.id = nextId++;
        capabilities.add((Tuple<SimpleCapability, Capability<? extends SimpleCapability>>)new Tuple(capInstance, capabilityObj));
        if (capabilities.get(capInstance.id).func_76341_a() != capInstance) {
            throw new IllegalStateException("SimpleCapability " + capabilityObj.getName() + " internal ID doesn't match the lookup id. Things won't work!");
        }
        CapabilityEventListener<C> cel = new CapabilityEventListener<C>(modId + capabilityClass.getName(), capabilityObj, capInstance);
        MinecraftForge.EVENT_BUS.register(cel);
    }

    private static Vec3d readVec3d(NBTTagCompound tag, String name) {
        if (!tag.func_74764_b(name)) {
            return null;
        }
        return new Vec3d(tag.func_74775_l(name).func_74769_h("x"), tag.func_74775_l(name).func_74769_h("y"), tag.func_74775_l(name).func_74769_h("z"));
    }

    private static void writeVec3d(Vec3d bt, NBTTagCompound tag, String name) {
        if (bt != null) {
            NBTTagCompound tag_pos = new NBTTagCompound();
            tag_pos.func_74780_a("x", bt.field_72450_a);
            tag_pos.func_74780_a("y", bt.field_72448_b);
            tag_pos.func_74780_a("z", bt.field_72449_c);
            tag.func_74782_a(name, (NBTBase)tag_pos);
        }
    }

    private static UUID readUUID(NBTTagCompound tag, String name) {
        if (!tag.func_74764_b(name)) {
            return null;
        }
        return UUIDs.fromNBT(tag.func_74775_l(name));
    }

    private static void writeUUID(UUID bt, NBTTagCompound tag, String name) {
        if (bt != null) {
            tag.func_74782_a(name, (NBTBase)UUIDs.toNBT(bt));
        }
    }

    private static BlockPos readPos(NBTTagCompound tag, String name) {
        if (!tag.func_74764_b(name)) {
            return null;
        }
        return new BlockPos(tag.func_74775_l(name).func_74762_e("x"), tag.func_74775_l(name).func_74762_e("y"), tag.func_74775_l(name).func_74762_e("z"));
    }

    private static void writePos(BlockPos bt, NBTTagCompound tag, String name) {
        if (bt != null) {
            NBTTagCompound tag_pos = new NBTTagCompound();
            tag_pos.func_74768_a("x", bt.func_177958_n());
            tag_pos.func_74768_a("y", bt.func_177956_o());
            tag_pos.func_74768_a("z", bt.func_177952_p());
            tag.func_74782_a(name, (NBTBase)tag_pos);
        }
    }

    private static ItemStack readItemStack(NBTTagCompound tag, String name) {
        if (!tag.func_74764_b(name)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(tag.func_74775_l(name));
    }

    private static void writeItemStack(ItemStack bt, NBTTagCompound tag, String name) {
        if (bt != null) {
            tag.func_74782_a(name, (NBTBase)bt.serializeNBT());
        }
    }

    private static NBTTagCompound readNBT(NBTTagCompound tag, String name) {
        return tag.func_74775_l(name);
    }

    private static void writeNBT(NBTTagCompound bt, NBTTagCompound tag, String name) {
        if (bt != null) {
            tag.func_74782_a(name, (NBTBase)bt);
        }
    }

    private static String readString(NBTTagCompound tag, String name) {
        if (!tag.func_74764_b(name)) {
            return null;
        }
        return tag.func_74779_i(name);
    }

    private static void writeString(String bt, NBTTagCompound tag, String name) {
        if (bt != null) {
            tag.func_74778_a(name, bt);
        }
    }

    private static char readChar(NBTTagCompound tag, String name) {
        return (char)tag.func_74762_e(name);
    }

    private static void writeChar(char bt, NBTTagCompound tag, String name) {
        tag.func_74768_a(name, (int)bt);
    }

    private static byte readByte(NBTTagCompound tag, String name) {
        return tag.func_74771_c(name);
    }

    private static void writeByte(byte bt, NBTTagCompound tag, String name) {
        tag.func_74774_a(name, bt);
    }

    private static short readShort(NBTTagCompound tag, String name) {
        return tag.func_74765_d(name);
    }

    private static void writeShort(short bt, NBTTagCompound tag, String name) {
        tag.func_74777_a(name, bt);
    }

    private static int readInt(NBTTagCompound tag, String name) {
        return tag.func_74762_e(name);
    }

    private static void writeInt(int bt, NBTTagCompound tag, String name) {
        tag.func_74768_a(name, bt);
    }

    private static long readLong(NBTTagCompound tag, String name) {
        return tag.func_74763_f(name);
    }

    private static void writeLong(long bt, NBTTagCompound tag, String name) {
        tag.func_74772_a(name, bt);
    }

    private static float readFloat(NBTTagCompound tag, String name) {
        return tag.func_74760_g(name);
    }

    private static void writeFloat(float bt, NBTTagCompound tag, String name) {
        tag.func_74776_a(name, bt);
    }

    private static double readDouble(NBTTagCompound tag, String name) {
        return tag.func_74769_h(name);
    }

    private static void writeDouble(double bt, NBTTagCompound tag, String name) {
        tag.func_74780_a(name, bt);
    }

    private static boolean readBoolean(NBTTagCompound tag, String name) {
        return tag.func_74767_n(name);
    }

    private static void writeBoolean(boolean bt, NBTTagCompound tag, String name) {
        tag.func_74757_a(name, bt);
    }

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsKey(clazz.getCanonicalName())) {
            return fieldCache.get(clazz.getCanonicalName());
        }
        Field[] afields = clazz.getFields();
        Arrays.sort(afields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        ArrayList flist = Lists.newArrayList();
        for (Field f : afields) {
            if (!SimpleCapability.acceptField(f, f.getType())) continue;
            flist.add(f);
        }
        Field[] fields = new Field[flist.size()];
        for (int i = 0; i < flist.size(); ++i) {
            fields[i] = (Field)flist.get(i);
        }
        fieldCache.put(clazz.getCanonicalName(), fields);
        return fields;
    }

    private static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = handlers.get(clazz.getCanonicalName());
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    private static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        if (f.isAnnotationPresent(Ignore.class) || Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        if (f.isAnnotationPresent(CustomSerializer.class)) {
            return true;
        }
        return handlers.containsKey(type.getCanonicalName());
    }

    private static boolean syncField(Field f, Class<?> type) {
        return SimpleCapability.acceptField(f, type) && !f.isAnnotationPresent(DontSync.class);
    }

    private static <T> void map(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(type.getCanonicalName(), (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    public static void messageReceived(NBTTagCompound tag, int capabilityId, int entityID, byte dirt) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                Capability capability = (Capability)capabilities.get(capabilityId).func_76340_b();
                SimpleCapability.log("message received for  " + capability.getName() + ", entity: " + entityID);
                Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
                try {
                    SimpleCapability.log("EntityName: " + e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (e != null && e.hasCapability(capability, null)) {
                    ((SimpleCapability)e.getCapability(capability, null)).readSyncNBT(tag);
                    ((SimpleCapability)e.getCapability(capability, null)).onSyncMessage(dirt);
                } else {
                    SimpleCapability.log("message dropped: " + e + ", " + capability.getName());
                }
            }
        });
    }

    private static void log(Object o) {
        if (sc_dbg) {
            MLog.i(o);
        }
    }

    private final void writeField(Field f, Class clazz, NBTTagCompound buf) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        if (f.getAnnotation(CustomSerializer.class) != null) {
            f.getAnnotation(CustomSerializer.class).writer().newInstance().write(f.get(this), buf, f.getName());
        } else {
            Pair<Reader, Writer> handler = SimpleCapability.getHandler(clazz);
            ((Writer)handler.getRight()).write(f.get(this), buf, f.getName());
        }
    }

    private final void readField(Field f, Class clazz, NBTTagCompound buf) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        if (f.getAnnotation(CustomSerializer.class) != null) {
            f.set(this, f.getAnnotation(CustomSerializer.class).reader().newInstance().read(buf, f.getName()));
        } else {
            Pair<Reader, Writer> handler = SimpleCapability.getHandler(clazz);
            f.set(this, ((Reader)handler.getLeft()).read(buf, f.getName()));
        }
    }

    public final NBTBase serialize(NBTTagCompound tag) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SimpleCapability.getClassFields(clazz)) {
                Class<?> type = f.getType();
                this.writeField(f, type, tag);
            }
        }
        catch (Exception e) {
            throw new SerializationException("Error at serializing capability " + this, (Throwable)e);
        }
        return tag;
    }

    public final void deserialize(NBTTagCompound tag) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SimpleCapability.getClassFields(clazz)) {
                Class<?> type = f.getType();
                this.readField(f, type, tag);
            }
        }
        catch (Exception e) {
            throw new SerializationException("Error at deserializing capability " + this, (Throwable)e);
        }
    }

    public final void readSyncNBT(NBTTagCompound tag) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SimpleCapability.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!SimpleCapability.syncField(f, type)) continue;
                this.readField(f, type, tag);
            }
        }
        catch (Exception e) {
            throw new SerializationException("[Cap-Syn] Error at deserializing capability " + this, (Throwable)e);
        }
    }

    public final void writeSyncNBT(NBTTagCompound tag) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SimpleCapability.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!SimpleCapability.syncField(f, type)) continue;
                this.writeField(f, type, tag);
            }
        }
        catch (Exception e) {
            throw new SerializationException("[Cap-Syn] Error at serializing capability " + this, (Throwable)e);
        }
    }

    public abstract boolean isRelevantFor(Entity var1);

    @SideOnly(value=Side.CLIENT)
    public void onSyncMessage(byte mode) {
    }

    public boolean shouldSyncToPlayersAround() {
        return true;
    }

    public boolean shouldSyncToOwnerPlayer() {
        return true;
    }

    public abstract SimpleCapability getNewInstance();

    public final void markDirty(byte mode) {
        this.dirty = mode;
    }

    static {
        SimpleCapability.map(Byte.TYPE, SimpleCapability::readByte, SimpleCapability::writeByte);
        SimpleCapability.map(Short.TYPE, SimpleCapability::readShort, SimpleCapability::writeShort);
        SimpleCapability.map(Integer.TYPE, SimpleCapability::readInt, SimpleCapability::writeInt);
        SimpleCapability.map(Long.TYPE, SimpleCapability::readLong, SimpleCapability::writeLong);
        SimpleCapability.map(Float.TYPE, SimpleCapability::readFloat, SimpleCapability::writeFloat);
        SimpleCapability.map(Double.TYPE, SimpleCapability::readDouble, SimpleCapability::writeDouble);
        SimpleCapability.map(Boolean.TYPE, SimpleCapability::readBoolean, SimpleCapability::writeBoolean);
        SimpleCapability.map(Character.TYPE, SimpleCapability::readChar, SimpleCapability::writeChar);
        SimpleCapability.map(String.class, SimpleCapability::readString, SimpleCapability::writeString);
        SimpleCapability.map(NBTTagCompound.class, SimpleCapability::readNBT, SimpleCapability::writeNBT);
        SimpleCapability.map(ItemStack.class, SimpleCapability::readItemStack, SimpleCapability::writeItemStack);
        SimpleCapability.map(BlockPos.class, SimpleCapability::readPos, SimpleCapability::writePos);
        SimpleCapability.map(UUID.class, SimpleCapability::readUUID, SimpleCapability::writeUUID);
        SimpleCapability.map(Vec3d.class, SimpleCapability::readVec3d, SimpleCapability::writeVec3d);
    }

    public static class CapabilityEventListener<C extends SimpleCapability> {
        private final ResourceLocation name;
        private final Capability<C> capability;
        private final SimpleCapability default_instance;

        public CapabilityEventListener(String name, Capability<C> capability, SimpleCapability default_instance) {
            this.name = new ResourceLocation(name);
            this.capability = capability;
            this.default_instance = default_instance;
        }

        @SubscribeEvent
        public void attachCapabilityToEntity(AttachCapabilitiesEvent<Entity> evt) {
            if (this.default_instance.isRelevantFor((Entity)evt.getObject())) {
                SimpleCapability.log("Capability " + this.name + " attached");
                evt.addCapability(this.name, new SimpleProvider<SimpleCapability>(this.capability, this.default_instance.getNewInstance()));
            }
        }

        @SubscribeEvent
        public void onEntityTracking(PlayerEvent.StartTracking evt) {
            if (this.default_instance.shouldSyncToPlayersAround()) {
                Entity e = evt.getTarget();
                SimpleCapability.log("start tracking: " + e);
                if (!e.field_70170_p.field_72995_K && e.hasCapability(this.capability, null) && evt.getEntityPlayer() instanceof EntityPlayerMP) {
                    SimpleCapability.log("start tracking - succeded");
                    NBTTagCompound tag = new NBTTagCompound();
                    ((SimpleCapability)e.getCapability(this.capability, null)).writeSyncNBT(tag);
                    net.sendTo((IMessage)new CapabilityMessage(this.default_instance.id, tag, e.func_145782_y(), 0), (EntityPlayerMP)evt.getEntityPlayer());
                }
            }
        }

        @SubscribeEvent
        public void onEntityUpdate(LivingEvent.LivingUpdateEvent evt) {
            if (!evt.getEntityLiving().field_70170_p.field_72995_K && evt.getEntityLiving().hasCapability(this.capability, null)) {
                SimpleCapability instance = (SimpleCapability)evt.getEntityLiving().getCapability(this.capability, null);
                if (instance.dirty != 0) {
                    SimpleCapability.log("Cleaning instance of " + this.capability.getName() + " for " + evt.getEntityLiving());
                    NBTTagCompound tag = new NBTTagCompound();
                    ((SimpleCapability)evt.getEntityLiving().getCapability(this.capability, null)).writeSyncNBT(tag);
                    CapabilityMessage msg = new CapabilityMessage(this.default_instance.id, tag, evt.getEntityLiving().func_145782_y(), instance.dirty);
                    if (this.default_instance.shouldSyncToOwnerPlayer() && evt.getEntityLiving() instanceof EntityPlayerMP) {
                        net.sendTo((IMessage)msg, (EntityPlayerMP)evt.getEntityLiving());
                    }
                    if (this.default_instance.shouldSyncToPlayersAround()) {
                        net.sendToAllTracking((IMessage)msg, (Entity)evt.getEntityLiving());
                    }
                    instance.dirty = 0;
                }
            }
        }

        @SubscribeEvent
        public void onWorldJoin(EntityJoinWorldEvent evt) {
            if (this.default_instance.shouldSyncToOwnerPlayer() && evt.getEntity() instanceof EntityPlayerMP && this.default_instance.isRelevantFor(evt.getEntity())) {
                SimpleCapability.log("onWorldJoin - player");
                EntityPlayerMP entity = (EntityPlayerMP)evt.getEntity();
                NBTTagCompound tag = new NBTTagCompound();
                ((SimpleCapability)evt.getEntity().getCapability(this.capability, null)).writeSyncNBT(tag);
                net.sendTo((IMessage)new CapabilityMessage(this.default_instance.id, tag, entity.func_145782_y(), 0), entity);
            }
        }
    }

    public static class SimpleStorage<C extends SimpleCapability>
    implements Capability.IStorage<C> {
        public NBTBase writeNBT(Capability<C> capability, C instance, EnumFacing side) {
            return ((SimpleCapability)instance).serialize(new NBTTagCompound());
        }

        public void readNBT(Capability<C> capability, C instance, EnumFacing side, NBTBase nbt) {
            ((SimpleCapability)instance).deserialize((NBTTagCompound)nbt);
        }
    }

    public static class SimpleProvider<T extends SimpleCapability>
    implements ICapabilitySerializable<NBTBase> {
        private Capability<T> capability;
        private T deafault_instance;

        public SimpleProvider(Capability<T> capability, T default_instance) {
            this.capability = capability;
            this.deafault_instance = default_instance;
        }

        public boolean hasCapability(Capability<?> capabilityIn, EnumFacing facing) {
            return capabilityIn == this.capability;
        }

        public <V> V getCapability(Capability<V> capabilityIn, EnumFacing facing) {
            if (capabilityIn == this.capability) {
                return (V)this.capability.cast(this.deafault_instance);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return this.capability.getStorage().writeNBT(this.capability, this.deafault_instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            this.capability.getStorage().readNBT(this.capability, this.deafault_instance, null, nbt);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CustomSerializer {
        public Class<? extends Reader> reader();

        public Class<? extends Writer> writer();
    }

    public static interface Reader<T> {
        public T read(NBTTagCompound var1, String var2);
    }

    public static interface Writer<T> {
        public void write(T var1, NBTTagCompound var2, String var3);
    }
}

