/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.client.blockmodels;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zabi.minecraft.minerva.client.blockmodels.IModelRegister;

@SideOnly(value=Side.CLIENT)
public final class ModelHandler {
    private ModelHandler() {
    }

    public static void registerModels() {
        for (Block block : Block.field_149771_c) {
            if (!(block instanceof IModelRegister)) continue;
            ((IModelRegister)block).registerModel();
        }
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IModelRegister)) continue;
            ((IModelRegister)item).registerModel();
        }
    }

    public static void registerForgeModel(Block block, int meta, String variant) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            throw new UnsupportedOperationException("This block has no Item!");
        }
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(item.getRegistryName(), variant);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static void registerForgeModel(Item item, int meta, String variant) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(item.getRegistryName(), variant);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static void registerModel(Block block, int meta) {
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            ModelHandler.registerModel(item, meta);
        }
    }

    public static void registerModel(Item item, int meta) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static <T extends Enum<T>> void registerModel(Block block, Class<T> clazz) {
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            throw new UnsupportedOperationException("This block has no Item!");
        }
        ModelHandler.registerModel(item, clazz);
    }

    public static <T extends Enum<T>> void registerModel(Item item, Class<T> clazz) {
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            ResourceLocation location = new ResourceLocation(item.getRegistryName() + "_" + ((IStringSerializable)t).func_176610_l());
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(location, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)t.ordinal(), (ModelResourceLocation)modelResourceLocation);
        }
    }
}

