/*
 * Decompiled with CFR 0.152.
 */
package com.eksekk.vanillaanvilrepair.repairlist;

import com.eksekk.vanillaanvilrepair.config.ConfigFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreIngredient;

public class RepairList {
    private static Map<Item, ArrayList<Item>> repairListCT = new HashMap<Item, ArrayList<Item>>();
    private static Map<Item, ArrayList<Item>> repairList = new HashMap<Item, ArrayList<Item>>();

    public static Map<Item, ArrayList<Item>> getRepairList() {
        return repairList;
    }

    public static void addRepairEntryCT(Item repairedItem, Item material) {
        repairListCT.putIfAbsent(material, new ArrayList());
        repairListCT.get(material).add(repairedItem);
    }

    private static void addRepairEntry(Item repairedItem, Item material) {
        repairList.putIfAbsent(material, new ArrayList());
        repairList.get(material).add(repairedItem);
    }

    public static void processConfigRepairEntries() {
        String[] repairEntries;
        repairList.clear();
        for (Map.Entry<Item, ArrayList<Item>> entry : repairListCT.entrySet()) {
            repairList.putIfAbsent(entry.getKey(), new ArrayList());
            repairList.get(entry.getKey()).addAll((Collection<Item>)entry.getValue());
        }
        for (String repair : repairEntries = ConfigFields.repairList) {
            String[] splittedItemsMaterials = repair.split(";");
            if (splittedItemsMaterials.length != 2) {
                System.err.println("Config repair entry \"" + repair + "\" is invalid, skipping");
                continue;
            }
            String[] splittedItems = splittedItemsMaterials[0].split(",");
            String[] splittedMaterials = splittedItemsMaterials[1].split(",");
            ArrayList<Item> repairedItems = new ArrayList<Item>(splittedItems.length);
            ArrayList<Item> materials = new ArrayList<Item>(splittedMaterials.length);
            for (String itemString : splittedItems) {
                Item repairedItem = Item.func_111206_d((String)itemString);
                if (repairedItem == null) {
                    System.err.println("Config repair item entry \"" + itemString + "\" is invalid - repaired item is null, skipping this item");
                    continue;
                }
                repairedItems.add(repairedItem);
            }
            for (String materialString : splittedMaterials) {
                if (materialString.startsWith("ore")) {
                    OreIngredient oreEntry = new OreIngredient(materialString.substring(4));
                    ItemStack[] oreMaterials = oreEntry.func_193365_a();
                    if (oreMaterials.length == 0) {
                        System.err.println("Empty OreDictionary entry " + materialString.substring(4));
                    }
                    for (ItemStack material : oreMaterials) {
                        materials.add(material.func_77973_b());
                    }
                    continue;
                }
                Item material = Item.func_111206_d((String)materialString);
                if (material == null) {
                    System.err.println("Config repair material entry \"" + materialString + "\" is invalid - material is null, skipping this material");
                    continue;
                }
                materials.add(material);
            }
            for (Item material : materials) {
                repairList.putIfAbsent(material, new ArrayList());
                repairList.get(material).addAll(repairedItems);
            }
        }
    }
}

