/*
 * Decompiled with CFR 0.152.
 */
package alexndr.plugins.Aesthetics;

import alexndr.api.config.ConfigHelper;
import alexndr.api.config.types.ConfigBlock;
import alexndr.api.config.types.ConfigEntry;
import alexndr.api.logger.LogHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Settings {
    public static final String CONFIGURE_BRICKS = "Bricks";
    public static final String CONFIGURE_SOBLOCKS = "Simple Ores Blocks";
    public static final String CONFIGURE_FBLOCKS = "Fusion Blocks";
    public static final String CONFIGURE_NRBLOCKS = "Netherrocks Blocks";
    private static Configuration settings = new Configuration();
    public static ConfigBlock ironBricks;
    public static ConfigBlock goldBricks;
    public static ConfigBlock diamondBricks;
    public static ConfigBlock copperBricks;
    public static ConfigBlock tinBricks;
    public static ConfigBlock mythrilBricks;
    public static ConfigBlock adamantiumBricks;
    public static ConfigBlock onyxBricks;
    public static ConfigBlock mythrilDoor;
    public static ConfigBlock adamantiumDoor;
    public static ConfigBlock onyxDoor;
    public static ConfigBlock tinDoor;
    public static ConfigBlock copperDoor;
    public static ConfigBlock copperBars;
    public static ConfigBlock tinBars;
    public static ConfigBlock mythrilBars;
    public static ConfigBlock adamantiumBars;
    public static ConfigBlock onyxBars;
    public static ConfigBlock steelBricks;
    public static ConfigBlock bronzeBricks;
    public static ConfigBlock thyriumBricks;
    public static ConfigBlock sinisiteBricks;
    public static ConfigBlock bronzeDoor;
    public static ConfigBlock steelBars;
    public static ConfigBlock bronzeBars;
    public static ConfigBlock thyriumBars;
    public static ConfigBlock sinisiteBars;
    public static ConfigBlock fyriteBricks;
    public static ConfigBlock malachiteBricks;
    public static ConfigBlock ashstoneBricks;
    public static ConfigBlock illumeniteBricks;
    public static ConfigBlock dragonstoneBricks;
    public static ConfigBlock argoniteBricks;
    public static ConfigBlock dragonstoneDoor;
    public static ConfigBlock ashstoneDoor;
    public static ConfigBlock argoniteDoor;
    public static ConfigBlock fyriteDoor;
    public static ConfigBlock illumeniteDoor;
    public static ConfigBlock malachiteDoor;
    public static ConfigBlock fyriteBars;
    public static ConfigBlock malachiteBars;
    public static ConfigBlock ashstoneBars;
    public static ConfigBlock illumeniteBars;
    public static ConfigBlock dragonstoneBars;
    public static ConfigBlock argoniteBars;
    public static boolean enableSimpleOres;
    public static boolean enableFusion;
    public static boolean enableNetherrocks;
    public static boolean MCBricks;
    public static boolean MCBrickStairs;
    public static boolean SOBricks;
    public static boolean SOBrickStairs;
    public static boolean SODoors;
    public static boolean SOBars;
    public static boolean FBricks;
    public static boolean FBrickStairs;
    public static boolean FDoors;
    public static boolean FBars;
    public static boolean NRBricks;
    public static boolean NRBrickStairs;
    public static boolean NRDoors;
    public static boolean NRBars;

    public static void createOrLoadSettings(FMLPreInitializationEvent event) {
        settings = ConfigHelper.GetConfig((FMLPreInitializationEvent)event, (String)"AleXndr", (String)"aesthetics.cfg");
        LogHelper.verbose((String)"aesthetics", (String)"loading settings...");
        try {
            settings.load();
            ConfigHelper.createHelpEntry((Configuration)settings, (String)"http://minecraft.curseforge.com/projects/aesthetics");
            Settings.configureGeneral();
            Settings.configureVanilla();
            if (enableSimpleOres) {
                Settings.configureSimpleOres();
            }
            if (enableFusion) {
                Settings.configureFusion();
            }
            if (Loader.isModLoaded((String)"netherrocks") && enableNetherrocks) {
                Settings.configureNetherrocks();
            }
        }
        catch (Exception e) {
            LogHelper.severe((String)"aesthetics", (String)"Failed to load settings");
            e.printStackTrace();
        }
        finally {
            settings.save();
            LogHelper.verbose((String)"aesthetics", (String)"Settings loaded successfully");
        }
    }

    public static void configureGeneral() {
        enableSimpleOres = settings.getBoolean("EnableSimpleOres", "general", true, "Enable Simple Ores-based blocks");
        enableFusion = settings.getBoolean("EnableFusion", "general", true, "Enable Fusion-based blocks");
        enableNetherrocks = settings.getBoolean("EnableNetherrocks", "general", true, "Enable Netherrocks-based blocks");
        MCBricks = settings.getBoolean("EnableVanillaBricks", "general", true, "Enable vanilla-based bricks");
        MCBrickStairs = settings.getBoolean("EnableVanillaBrickStairs", "general", true, "Enable vanilla-based brick stairs");
        if (enableSimpleOres) {
            ConfigEntry SOToggles = new ConfigEntry("SimpleOres", "general", true);
            SOToggles.GetConfig(settings);
            SOBricks = settings.getBoolean("EnableBricks", SOToggles.getSubCategory(), Loader.isModLoaded((String)"simpleores"), "Enable Simple Ores-based bricks");
            SOBrickStairs = settings.getBoolean("EnableBrickStairs", SOToggles.getSubCategory(), Loader.isModLoaded((String)"simpleores"), "Enable Simple Ores-based brick stairs");
            SODoors = settings.getBoolean("EnableDoors", SOToggles.getSubCategory(), Loader.isModLoaded((String)"simpleores"), "Enable Simple Ores-based doors");
            SOBars = settings.getBoolean("EnableBars", SOToggles.getSubCategory(), Loader.isModLoaded((String)"simpleores"), "Enable Simple Ores-based bars");
        }
        if (enableFusion) {
            ConfigEntry FToggles = new ConfigEntry("Fusion", "general", true);
            FToggles.GetConfig(settings);
            FBricks = settings.getBoolean("EnableBricks", FToggles.getSubCategory(), Loader.isModLoaded((String)"fusion"), "Enable Fusion-based bricks");
            FBrickStairs = settings.getBoolean("EnableBrickStairs", FToggles.getSubCategory(), Loader.isModLoaded((String)"fusion"), "Enable Fusion-based brick stairs");
            FDoors = settings.getBoolean("EnableDoors", FToggles.getSubCategory(), Loader.isModLoaded((String)"fusion"), "Enable Fusion-based doors");
            FBars = settings.getBoolean("EnableBars", FToggles.getSubCategory(), Loader.isModLoaded((String)"fusion"), "Enable Fusion-based bars");
        }
        if (Loader.isModLoaded((String)"netherrocks") && enableNetherrocks) {
            ConfigEntry NRToggles = new ConfigEntry("Netherrocks", "general", true);
            NRToggles.GetConfig(settings);
            NRBricks = settings.getBoolean("EnableBricks", NRToggles.getSubCategory(), true, "Enable Netherrocks-based bricks");
            NRBrickStairs = settings.getBoolean("EnableBrickStairs", NRToggles.getSubCategory(), true, "Enable Netherrocks-based brick stairs");
            NRDoors = settings.getBoolean("EnableDoors", NRToggles.getSubCategory(), true, "Enable Netherrocks-based doors");
            NRBars = settings.getBoolean("EnableBars", NRToggles.getSubCategory(), true, "Enable Netherrocks-based bars");
        }
    }

    public static void configureVanilla() {
        ironBricks = new ConfigBlock("Iron Bricks", CONFIGURE_BRICKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        ironBricks.GetConfig(settings);
        goldBricks = new ConfigBlock("Gold Bricks", CONFIGURE_BRICKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        goldBricks.GetConfig(settings);
        diamondBricks = new ConfigBlock("Diamond Bricks", CONFIGURE_BRICKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        diamondBricks.GetConfig(settings);
    }

    public static void configureSimpleOres() {
        copperBricks = new ConfigBlock("Copper Bricks", CONFIGURE_SOBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        copperBricks.GetConfig(settings);
        tinBricks = new ConfigBlock("Tin Bricks", CONFIGURE_SOBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        tinBricks.GetConfig(settings);
        mythrilBricks = new ConfigBlock("Mythril Bricks", CONFIGURE_SOBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        mythrilBricks.GetConfig(settings);
        adamantiumBricks = new ConfigBlock("Adamantium Bricks", CONFIGURE_SOBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        adamantiumBricks.GetConfig(settings);
        onyxBricks = new ConfigBlock("Onyx Bricks", CONFIGURE_SOBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        onyxBricks.GetConfig(settings);
        copperDoor = new ConfigBlock("Copper Door", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        copperDoor.GetConfig(settings);
        tinDoor = new ConfigBlock("Tin Door", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        tinDoor.GetConfig(settings);
        mythrilDoor = new ConfigBlock("Mythril Door", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        mythrilDoor.GetConfig(settings);
        adamantiumDoor = new ConfigBlock("Adamantium Door", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        adamantiumDoor.GetConfig(settings);
        onyxDoor = new ConfigBlock("Onyx Door", CONFIGURE_SOBLOCKS).setHardness(20.0f).setResistance(29.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        onyxDoor.GetConfig(settings);
        copperBars = new ConfigBlock("Copper Bars", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        copperBars.GetConfig(settings);
        tinBars = new ConfigBlock("Tin Bars", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        tinBars.GetConfig(settings);
        mythrilBars = new ConfigBlock("Mythril Bars", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        mythrilBars.GetConfig(settings);
        adamantiumBars = new ConfigBlock("Adamantium Bars", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        adamantiumBars.GetConfig(settings);
        onyxBars = new ConfigBlock("Onyx Bars", CONFIGURE_SOBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        onyxBars.GetConfig(settings);
    }

    public static void configureFusion() {
        steelBricks = new ConfigBlock("Steel Bricks", CONFIGURE_FBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        steelBricks.GetConfig(settings);
        bronzeBricks = new ConfigBlock("Bronze Bricks", CONFIGURE_FBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        bronzeBricks.GetConfig(settings);
        thyriumBricks = new ConfigBlock("Thyrium Bricks", CONFIGURE_FBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        thyriumBricks.GetConfig(settings);
        sinisiteBricks = new ConfigBlock("Sinisite Bricks", CONFIGURE_FBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        sinisiteBricks.GetConfig(settings);
        bronzeDoor = new ConfigBlock("Bronze Door", CONFIGURE_FBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        bronzeDoor.GetConfig(settings);
        steelBars = new ConfigBlock("Steel Bars", CONFIGURE_FBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        steelBars.GetConfig(settings);
        bronzeBars = new ConfigBlock("Bronze Bars", CONFIGURE_FBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        bronzeBars.GetConfig(settings);
        thyriumBars = new ConfigBlock("Thyrium Bars", CONFIGURE_FBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        thyriumBars.GetConfig(settings);
        sinisiteBars = new ConfigBlock("Sinisite Bars", CONFIGURE_FBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        sinisiteBars.GetConfig(settings);
    }

    public static void configureNetherrocks() {
        fyriteBricks = new ConfigBlock("Fyrite Bricks", CONFIGURE_NRBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        fyriteBricks.GetConfig(settings);
        malachiteBricks = new ConfigBlock("Malachite Bricks", CONFIGURE_NRBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        malachiteBricks.GetConfig(settings);
        ashstoneBricks = new ConfigBlock("Ashstone Bricks", CONFIGURE_NRBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        ashstoneBricks.GetConfig(settings);
        illumeniteBricks = new ConfigBlock("Illumenite Bricks", CONFIGURE_NRBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(1.0f).setHarvestTool("pickaxe");
        illumeniteBricks.GetConfig(settings);
        dragonstoneBricks = new ConfigBlock("Dragonstone Bricks", CONFIGURE_NRBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        dragonstoneBricks.GetConfig(settings);
        argoniteBricks = new ConfigBlock("Argonite Bricks", CONFIGURE_NRBLOCKS).setHardness(15.0f).setResistance(20.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        argoniteBricks.GetConfig(settings);
        dragonstoneDoor = new ConfigBlock("Dragonstone Door", CONFIGURE_NRBLOCKS).setHardness(10.0f).setResistance(44.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        dragonstoneDoor.GetConfig(settings);
        ashstoneDoor = new ConfigBlock("Ashstone Door", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        ashstoneDoor.GetConfig(settings);
        argoniteDoor = new ConfigBlock("Argonite Door", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        argoniteDoor.GetConfig(settings);
        fyriteDoor = new ConfigBlock("Fyrite Door", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        fyriteDoor.GetConfig(settings);
        illumeniteDoor = new ConfigBlock("Illumenite Door", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(10.0f).setLightValue(1.0f).setHarvestTool("pickaxe");
        illumeniteDoor.GetConfig(settings);
        malachiteDoor = new ConfigBlock("Malachite Door", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(10.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        malachiteDoor.GetConfig(settings);
        fyriteBars = new ConfigBlock("Fyrite Bars", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        fyriteBars.GetConfig(settings);
        malachiteBars = new ConfigBlock("Malachite Bars", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        malachiteBars.GetConfig(settings);
        ashstoneBars = new ConfigBlock("Ashstone Bars", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        ashstoneBars.GetConfig(settings);
        illumeniteBars = new ConfigBlock("Illumenite Bars", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(1.0f).setHarvestTool("pickaxe");
        illumeniteBars.GetConfig(settings);
        dragonstoneBars = new ConfigBlock("Dragonstone Bars", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        dragonstoneBars.GetConfig(settings);
        argoniteBars = new ConfigBlock("Argonite Bars", CONFIGURE_NRBLOCKS).setHardness(7.0f).setResistance(12.0f).setLightValue(0.0f).setHarvestTool("pickaxe");
        argoniteBars.GetConfig(settings);
    }
}

