/*
 * Decompiled with CFR 0.152.
 */
package shadows.hitwithaxe.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import shadows.hitwithaxe.EnumBarkType;
import shadows.hitwithaxe.block.BlockDebarkedLog;
import shadows.placebo.Placebo;
import shadows.placebo.util.PlaceboUtil;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockDebarkedRubber
extends BlockDebarkedLog {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75), new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25), new AxisAlignedBB(0.25, 0.25, 0.75, 0.75, 0.75, 1.0), new AxisAlignedBB(0.75, 0.25, 0.25, 1.0, 0.75, 0.75), new AxisAlignedBB(0.0, 0.25, 0.25, 0.25, 0.75, 0.75), new AxisAlignedBB(0.25, 0.75, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75)};
    protected static final AxisAlignedBB[] COMBINED_BOUNDING_BOXES = new AxisAlignedBB[64];

    public static AxisAlignedBB getCombinedBoundingBoxForState(IBlockState state) {
        int index = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            index |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            index |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            index |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            index |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            index |= 0x10;
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            index |= 0x20;
        }
        return COMBINED_BOUNDING_BOXES[index];
    }

    public BlockDebarkedRubber(EnumBarkType e) {
        super(e);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149647_a((CreativeTabs)BLCreativeTabs.BLOCKS);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177976_e()))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177984_a()))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos.func_177977_b(), EnumFacing.UP) || this.canConnectTo(worldIn, pos.func_177977_b())));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == this || block == BlockRegistry.LEAVES_RUBBER_TREE || block == BlockRegistry.LOG_RUBBER;
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        BlockDebarkedRubber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOXES[0]);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockDebarkedRubber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOXES[1]);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockDebarkedRubber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOXES[2]);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockDebarkedRubber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOXES[3]);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockDebarkedRubber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOXES[4]);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockDebarkedRubber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOXES[5]);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockDebarkedRubber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOXES[6]);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BlockDebarkedRubber.getCombinedBoundingBoxForState(state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public void initModels(ModelRegistryEvent e) {
        Placebo.PROXY.useRenamedMapper((Block)this, "rubber_log");
        PlaceboUtil.sMRL((String)"rubber_log", (Block)this, (int)0, (String)"inventory");
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P();
    }

    static {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        for (int i = 0; i < 64; ++i) {
            boolean north = (i & 1) == 1;
            boolean south = (i >> 1 & 1) == 1;
            boolean east = (i >> 2 & 1) == 1;
            boolean west = (i >> 3 & 1) == 1;
            boolean up = (i >> 4 & 1) == 1;
            boolean down = (i >> 5 & 1) == 1;
            boxes.clear();
            boxes.add(BOUNDING_BOXES[0]);
            if (north) {
                boxes.add(BOUNDING_BOXES[1]);
            }
            if (south) {
                boxes.add(BOUNDING_BOXES[2]);
            }
            if (east) {
                boxes.add(BOUNDING_BOXES[3]);
            }
            if (west) {
                boxes.add(BOUNDING_BOXES[4]);
            }
            if (up) {
                boxes.add(BOUNDING_BOXES[5]);
            }
            if (down) {
                boxes.add(BOUNDING_BOXES[6]);
            }
            double minX = 1.0;
            double minY = 1.0;
            double minZ = 1.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxZ = 0.0;
            for (AxisAlignedBB box : boxes) {
                if (box.field_72340_a < minX) {
                    minX = box.field_72340_a;
                }
                if (box.field_72338_b < minY) {
                    minY = box.field_72338_b;
                }
                if (box.field_72339_c < minZ) {
                    minZ = box.field_72339_c;
                }
                if (box.field_72336_d > maxX) {
                    maxX = box.field_72336_d;
                }
                if (box.field_72337_e > maxY) {
                    maxY = box.field_72337_e;
                }
                if (!(box.field_72334_f > maxZ)) continue;
                maxZ = box.field_72334_f;
            }
            BlockDebarkedRubber.COMBINED_BOUNDING_BOXES[i] = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }
}

