/*
 * Decompiled with CFR 0.152.
 */
package shadows.hitwithaxe;

import com.google.common.base.Predicate;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shadows.hitwithaxe.ITransformCall;

public class TransformRecipe {
    protected final Predicate<IBlockState> input;
    protected final ITransformCall action;
    protected final int harvestLevel;
    protected final List<ItemStack> displayIn;
    protected final List<ItemStack> displayOut;

    public TransformRecipe(Predicate<IBlockState> input, ITransformCall action, int harvestLevel, List<ItemStack> displayIn, List<ItemStack> displayOut) {
        this.input = input;
        this.action = action;
        this.harvestLevel = harvestLevel;
        this.displayIn = displayIn;
        this.displayOut = displayOut;
    }

    public boolean matches(IBlockState state) {
        return this.input.apply((Object)state);
    }

    public void action(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand) {
        this.action.call(world, pos, state, player, hand);
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public void addIngredients(IIngredients ig) {
        ig.setInputs(VanillaTypes.ITEM, this.displayIn);
        ig.setOutputs(VanillaTypes.ITEM, this.displayOut);
    }

    public List<ItemStack> getDisplayIn() {
        return this.displayIn;
    }

    public List<ItemStack> getDisplayOut() {
        return this.displayOut;
    }

    public ItemStack getFirstDisplayIn() {
        return this.getDisplayIn().get(0);
    }
}

