/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.google.common.base.Optional;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityBlockSwapper
extends Entity {
    private static final DataParameter<Optional<IBlockState>> ORIG_BLOCK_STATE = EntityDataManager.func_187226_a(EntityBlockSwapper.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Integer> RESTORE_TIME = EntityDataManager.func_187226_a(EntityBlockSwapper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> POS = EntityDataManager.func_187226_a(EntityBlockSwapper.class, (DataSerializer)DataSerializers.field_187200_j);
    private int duration;
    private boolean breakParticlesEnd;
    private BlockPos pos;

    public EntityBlockSwapper(World world) {
        this(world, new BlockPos(0, 0, 0), Blocks.field_150350_a.func_176223_P(), 20, false, false);
    }

    public EntityBlockSwapper(World world, BlockPos pos, IBlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        super(world);
        List swappers;
        this.setStorePos(pos);
        this.setRestoreTime(duration);
        this.breakParticlesEnd = breakParticlesEnd;
        this.func_70105_a(1.0f, 1.0f);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        if (!world.field_72995_K) {
            this.setOrigBlock(world.func_180495_p(pos));
            if (breakParticlesStart) {
                world.func_175655_b(pos, false);
            }
            world.func_175656_a(pos, newBlock);
        }
        if (!(swappers = world.func_72872_a(EntityBlockSwapper.class, this.func_174813_aQ())).isEmpty()) {
            EntityBlockSwapper swapper = (EntityBlockSwapper)((Object)swappers.get(0));
            this.setOrigBlock(swapper.getOrigBlock());
            swapper.func_70106_y();
        }
    }

    public static void swapBlock(World world, BlockPos pos, IBlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        if (!world.field_72995_K) {
            EntityBlockSwapper swapper = new EntityBlockSwapper(world, pos, newBlock, duration, breakParticlesStart, breakParticlesEnd);
            world.func_72838_d((Entity)swapper);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ORIG_BLOCK_STATE, (Object)Optional.of((Object)Blocks.field_150346_d.func_176223_P()));
        this.func_184212_Q().func_187214_a(RESTORE_TIME, (Object)20);
        this.func_184212_Q().func_187214_a(POS, (Object)new BlockPos(0, 0, 0));
    }

    public int getRestoreTime() {
        return (Integer)this.field_70180_af.func_187225_a(RESTORE_TIME);
    }

    public void setRestoreTime(int restoreTime) {
        this.field_70180_af.func_187227_b(RESTORE_TIME, (Object)restoreTime);
        this.duration = restoreTime;
    }

    public BlockPos getStorePos() {
        return (BlockPos)this.field_70180_af.func_187225_a(POS);
    }

    public void setStorePos(BlockPos bpos) {
        this.field_70180_af.func_187227_b(POS, (Object)bpos);
        this.pos = bpos;
    }

    public IBlockState getOrigBlock() {
        return (IBlockState)((Optional)this.func_184212_Q().func_187225_a(ORIG_BLOCK_STATE)).get();
    }

    public void setOrigBlock(IBlockState block) {
        this.func_184212_Q().func_187227_b(ORIG_BLOCK_STATE, (Object)Optional.of((Object)block));
    }

    public void restoreBlock() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.breakParticlesEnd) {
                this.field_70170_p.func_175655_b(this.pos, false);
            }
            this.field_70170_p.func_175656_a(this.pos, this.getOrigBlock());
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.duration && this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ()).isEmpty()) {
            this.restoreBlock();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        Optional blockOption = Optional.of((Object)this.getOrigBlock());
        if (blockOption.isPresent()) {
            compound.func_74782_a("block", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)((IBlockState)blockOption.get())));
        }
        compound.func_74768_a("restoreTime", this.getRestoreTime());
        compound.func_74768_a("storePosX", this.getStorePos().func_177958_n());
        compound.func_74768_a("storePosY", this.getStorePos().func_177956_o());
        compound.func_74768_a("storePosZ", this.getStorePos().func_177952_p());
    }

    public void func_70037_a(NBTTagCompound compound) {
        IBlockState blockState = NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("block")));
        this.setOrigBlock(blockState);
        this.setRestoreTime(compound.func_74762_e("restoreTime"));
        this.setStorePos(new BlockPos(compound.func_74762_e("storePosX"), compound.func_74762_e("storePosY"), compound.func_74762_e("storePosZ")));
    }
}

