/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAttackAI;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import java.util.List;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.SoundEvent;

public class AnimationAreaAttackAI<T extends MowzieEntity>
extends AnimationAttackAI<T> {
    private float arc;
    private float height;
    private boolean faceTarget;

    public AnimationAreaAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float knockback, float range, float height, float arc, float damageMultiplier, int damageFrame) {
        super(entity, animation, attackSound, hitSound, knockback, range, damageMultiplier, damageFrame);
        this.arc = arc;
        this.height = height;
        this.faceTarget = true;
    }

    public AnimationAreaAttackAI(T entity, Animation animation, SoundEvent attackSound, SoundEvent hitSound, float knockback, float range, float height, float arc, float damageMultiplier, int damageFrame, boolean faceTarget) {
        super(entity, animation, attackSound, hitSound, knockback, range, damageMultiplier, damageFrame);
        this.arc = arc;
        this.height = height;
        this.faceTarget = faceTarget;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75246_d() {
        if (this.faceTarget && this.entity.getAnimationTick() < this.damageFrame && this.entityTarget != null) {
            this.entity.func_70625_a((Entity)this.entityTarget, 30.0f, 30.0f);
        } else if (this.entity.getAnimationTick() == this.damageFrame) {
            this.hitEntities();
        }
    }

    public void hitEntities() {
        List<EntityLivingBase> entitiesHit = this.entity.getEntityLivingBaseNearby(this.range, this.height, this.range, this.range);
        boolean hit = false;
        for (EntityLivingBase entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.field_70161_v - this.entity.field_70161_v, entityHit.field_70165_t - this.entity.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.entity.field_70761_aq % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.field_70161_v - this.entity.field_70161_v) * (entityHit.field_70161_v - this.entity.field_70161_v) + (entityHit.field_70165_t - this.entity.field_70165_t) * (entityHit.field_70165_t - this.entity.field_70165_t)) - entityHit.field_70130_N / 2.0f;
            if (!(entityHitDistance <= this.range && entityRelativeAngle <= this.arc / 2.0f && entityRelativeAngle >= -this.arc / 2.0f || entityRelativeAngle >= 360.0f - this.arc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.arc / 2.0f)) continue;
            this.entity.attackEntityAsMob((Entity)entityHit, this.damageMultiplier);
            entityHit.field_70159_w *= (double)this.knockback;
            entityHit.field_70179_y *= (double)this.knockback;
            hit = true;
        }
        if (hit && this.hitSound != null) {
            this.entity.func_184185_a(this.hitSound, 1.0f, 1.0f);
        }
        if (this.attackSound != null) {
            this.entity.func_184185_a(this.attackSound, 1.0f, 1.0f);
        }
    }
}

