/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particles.util;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particles.util.MowzieParticleBase;
import com.bobmowzie.mowziesmobs.client.particles.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particles.util.ParticleRibbon;

public class RibbonComponent
extends ParticleComponent {
    int length;
    MMParticle ribbon;
    double yaw;
    double pitch;
    double roll;
    double scale;
    double r;
    double g;
    double b;
    double a;
    boolean faceCamera;
    boolean emissive;
    ParticleComponent[] components;

    public RibbonComponent(MMParticle particle, int length, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, boolean faceCamera, boolean emissive, ParticleComponent[] components) {
        this.length = length;
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.scale = scale;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.emissive = emissive;
        this.faceCamera = faceCamera;
        this.components = components;
        if (particle.getFactory() instanceof ParticleRibbon.ParticleRibbonFactory) {
            this.ribbon = particle;
        } else {
            System.out.println("Specified non-ribbon particle for ribbon component");
            this.ribbon = null;
        }
    }

    @Override
    public void init(MowzieParticleBase particle) {
        super.init(particle);
        if (particle != null) {
            ParticleComponent[] newComponents = new ParticleComponent[this.components.length + 1];
            for (int i = 0; i < this.components.length; ++i) {
                newComponents[i] = this.components[i];
            }
            newComponents[this.components.length] = new AttachToParticle(particle);
            ParticleRibbon.spawnRibbon(particle.getWorld(), this.ribbon, this.length, particle.getPosX(), particle.getPosY(), particle.getPosZ(), 0.0, 0.0, 0.0, this.faceCamera, this.yaw, this.pitch, this.roll, this.scale, this.r, this.g, this.b, this.a, 0.0, particle.getMaxAge() + (float)this.length, this.emissive, newComponents);
        }
    }

    public static class PropertyOverLength
    extends ParticleComponent {
        private ParticleComponent.AnimData animData;
        private EnumRibbonProperty property;

        public PropertyOverLength(EnumRibbonProperty property, ParticleComponent.AnimData animData) {
            this.animData = animData;
            this.property = property;
        }

        public float evaluate(float t) {
            return this.animData.evaluate(t);
        }

        public EnumRibbonProperty getProperty() {
            return this.property;
        }

        public static enum EnumRibbonProperty {
            RED,
            GREEN,
            BLUE,
            ALPHA,
            SCALE;

        }
    }

    private static class AttachToParticle
    extends ParticleComponent {
        MowzieParticleBase attachedParticle;

        public AttachToParticle(MowzieParticleBase attachedParticle) {
            this.attachedParticle = attachedParticle;
        }

        @Override
        public void init(MowzieParticleBase particle) {
            super.init(particle);
            this.attachedParticle.ribbon = (ParticleRibbon)particle;
        }
    }
}

