/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.village;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.village.SnowVillagePieces;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class MapGenSnowVillage
extends WorldGenerator {
    public static List<Biome> VILLAGE_SPAWN_BIOMES = Arrays.asList(Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_185445_W, IafWorldRegistry.GLACIER_BIOME, Biomes.field_150579_T, Biomes.field_76776_l, Biomes.field_150584_S);
    private final int minTownSeparation;
    private int size;
    private int distance = 9;

    public MapGenSnowVillage() {
        this.minTownSeparation = 8;
    }

    public MapGenSnowVillage(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().equals("size")) {
                this.size = MathHelper.func_82714_a((String)entry.getValue(), (int)this.size, (int)0);
                continue;
            }
            if (!entry.getKey().equals("distance")) continue;
            this.distance = MathHelper.func_82714_a((String)entry.getValue(), (int)this.distance, (int)9);
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        this.distance = 9;
        boolean canSpawn = this.canSpawnStructureAtCoords(world, position.func_177958_n() >> 4, position.func_177952_p() >> 4);
        if (new Random().nextInt(IceAndFire.CONFIG.generateSnowVillageChance + 1) == 0) {
            int new_size = 32;
            this.getStructureStart(world, position.func_177958_n() >> 4, position.func_177952_p() >> 4, rand).func_75068_a(world, rand, new StructureBoundingBox(position.func_177958_n() - new_size, position.func_177952_p() - new_size, position.func_177958_n() + new_size, position.func_177952_p() + new_size));
        }
        return canSpawn;
    }

    public String getStructureName() {
        return "SnowVillage";
    }

    protected boolean canSpawnStructureAtCoords(World world, int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int k = chunkX / this.distance;
        int l = chunkZ / this.distance;
        Random random = world.func_72843_D(k, l, 10387312);
        k *= this.distance;
        l *= this.distance;
        k += random.nextInt(this.distance - 8);
        l += random.nextInt(this.distance - 8);
        return true;
    }

    protected StructureStart getStructureStart(World world, int chunkX, int chunkZ, Random random) {
        return new Start(world, random, chunkX, chunkZ, this.size);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World worldIn, Random rand, int x, int z, int size) {
            super(x, z);
            List<SnowVillagePieces.PieceWeight> list = SnowVillagePieces.getStructureVillageWeightedPieceList(rand, size);
            SnowVillagePieces.Start structurevillagepieces$start = new SnowVillagePieces.Start(worldIn.func_72959_q(), 0, rand, (x << 4) + 2, (z << 4) + 2, list, size);
            this.field_75075_a.add(structurevillagepieces$start);
            structurevillagepieces$start.func_74861_a(structurevillagepieces$start, this.field_75075_a, rand);
            List<StructureComponent> list1 = structurevillagepieces$start.pendingRoads;
            List<StructureComponent> list2 = structurevillagepieces$start.pendingHouses;
            while (!list1.isEmpty() || !list2.isEmpty()) {
                if (list1.isEmpty()) {
                    int i = rand.nextInt(list2.size());
                    StructureComponent structurecomponent = list2.remove(i);
                    structurecomponent.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
                    continue;
                }
                int j = rand.nextInt(list1.size());
                StructureComponent structurecomponent2 = list1.remove(j);
                structurecomponent2.func_74861_a((StructureComponent)structurevillagepieces$start, this.field_75075_a, rand);
            }
            this.func_75072_c();
            int k = 0;
            for (StructureComponent structurecomponent1 : this.field_75075_a) {
                if (structurecomponent1 instanceof StructureVillagePieces.Road) continue;
                ++k;
            }
            this.hasMoreThanTwoComponents = k > 2;
        }

        public boolean func_75069_d() {
            return this.hasMoreThanTwoComponents;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.hasMoreThanTwoComponents);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.hasMoreThanTwoComponents = tagCompound.func_74767_n("Valid");
        }
    }
}

