/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.block.BlockReturningState;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenDreadRuin;
import com.github.alexthe666.iceandfire.world.gen.WorldGenDreadSpike;
import com.github.alexthe666.iceandfire.world.gen.WorldGenDreadwoodTree;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeDreadLands
extends Biome {
    protected static final IBlockState STONE = IafBlockRegistry.frozenStone.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(false));
    protected static final IBlockState ICE = IafBlockRegistry.dragon_ice.func_176223_P();
    protected static final IBlockState DIRT = IafBlockRegistry.frozenDirt.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(false));
    protected static final IBlockState GRASS = IafBlockRegistry.frozenGrass.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(false));
    protected static final IBlockState GRAVEL = IafBlockRegistry.frozenGravel.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(false));
    protected static final IBlockState DRAGON_ICE = IafBlockRegistry.dragon_ice.func_176223_P();
    private static final WorldGenDreadwoodTree DREADWOOD_TREE = new WorldGenDreadwoodTree();
    private static final WorldGenDreadSpike DREAD_SPIKE = new WorldGenDreadSpike();
    private static final WorldGenDreadRuin DREAD_RUIN = new WorldGenDreadRuin();

    public BiomeDreadLands() {
        super(new Biome.BiomeProperties("dreadlands").func_185410_a(-1.0f).func_185398_c(1.125f).func_185400_d(0.025f).func_185410_a(0.0f).func_185395_b(3.5f).func_185411_b());
        this.field_76752_A = IafBlockRegistry.frozenGrass.func_176223_P();
        this.field_76753_B = IafBlockRegistry.frozenDirt.func_176223_P();
        this.setRegistryName("iceandfire", "Dreadlands");
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I.field_76832_z = 1;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int l;
        int k6;
        float k1 = this.field_76760_I.field_76832_z;
        if (rand.nextFloat() < this.field_76760_I.field_189870_A) {
            k1 += 1.0f;
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE) && rand.nextFloat() < 0.1f) {
            int j2 = 0;
            while ((float)j2 < k1) {
                int k62 = rand.nextInt(16) + 8;
                int l2 = rand.nextInt(16) + 8;
                BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k62, 0, l2));
                DREADWOOD_TREE.func_180709_b(worldIn, rand, blockpos);
                ++j2;
            }
        }
        if (rand.nextFloat() < 0.2f) {
            k6 = rand.nextInt(16) + 8;
            l = rand.nextInt(16) + 8;
            BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, -1, l));
            DREAD_SPIKE.func_180709_b(worldIn, rand, blockpos);
        }
        if (rand.nextFloat() < 0.05f) {
            k6 = rand.nextInt(16) + 8;
            l = rand.nextInt(16) + 8;
            BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, -1, l));
            DREAD_RUIN.func_180709_b(worldIn, rand, blockpos);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateGlacierBiome(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public final void generateGlacierBiome(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = this.field_76752_A;
        IBlockState iblockstate1 = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(i1, j1, l, field_185367_c);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != IafBlockRegistry.frozenStone) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate1 = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.field_76752_A;
                    iblockstate1 = this.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = this.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : field_185372_h;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = field_185366_b;
                    iblockstate1 = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != IafBlockRegistry.frozenDirt || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = STONE;
        }
    }
}

