/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.util;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.ISyncMount;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class IceAndFireCoreUtils {
    public static double getMoveThreshold(NetHandlerPlayServer e) {
        return IceAndFire.CONFIG.dragonMovedWronglyFix && e.field_147369_b.func_184208_bv() instanceof ISyncMount ? 1.5 : 0.0625;
    }

    public static double getFastestEntityMotionSpeed(NetHandlerPlayServer e) {
        return IceAndFire.CONFIG.dragonMovedWronglyFix && e.field_147369_b.func_184208_bv() instanceof ISyncMount ? 1000.0 : 100.0;
    }

    public static boolean is(ItemStack stack, String name) {
        if (Item.func_111206_d((String)name) == stack.func_77973_b()) {
            return true;
        }
        int oreId = OreDictionary.getOreID((String)name);
        for (int checkAgainst : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (oreId != checkAgainst) continue;
            return true;
        }
        return false;
    }

    public static Set<Item> all(String name) {
        HashSet<Item> itemSet = new HashSet<Item>();
        Item itemOrNull = Item.func_111206_d((String)name);
        if (itemOrNull != null) {
            itemSet.add(itemOrNull);
        }
        itemSet.addAll(OreDictionary.getOres((String)name).stream().map(ItemStack::func_77973_b).collect(Collectors.toSet()));
        return itemSet;
    }

    public static boolean entityNameArrayContains(String[] names, Entity entity) {
        return Arrays.stream(names).map(ResourceLocation::new).filter(resourceLocation -> {
            if (ForgeRegistries.ENTITIES.getValue(resourceLocation) == null) {
                IceAndFire.logger.warn("Couldn't find entity type " + resourceLocation.toString() + ", ignoring");
                return false;
            }
            return true;
        }).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getValue(arg_0)).map(EntityEntry::getEntityClass).anyMatch(cls -> cls.isInstance(entity));
    }

    public static boolean blackOrWhitelistCheck(String[] configList, boolean isWhitelist, ResourceLocation resourceLocation) {
        if (isWhitelist) {
            for (String string : configList) {
                if (!new ResourceLocation(string).equals((Object)resourceLocation)) continue;
                return true;
            }
            return false;
        }
        for (String string : configList) {
            if (!new ResourceLocation(string).equals((Object)resourceLocation)) continue;
            return false;
        }
        return true;
    }
}

