/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item.block;

import com.github.alexthe666.iceandfire.block.BlockVenerableStump;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockVenerableStump
extends ItemBlock {
    public ItemBlockVenerableStump(Block block) {
        super(block);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        IBlockState originState = world.func_180495_p(pos);
        if (!originState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        ItemStack heldStack = player.func_184586_b(hand);
        for (BlockVenerableStump.StumpPart part : BlockVenerableStump.StumpPart.values()) {
            BlockPos partPos = pos.func_177971_a(part.getFromCenter());
            if (player.func_175151_a(partPos, facing, heldStack) && this.field_150939_a.func_176196_c(world, partPos)) continue;
            return EnumActionResult.FAIL;
        }
        ItemBlockVenerableStump.placeStump(world, pos, this.field_150939_a);
        SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        heldStack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public static void placeStump(World world, BlockPos pos, Block block) {
        for (BlockVenerableStump.StumpPart part : BlockVenerableStump.StumpPart.values()) {
            BlockPos partPos = pos.func_177971_a(part.getFromCenter());
            IBlockState blockState = block.func_176223_P().func_177226_a(BlockVenerableStump.PART, (Comparable)((Object)part));
            world.func_180501_a(partPos, blockState, 2);
            world.func_175685_c(partPos, block, true);
        }
    }

    public int getItemBurnTime(ItemStack stack) {
        return 2700;
    }
}

