/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityTideTrident;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTideTrident
extends Item {
    public ItemTideTrident() {
        this.func_77637_a(IceAndFire.TAB_ITEMS);
        this.func_77655_b("iceandfire.tide_trident");
        this.setRegistryName("iceandfire", "tide_trident");
        this.field_77777_bU = 1;
        this.func_77656_e(400);
    }

    public static float getArrowVelocity(int i) {
        float f = (float)i / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entity, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        if (i < 0) {
            return;
        }
        float f = ItemTideTrident.getArrowVelocity(i) * 3.0f;
        entity.func_184185_a(SoundEvents.field_187511_aA, 1.0f, 1.0f);
        EntityTideTrident feather = new EntityTideTrident(worldIn, entity, stack);
        feather.shoot((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_72838_d((Entity)feather);
        }
        if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151045_i && toRepair.func_77952_i() != 0;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 12.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.9f, 0));
        }
        return multimap;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185304_p || enchantment == Enchantments.field_180313_o || enchantment == Enchantments.field_190940_C) {
            return true;
        }
        return enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE;
    }

    public int func_77619_b() {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack itemStackIn = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.legendary_weapon.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.tide_trident.desc_0", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.tide_trident.desc_1", (Object[])new Object[0]));
    }
}

