/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.world.DragonPosWorldData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSummoningCrystal
extends Item {
    private ForgeChunkManager.Ticket lastChunkTicket = null;

    public ItemSummoningCrystal(String variant) {
        this.func_77655_b("iceandfire.summoning_crystal_" + variant);
        this.setRegistryName("iceandfire", "summoning_crystal_" + variant);
        this.func_77637_a(IceAndFire.TAB_ITEMS);
        this.func_185043_a(new ResourceLocation("has_dragon"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemSummoningCrystal.hasDragon(stack) ? 1.0f : 0.0f;
            }
        });
        this.func_77625_d(1);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.func_77982_d(new NBTTagCompound());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int f, boolean f1) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public ItemStack onItemUseFinish(World worldIn, EntityLivingBase entityLiving) {
        return new ItemStack((Item)this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean ice;
        boolean flag = false;
        boolean bl = ice = stack.func_77973_b() == IafItemRegistry.summoning_crystal_ice;
        if (stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                if (!tagInfo.contains("Dragon")) continue;
                NBTTagCompound draginTag = stack.func_77978_p().func_74775_l(tagInfo);
                String dragonName = I18n.func_135052_a((String)(ice ? "entity.icedragon.name" : "entity.firedragon.name"), (Object[])new Object[0]);
                if (!draginTag.func_74779_i("CustomName").isEmpty()) {
                    dragonName = draginTag.func_74779_i("CustomName");
                }
                tooltip.add(I18n.func_135052_a((String)"item.iceandfire.summoning_crystal.bound", (Object[])new Object[]{dragonName}));
                flag = true;
            }
        }
        if (!flag) {
            tooltip.add(I18n.func_135052_a((String)"item.iceandfire.summoning_crystal.desc_0", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"item.iceandfire.summoning_crystal.desc_1", (Object[])new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        boolean flag = false;
        BlockPos offsetPos = pos.func_177972_a(facing);
        float yaw = player.field_70177_z;
        boolean displayError = false;
        if (stack.func_77973_b() == this && ItemSummoningCrystal.hasDragon(stack)) {
            if (stack.func_77978_p() != null) {
                for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                    NBTTagCompound dragonTag;
                    UUID id;
                    if (!tagInfo.contains("Dragon") || (id = (dragonTag = stack.func_77978_p().func_74775_l(tagInfo)).func_186857_a("DragonUUID")) == null || worldIn.field_72995_K) continue;
                    try {
                        Entity entity = worldIn.func_73046_m().func_175576_a(id);
                        if (entity != null) {
                            flag = true;
                            this.summonEntity(entity, worldIn, offsetPos, yaw);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        displayError = true;
                    }
                    ForgeChunkManager.Ticket ticket = null;
                    DragonPosWorldData data = DragonPosWorldData.get(worldIn);
                    BlockPos dragonChunkPos = null;
                    if (data != null) {
                        dragonChunkPos = data.getDragonPos(id);
                    }
                    if (!IceAndFire.CONFIG.chunkLoadSummonCrystal) continue;
                    try {
                        boolean flag2 = false;
                        if (!flag && data != null && (ticket = ForgeChunkManager.requestPlayerTicket((Object)IceAndFire.INSTANCE, (String)player.func_70005_c_(), (World)worldIn, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
                            if (dragonChunkPos != null) {
                                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(dragonChunkPos));
                            } else {
                                displayError = true;
                            }
                            this.lastChunkTicket = ticket;
                            flag2 = true;
                        }
                        if (flag2) {
                            try {
                                Entity entity = worldIn.func_73046_m().func_175576_a(id);
                                if (entity != null) {
                                    flag = true;
                                    this.summonEntity(entity, worldIn, offsetPos, yaw);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!flag || this.lastChunkTicket == null || dragonChunkPos == null) continue;
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.lastChunkTicket);
                        this.lastChunkTicket = null;
                    }
                    catch (Exception e) {
                        IceAndFire.logger.warn("Could not load chunk when summoning dragon");
                        e.printStackTrace();
                    }
                }
            }
            if (flag) {
                player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                player.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
                player.func_184609_a(hand);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.iceandfire.dragonTeleport", new Object[0]), true);
                stack.func_77982_d(new NBTTagCompound());
            } else if (displayError) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.iceandfire.noDragonTeleport", new Object[0]), true);
            }
        }
        return EnumActionResult.PASS;
    }

    public void summonEntity(Entity entity, World worldIn, BlockPos offsetPos, float yaw) {
        DragonPosWorldData data;
        entity.func_70012_b((double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o() + 0.5, (double)offsetPos.func_177952_p() + 0.5, yaw, 0.0f);
        if (entity instanceof EntityDragonBase) {
            ((EntityDragonBase)entity).setCrystalBound(false);
        }
        if (IceAndFire.CONFIG.chunkLoadSummonCrystal && (data = DragonPosWorldData.get(worldIn)) != null) {
            data.removeDragon(entity.func_110124_au());
        }
    }

    public static boolean hasDragon(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemSummoningCrystal && stack.func_77978_p() != null) {
            for (String tagInfo : stack.func_77978_p().func_150296_c()) {
                if (!tagInfo.contains("Dragon")) continue;
                return true;
            }
        }
        return false;
    }
}

