/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.StatCollector;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDragonHorn
extends Item {
    public ItemDragonHorn() {
        this.field_77777_bU = 1;
        this.func_77637_a(IceAndFire.TAB_ITEMS);
        this.func_77655_b("iceandfire.dragon_horn");
        this.setRegistryName("iceandfire", "dragon_horn");
        this.func_185043_a(new ResourceLocation("iceorfire"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return (float)ItemDragonHorn.getDragonType(stack) * 0.25f;
            }
        });
    }

    public static int getDragonType(ItemStack stack) {
        Class clazz;
        NBTTagCompound entity;
        if (stack.func_77978_p() != null && !(entity = stack.func_77978_p().func_74775_l("EntityTag")).func_82582_d() && (clazz = EntityList.func_192839_a((String)entity.func_74779_i("id"))) != null) {
            return clazz == EntityFireDragon.class ? 1 : 2;
        }
        return 0;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound nbtPrev = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
        NBTTagCompound nbt = nbtPrev.func_74775_l("EntityTag");
        if (!nbt.func_82582_d()) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldIn);
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, player.func_70079_am(), 0.0f);
            stack.func_77982_d(new NBTTagCompound());
            worldIn.func_184133_a(player, pos, SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 3.0f, 0.75f);
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d(entity);
            }
            player.func_184609_a(hand);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        ItemStack trueStack = playerIn.func_184586_b(hand);
        if (target instanceof EntityDragonBase && ((EntityDragonBase)target).func_152114_e((EntityLivingBase)playerIn) && (trueStack.func_77978_p() == null || trueStack.func_77978_p() != null && trueStack.func_77978_p().func_74775_l("EntityTag").func_82582_d())) {
            NBTTagCompound entityTag = new NBTTagCompound();
            entityTag.func_74778_a("id", EntityList.func_191301_a((Entity)target).toString());
            target.func_70014_b(entityTag);
            NBTTagCompound newTag = new NBTTagCompound();
            newTag.func_74782_a("EntityTag", (NBTBase)entityTag);
            trueStack.func_77982_d(newTag);
            playerIn.func_184609_a(hand);
            playerIn.field_70170_p.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 3.0f, 0.75f);
            target.func_70106_y();
            playerIn.field_70170_p.func_72900_e((Entity)target);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound entityTag;
        if (stack.func_77978_p() != null && !(entityTag = stack.func_77978_p().func_74775_l("EntityTag")).func_82582_d()) {
            String name;
            Class clazz = EntityList.func_192839_a((String)entityTag.func_74779_i("id"));
            EntityEntry entry = EntityRegistry.getEntry((Class)clazz);
            if (entry != null) {
                name = I18n.func_135052_a((String)("entity." + entry.getName() + ".name"), (Object[])new Object[0]);
                tooltip.add(name);
            }
            name = entityTag.func_74779_i("CustomName").isEmpty() ? StatCollector.translateToLocal("dragon.unnamed") : StatCollector.translateToLocal("dragon.name") + entityTag.func_74779_i("CustomName");
            tooltip.add("" + name);
            String gender = StatCollector.translateToLocal("dragon.gender") + StatCollector.translateToLocal(entityTag.func_74767_n("Gender") ? "dragon.gender.male" : "dragon.gender.female");
            tooltip.add("" + gender);
            int stagenumber = entityTag.func_74762_e("AgeTicks") / 24000;
            int stage1 = 0;
            stage1 = stagenumber >= 100 ? 5 : (stagenumber >= 75 ? 4 : (stagenumber >= 50 ? 3 : (stagenumber >= 25 ? 2 : 1)));
            String stage = StatCollector.translateToLocal("dragon.stage") + stage1 + " " + StatCollector.translateToLocal("dragon.days.front") + stagenumber + " " + StatCollector.translateToLocal("dragon.days.back");
            tooltip.add("" + stage);
        }
    }
}

