/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.StatCollector;
import com.github.alexthe666.iceandfire.entity.ChainEntityProperties;
import com.github.alexthe666.iceandfire.entity.EntityChainTie;
import com.github.alexthe666.iceandfire.util.IsImmune;
import java.util.List;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemChain
extends Item {
    private boolean sticky;

    public ItemChain(boolean sticky) {
        this.sticky = sticky;
        this.func_77637_a(IceAndFire.TAB_ITEMS);
        this.func_77655_b(sticky ? "iceandfire.chain" : "iceandfire.chain_sticky");
        this.setRegistryName("iceandfire", sticky ? "chain" : "chain_sticky");
    }

    public static boolean attachToFence(EntityPlayer player, World worldIn, BlockPos fence) {
        EntityChainTie entityleashknot = EntityChainTie.getKnotForPosition(worldIn, fence);
        boolean flag = false;
        double d0 = 30.0;
        int i = fence.func_177958_n();
        int j = fence.func_177956_o();
        int k = fence.func_177952_p();
        for (EntityLiving entityliving : worldIn.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0))) {
            ChainEntityProperties chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityliving, ChainEntityProperties.class);
            if (chainProperties == null || !chainProperties.isChained() || !chainProperties.isConnectedToEntity((Entity)entityliving, (Entity)player)) continue;
            if (entityleashknot == null) {
                entityleashknot = EntityChainTie.createKnot(worldIn, fence);
            }
            chainProperties.addChain((Entity)entityliving, (Entity)entityleashknot);
            chainProperties.removeChain((Entity)entityliving, (Entity)player);
            flag = true;
        }
        return flag;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(StatCollector.translateToLocal("item.iceandfire.chain.desc_0"));
        tooltip.add(StatCollector.translateToLocal("item.iceandfire.chain.desc_1"));
        if (!this.sticky) {
            tooltip.add(TextFormatting.GREEN + StatCollector.translateToLocal("item.iceandfire.chain_sticky.desc_2"));
            tooltip.add(TextFormatting.GREEN + StatCollector.translateToLocal("item.iceandfire.chain_sticky.desc_3"));
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (IsImmune.toChains((Entity)target)) {
            return false;
        }
        ChainEntityProperties chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)target, ChainEntityProperties.class);
        if (chainProperties != null) {
            if (chainProperties.isConnectedToEntity((Entity)target, (Entity)playerIn) || chainProperties.wasJustDisconnected) {
                chainProperties.wasJustDisconnected = false;
                return true;
            }
            if (!this.sticky) {
                double d0 = 60.0;
                double i = playerIn.field_70165_t;
                double j = playerIn.field_70163_u;
                double k = playerIn.field_70161_v;
                boolean flag = false;
                for (EntityLiving entityliving : playerIn.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(i - d0, j - d0, k - d0, i + d0, j + d0, k + d0))) {
                    ChainEntityProperties otherChainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityliving, ChainEntityProperties.class);
                    if (otherChainProperties == null || !otherChainProperties.isChained() || !otherChainProperties.isConnectedToEntity((Entity)entityliving, (Entity)playerIn)) continue;
                    chainProperties.addChain((Entity)target, (Entity)entityliving);
                    chainProperties.removeChain((Entity)target, (Entity)playerIn);
                    otherChainProperties.removeChain((Entity)target, (Entity)playerIn);
                    flag = true;
                }
                if (!flag) {
                    chainProperties.addChain((Entity)target, (Entity)playerIn);
                }
            } else {
                chainProperties.addChain((Entity)target, (Entity)playerIn);
            }
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            chainProperties.updateConnectedEntities((Entity)target);
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (!(block instanceof BlockWall)) {
            return EnumActionResult.PASS;
        }
        if (!worldIn.field_72995_K) {
            ItemChain.attachToFence(player, worldIn, pos);
        }
        return EnumActionResult.SUCCESS;
    }
}

