/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.util.IceAndFireCoreUtils;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenGorgonTemple;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMausoleum;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenSirenIsland;
import com.github.alexthe666.iceandfire.world.village.MapGenPixieVillage;
import com.github.alexthe666.iceandfire.world.village.MapGenSnowVillage;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenEvents
implements IWorldGenerator {
    public static final MapGenSnowVillage SNOW_VILLAGE = new MapGenSnowVillage();
    public static final MapGenPixieVillage PIXIE_VILLAGE = new MapGenPixieVillage();
    public static final WorldGenMyrmexHive JUNGLE_MYRMEX_HIVE = new WorldGenMyrmexHive(false, true);
    public static final WorldGenMyrmexHive DESERT_MYRMEX_HIVE = new WorldGenMyrmexHive(false, false);
    private static final WorldGenFireDragonCave FIRE_DRAGON_CAVE = new WorldGenFireDragonCave();
    private static final WorldGenFireDragonRoosts FIRE_DRAGON_ROOST = new WorldGenFireDragonRoosts();
    private static final WorldGenIceDragonCave ICE_DRAGON_CAVE = new WorldGenIceDragonCave();
    private static final WorldGenIceDragonRoosts ICE_DRAGON_ROOST = new WorldGenIceDragonRoosts();
    private static final WorldGenCyclopsCave CYCLOPS_CAVE = new WorldGenCyclopsCave();
    private static final WorldGenSirenIsland SIREN_ISLAND = new WorldGenSirenIsland();
    private static final WorldGenHydraCave HYDRA_CAVE = new WorldGenHydraCave();
    private BlockPos lastSnowVillage = null;
    private BlockPos lastPixieVillage = null;
    private BlockPos lastMyrmexHive = null;
    private BlockPos lastDragonRoost = null;
    private BlockPos lastDragonCave = null;
    private BlockPos lastCyclopsCave = null;
    private BlockPos lastSirenIsland = null;
    private BlockPos lastGorgonTemple = null;
    private BlockPos lastMausoleum = null;
    private BlockPos lastHydraCave = null;

    public static BlockPos getHeight(World world, BlockPos pos) {
        return world.func_175645_m(pos);
    }

    private static boolean canHeightSkipBlock(BlockPos pos, World world) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockLog || state.func_177230_c() instanceof BlockLiquid;
    }

    public static BlockPos degradeSurface(World world, BlockPos surface) {
        while ((!world.func_180495_p(surface).func_185914_p() || WorldGenEvents.canHeightSkipBlock(surface, world)) && surface.func_177956_o() > 1) {
            surface = surface.func_177977_b();
        }
        return surface;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos pos;
        boolean canSpawnInBiome;
        if (world.func_175624_G() == WorldType.field_77138_c && !IceAndFire.CONFIG.spawnStructuresOnSuperflat) {
            return;
        }
        boolean prevLogCascadingWorldGen = ForgeModContainer.logCascadingWorldGeneration;
        double spawnCheck = IceAndFire.CONFIG.worldGenDistance * IceAndFire.CONFIG.worldGenDistance;
        if (!IceAndFire.CONFIG.logCascadingWorldGen) {
            ForgeModContainer.logCascadingWorldGeneration = false;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        BlockPos height = WorldGenEvents.getHeight(world, new BlockPos(x, 0, z));
        if (IceAndFire.CONFIG.spawnGorgons && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && (this.lastGorgonTemple == null || this.lastGorgonTemple.func_177951_i((Vec3i)height) >= spawnCheck) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) && random.nextInt(IceAndFire.CONFIG.spawnGorgonsChance + 1) == 0) {
            BlockPos surface = world.func_175645_m(new BlockPos(x, 0, z));
            surface = WorldGenEvents.degradeSurface(world, surface);
            new WorldGenGorgonTemple(EnumFacing.func_176731_b((int)random.nextInt(3))).func_180709_b(world, random, surface);
            this.lastGorgonTemple = surface;
        }
        if (IceAndFire.CONFIG.generateSirenIslands && this.isFarEnoughFromSpawn(world, height) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && !BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && random.nextInt(IceAndFire.CONFIG.generateSirenChance + 1) == 0 && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && (this.lastSirenIsland == null || this.lastSirenIsland.func_177951_i((Vec3i)height) >= spawnCheck)) {
            SIREN_ISLAND.func_180709_b(world, random, height);
            this.lastSirenIsland = height;
        }
        if (IceAndFire.CONFIG.generateCyclopsCaves && this.isFarEnoughFromSpawn(world, height) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) && random.nextInt(IceAndFire.CONFIG.spawnCyclopsCaveChance + 1) == 0 && world.func_180495_p(height.func_177977_b()).func_185914_p() && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && (this.lastCyclopsCave == null || this.lastCyclopsCave.func_177951_i((Vec3i)height) >= spawnCheck)) {
            CYCLOPS_CAVE.func_180709_b(world, random, height);
            this.lastCyclopsCave = height;
        }
        if (IceAndFire.CONFIG.generateWanderingCyclops && this.isFarEnoughFromSpawn(world, height) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) && (this.lastCyclopsCave == null || this.lastCyclopsCave.func_177951_i((Vec3i)height) >= spawnCheck) && random.nextInt(IceAndFire.CONFIG.spawnWanderingCyclopsChance + 1) == 0) {
            EntityCyclops cyclops = new EntityCyclops(world);
            cyclops.func_70107_b(x, height.func_177956_o() + 1, z);
            cyclops.setVariant(random.nextInt(3));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)cyclops);
            }
            for (int i = 0; i < 3 + random.nextInt(3); ++i) {
                EntitySheep sheep = new EntitySheep(world);
                sheep.func_70107_b((double)x, (double)(height.func_177956_o() + 1), (double)z);
                sheep.func_175512_b(EntitySheep.func_175510_a((Random)random));
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)sheep);
            }
            this.lastCyclopsCave = height;
        }
        if (IceAndFire.CONFIG.spawnPixies && this.isFarEnoughFromSpawn(world, height) && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && (this.lastPixieVillage == null || this.lastPixieVillage.func_177951_i((Vec3i)height) >= spawnCheck) && (canSpawnInBiome = IceAndFireCoreUtils.blackOrWhitelistCheck(IceAndFire.CONFIG.pixieVillageBiomeBlacklist, IceAndFire.CONFIG.pixieVillageBiomeBlacklistIsWhitelist, Objects.requireNonNull(world.func_180494_b(height).getRegistryName(), "Attempted to spawn pixie village in unregistered biome"))) && random.nextInt(IceAndFire.CONFIG.spawnPixiesChance + 1) == 0) {
            PIXIE_VILLAGE.func_180709_b(world, random, height);
            this.lastPixieVillage = height;
        }
        if (IceAndFire.CONFIG.generateDragonRoosts && this.isFarEnoughFromSpawn(world, height) && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), true) && (this.lastDragonRoost == null || this.lastDragonRoost.func_177951_i((Vec3i)height) >= spawnCheck)) {
            boolean isHills;
            boolean bl = isHills = BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && !BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY);
            if (!(world.func_180494_b(height).func_76746_c() || !((double)world.func_180494_b(height).func_185353_n() > 0.0) || world.func_180494_b(height) == Biomes.field_76774_n || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.WET) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonRoostChance : IceAndFire.CONFIG.generateDragonRoostChance * 2) + 1) != 0)) {
                BlockPos surface = world.func_175645_m(new BlockPos(x, 0, z));
                surface = WorldGenEvents.degradeSurface(world, surface);
                FIRE_DRAGON_ROOST.func_180709_b(world, random, surface);
                this.lastDragonRoost = surface;
            }
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonRoostChance : IceAndFire.CONFIG.generateDragonRoostChance * 2) + 1) == 0) {
                BlockPos surface = world.func_175645_m(new BlockPos(x, 0, z));
                surface = WorldGenEvents.degradeSurface(world, surface);
                ICE_DRAGON_ROOST.func_180709_b(world, random, surface);
                this.lastDragonRoost = surface;
            }
        }
        if (IceAndFire.CONFIG.generateDragonSkeletons && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), true)) {
            int dragonage;
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && random.nextInt(IceAndFire.CONFIG.generateDragonSkeletonChance + 1) == 0) {
                EntityFireDragon firedragon = new EntityFireDragon(world);
                firedragon.func_70107_b(x, height.func_177956_o() + 1, z);
                dragonage = 10 + random.nextInt(100);
                firedragon.growDragon(dragonage);
                firedragon.modelDeadProgress = 20.0f;
                firedragon.setModelDead(true);
                firedragon.setDeathStage(dragonage / 5 / 2);
                firedragon.field_70177_z = random.nextInt(360);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)firedragon);
                }
            }
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && random.nextInt(IceAndFire.CONFIG.generateDragonSkeletonChance + 1) == 0) {
                EntityIceDragon icedragon = new EntityIceDragon(world);
                icedragon.func_70107_b(x, height.func_177956_o() + 1, z);
                dragonage = 10 + random.nextInt(100);
                icedragon.growDragon(dragonage);
                icedragon.modelDeadProgress = 20.0f;
                icedragon.setModelDead(true);
                icedragon.setDeathStage(dragonage / 5 / 2);
                icedragon.field_70177_z = random.nextInt(360);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)icedragon);
                }
            }
        }
        if (IceAndFire.CONFIG.spawnHippocampus && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextInt(IceAndFire.CONFIG.hippocampusSpawnChance + 1) == 0) {
            for (int i = 0; i < random.nextInt(5); ++i) {
                BlockPos pos2 = new BlockPos(x + random.nextInt(10) - 5, 20 + random.nextInt(40), z + random.nextInt(10) - 5);
                if (world.func_180495_p(pos2).func_185904_a() != Material.field_151586_h) continue;
                EntityHippocampus campus = new EntityHippocampus(world);
                campus.setVariant(random.nextInt(5));
                campus.func_70012_b((float)pos2.func_177958_n() + 0.5f, (float)pos2.func_177956_o() + 0.5f, (float)pos2.func_177952_p() + 0.5f, 0.0f, 0.0f);
                if (!campus.func_70058_J()) continue;
                world.func_72838_d((Entity)campus);
            }
        }
        if (IceAndFire.CONFIG.spawnSeaSerpents && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) && random.nextInt(IceAndFire.CONFIG.seaSerpentSpawnChance + 1) == 0 && world.func_180495_p(pos = new BlockPos(x + random.nextInt(10) - 5, 20 + random.nextInt(40), z + random.nextInt(10) - 5)).func_185904_a() == Material.field_151586_h) {
            EntitySeaSerpent serpent = new EntitySeaSerpent(world);
            serpent.onWorldSpawn(random);
            serpent.func_70012_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
            world.func_72838_d((Entity)serpent);
        }
        if (IceAndFire.CONFIG.spawnStymphalianBirds && this.isFarEnoughFromSpawn(world, height) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && random.nextInt(IceAndFire.CONFIG.stymphalianBirdSpawnChance + 1) == 0) {
            for (int i = 0; i < 4 + random.nextInt(4); ++i) {
                BlockPos pos3 = height.func_177982_a(random.nextInt(10) - 5, 0, random.nextInt(10) - 5);
                if (!world.func_180495_p(pos3.func_177977_b()).func_185914_p()) continue;
                EntityStymphalianBird bird = new EntityStymphalianBird(world);
                bird.func_70012_b((float)pos3.func_177958_n() + 0.5f, (float)pos3.func_177956_o() + 0.5f, (float)pos3.func_177952_p() + 0.5f, 0.0f, 0.0f);
                if (!bird.func_70058_J()) continue;
                world.func_72838_d((Entity)bird);
            }
        }
        if (IceAndFire.CONFIG.generateDragonDens && this.isFarEnoughFromSpawn(world, height) && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), true) && (this.lastDragonCave == null || this.lastDragonCave.func_177951_i((Vec3i)height) >= spawnCheck)) {
            int newY;
            BlockPos pos4;
            boolean isHills;
            boolean bl = isHills = BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
            if (!(world.func_180494_b(height).func_76746_c() || !((double)world.func_180494_b(height).func_185353_n() > 0.0) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.WET) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonDenChance : IceAndFire.CONFIG.generateDragonDenChance * 2) + 1) != 0 || world.func_175710_j(pos4 = new BlockPos(x, newY = 20 + random.nextInt(20), z)))) {
                FIRE_DRAGON_CAVE.func_180709_b(world, random, pos4);
                this.lastDragonCave = pos4;
            }
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && !BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) && random.nextInt((isHills ? IceAndFire.CONFIG.generateDragonDenChance : IceAndFire.CONFIG.generateDragonDenChance * 2) + 1) == 0) {
                newY = 20 + random.nextInt(20);
                pos4 = new BlockPos(x, newY, z);
                ICE_DRAGON_CAVE.func_180709_b(world, random, pos4);
                this.lastDragonCave = pos4;
            }
        }
        if (IceAndFire.CONFIG.generateSilverOre) {
            for (int silverAmount = 0; silverAmount < 2; ++silverAmount) {
                int oreHeight = random.nextInt(32);
                int xOre = chunkX * 16 + random.nextInt(16);
                int zOre = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(IafBlockRegistry.silverOre.func_176223_P(), 4 + random.nextInt(4)).func_180709_b(world, random, new BlockPos(xOre, oreHeight, zOre));
            }
        }
        if (IceAndFire.CONFIG.generateSapphireOre && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            int count = 3 + random.nextInt(6);
            for (int sapphireAmount = 0; sapphireAmount < count; ++sapphireAmount) {
                int zOre;
                int oreHeight = random.nextInt(28) + 4;
                int xOre = chunkX * 16 + random.nextInt(16);
                BlockPos pos5 = new BlockPos(xOre, oreHeight, zOre = chunkZ * 16 + random.nextInt(16));
                IBlockState state = world.func_180495_p(pos5);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos5, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b))) continue;
                world.func_175656_a(pos5, IafBlockRegistry.sapphireOre.func_176223_P());
            }
        }
        if (IceAndFire.CONFIG.generateSnowVillages && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && (this.lastSnowVillage == null || this.lastSnowVillage.func_177951_i((Vec3i)height) >= spawnCheck)) {
            SNOW_VILLAGE.func_180709_b(world, random, height);
            this.lastSnowVillage = height;
        }
        if (IceAndFire.CONFIG.generateMyrmexColonies && random.nextInt(IceAndFire.CONFIG.myrmexColonyGenChance) == 0 && this.isFarEnoughFromSpawn(world, height) && MyrmexWorldData.get(world).getNearestHive(height, 500) == null && (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && (this.lastMyrmexHive == null || this.lastMyrmexHive.func_177951_i((Vec3i)height) >= spawnCheck)) {
            BlockPos lowestHeight = new BlockPos(height.func_177958_n(), world.func_82734_g(height.func_177958_n(), height.func_177952_p()), height.func_177952_p());
            int down = Math.max(15, lowestHeight.func_177956_o() - 20 + random.nextInt(10));
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                JUNGLE_MYRMEX_HIVE.func_180709_b(world, random, new BlockPos(lowestHeight.func_177958_n(), down, lowestHeight.func_177952_p()));
            } else {
                DESERT_MYRMEX_HIVE.func_180709_b(world, random, new BlockPos(lowestHeight.func_177958_n(), down, lowestHeight.func_177952_p()));
            }
            this.lastMyrmexHive = height;
        }
        if (!this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false)) {
            BlockPos surface;
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && random.nextInt(15) == 0 && IafBlockRegistry.frost_lily.func_176196_c(world, surface = world.func_175645_m(new BlockPos(x, 0, z)))) {
                world.func_175656_a(surface, IafBlockRegistry.frost_lily.func_176223_P());
            }
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && random.nextInt(15) == 0 && IafBlockRegistry.fire_lily.func_176196_c(world, surface = world.func_175645_m(new BlockPos(x, 0, z)))) {
                world.func_175656_a(surface, IafBlockRegistry.fire_lily.func_176223_P());
            }
            if (BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && random.nextInt(15) == 0 && (surface = this.getNetherHeight(world, new BlockPos(x, 0, z))) != null) {
                world.func_175656_a(surface.func_177984_a(), IafBlockRegistry.fire_lily.func_176223_P());
            }
        }
        if (IceAndFire.CONFIG.generateMausoleums && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && (this.lastMausoleum == null || this.lastMausoleum.func_177951_i((Vec3i)height) >= spawnCheck) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.COLD) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && random.nextInt(IceAndFire.CONFIG.generateMausoleumChance + 1) == 0) {
            BlockPos surface = world.func_175645_m(new BlockPos(x, 0, z));
            surface = WorldGenEvents.degradeSurface(world, surface);
            new WorldGenMausoleum(EnumFacing.func_176731_b((int)random.nextInt(3))).func_180709_b(world, random, surface);
            this.lastMausoleum = surface;
        }
        if (IceAndFire.CONFIG.generateHydraCaves && this.isFarEnoughFromSpawn(world, height) && BiomeDictionary.hasType((Biome)world.func_180494_b(height), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && random.nextInt(IceAndFire.CONFIG.generateHydraChance + 1) == 0 && world.func_180495_p(height.func_177977_b()).func_185914_p() && !this.isDimensionBlacklisted(world.field_73011_w.getDimension(), false) && (this.lastHydraCave == null || this.lastHydraCave.func_177951_i((Vec3i)height) >= spawnCheck)) {
            HYDRA_CAVE.func_180709_b(world, random, height);
            this.lastHydraCave = height;
        }
        if (!IceAndFire.CONFIG.logCascadingWorldGen) {
            ForgeModContainer.logCascadingWorldGeneration = prevLogCascadingWorldGen;
        }
    }

    private boolean isDimensionBlacklisted(int id, boolean dragons) {
        if (id == IceAndFire.CONFIG.dreadlandsDimensionId) {
            return true;
        }
        boolean useBlackOrWhiteLists = IceAndFire.CONFIG.useDimensionBlackList;
        int[] blacklistedArray = dragons ? IceAndFire.CONFIG.dragonBlacklistedDimensions : IceAndFire.CONFIG.structureBlacklistedDimensions;
        int[] whitelistedArray = dragons ? IceAndFire.CONFIG.dragonWhitelistedDimensions : IceAndFire.CONFIG.structureWhitelistedDimensions;
        int[] array = useBlackOrWhiteLists ? blacklistedArray : whitelistedArray;
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        for (int dimension : array) {
            dimList.add(dimension);
        }
        if (dimList.contains(id)) {
            return useBlackOrWhiteLists;
        }
        return !useBlackOrWhiteLists;
    }

    private BlockPos getNetherHeight(World world, BlockPos pos) {
        for (int i = 0; i < 255; ++i) {
            BlockPos ground = pos.func_177981_b(i);
            if (world.func_180495_p(ground).func_177230_c() != Blocks.field_150424_aL || !world.func_175623_d(ground.func_177984_a())) continue;
            return ground;
        }
        return null;
    }

    private boolean isFarEnoughFromSpawn(World world, BlockPos pos) {
        BlockPos spawnRelative = new BlockPos(world.func_175694_M().func_177958_n(), pos.func_177956_o(), world.func_175694_M().func_177952_p());
        boolean spawnCheck = spawnRelative.func_177951_i((Vec3i)pos) > (double)(IceAndFire.CONFIG.dangerousWorldGenDistanceLimit * IceAndFire.CONFIG.dangerousWorldGenDistanceLimit);
        return spawnCheck;
    }
}

