/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.gui.IceAndFireMainMenu;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.client.render.entity.ICustomStoneLayer;
import com.github.alexthe666.iceandfire.client.render.entity.RenderCockatrice;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerChainedEntity;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerStoneEntity;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerStoneEntityCrack;
import com.github.alexthe666.iceandfire.entity.ChainEntityProperties;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.MiscEntityProperties;
import com.github.alexthe666.iceandfire.entity.SirenEntityProperties;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.util.IAFMath;
import java.util.Map;
import java.util.Random;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ClientEvents {
    private static final ResourceLocation SIREN_SHADER = new ResourceLocation("iceandfire:shaders/post/siren.json");
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("textures/blocks/frosted_ice_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("textures/blocks/frosted_ice_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("textures/blocks/frosted_ice_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("textures/blocks/frosted_ice_3.png");
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("iceandfire:textures/models/misc/chain_link.png");
    private final Random rand = new Random();

    public static void initializeStoneLayer() {
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().field_78729_o.entrySet()) {
            Render render = (Render)entry.getValue();
            if (!(render instanceof RenderLivingBase) || !EntityLiving.class.isAssignableFrom((Class)entry.getKey())) continue;
            ((RenderLivingBase)render).func_177094_a(new LayerStoneEntity((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render)));
            ((RenderLivingBase)render).func_177094_a((LayerRenderer)new LayerStoneEntityCrack((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render)));
            ((RenderLivingBase)render).func_177094_a((LayerRenderer)new LayerChainedEntity((Render<? extends Entity>)render));
        }
        RenderingRegistry registry = (RenderingRegistry)ObfuscationReflectionHelper.getPrivateValue(RenderingRegistry.class, null, (String)"INSTANCE");
        Map entityRenders = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderingRegistry.class, (Object)registry, (String)"entityRenderers");
        Map entityRendersOld = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderingRegistry.class, (Object)registry, (String)"entityRenderersOld");
        if (registry != null) {
            LayerStoneEntityCrack crackLayer;
            LayerRenderer<EntityLivingBase> stoneLayer;
            Render render;
            if (entityRenders != null) {
                for (Map.Entry entry : entityRenders.entrySet()) {
                    if (entry.getValue() == null) continue;
                    try {
                        render = ((IRenderFactory)entry.getValue()).createRenderFor(Minecraft.func_71410_x().func_175598_ae());
                        if (render == null || !(render instanceof RenderLivingBase) || !EntityLiving.class.isAssignableFrom((Class)entry.getKey())) continue;
                        stoneLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getStoneLayer((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render)) : new LayerRenderer<EntityLivingBase>((RenderLivingBase<EntityLivingBase>)((RenderLivingBase)render));
                        crackLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getCrackLayer((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render)) : new LayerStoneEntityCrack((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render));
                        ((RenderLivingBase)render).func_177094_a(stoneLayer);
                        ((RenderLivingBase)render).func_177094_a((LayerRenderer)crackLayer);
                        ((RenderLivingBase)render).func_177094_a((LayerRenderer)new LayerChainedEntity((Render<? extends Entity>)render));
                    }
                    catch (NullPointerException exp) {
                        IceAndFire.logger.warn("Ice and Fire: Could not apply stone render layer to " + ((Class)entry.getKey()).getSimpleName() + ", someone isn't registering their renderer properly... <.<");
                    }
                }
            }
            if (entityRendersOld != null) {
                for (Map.Entry entry : entityRendersOld.entrySet()) {
                    render = (Render)entry.getValue();
                    if (!(render instanceof RenderLivingBase) || !EntityLiving.class.isAssignableFrom((Class)entry.getKey())) continue;
                    stoneLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getStoneLayer((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render)) : new LayerRenderer<EntityLivingBase>((RenderLivingBase<EntityLivingBase>)((RenderLivingBase)render));
                    crackLayer = render instanceof ICustomStoneLayer ? ((ICustomStoneLayer)render).getCrackLayer((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render)) : new LayerStoneEntityCrack((RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)render));
                    ((RenderLivingBase)render).func_177094_a(stoneLayer);
                    ((RenderLivingBase)render).func_177094_a((LayerRenderer)crackLayer);
                    ((RenderLivingBase)render).func_177094_a((LayerRenderer)new LayerChainedEntity((Render<? extends Entity>)render));
                }
            }
        }
    }

    private static ResourceLocation getIceTexture(int ticksFrozen) {
        if (ticksFrozen < 100) {
            if (ticksFrozen < 50) {
                if (ticksFrozen < 20) {
                    return TEXTURE_3;
                }
                return TEXTURE_2;
            }
            return TEXTURE_1;
        }
        return TEXTURE_0;
    }

    public static void renderAABB(AxisAlignedBB boundingBox, double x, double y, double z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        double maxX = boundingBox.field_72336_d * 0.625;
        double minX = boundingBox.field_72340_a * 0.625;
        double maxY = boundingBox.field_72337_e * 0.625;
        double minY = boundingBox.field_72338_b * 0.625;
        double maxZ = boundingBox.field_72334_f * 0.625;
        double minZ = boundingBox.field_72339_c * 0.625;
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(minX - maxX, maxY - minY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(maxX - minX, maxY - minY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(maxX - minX, maxY - minY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(minX - maxX, maxY - minY).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(maxX - minX, maxZ - minZ).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(minX - maxX, maxZ - minZ).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(minX - maxX, minY - maxY).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(maxX - minX, minY - maxY).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(maxX - minX, maxZ - minZ).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(minX - maxX, maxZ - minZ).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(minX - maxX, minY - maxY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(minX - maxX, maxY - minY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(maxX - minX, maxY - minY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(maxX - minX, minY - maxY).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_187315_a(minX - maxX, minY - maxY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_187315_a(minX - maxX, maxY - minY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_187315_a(maxX - minX, maxY - minY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_187315_a(maxX - minX, minY - maxY).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityDragonBase) {
            int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
            EntityDragonBase dragon = (EntityDragonBase)player.func_184187_bx();
            float scale = dragon.getRenderSize() / 3.0f;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && currentView != 0) {
                if (currentView == 1) {
                    GL11.glTranslatef((float)(scale * 0.5f), (float)0.0f, (float)(-scale * 3.0f));
                } else if (currentView == 2) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-scale * 3.0f));
                } else if (currentView == 3) {
                    GL11.glTranslatef((float)(scale * 0.5f), (float)0.0f, (float)(-scale * 0.5f));
                }
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 && currentView != 0) {
                if (currentView == 1) {
                    GL11.glTranslatef((float)(-scale * 1.2f), (float)0.0f, (float)5.0f);
                } else if (currentView == 2) {
                    GL11.glTranslatef((float)(scale * 1.2f), (float)0.0f, (float)5.0f);
                } else if (currentView == 3) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(scale * 3.0f));
                }
            }
        }
    }

    protected double translateToBody(RenderLiving<?> renderer) {
        double roll = 0.0;
        roll += this.postRenderRoll(((IceAndFireTabulaModel)renderer.func_177087_b()).getCube("BodyUpper"), 0.0625f);
        return roll += this.postRenderRoll(((IceAndFireTabulaModel)renderer.func_177087_b()).getCube("Neck1"), 0.0625f);
    }

    public double postRenderRoll(AdvancedModelRenderer renderer, float scale) {
        return renderer.field_78808_h * 57.295776f;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K && IafKeybindRegistry.dragon_change_view.func_151468_f()) {
                int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
                currentView = currentView + 1 > 3 ? 0 : ++currentView;
                IceAndFire.PROXY.setDragon3rdPersonView(currentView);
            }
            SirenEntityProperties sirenProps = (SirenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), SirenEntityProperties.class);
            if (player.field_70170_p.field_72995_K && sirenProps != null) {
                EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
                EntitySiren siren = sirenProps.getSiren(event.getEntityLiving().field_70170_p);
                if (siren == null) {
                    sirenProps.isCharmed = false;
                }
                if (sirenProps.isCharmed) {
                    if (player.field_70170_p.field_72995_K && this.rand.nextInt(40) == 0) {
                        IceAndFire.PROXY.spawnParticle("siren_appearance", player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0);
                    }
                    if (IceAndFire.CONFIG.sirenShader && sirenProps.isCharmed && !renderer.func_147702_a()) {
                        renderer.func_175069_a(SIREN_SHADER);
                    }
                }
                if (IceAndFire.CONFIG.sirenShader && !sirenProps.isCharmed && renderer != null && renderer.func_147706_e() != null && renderer.func_147706_e().func_148022_b() != null && SIREN_SHADER.toString().equals(renderer.func_147706_e().func_148022_b())) {
                    renderer.func_181022_b();
                }
            }
        }
    }

    @SubscribeEvent
    public void onPreRenderLiving(RenderLivingEvent.Pre<?> event) {
        StoneEntityProperties properties;
        if (event.getEntity().func_184187_bx() != null && event.getEntity().func_184187_bx() instanceof EntityDragonBase && (ClientProxy.currentDragonRiders.contains(event.getEntity().func_110124_au()) || event.getEntity() == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0)) {
            event.setCanceled(true);
            MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(event.getEntity(), event.getRenderer(), event.getPartialRenderTick(), event.getX(), event.getY(), event.getZ()));
        }
        if (event.getEntity() instanceof EntityLiving && !event.getEntity().func_82150_aj() && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntity(), StoneEntityProperties.class)) != null && properties.isStone) {
            event.getEntity().func_82142_c(true);
        }
    }

    @SubscribeEvent
    public void onPostRenderLiving(RenderLivingEvent.Post<?> event) {
        StoneEntityProperties stoneProps;
        MiscEntityProperties miscProps;
        FrozenEntityProperties frozenProps;
        EntityLivingBase entity = event.getEntity();
        ChainEntityProperties properties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, ChainEntityProperties.class);
        if (properties != null) {
            if (!properties.connectedEntities.isEmpty()) {
                if (!properties.alreadyIgnoresCamera) {
                    entity.field_70158_ak = true;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179129_p();
                GlStateManager.func_179108_z();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179140_f();
                int light = entity.field_70170_p.func_175626_b(new BlockPos((Entity)entity), 0);
                int i1 = light % 65536;
                int j1 = light / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)i1, (float)j1);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                event.getRenderer().func_110776_a(CHAIN_TEXTURE);
                double posX = Minecraft.func_71410_x().field_71439_g.field_70169_q + (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70169_q) * (double)event.getPartialRenderTick();
                double posY = Minecraft.func_71410_x().field_71439_g.field_70167_r + (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70167_r) * (double)event.getPartialRenderTick();
                double posZ = Minecraft.func_71410_x().field_71439_g.field_70166_s + (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70166_s) * (double)event.getPartialRenderTick();
                for (Entity chainer : properties.connectedEntities) {
                    GlStateManager.func_179094_E();
                    double chainPosX = chainer.field_70169_q + (chainer.field_70165_t - chainer.field_70169_q) * (double)event.getPartialRenderTick();
                    double chainPosY = chainer.field_70167_r + (chainer.field_70163_u - chainer.field_70167_r) * (double)event.getPartialRenderTick();
                    double chainPosZ = chainer.field_70166_s + (chainer.field_70161_v - chainer.field_70166_s) * (double)event.getPartialRenderTick();
                    GlStateManager.func_179137_b((double)(chainPosX - posX), (double)(chainPosY - posY), (double)(chainPosZ - posZ));
                    GlStateManager.func_179137_b((double)0.0, (double)0.75, (double)0.0);
                    double height = (double)chainer.func_70047_e() * 0.75;
                    Vec3d vec3d = this.getChainPosition((Entity)entity, height, event.getPartialRenderTick());
                    if (entity instanceof EntityDragonBase) {
                        vec3d = this.getChainPosition((Entity)entity, ((EntityDragonBase)entity).getRenderSize() * 0.15f, event.getPartialRenderTick());
                    }
                    Vec3d vec3d1 = this.getChainPosition(chainer, height, event.getPartialRenderTick());
                    Vec3d vec3d2 = vec3d.func_178788_d(vec3d1);
                    double d0 = vec3d2.func_72433_c();
                    vec3d2 = vec3d2.func_72432_b();
                    float f5 = (float)this.acos(vec3d2.field_72448_b);
                    float f6 = -((float)IAFMath.atan2_accurate(vec3d2.field_72449_c, vec3d2.field_72450_a));
                    GlStateManager.func_179114_b((float)((1.5707964f + f6) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(f5 * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                    double d1 = 0.0;
                    int j = 225;
                    int k = 225;
                    int l = 225;
                    float texture_scale = 0.3f;
                    double d12 = 0.0 + Math.cos(d1 + Math.PI) * (double)texture_scale;
                    double d13 = 0.0 + Math.sin(d1 + Math.PI) * (double)texture_scale;
                    double d14 = 0.0 + Math.cos(d1 + 0.0) * (double)texture_scale;
                    double d15 = 0.0 + Math.sin(d1 + 0.0) * (double)texture_scale;
                    double d16 = 0.0 + Math.cos(d1 + 1.5707963267948966) * (double)texture_scale;
                    double d17 = 0.0 + Math.sin(d1 + 1.5707963267948966) * (double)texture_scale;
                    double d18 = 0.0 + Math.cos(d1 + 4.71238898038469) * (double)texture_scale;
                    double d19 = 0.0 + Math.sin(d1 + 4.71238898038469) * (double)texture_scale;
                    double d22 = 0.0;
                    double d23 = d0 * 1.0 - (double)texture_scale + d22;
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    bufferbuilder.func_181662_b(d12, d0, d13).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
                    bufferbuilder.func_181662_b(d12, 0.0, d13).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
                    bufferbuilder.func_181662_b(d14, 0.0, d15).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
                    bufferbuilder.func_181662_b(d14, d0, d15).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
                    bufferbuilder.func_181662_b(d16, d0, d17).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
                    bufferbuilder.func_181662_b(d16, 0.0, d17).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
                    bufferbuilder.func_181662_b(d18, 0.0, d19).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
                    bufferbuilder.func_181662_b(d18, d0, d19).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179084_k();
                GlStateManager.func_179089_o();
                GlStateManager.func_179145_e();
                GlStateManager.func_179133_A();
                GlStateManager.func_179121_F();
            } else if (!properties.alreadyIgnoresCamera && entity.field_70158_ak) {
                entity.field_70158_ak = false;
            }
        }
        if ((frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, FrozenEntityProperties.class)) != null && frozenProps.isFrozen) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            float sideExpand = 0.25f;
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(event.getEntity().func_184177_bl().field_72340_a - event.getEntity().field_70165_t + event.getX() - (double)sideExpand, event.getEntity().func_184177_bl().field_72338_b - event.getEntity().field_70163_u + event.getY(), event.getEntity().func_184177_bl().field_72339_c - event.getEntity().field_70161_v + event.getZ() - (double)sideExpand, event.getEntity().func_184177_bl().field_72336_d - event.getEntity().field_70165_t + event.getX() + (double)sideExpand, event.getEntity().func_184177_bl().field_72337_e - event.getEntity().field_70163_u + event.getY() + (double)sideExpand, event.getEntity().func_184177_bl().field_72334_f - event.getEntity().field_70161_v + event.getZ() + (double)sideExpand);
            event.getRenderer().func_110776_a(ClientEvents.getIceTexture(frozenProps.ticksUntilUnfrozen));
            ClientEvents.renderAABB(axisalignedbb1, 0.0, 0.0, 0.0);
            GlStateManager.func_179084_k();
            GlStateManager.func_179133_A();
        }
        if ((miscProps = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, MiscEntityProperties.class)) != null && miscProps.glarers.size() > 0) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            event.getRenderer().func_110776_a(RenderCockatrice.TEXTURE_BEAM);
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
            GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
            GlStateManager.func_179129_p();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            float f1 = 240.0f;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f1, (float)f1);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float f2 = (float)entity.field_70170_p.func_82737_E() + event.getPartialRenderTick();
            float f3 = f2 * 0.15f % 1.0f;
            float f4 = entity.func_70047_e();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)1.2f, (float)0.0f);
            for (Entity entitylivingbase : miscProps.glarers) {
                Vec3d vec3d = this.getChainPosition(entitylivingbase, (double)entitylivingbase.func_70047_e() * 0.75, event.getPartialRenderTick());
                Vec3d vec3d1 = this.getChainPosition((Entity)entity, f4, event.getPartialRenderTick());
                Vec3d vec3d2 = vec3d1.func_178788_d(vec3d);
                double d0 = vec3d2.func_72433_c() + 1.0;
                vec3d2 = vec3d2.func_72432_b();
                float f5 = (float)this.acos(vec3d2.field_72448_b);
                float f6 = (float)IAFMath.atan2_accurate(vec3d2.field_72449_c, vec3d2.field_72450_a);
                GlStateManager.func_179114_b((float)((1.5707964f + -f6) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(f5 * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                double d1 = (double)f2 * 0.05 * -1.5;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                int j = 225;
                int k = 225;
                int l = 225;
                double d4 = 0.0 + Math.cos(d1 + 2.356194490192345) * 0.282;
                double d5 = 0.0 + Math.sin(d1 + 2.356194490192345) * 0.282;
                double d6 = 0.0 + Math.cos(d1 + 0.7853981633974483) * 0.282;
                double d7 = 0.0 + Math.sin(d1 + 0.7853981633974483) * 0.282;
                double d8 = 0.0 + Math.cos(d1 + 3.9269908169872414) * 0.282;
                double d9 = 0.0 + Math.sin(d1 + 3.9269908169872414) * 0.282;
                double d10 = 0.0 + Math.cos(d1 + 5.497787143782138) * 0.282;
                double d11 = 0.0 + Math.sin(d1 + 5.497787143782138) * 0.282;
                double d12 = 0.0 + Math.cos(d1 + Math.PI) * 0.2;
                double d13 = 0.0 + Math.sin(d1 + Math.PI) * 0.2;
                double d14 = 0.0 + Math.cos(d1 + 0.0) * 0.2;
                double d15 = 0.0 + Math.sin(d1 + 0.0) * 0.2;
                double d16 = 0.0 + Math.cos(d1 + 1.5707963267948966) * 0.2;
                double d17 = 0.0 + Math.sin(d1 + 1.5707963267948966) * 0.2;
                double d18 = 0.0 + Math.cos(d1 + 4.71238898038469) * 0.2;
                double d19 = 0.0 + Math.sin(d1 + 4.71238898038469) * 0.2;
                double d22 = -1.0f + f3;
                double d23 = d0 * 2.5 + d22;
                bufferbuilder.func_181662_b(d12, d0, d13).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d12, 0.0, d13).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d14, 0.0, d15).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d14, d0, d15).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d16, d0, d17).func_187315_a(0.4999, d23).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d16, 0.0, d17).func_187315_a(0.4999, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d18, 0.0, d19).func_187315_a(0.0, d22).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d18, d0, d19).func_187315_a(0.0, d23).func_181669_b(j, k, l, 255).func_181675_d();
                double d24 = 0.0;
                if (entity.field_70173_aa % 2 == 0) {
                    d24 = 0.5;
                }
                bufferbuilder.func_181662_b(d4, d0, d5).func_187315_a(0.5, d24 + 0.5).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d6, d0, d7).func_187315_a(1.0, d24 + 0.5).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d10, d0, d11).func_187315_a(1.0, d24).func_181669_b(j, k, l, 255).func_181675_d();
                bufferbuilder.func_181662_b(d8, d0, d9).func_187315_a(0.5, d24).func_181669_b(j, k, l, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
        if (event.getEntity() instanceof EntityLiving && (stoneProps = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntity(), StoneEntityProperties.class)) != null && stoneProps.isStone) {
            event.getEntity().func_82142_c(false);
        }
    }

    private double acos(double x) {
        return (-0.6981317007977321 * x * x - 0.8726646259971648) * x + 1.5707963267948966;
    }

    private Vec3d getChainPosition(Entity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = entityLivingBaseIn.field_70142_S + (entityLivingBaseIn.field_70165_t - entityLivingBaseIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + entityLivingBaseIn.field_70137_T + (entityLivingBaseIn.field_70163_u - entityLivingBaseIn.field_70137_T) * (double)p_177110_4_;
        double d2 = entityLivingBaseIn.field_70136_U + (entityLivingBaseIn.field_70161_v - entityLivingBaseIn.field_70136_U) * (double)p_177110_4_;
        return new Vec3d(d0, d1, d2);
    }

    @SubscribeEvent
    public void onGuiOpened(GuiOpenEvent event) {
        if (IceAndFire.CONFIG.customMainMenu && event.getGui() instanceof GuiMainMenu && !(event.getGui() instanceof IceAndFireMainMenu)) {
            event.setGui((GuiScreen)new IceAndFireMainMenu());
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        EntityDragonBase dragon;
        if (IceAndFire.CONFIG.dragonAuto3rdPerson && event.getEntityBeingMounted() instanceof EntityDragonBase && event.getWorldObj().field_72995_K && event.getEntityMounting() == Minecraft.func_71410_x().field_71439_g && (dragon = (EntityDragonBase)event.getEntityBeingMounted()).func_70909_n() && dragon.func_152114_e((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            if (event.isDismounting()) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = IceAndFire.PROXY.getPreviousViewType();
            } else {
                IceAndFire.PROXY.setPreviousViewType(Minecraft.func_71410_x().field_71474_y.field_74320_O);
                Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                IceAndFire.PROXY.setDragon3rdPersonView(2);
            }
        }
    }
}

