/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.enums;

import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import com.github.alexthe666.iceandfire.item.ItemTrollLeather;
import com.github.alexthe666.iceandfire.item.ItemTrollWeapon;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum EnumTroll {
    FOREST(BiomeDictionary.Type.FOREST, IafItemRegistry.troll_forest, Weapon.TRUNK, Weapon.COLUMN_FOREST, Weapon.AXE, Weapon.HAMMER),
    FROST(BiomeDictionary.Type.SNOWY, IafItemRegistry.troll_frost, Weapon.COLUMN_FROST, Weapon.TRUNK_FROST, Weapon.AXE, Weapon.HAMMER),
    MOUNTAIN(BiomeDictionary.Type.MOUNTAIN, IafItemRegistry.troll_mountain, Weapon.COLUMN, Weapon.AXE, Weapon.HAMMER);

    public ResourceLocation TEXTURE;
    public ResourceLocation TEXTURE_STONE;
    public ResourceLocation TEXTURE_EYES;
    public BiomeDictionary.Type spawnBiome;
    public ItemArmor.ArmorMaterial material;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_leather")
    public Item leather;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_helmet")
    public Item helmet;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_chestplate")
    public Item chestplate;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_leggings")
    public Item leggings;
    @GameRegistry.ObjectHolder(value="iceandfire:troll_boots")
    public Item boots;
    private Weapon[] weapons;

    private EnumTroll(BiomeDictionary.Type biome, ItemArmor.ArmorMaterial material, Weapon ... weapons) {
        this.spawnBiome = biome;
        this.weapons = weapons;
        this.material = material;
        this.TEXTURE = new ResourceLocation("iceandfire:textures/models/troll/troll_" + this.name().toLowerCase() + ".png");
        this.TEXTURE_STONE = new ResourceLocation("iceandfire:textures/models/troll/troll_" + this.name().toLowerCase() + "_stone.png");
        this.TEXTURE_EYES = new ResourceLocation("iceandfire:textures/models/troll/troll_" + this.name().toLowerCase() + "_eyes.png");
        this.leather = new ItemTrollLeather(this);
        this.helmet = new ItemTrollArmor(this, material, 0, EntityEquipmentSlot.HEAD);
        this.chestplate = new ItemTrollArmor(this, material, 1, EntityEquipmentSlot.CHEST);
        this.leggings = new ItemTrollArmor(this, material, 2, EntityEquipmentSlot.LEGS);
        this.boots = new ItemTrollArmor(this, material, 3, EntityEquipmentSlot.FEET);
    }

    public static EnumTroll getBiomeType(Biome biome) {
        ArrayList<EnumTroll> types = new ArrayList<EnumTroll>();
        for (EnumTroll type : EnumTroll.values()) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type.spawnBiome)) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            return EnumTroll.values()[new Random().nextInt(EnumTroll.values().length)];
        }
        return (EnumTroll)((Object)types.get(new Random().nextInt(types.size())));
    }

    public static Weapon getWeaponForType(EnumTroll troll) {
        return troll.weapons[new Random().nextInt(troll.weapons.length)];
    }

    public static enum Weapon {
        AXE,
        COLUMN,
        COLUMN_FOREST,
        COLUMN_FROST,
        HAMMER,
        TRUNK,
        TRUNK_FROST;

        public ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/models/troll/weapon/weapon_" + this.name().toLowerCase() + ".png");
        public Item item = new ItemTrollWeapon(this);
    }
}

