/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.block.BlockDragonforgeBricks;
import com.github.alexthe666.iceandfire.block.BlockDragonforgeCore;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.inventory.ContainerDragonForge;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityDragonforge
extends TileEntity
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{2};
    private static final int[] SLOTS_SIDES = new int[]{0, 1};
    public boolean isFire;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    private NonNullList<ItemStack> forgeItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int cookTime;
    private int lastDragonFlameTimer = 0;
    private boolean prevAssembled;
    private boolean canAddFlameAgain = true;

    public TileEntityDragonforge() {
    }

    public TileEntityDragonforge(boolean isFire) {
        this.isFire = isFire;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public int func_70302_i_() {
        return this.forgeItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.forgeItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void updateGrills(boolean grill) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState grillState;
            BlockPos grillPos = this.func_174877_v().func_177972_a(facing);
            if ((!this.isFire || this.field_145850_b.func_180495_p(grillPos).func_177230_c() != IafBlockRegistry.dragonforge_fire_brick) && (this.isFire || this.field_145850_b.func_180495_p(grillPos).func_177230_c() != IafBlockRegistry.dragonforge_ice_brick)) continue;
            IBlockState iBlockState = grillState = this.isFire ? IafBlockRegistry.dragonforge_fire_brick.func_176223_P().func_177226_a((IProperty)BlockDragonforgeBricks.GRILL, (Comparable)Boolean.valueOf(grill)) : IafBlockRegistry.dragonforge_ice_brick.func_176223_P().func_177226_a((IProperty)BlockDragonforgeBricks.GRILL, (Comparable)Boolean.valueOf(grill));
            if (this.field_145850_b.func_180495_p(grillPos) == grillState) continue;
            this.field_145850_b.func_175656_a(grillPos, grillState);
        }
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.forgeItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.forgeItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.forgeItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.forgeItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.forgeItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.forgeItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.forgeItemStacks);
        this.cookTime = compound.func_74762_e("CookTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.forgeItemStacks);
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.cookTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        this.isFire = this.func_145838_q().func_149739_a().equals(IafBlockRegistry.dragonforge_fire_core.func_149739_a());
        if (this.lastDragonFlameTimer > 0) {
            --this.lastDragonFlameTimer;
        }
        this.updateGrills(this.assembled());
        if (!this.field_145850_b.field_72995_K) {
            if (this.prevAssembled != this.assembled()) {
                BlockDragonforgeCore.setState(this.isFire, this.prevAssembled, this.field_145850_b, this.field_174879_c);
            }
            this.prevAssembled = this.assembled();
            if (!this.assembled()) {
                return;
            }
        }
        if (this.canSmelt() && this.cookTime > 0 && this.lastDragonFlameTimer == 0) {
            --this.cookTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning()) {
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime >= this.getMaxCookTime()) {
                        this.cookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.getMaxCookTime());
            }
            if (flag != this.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
        if (!this.canAddFlameAgain) {
            this.canAddFlameAgain = true;
        }
    }

    public int getMaxCookTime() {
        ItemStack stack = this.getCurrentResult();
        if (stack.func_77973_b() == Item.func_150898_a((Block)IafBlockRegistry.ash) || stack.func_77973_b() == Item.func_150898_a((Block)IafBlockRegistry.dragon_ice)) {
            return 100;
        }
        return 1000;
    }

    private ItemStack getCurrentResult() {
        DragonForgeRecipe forgeRecipe = null;
        forgeRecipe = this.isFire ? IafRecipeRegistry.getFireForgeRecipe((ItemStack)this.forgeItemStacks.get(0)) : IafRecipeRegistry.getIceForgeRecipe((ItemStack)this.forgeItemStacks.get(0));
        ItemStack itemstack = ItemStack.field_190927_a;
        if (forgeRecipe != null && ((ItemStack)this.forgeItemStacks.get(1)).func_77969_a(forgeRecipe.getBlood())) {
            itemstack = forgeRecipe.getOutput();
        }
        if (itemstack == ItemStack.field_190927_a) {
            itemstack = this.isFire ? new ItemStack(IafBlockRegistry.ash) : new ItemStack(IafBlockRegistry.dragon_ice);
        }
        return itemstack;
    }

    public boolean canSmelt() {
        if (((ItemStack)this.forgeItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = this.getCurrentResult();
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.forgeItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.forgeItemStacks.get(0);
            ItemStack bloodStack = (ItemStack)this.forgeItemStacks.get(1);
            ItemStack itemstack1 = this.getCurrentResult();
            ItemStack itemstack2 = (ItemStack)this.forgeItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.forgeItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!bloodStack.func_190926_b() && this.cookTime == 0) {
                bloodStack.func_190918_g(1);
            }
            itemstack.func_190918_g(1);
        }
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        DragonForgeRecipe forgeRecipe;
        if (index == 2) {
            return false;
        }
        if (index == 1 && (forgeRecipe = this.isFire ? IafRecipeRegistry.getFireForgeRecipeForBlood(stack) : IafRecipeRegistry.getIceForgeRecipeForBlood(stack)) != null) {
            return true;
        }
        return index == 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDragonForge(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        return this.cookTime;
    }

    public void func_174885_b(int id, int value) {
        this.cookTime = value;
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        this.forgeItemStacks.clear();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String func_70005_c_() {
        return this.isFire ? "container.dragonforge_fire" : "container.dragonforge_ice";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void transferPower(int i) {
        if (this.canSmelt()) {
            if (this.canAddFlameAgain) {
                this.cookTime = Math.min(this.getMaxCookTime() + 1, this.cookTime + i);
                this.canAddFlameAgain = false;
            }
        } else {
            this.cookTime = 0;
        }
        this.lastDragonFlameTimer = 40;
    }

    private boolean checkBoneCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.func_177978_c().func_177974_f(), IafBlockRegistry.dragon_bone_block) && this.doesBlockEqual(pos.func_177978_c().func_177976_e(), IafBlockRegistry.dragon_bone_block) && this.doesBlockEqual(pos.func_177968_d().func_177974_f(), IafBlockRegistry.dragon_bone_block) && this.doesBlockEqual(pos.func_177968_d().func_177976_e(), IafBlockRegistry.dragon_bone_block);
    }

    private boolean checkBrickCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.func_177978_c().func_177974_f(), this.getBrick()) && this.doesBlockEqual(pos.func_177978_c().func_177976_e(), this.getBrick()) && this.doesBlockEqual(pos.func_177968_d().func_177974_f(), this.getBrick()) && this.doesBlockEqual(pos.func_177968_d().func_177976_e(), this.getBrick());
    }

    private boolean checkBrickSlots(BlockPos pos) {
        return this.doesBlockEqual(pos.func_177978_c(), this.getBrick()) && this.doesBlockEqual(pos.func_177974_f(), this.getBrick()) && this.doesBlockEqual(pos.func_177976_e(), this.getBrick()) && this.doesBlockEqual(pos.func_177968_d(), this.getBrick());
    }

    public boolean assembled() {
        return this.checkBoneCorners(this.field_174879_c.func_177977_b()) && this.checkBrickSlots(this.field_174879_c.func_177977_b()) && this.checkBrickCorners(this.field_174879_c) && this.atleastThreeAreBricks(this.field_174879_c) && this.checkBoneCorners(this.field_174879_c.func_177984_a()) && this.checkBrickSlots(this.field_174879_c.func_177984_a());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    private Block getBrick() {
        return this.isFire ? IafBlockRegistry.dragonforge_fire_brick : IafBlockRegistry.dragonforge_ice_brick;
    }

    private boolean doesBlockEqual(BlockPos pos, Block block) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == block;
    }

    private boolean atleastThreeAreBricks(BlockPos pos) {
        int count = 0;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (this.field_145850_b.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this.getBrick()) continue;
            ++count;
        }
        return count > 2;
    }
}

