/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.util.IceAndFireCoreUtils;
import com.google.common.base.Predicate;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class HippogryphAITargetItems<T extends EntityItem>
extends EntityAITarget {
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super EntityItem> targetEntitySelector;
    private final int targetChance;
    protected EntityItem targetEntity;

    public HippogryphAITargetItems(EntityCreature creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public HippogryphAITargetItems(EntityCreature creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 100, checkSight, onlyNearby, null);
    }

    public HippogryphAITargetItems(EntityCreature creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<EntityItem>(){

            public boolean apply(@Nullable EntityItem item) {
                return item != null && !item.func_92059_d().func_190926_b() && IceAndFireCoreUtils.is(item.func_92059_d(), IceAndFire.CONFIG.hippogryphTameItem);
            }
        };
    }

    public boolean func_75250_a() {
        if (!((EntityHippogryph)this.field_75299_d).canMove()) {
            return false;
        }
        List list = this.field_75299_d.field_70170_p.func_175647_a(EntityItem.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = (EntityItem)list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v, 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.field_75299_d.func_70681_au().nextFloat() < (float)this.targetChance / 100.0f) {
            if (this.targetEntity == null || this.targetEntity != null && this.targetEntity.field_70128_L) {
                this.func_75251_c();
            }
            if (this.targetEntity != null && !this.targetEntity.field_70128_L && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.0) {
                EntityHippogryph hippo = (EntityHippogryph)this.field_75299_d;
                this.targetEntity.func_92059_d().func_190918_g(1);
                this.field_75299_d.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                hippo.setAnimation(EntityHippogryph.ANIMATION_EAT);
                ++hippo.feedings;
                hippo.func_70691_i(4.0f);
                if (!(hippo.feedings <= 3 || hippo.feedings <= 7 && hippo.func_70681_au().nextInt(3) != 0 || hippo.func_70909_n() || this.targetEntity.func_145800_j() == null || this.targetEntity.func_145800_j().isEmpty() || this.field_75299_d.field_70170_p.func_72924_a(this.targetEntity.func_145800_j()) == null)) {
                    EntityPlayer owner = this.field_75299_d.field_70170_p.func_72924_a(this.targetEntity.func_145800_j());
                    hippo.func_70903_f(true);
                    hippo.func_184754_b(owner.func_110124_au());
                    hippo.func_70624_b(null);
                    hippo.setCommand(1);
                    hippo.func_70904_g(true);
                }
                this.func_75251_c();
            }
        }
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            double d1 = this.theEntity.func_70068_e(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

