/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class DragonAIWander
extends EntityAIBase {
    private final EntityDragonBase dragon;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private final double speed;
    private int executionChance;
    private boolean mustUpdate;

    public DragonAIWander(EntityDragonBase creatureIn, double speedIn) {
        this(creatureIn, speedIn, 20);
    }

    public DragonAIWander(EntityDragonBase creatureIn, double speedIn, int chance) {
        this.dragon = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Vec3d vec3d;
        Material materialBelowBelow;
        Material materialBelow;
        Material material;
        if (!this.dragon.canMove()) {
            return false;
        }
        if (this.dragon.func_184179_bs() != null) {
            return false;
        }
        if (this.dragon.isFlying() || this.dragon.isHovering()) {
            return false;
        }
        if (!this.mustUpdate && this.dragon.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        do {
            if ((vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.dragon, (int)10, (int)7)) == null) {
                return false;
            }
            BlockPos pos = new BlockPos(vec3d);
            material = this.dragon.field_70170_p.func_180495_p(pos).func_185904_a();
            materialBelow = this.dragon.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a();
            materialBelowBelow = this.dragon.field_70170_p.func_180495_p(pos.func_177979_c(2)).func_185904_a();
        } while (material.func_76224_d() || materialBelow.func_76224_d() || materialBelowBelow.func_76224_d());
        this.xPosition = vec3d.field_72450_a;
        this.yPosition = vec3d.field_72448_b;
        this.zPosition = vec3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    public boolean func_75253_b() {
        return !this.dragon.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.dragon.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

