/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAIAirTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class StymphalianBirdFlock {
    private EntityStymphalianBird leader;
    private ArrayList<EntityStymphalianBird> members = new ArrayList();
    private BlockPos leaderTarget;
    private BlockPos prevLeaderTarget;
    private Random random;
    private int distance = 15;

    private StymphalianBirdFlock() {
    }

    public static StymphalianBirdFlock createFlock(EntityStymphalianBird bird) {
        StymphalianBirdFlock flock = new StymphalianBirdFlock();
        flock.leader = bird;
        flock.members = new ArrayList();
        flock.members.add(bird);
        flock.leaderTarget = bird.airTarget;
        flock.random = bird.func_70681_au();
        return flock;
    }

    @Nullable
    public static StymphalianBirdFlock getNearbyFlock(EntityStymphalianBird bird) {
        float d0 = IceAndFire.CONFIG.stymphalianBirdFlockLength;
        List list = bird.field_70170_p.func_175674_a((Entity)bird, new AxisAlignedBB(bird.field_70165_t, bird.field_70163_u, bird.field_70161_v, bird.field_70165_t + 1.0, bird.field_70163_u + 1.0, bird.field_70161_v + 1.0).func_72314_b((double)d0, 10.0, (double)d0), EntityStymphalianBird.STYMPHALIAN_PREDICATE);
        list.sort(new EntityAINearestAttackableTarget.Sorter((Entity)bird));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityStymphalianBird)) continue;
                EntityStymphalianBird other = (EntityStymphalianBird)entity;
                if (other.flock == null) continue;
                return other.flock;
            }
        }
        return null;
    }

    public boolean isLeader(EntityStymphalianBird bird) {
        return this.leader != null && this.leader == bird;
    }

    public void addToFlock(EntityStymphalianBird bird) {
        this.members.add(bird);
    }

    public void update() {
        if (!this.members.isEmpty() && (this.leader == null || this.leader.field_70128_L)) {
            this.leader = this.members.get(this.random.nextInt(this.members.size()));
        }
        if (this.leader != null && !this.leader.field_70128_L) {
            this.prevLeaderTarget = this.leaderTarget;
            this.leaderTarget = this.leader.airTarget;
        }
    }

    public void onLeaderAttack(EntityLivingBase attackTarget) {
        for (EntityStymphalianBird bird : this.members) {
            if (bird.func_70638_az() != null || this.isLeader(bird)) continue;
            bird.func_70624_b(attackTarget);
        }
    }

    public EntityStymphalianBird getLeader() {
        return this.leader;
    }

    public void setTarget(BlockPos target) {
        this.leaderTarget = target;
        for (EntityStymphalianBird bird : this.members) {
            if (this.isLeader(bird)) continue;
            bird.airTarget = StymphalianBirdAIAirTarget.getNearbyAirTarget(bird);
        }
    }

    public void setFlying(boolean flying) {
        for (EntityStymphalianBird bird : this.members) {
            if (this.isLeader(bird)) continue;
            bird.setFlying(flying);
        }
    }

    public void setFearTarget(EntityLivingBase living) {
        for (EntityStymphalianBird bird : this.members) {
            bird.setVictor(living);
        }
    }
}

