/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.IafVillagerRegistry;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import java.util.Objects;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class EntitySnowVillager
extends EntityVillager {
    private VillagerRegistry.VillagerProfession prof;

    public EntitySnowVillager(World worldIn) {
        super(worldIn);
    }

    public EntitySnowVillager(World worldIn, int profession) {
        super(worldIn, profession);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if (properties != null && properties.isStone) {
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70938_b(int professionId) {
        if (professionId > 2) {
            professionId = 2;
        }
        this.field_70180_af.func_187227_b(field_184752_bw, (Object)professionId);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (field_184621_as.equals(key) && this.field_70170_p.field_72995_K) {
            if (this.func_184587_cr() && this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = this.func_184586_b(this.func_184600_cs());
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = this.field_184627_bm.func_77988_m();
                }
            } else if (!this.func_184587_cr() && !this.field_184627_bm.func_190926_b()) {
                this.field_184627_bm = ItemStack.field_190927_a;
                this.field_184628_bn = 0;
            }
        }
        if (Objects.equals(field_184751_bv, key)) {
            this.func_98054_a(this.func_70631_g_());
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityZombie && (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD)) {
            return;
        }
        super.func_70645_a(cause);
    }

    public void setProfession(VillagerRegistry.VillagerProfession prof) {
        if (IafVillagerRegistry.INSTANCE.professions.containsValue(prof)) {
            this.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)prof));
        } else {
            IafVillagerRegistry.INSTANCE.setRandomProfession(this, this.field_70170_p.field_73012_v);
        }
    }

    public EntityVillager func_90011_a(EntityAgeable ageable) {
        EntitySnowVillager entityvillager = new EntitySnowVillager(this.field_70170_p);
        entityvillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityvillager)), null);
        return entityvillager;
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        String s = this.func_95999_t();
        if (s != null && !s.isEmpty()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)team, (String)s));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            return textcomponentstring;
        }
        String s1 = this.getProfessionForge().getCareer(0).getName();
        TextComponentTranslation itextcomponent = new TextComponentTranslation("entity.Villager." + s1, new Object[0]);
        itextcomponent.func_150256_b().func_150209_a(this.func_174823_aP());
        itextcomponent.func_150256_b().func_179989_a(this.func_189512_bd());
        if (team != null) {
            itextcomponent.func_150256_b().func_150238_a(team.func_178775_l());
        }
        return itextcomponent;
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        if (this.prof == null) {
            String p = this.getEntityData().func_74779_i("ProfessionName");
            this.prof = p.isEmpty() ? IafVillagerRegistry.INSTANCE.professions.get(this.func_70681_au().nextInt(3)) : IafVillagerRegistry.INSTANCE.professions.get(this.intFromProfesion(p));
            this.field_175563_bv = 1;
        }
        return this.prof;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70938_b(compound.func_74762_e("Profession"));
        if (compound.func_74764_b("ProfessionName")) {
            VillagerRegistry.VillagerProfession p = IafVillagerRegistry.INSTANCE.professions.get(this.intFromProfesion(compound.func_74779_i("ProfessionName")));
            if (p == null) {
                p = IafVillagerRegistry.INSTANCE.professions.get(0);
            }
            this.setProfession(p);
        }
    }

    public IEntityLivingData func_190672_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data, boolean forgeCheck) {
        this.prof = IafVillagerRegistry.INSTANCE.professions.get(this.func_70681_au().nextInt(3));
        return data;
    }

    private int intFromProfesion(String prof) {
        if (prof.contains("fisherman")) {
            return 0;
        }
        if (prof.contains("craftsman")) {
            return 1;
        }
        if (prof.contains("shaman")) {
            return 2;
        }
        return 0;
    }
}

