/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIAttackMeleeNoCooldown;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIFollowSummoner;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAISummonerHurtByTarget;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAISummonerHurtTarget;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.google.common.base.Optional;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityMyrmexSwarmer
extends EntityMyrmexRoyal {
    private static final DataParameter<Optional<UUID>> SUMMONER_ID = EntityDataManager.func_187226_a(EntityMyrmexSwarmer.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> TICKS_ALIVE = EntityDataManager.func_187226_a(EntityMyrmexSwarmer.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMyrmexSwarmer(World worldIn) {
        super(worldIn);
        this.field_70765_h = new EntityMyrmexRoyal.FlyMoveHelper(this, this);
        this.field_70699_by = new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
        this.switchNavigator(false);
        this.func_70105_a(0.5f, 0.5f);
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    @Override
    protected void switchNavigator(boolean onLand) {
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(IceAndFire.CONFIG.myrmexBaseAttackStrength - 1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
    }

    @Override
    protected double attackDistance() {
        return 13.0;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MyrmexAIFollowSummoner(this, 0.25, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityMyrmexRoyal.AIFlyAtTarget(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityMyrmexRoyal.AIFlyRandom(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMeleeNoCooldown((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new MyrmexAISummonerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new MyrmexAISummonerHurtTarget(this));
    }

    @Override
    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof EntityMyrmexSwarmer) {
            super.func_82167_n(entityIn);
        }
    }

    @Override
    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMONER_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(TICKS_ALIVE, (Object)0);
    }

    @Nullable
    public EntityLivingBase getSummoner() {
        try {
            UUID uuid = this.getSummonerUUID();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (this.getSummonerUUID() == null || entityIn instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)entityIn).getSummonerUUID() == null) {
            return false;
        }
        if (entityIn instanceof EntityTameable) {
            UUID ownerID = ((EntityTameable)entityIn).func_184753_b();
            return ownerID != null && ownerID.equals(this.getSummonerUUID());
        }
        return entityIn.func_110124_au().equals(this.getSummonerUUID()) || entityIn instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)entityIn).getSummonerUUID() != null && Objects.equals(((EntityMyrmexSwarmer)entityIn).getSummonerUUID(), this.getSummonerUUID());
    }

    public void setSummonerID(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(SUMMONER_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getSummonerUUID() == null) {
            compound.func_74778_a("SummonerUUID", "");
        } else {
            compound.func_74778_a("SummonerUUID", this.getSummonerUUID().toString());
        }
        compound.func_74768_a("SummonTicks", this.getTicksAlive());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        String s = "";
        if (compound.func_150297_b("SummonerUUID", 8)) {
            s = compound.func_74779_i("SummonerUUID");
        }
        if (!s.isEmpty()) {
            try {
                this.setSummonerID(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setTicksAlive(compound.func_74762_e("SummonTicks"));
    }

    public void setSummonedBy(EntityPlayer player) {
        this.setSummonerID(player.func_110124_au());
    }

    @Nullable
    public UUID getSummonerUUID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(SUMMONER_ID)).orNull();
    }

    public int getTicksAlive() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_ALIVE);
    }

    public void setTicksAlive(int ticks) {
        this.field_70180_af.func_187227_b(TICKS_ALIVE, (Object)ticks);
    }

    @Override
    public void func_70636_d() {
        double dist;
        super.func_70636_d();
        this.setFlying(true);
        boolean flying = this.isFlying() && !this.field_70122_E;
        this.setTicksAlive(this.getTicksAlive() + 1);
        if (flying) {
            this.field_70181_x -= 0.08;
            if (this.field_70765_h.func_179919_e() > this.field_70163_u) {
                this.field_70181_x += 0.08;
            }
        }
        if (this.field_70122_E) {
            this.field_70122_E = false;
            this.field_70181_x += (double)0.2f;
        }
        if (this.func_70638_az() != null) {
            this.field_70765_h.func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v, 1.0);
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_BITE : ANIMATION_STING);
            }
            if (this.func_70638_az().field_70128_L) {
                this.field_70765_h.field_188491_h = EntityMoveHelper.Action.WAIT;
            }
        }
        if (this.getTicksAlive() > 1800) {
            this.func_174812_G();
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < this.attackDistance()) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playStingSound();
            dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist < this.attackDistance()) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2));
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 70, 1));
            }
        }
    }

    @Override
    public int getGrowthStage() {
        return 2;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    public float getModelScale() {
        return 0.25f;
    }

    @Override
    public boolean shouldHaveNormalAI() {
        return false;
    }

    @Override
    public int getCasteImportance() {
        return 0;
    }

    @Override
    public boolean isBreedingSeason() {
        return false;
    }

    public boolean shouldAttackEntity(EntityLivingBase attacker, EntityLivingBase entitylivingbase) {
        return !this.func_184191_r((Entity)attacker);
    }
}

