/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.BlockMyrmexBiolight;
import com.github.alexthe666.iceandfire.block.BlockMyrmexConnectedResin;
import com.github.alexthe666.iceandfire.block.BlockMyrmexResin;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.MyrmexHive;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateMyrmex;
import com.github.alexthe666.iceandfire.util.IAFMath;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMyrmexBase
extends EntityAnimal
implements IAnimatedEntity,
IMerchant {
    public static final Animation ANIMATION_PUPA_WIGGLE = Animation.create((int)20);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityMyrmexBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> GROWTH_STAGE = EntityDataManager.func_187226_a(EntityMyrmexBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> VARIANT = EntityDataManager.func_187226_a(EntityMyrmexBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final ResourceLocation TEXTURE_DESERT_LARVA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_larva.png");
    private static final ResourceLocation TEXTURE_DESERT_PUPA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_pupa.png");
    private static final ResourceLocation TEXTURE_JUNGLE_LARVA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_larva.png");
    private static final ResourceLocation TEXTURE_JUNGLE_PUPA = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_pupa.png");
    public boolean isEnteringHive = false;
    public boolean isBeingGuarded = false;
    protected int growthTicks = 1;
    private int animationTick;
    private Animation currentAnimation;
    private MyrmexHive hive;
    @Nullable
    private EntityPlayer buyingPlayer;
    @Nullable
    private MerchantRecipeList buyingList;
    private UUID lastBuyingPlayer;
    private int careerId;
    private int careerLevel;
    private boolean needsInitilization;
    private int timeUntilReset;
    private int wealth;

    public EntityMyrmexBase(World worldIn) {
        super(worldIn);
        this.field_70138_W = 2.0f;
    }

    private static boolean isJungleBiome(World world, BlockPos position) {
        Biome biome = world.func_180494_b(position);
        return biome.field_76752_A != Blocks.field_150354_m && biome.field_76753_B != Blocks.field_150354_m && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
    }

    public static boolean haveSameHive(EntityMyrmexBase myrmex, Entity entity) {
        if (entity instanceof EntityMyrmexBase && myrmex.getHive() != null && ((EntityMyrmexBase)entity).getHive() != null && myrmex.isJungle() == ((EntityMyrmexBase)entity).isJungle()) {
            return myrmex.getHive().getCenter() == ((EntityMyrmexBase)entity).getHive().getCenter();
        }
        if (entity instanceof EntityMyrmexEgg) {
            return myrmex.isJungle() == ((EntityMyrmexEgg)entity).isJungle();
        }
        return false;
    }

    public static boolean isEdibleBlock(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockMyrmexBiolight) {
            return false;
        }
        return blockState.func_185904_a() == Material.field_151584_j || blockState.func_185904_a() == Material.field_151585_k || blockState.func_185904_a() == Material.field_151582_l || blockState.func_185904_a() == Material.field_151570_A || block instanceof BlockBush || block instanceof BlockCactus || block instanceof BlockLeaves;
    }

    public static int getRandomCaste(World world, Random random, boolean royal) {
        float rand = random.nextFloat();
        if (royal) {
            if ((double)rand > 0.9) {
                return 2;
            }
            if ((double)rand > 0.75) {
                return 3;
            }
            if ((double)rand > 0.5) {
                return 1;
            }
            return 0;
        }
        if ((double)rand > 0.8) {
            return 3;
        }
        if ((double)rand > 0.6) {
            return 1;
        }
        return 0;
    }

    public boolean canMove() {
        return this.getGrowthStage() > 1 && !this.isTrading();
    }

    public boolean func_70631_g_() {
        return this.getGrowthStage() < 2;
    }

    protected void func_70619_bc() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization) {
                    for (MerchantRecipe merchantrecipe : this.buyingList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                    if (this.getHive() != null && this.lastBuyingPlayer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.getHive().setWorld(this.field_70170_p);
                        this.getHive().modifyPlayerReputation(this.lastBuyingPlayer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.getCasteImportance() * 7 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (dmg == DamageSource.field_76368_d && this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getGrowthStage() < 2) {
            this.setAnimation(ANIMATION_PUPA_WIGGLE);
        }
        return super.func_70097_a(dmg, i);
    }

    protected float func_175134_bD() {
        return 0.52f;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = this.func_175134_bD();
        if (this.func_70644_a(MobEffects.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        float f = this.field_70177_z * ((float)Math.PI / 180);
        this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
        this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockMyrmexResin ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateMyrmex((EntityLiving)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(GROWTH_STAGE, (Object)2);
        this.field_70180_af.func_187214_a(VARIANT, (Object)Boolean.FALSE);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (this.getGrowthStage() < 2 && this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityMyrmexBase) {
            float yaw;
            this.field_70177_z = yaw = this.func_184187_bx().field_70177_z;
            this.field_70759_as = yaw;
            this.field_70761_aq = 0.0f;
            this.field_70760_ar = 0.0f;
        }
        this.func_98054_a(false);
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F && (this.field_70122_E || !this.field_70124_G));
        }
        if (this.getGrowthStage() < 2) {
            ++this.growthTicks;
            if (this.growthTicks == IceAndFire.CONFIG.myrmexLarvaTicks) {
                this.setGrowthStage(this.getGrowthStage() + 1);
                this.growthTicks = 0;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getGrowthStage() < 2 && this.func_70681_au().nextInt(150) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_PUPA_WIGGLE);
        }
        if (this.func_70638_az() != null && !(this.func_70638_az() instanceof EntityPlayer) && this.func_70661_as().func_75500_f()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && (EntityMyrmexBase.haveSameHive(this, (Entity)this.func_70638_az()) || this.func_70638_az() instanceof EntityTameable && !this.canAttackTamable((EntityTameable)this.func_70638_az()) || this.func_70638_az() instanceof EntityPlayer && this.getHive() != null && !this.getHive().isPlayerReputationTooLowToFight(this.func_70638_az().func_110124_au()))) {
            this.func_70624_b(null);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 500 == 0 && this.isOnResin()) {
            this.func_70691_i(1.0f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)76);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("GrowthStage", this.getGrowthStage());
        tag.func_74768_a("GrowthTicks", this.growthTicks);
        tag.func_74757_a("Variant", this.isJungle());
        if (this.getHive() != null) {
            tag.func_186854_a("HiveUUID", this.getHive().hiveUUID);
        }
        tag.func_74768_a("Career", this.careerId);
        tag.func_74768_a("CareerLevel", this.careerLevel);
        tag.func_74768_a("Riches", this.wealth);
        if (this.buyingList != null) {
            tag.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setGrowthStage(tag.func_74762_e("GrowthStage"));
        this.growthTicks = tag.func_74762_e("GrowthTicks");
        this.setJungleVariant(tag.func_74767_n("Variant"));
        this.setHive(MyrmexWorldData.get(this.field_70170_p).getHiveFromUUID(tag.func_186857_a("HiveUUID")));
        this.careerId = tag.func_74762_e("Career");
        this.careerLevel = tag.func_74762_e("CareerLevel");
        if (tag.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = tag.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
        this.wealth = tag.func_74762_e("Riches");
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? IafSoundRegistry.MYRMEX_HURT : IafSoundRegistry.MYRMEX_IDLE, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        if (this.getHive() != null && this.func_70931_l_() != null) {
            this.getHive().setWorld(this.field_70170_p);
            this.getHive().modifyPlayerReputation(this.func_70931_l_().func_110124_au(), 2);
        }
        this.func_184185_a(IafSoundRegistry.MYRMEX_IDLE, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            this.lastBuyingPlayer = this.buyingPlayer != null ? this.buyingPlayer.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == IafItemRegistry.myrmex_desert_resin || recipe.func_77394_a().func_77973_b() == IafItemRegistry.myrmex_jungle_resin) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    private void populateBuyingList() {
        if (this.careerId != 0 && this.careerLevel != 0) {
            ++this.careerLevel;
        } else {
            this.careerId = this.getProfessionForge().getRandomCareer(this.field_70146_Z) + 1;
            this.careerLevel = 1;
        }
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        int i = this.careerId - 1;
        int j = this.careerLevel - 1;
        List trades = this.getProfessionForge().getCareer(i).getTrades(j);
        if (trades != null) {
            for (EntityVillager.ITradeList entityvillager$itradelist : trades) {
                entityvillager$itradelist.func_190888_a((IMerchant)this, this.buyingList, this.field_70146_Z);
            }
        }
    }

    public boolean canAttackTamable(EntityTameable tameable) {
        if (tameable.func_70902_q() != null && this.getHive() != null) {
            return this.getHive().isPlayerReputationTooLowToFight(tameable.func_184753_b());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        String s = this.func_95999_t();
        if (s != null && !s.isEmpty()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)team, (String)s));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            return textcomponentstring;
        }
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        TextComponentString itextcomponent = new TextComponentString(this.func_70005_c_());
        itextcomponent.func_150256_b().func_150209_a(this.func_174823_aP());
        itextcomponent.func_150256_b().func_179989_a(this.func_189512_bd());
        if (team != null) {
            itextcomponent.func_150256_b().func_150238_a(team.func_178775_l());
        }
        return itextcomponent;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public int getGrowthStage() {
        return (Integer)this.field_70180_af.func_187225_a(GROWTH_STAGE);
    }

    public void setGrowthStage(int stage) {
        this.field_70180_af.func_187227_b(GROWTH_STAGE, (Object)stage);
    }

    public boolean isJungle() {
        return (Boolean)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setJungleVariant(boolean isJungle) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)isJungle);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70617_f_() {
        return super.func_70617_f_();
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE};
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        if (this.getHive() == null || livingBase == null || livingBase instanceof EntityPlayer && this.getHive().isPlayerReputationTooLowToFight(livingBase.func_110124_au())) {
            super.func_70604_c(livingBase);
        }
        if (this.getHive() != null && livingBase != null) {
            this.getHive().addOrRenewAgressor(livingBase, this.getImportance());
        }
        if (this.getHive() != null && livingBase != null && livingBase instanceof EntityPlayer) {
            int i = -5 * this.getCasteImportance();
            this.getHive().setWorld(this.field_70170_p);
            this.getHive().modifyPlayerReputation(livingBase.func_110124_au(), i);
            if (this.func_70089_S()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)13);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        Entity entity;
        if (this.getHive() != null && (entity = cause.func_76346_g()) != null) {
            this.getHive().setWorld(this.field_70170_p);
            this.getHive().modifyPlayerReputation(entity.func_110124_au(), -15);
        }
        super.func_70645_a(cause);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        boolean flag2;
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.shouldHaveNormalAI()) {
            return false;
        }
        boolean bl = flag2 = itemstack.func_77973_b() == IafItemRegistry.myrmex_jungle_staff || itemstack.func_77973_b() == IafItemRegistry.myrmex_desert_staff;
        if (flag2) {
            this.onStaffInteract(player, itemstack);
            player.func_184609_a(hand);
            return true;
        }
        boolean bl2 = flag = itemstack.func_77973_b() == Items.field_151057_cb || itemstack.func_77973_b() == Items.field_151058_ca;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!(this.func_190669_a(itemstack, ((Object)((Object)this)).getClass()) || this.getGrowthStage() < 2 || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!(this.field_70170_p.field_72995_K || this.buyingList.isEmpty() || this.getHive() != null && this.getHive().isPlayerReputationTooLowToTrade(player.func_110124_au()))) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void onStaffInteract(EntityPlayer player, ItemStack itemstack) {
        UUID staffUUID = itemstack.func_77978_p().func_186857_a("HiveUUID");
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!player.func_184812_l_() && this.getHive() != null && !this.getHive().canPlayerCommandHive(player.func_110124_au())) {
            return;
        }
        if (this.getHive() == null) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.null_hive", new Object[0]), true);
        } else if (staffUUID != null && staffUUID.equals(this.getHive().hiveUUID)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.staff_already_set", new Object[0]), true);
        } else {
            this.getHive().setWorld(this.field_70170_p);
            EntityMyrmexQueen queen = this.getHive().getQueen();
            BlockPos center = this.getHive().getCenterGround();
            if (queen.func_145818_k_()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.staff_set_named", new Object[]{queen.func_95999_t(), center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("myrmex.message.staff_set_unnamed", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), true);
            }
            itemstack.func_77978_p().func_186854_a("HiveUUID", this.getHive().hiveUUID);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setHive(MyrmexWorldData.get(this.field_70170_p).getNearestHive(this.func_180425_c(), 400));
        if (this.getHive() != null) {
            this.setJungleVariant(EntityMyrmexBase.isJungleBiome(this.field_70170_p, this.getHive().getCenter()));
        } else {
            this.setJungleVariant(this.field_70146_Z.nextBoolean());
        }
        this.populateBuyingList();
        return livingdata;
    }

    public abstract boolean shouldLeaveHive();

    public abstract boolean shouldEnterHive();

    public void func_98054_a(boolean baby) {
        this.func_98055_j(this.getGrowthStage() == 0 ? 0.5f : (this.getGrowthStage() == 1 ? 0.75f : 1.0f));
    }

    public abstract ResourceLocation getAdultTexture();

    public abstract float getModelScale();

    public ResourceLocation getTexture() {
        if (this.getGrowthStage() == 0) {
            return this.isJungle() ? TEXTURE_JUNGLE_LARVA : TEXTURE_DESERT_LARVA;
        }
        if (this.getGrowthStage() == 1) {
            return this.isJungle() ? TEXTURE_JUNGLE_PUPA : TEXTURE_DESERT_PUPA;
        }
        return this.getAdultTexture();
    }

    public MyrmexHive getHive() {
        return this.hive;
    }

    public void setHive(MyrmexHive newHive) {
        this.hive = newHive;
        if (this.hive != null) {
            this.hive.addMyrmex(this);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!EntityMyrmexBase.haveSameHive(this, entityIn)) {
            entityIn.func_70108_f((Entity)this);
        }
    }

    public boolean canSeeSky() {
        return this.field_70170_p.func_175710_j(new BlockPos((Entity)this));
    }

    public boolean isOnResin() {
        double d0 = this.field_70163_u - 1.0;
        BlockPos blockpos = new BlockPos(this.field_70165_t, d0, this.field_70161_v);
        while (this.field_70170_p.func_175623_d(blockpos) && blockpos.func_177956_o() > 1) {
            blockpos = blockpos.func_177977_b();
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        return iblockstate.func_177230_c() instanceof BlockMyrmexResin || iblockstate.func_177230_c() instanceof BlockMyrmexConnectedResin;
    }

    public boolean isInNursery() {
        if (this.getHive() != null && this.getHive().getRooms(WorldGenMyrmexHive.RoomType.NURSERY).isEmpty() && this.getHive().getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_180425_c()) != null) {
            return false;
        }
        if (this.getHive() != null) {
            BlockPos nursery = this.getHive().getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_180425_c());
            return this.func_174831_c(nursery) < 45.0;
        }
        return false;
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        if (!this.canMove()) {
            strafe = 0.0f;
            forward = 0.0f;
            vertical = 0.0f;
            super.func_191986_a(strafe, forward, vertical);
            return;
        }
        super.func_191986_a(strafe, forward, vertical);
    }

    public int getImportance() {
        if (this.getGrowthStage() < 2) {
            return 1;
        }
        return this.getCasteImportance();
    }

    public abstract int getCasteImportance();

    public boolean needsGaurding() {
        return true;
    }

    public boolean shouldMoveThroughHive() {
        return true;
    }

    public boolean shouldWander() {
        return this.getHive() == null;
    }

    public VillagerRegistry.VillagerProfession getProfessionForge() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 76) {
            this.playVillagerEffect();
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.MYRMEX_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.MYRMEX_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.MYRMEX_DIE;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(IafSoundRegistry.MYRMEX_WALK, 0.16f * this.getMyrmexPitch() * (this.func_70681_au().nextFloat() * 0.6f + 0.4f), 1.0f);
    }

    protected void playBiteSound() {
        this.func_184185_a(IafSoundRegistry.MYRMEX_BITE, 1.0f * this.getMyrmexPitch(), 1.0f);
    }

    protected void playStingSound() {
        this.func_184185_a(IafSoundRegistry.MYRMEX_STING, 1.0f * this.getMyrmexPitch(), 0.6f);
    }

    protected void playVillagerEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.VILLAGER_HAPPY;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public float getMyrmexPitch() {
        return this.field_70130_N;
    }

    public boolean shouldHaveNormalAI() {
        return true;
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public AxisAlignedBB getAttackBounds() {
        float size = this.func_70603_bj() * 0.25f;
        return this.func_174813_aQ().func_72314_b((double)(1.0f + size), (double)(1.0f + size), (double)(1.0f + size));
    }

    protected static class GroundMoveHelper
    extends EntityMoveHelper {
        public GroundMoveHelper(EntityLiving entitylivingIn) {
            super(entitylivingIn);
        }

        public float distance(float rotateAngleFrom, float rotateAngleTo) {
            return (float)IAFMath.atan2_accurate(MathHelper.func_76126_a((float)(rotateAngleTo - rotateAngleFrom)), MathHelper.func_76134_b((float)(rotateAngleTo - rotateAngleFrom)));
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.STRAFE) {
                NodeProcessor nodeprocessor;
                float f = (float)this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                PathNavigate pathnavigate = this.field_75648_a.func_70661_as();
                if (pathnavigate != null && (nodeprocessor = pathnavigate.func_189566_q()) != null && nodeprocessor.func_186330_a((IBlockAccess)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.field_70165_t + (double)f7)), MathHelper.func_76128_c((double)this.field_75648_a.field_70163_u), MathHelper.func_76128_c((double)(this.field_75648_a.field_70161_v + (double)f8))) != PathNodeType.WALKABLE) {
                    this.field_188489_f = 1.0f;
                    this.field_188490_g = 0.0f;
                    f1 = f;
                }
                this.field_75648_a.func_70659_e(f1);
                this.field_75648_a.func_191989_p(this.field_188489_f);
                this.field_75648_a.func_184646_p(this.field_188490_g);
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f9 = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                float maxChange = 90.0f;
                float distance = (float)Math.toDegrees(this.distance((float)Math.toRadians(this.field_75648_a.field_70177_z), (float)Math.toRadians(f9)));
                this.field_75648_a.field_70177_z += MathHelper.func_76131_a((float)distance, (float)(-maxChange / 2.0f), (float)(maxChange / 2.0f));
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = EntityMoveHelper.Action.JUMPING;
                }
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            } else {
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }

    public static class BasicTrade
    implements EntityVillager.ITradeList {
        public ItemStack first;
        public ItemStack second;
        public EntityVillager.PriceInfo firstPrice;
        public EntityVillager.PriceInfo secondPrice;

        public BasicTrade(ItemStack first, ItemStack second, EntityVillager.PriceInfo firstPrice, EntityVillager.PriceInfo secondPrice) {
            this.first = first;
            this.second = second;
            this.firstPrice = firstPrice;
            this.secondPrice = secondPrice;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = this.firstPrice.func_179412_a(random);
            int j = this.secondPrice.func_179412_a(random);
            recipeList.add((Object)new MerchantRecipe(new ItemStack(this.first.func_77973_b(), i, this.first.func_77952_i()), new ItemStack(this.second.func_77973_b(), j, this.second.func_77952_i())));
        }
    }
}

