/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.IHumanoid;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.ai.GorgonAIStare;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageStoneStatue;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.util.IsImmune;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityGorgon
extends EntityMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHumanoid {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "gorgon"));
    public static Animation ANIMATION_SCARE;
    public static Animation ANIMATION_HIT;
    private int animationTick;
    private Animation currentAnimation;
    private GorgonAIStare aiStare;
    private EntityAIAttackMelee aiMelee;
    private int playerStatueCooldown;

    public EntityGorgon(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 1.99f);
        ANIMATION_SCARE = Animation.create((int)30);
        ANIMATION_HIT = Animation.create((int)10);
    }

    public static boolean isEntityLookingAt(EntityLivingBase looker, EntityLivingBase seen, double degree) {
        Vec3d vec3d = looker.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(seen.field_70165_t - looker.field_70165_t, seen.func_174813_aQ().field_72338_b + (double)seen.func_70047_e() - (looker.field_70163_u + (double)looker.func_70047_e()), seen.field_70161_v - looker.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - (degree *= 1.0 + (double)looker.func_70032_d((Entity)seen) * 0.1) / d0 && looker.func_70685_l((Entity)seen) && !EntityGorgon.isStoneMob(seen);
    }

    public static boolean isStoneMob(EntityLivingBase mob) {
        if (mob instanceof EntityLiving) {
            try {
                StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)mob, StoneEntityProperties.class);
                return properties != null && properties.isStone;
            }
            catch (Exception e) {
                IceAndFire.logger.warn("stone entity properties do not exist for " + mob.func_70005_c_());
            }
        }
        return false;
    }

    public static boolean isBlindfolded(EntityLivingBase attackTarget) {
        return attackTarget != null && (attackTarget.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == IafItemRegistry.blindfold || attackTarget.func_70644_a(MobEffects.field_76440_q));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.aiStare = new GorgonAIStare(this, 1.0, 15.0f);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiStare);
        this.aiMelee = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiMelee);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GorgonAIStare(this, 1.0, 15.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0){

            public boolean func_75250_a() {
                this.field_179481_f = 20;
                return super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f){

            public boolean func_75253_b() {
                if (this.field_75334_a != null && this.field_75334_a instanceof EntityPlayer && ((EntityPlayer)this.field_75334_a).func_184812_l_()) {
                    return false;
                }
                return super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer entity) {
                return true;
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(entity, StoneEntityProperties.class);
                return entity instanceof EntityLiving && DragonUtils.isAlive((EntityLivingBase)((EntityLiving)entity)) && (properties == null || !properties.isStone) || !IsImmune.toStone(entity) && entity instanceof IBlacklistedFromStatues && ((IBlacklistedFromStatues)entity).canBeTurnedToStone();
            }
        }));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMelee);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer) && entity instanceof EntityLiving) {
            this.forcePreyToLook((EntityLiving)entity);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean blindness;
        boolean bl = blindness = this.func_70644_a(MobEffects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az().func_70644_a(MobEffects.field_76440_q) || this.func_70638_az() != null && IsImmune.toStone((Entity)this.func_70638_az());
        if (blindness && this.field_70725_aQ == 0) {
            if (this.getAnimation() != ANIMATION_HIT) {
                this.setAnimation(ANIMATION_HIT);
            }
            if (entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 2, false, true));
            }
        }
        return super.func_70652_k(entityIn);
    }

    public void func_70624_b(@Nullable EntityLivingBase living) {
        super.func_70624_b(living);
        if (living != null && !this.field_70170_p.field_72995_K) {
            boolean blindness;
            boolean bl = blindness = this.func_70644_a(MobEffects.field_76440_q) || living.func_70644_a(MobEffects.field_76440_q) || IsImmune.toStone((Entity)living) || living instanceof IBlacklistedFromStatues && !((IBlacklistedFromStatues)living).canBeTurnedToStone() || EntityGorgon.isBlindfolded(living);
            if (blindness && this.field_70725_aQ == 0) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiStare);
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiMelee);
            } else {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiMelee);
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiStare);
            }
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return 30;
    }

    protected void func_70609_aI() {
        double d1;
        double d0;
        int k;
        ++this.field_70725_aQ;
        this.field_70757_a = 20;
        if (this.field_70170_p.field_72995_K) {
            for (k = 0; k < 5; ++k) {
                double d2 = 0.4;
                d0 = 0.1;
                d1 = 0.1;
                IceAndFire.PROXY.spawnParticle("blood", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
            }
        }
        if (this.field_70725_aQ >= 200) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            for (k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public void func_70636_d() {
        boolean blindness;
        EntityLivingBase target;
        super.func_70636_d();
        if (this.playerStatueCooldown > 0) {
            --this.playerStatueCooldown;
        }
        if ((target = this.func_70638_az()) != null) {
            blindness = this.func_70644_a(MobEffects.field_76440_q) || target.func_70644_a(MobEffects.field_76440_q);
            this.func_70671_ap().func_75650_a(target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, (float)this.func_184649_cE(), (float)this.func_70646_bf());
            if (!blindness && this.field_70725_aQ == 0 && target instanceof EntityLiving && !(target instanceof EntityPlayer)) {
                this.forcePreyToLook((EntityLiving)target);
            }
        }
        if (target != null && EntityGorgon.isEntityLookingAt((EntityLivingBase)this, target, 0.4) && EntityGorgon.isEntityLookingAt(target, (EntityLivingBase)this, 0.4) && !EntityGorgon.isBlindfolded(target)) {
            boolean bl = blindness = this.func_70644_a(MobEffects.field_76440_q) || target.func_70644_a(MobEffects.field_76440_q) || IsImmune.toStone((Entity)target);
            if (!blindness && this.field_70725_aQ == 0) {
                if (this.getAnimation() != ANIMATION_SCARE) {
                    this.func_184185_a(IafSoundRegistry.GORGON_ATTACK, 1.0f, 1.0f);
                    this.setAnimation(ANIMATION_SCARE);
                }
                if (this.getAnimation() == ANIMATION_SCARE && this.getAnimationTick() > 10) {
                    if (target instanceof EntityPlayer) {
                        if (!this.field_70170_p.field_72995_K) {
                            target.func_70097_a(IceAndFire.gorgon, 2.1474836E9f);
                            if (!target.func_70089_S() && this.playerStatueCooldown == 0) {
                                EntityStoneStatue statue = new EntityStoneStatue(this.field_70170_p);
                                statue.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
                                statue.smallArms = true;
                                if (!this.field_70170_p.field_72995_K) {
                                    this.field_70170_p.func_72838_d((Entity)statue);
                                }
                                statue.field_70126_B = target.field_70177_z;
                                statue.field_70177_z = target.field_70177_z;
                                statue.field_70759_as = target.field_70177_z;
                                statue.field_70761_aq = target.field_70177_z;
                                statue.field_70760_ar = target.field_70177_z;
                                this.playerStatueCooldown = 40;
                            }
                            this.func_70624_b(null);
                        }
                    } else if (target instanceof EntityLiving && !(target instanceof IBlacklistedFromStatues) || !IsImmune.toStone((Entity)target) && target instanceof IBlacklistedFromStatues && ((IBlacklistedFromStatues)target).canBeTurnedToStone()) {
                        EntityTameable dragon;
                        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)target, StoneEntityProperties.class);
                        EntityLiving attackTarget = (EntityLiving)target;
                        if (properties != null && !properties.isStone) {
                            properties.isStone = true;
                            if (this.field_70170_p.field_72995_K) {
                                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageStoneStatue(attackTarget.func_145782_y(), true));
                            } else {
                                IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageStoneStatue(attackTarget.func_145782_y(), true));
                            }
                            this.func_184185_a(IafSoundRegistry.GORGON_TURN_STONE, 1.0f, 1.0f);
                            this.func_70624_b(null);
                        }
                        if (attackTarget instanceof EntityDragonBase) {
                            dragon = (EntityDragonBase)attackTarget;
                            dragon.setFlying(false);
                            dragon.setHovering(false);
                        }
                        if (attackTarget instanceof EntityHippogryph) {
                            dragon = (EntityHippogryph)attackTarget;
                            dragon.setFlying(false);
                            dragon.setHovering(false);
                            dragon.airTarget = null;
                        }
                    }
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 25.0);
    }

    public int func_70646_bf() {
        return 10;
    }

    public int func_184649_cE() {
        return 10;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void forcePreyToLook(EntityLiving mob) {
        mob.func_70671_ap().func_75650_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, (float)mob.func_184649_cE(), (float)mob.func_70646_bf());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(IceAndFire.CONFIG.gorgonMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SCARE, ANIMATION_HIT};
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.GORGON_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return IafSoundRegistry.GORGON_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.GORGON_DIE;
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }
}

