/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.DragonFireEvent;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonFireCharge;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonSyncFire;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.Random;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityFireDragon
extends EntityDragonBase {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public static final ResourceLocation FEMALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/fire_dragon_female"));
    public static final ResourceLocation MALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/fire_dragon_male"));
    public static final ResourceLocation SKELETON_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/fire_dragon_skeleton"));
    public static Animation ANIMATION_FIRECHARGE;

    public EntityFireDragon(World worldIn) {
        super(worldIn, DragonType.FIRE, 1.0, 1 + IceAndFire.CONFIG.dragonAttackDamage, (double)IceAndFire.CONFIG.dragonHealth * 0.04, IceAndFire.CONFIG.dragonHealth, 0.15f, 0.4f);
        this.func_70105_a(0.78f, 1.2f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.field_70178_ae = true;
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)30);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "red_";
            }
            case 1: {
                return "green_";
            }
            case 2: {
                return "bronze_";
            }
            case 3: 
        }
        return "gray_";
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return IafItemRegistry.dragonscales_red;
            }
            case 1: {
                return IafItemRegistry.dragonscales_green;
            }
            case 2: {
                return IafItemRegistry.dragonscales_bronze;
            }
            case 3: 
        }
        return IafItemRegistry.dragonscales_gray;
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return IafItemRegistry.dragonegg_red;
            }
            case 1: {
                return IafItemRegistry.dragonegg_green;
            }
            case 2: {
                return IafItemRegistry.dragonegg_bronze;
            }
            case 3: 
        }
        return IafItemRegistry.dragonegg_gray;
    }

    @Override
    public Item getSummoningCrystal() {
        return IafItemRegistry.summoning_crystal_fire;
    }

    @Override
    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.func_70671_ap().func_75651_a(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0), entityIn.func_174791_d().func_72441_c(0.0, (double)(entityIn.field_70131_O / 2.0f), 0.0)) && entityIn.field_70130_N < this.field_70130_N * 0.5f && this.func_184179_bs() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.func_184220_m((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            if (this.func_174813_aQ().func_72314_b((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70652_k((Entity)this.func_70638_az());
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.field_70122_E)) {
                this.shootFireAtMob(this.func_70638_az());
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.func_70068_e((Entity)this.func_70638_az()) < 100.0) {
                double difX = this.func_70638_az().field_70165_t - this.field_70165_t;
                double difY = this.func_70638_az().field_70163_u + (double)this.func_70638_az().field_70131_O - this.field_70163_u;
                double difZ = this.func_70638_az().field_70161_v - this.field_70161_v;
                this.field_70159_w += difX * 0.1;
                this.field_70181_x += difY * 0.1;
                this.field_70179_y += difZ * 0.1;
                if (this.func_174813_aQ().func_72314_b((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                    this.func_70652_k((Entity)this.func_70638_az());
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.func_177958_n() + 0.5f, (float)burningTarget.func_177956_o() + 0.5f, (float)burningTarget.func_177952_p() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.func_70681_au().nextInt(5) == 0 && !this.func_70631_g_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.field_70177_z = this.field_70761_aq;
                Vec3d headVec = this.getHeadPosition();
                this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                float inaccuracy = 1.0f;
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge(this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.setSizes(size, size);
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                RayTraceResult mop;
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(EntityLivingBase entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.func_70681_au().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 20) {
                    this.field_70177_z = this.field_70761_aq;
                    Vec3d headVec = this.getHeadPosition();
                    double d2 = entity.field_70165_t - headVec.field_72450_a;
                    double d3 = entity.field_70163_u - headVec.field_72448_b;
                    double d4 = entity.field_70161_v - headVec.field_72449_c;
                    float inaccuracy = 1.0f;
                    this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge(this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.setSizes(size, size);
                    entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    if (entity.field_70128_L) {
                        this.setBreathingFire(false);
                    }
                    this.randomizeAttacks();
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.field_70177_z = this.field_70761_aq;
                    if (this.field_70173_aa % 5 == 0) {
                        this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1);
                    if (entity.field_70128_L) {
                        this.setBreathingFire(false);
                        this.randomizeAttacks();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireEvent(this, burnX, burnY, burnZ))) {
            return;
        }
        if (syncType == 1 && !this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 2 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 3 && !this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType == 4 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.field_70177_z = this.field_70761_aq;
                Vec3d headVec = this.getHeadPosition();
                double d2 = burnX - headVec.field_72450_a;
                double d3 = burnY - headVec.field_72448_b;
                double d4 = burnZ - headVec.field_72449_c;
                float inaccuracy = 1.0f;
                this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge(this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.setSizes(size, size);
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
            return;
        }
        this.func_70661_as().func_75499_g();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vec3d headPos = this.getHeadPosition();
        double d2 = burnX - headPos.field_72450_a;
        double d3 = burnY - headPos.field_72448_b;
        double d4 = burnZ - headPos.field_72449_c;
        float particleScale = MathHelper.func_76131_a((float)(this.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f);
        double distance = Math.max(5.0 * this.func_70011_f(burnX, burnY, burnZ), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.field_72450_a + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.field_72448_b + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.field_72449_c + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(5) == 0) {
                    IceAndFire.PROXY.spawnDragonParticle("dragonfire", headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, 0.0, 0.0, 0.0, this);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                RayTraceResult result = this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(progressX, progressY, progressZ), false, true, false);
                BlockPos pos = result.func_178782_a();
                IafDragonDestructionManager.destroyAreaFire(this.field_70170_p, pos, this);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            if (!this.field_70170_p.field_72995_K) {
                IafDragonDestructionManager.destroyAreaFire(this.field_70170_p, new BlockPos(spawnX, spawnY, spawnZ), this);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_IDLE : (this.isAdult() ? IafSoundRegistry.FIREDRAGON_ADULT_IDLE : IafSoundRegistry.FIREDRAGON_CHILD_IDLE);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_HURT : (this.isAdult() ? IafSoundRegistry.FIREDRAGON_ADULT_HURT : IafSoundRegistry.FIREDRAGON_CHILD_HURT);
    }

    protected SoundEvent func_184615_bR() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_DEATH : (this.isAdult() ? IafSoundRegistry.FIREDRAGON_ADULT_DEATH : IafSoundRegistry.FIREDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? IafSoundRegistry.FIREDRAGON_TEEN_ROAR : (this.isAdult() ? IafSoundRegistry.FIREDRAGON_ADULT_ROAR : IafSoundRegistry.FIREDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR, ANIMATION_EPIC_ROAR};
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == IafItemRegistry.fire_stew;
    }

    @Override
    protected void spawnDeathParticles() {
        for (int k = 0; k < 3; ++k) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            if (!this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
        }
    }

    @Override
    protected void spawnBabyParticles() {
        for (int i = 0; i < 5; ++i) {
            float radiusAdd = (float)i * 0.15f;
            float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
            float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
            float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    protected ItemStack getSkull() {
        return new ItemStack(IafItemRegistry.dragon_skull);
    }

    @Override
    public void tryScorchTarget() {
        EntityLivingBase entity = this.func_70638_az();
        if (entity != null) {
            float distX = (float)(entity.field_70165_t - this.field_70165_t);
            float distZ = (float)(entity.field_70161_v - this.field_70161_v);
            if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.field_70177_z = this.field_70761_aq;
                    if (this.field_70173_aa % 5 == 0) {
                        this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(this.field_70165_t + (double)(distX * (float)this.fireTicks / 40.0f), entity.field_70163_u, this.field_70161_v + (double)(distZ * (float)this.fireTicks / 40.0f), 1);
                }
            } else {
                this.setBreathingFire(true);
            }
        }
    }
}

