/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.client.model.util.LegSolverQuadruped;
import com.github.alexthe666.iceandfire.entity.ChainEntityProperties;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IDeadMob;
import com.github.alexthe666.iceandfire.entity.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.IDropArmor;
import com.github.alexthe666.iceandfire.entity.IFlyingMount;
import com.github.alexthe666.iceandfire.entity.ISyncMount;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonFlightManager;
import com.github.alexthe666.iceandfire.entity.IafDragonLogic;
import com.github.alexthe666.iceandfire.entity.ReversedBuffer;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIEscort;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIMate;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIRide;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetNonTamed;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeInput;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemSummoningCrystal;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.message.MessageDragonSetBurnBlock;
import com.github.alexthe666.iceandfire.message.MessageStartRidingMob;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateDragon;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateFlyingCreature;
import com.github.alexthe666.iceandfire.world.DragonPosWorldData;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.ilexiconn.llibrary.server.entity.multipart.IMultipartEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityDragonBase
extends EntityTameable
implements ISyncMount,
IFlyingMount,
IMultipartEntity,
IAnimatedEntity,
IDragonFlute,
IDeadMob,
IVillagerFear,
IAnimalFear,
IDropArmor {
    public static final int FLIGHT_CHANCE_PER_TICK = 1500;
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> AGE_TICKS = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FIREBREATHING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOVERING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MODEL_DEAD = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DEATH_STAGE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> TACKLE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> AGINGDISABLED = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DRAGON_PITCH = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> CRYSTAL_BOUND = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public static Animation ANIMATION_WINGBLAST;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_EPIC_ROAR;
    public static Animation ANIMATION_TAILWHACK;
    public DragonType dragonType;
    public double minimumDamage;
    public double maximumDamage;
    public double minimumHealth;
    public double maximumHealth;
    public double minimumSpeed;
    public double maximumSpeed;
    public double minimumArmor;
    public double maximumArmor;
    public float sitProgress;
    public float sleepProgress;
    public float hoverProgress;
    public float flyProgress;
    public float fireBreathProgress;
    public float diveProgress;
    public float prevDiveProgress;
    public float prevFireBreathProgress;
    public int fireStopTicks;
    public int flyTicks;
    public float modelDeadProgress;
    public float ridingProgress;
    public float tackleProgress;
    public boolean isDaytime;
    public int flightCycle;
    public BlockPos homePos;
    public boolean hasHomePosition = false;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer roll_buffer;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer pitch_buffer;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer pitch_buffer_body;
    @SideOnly(value=Side.CLIENT)
    public ReversedBuffer turn_buffer;
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer tail_buffer;
    public int spacebarTicks;
    public float[][] growth_stages;
    public LegSolverQuadruped legSolver;
    public int walkCycle;
    public BlockPos burningTarget;
    public int burnProgress;
    public double burnParticleX;
    public double burnParticleY;
    public double burnParticleZ;
    public float prevDragonPitch;
    public IafDragonAttacks.Air airAttack;
    public IafDragonAttacks.Ground groundAttack;
    public boolean usingGroundAttack = true;
    public IafDragonLogic logic;
    public int hoverTicks;
    public int tacklingTicks;
    public int ticksStill;
    public int navigatorType;
    public InventoryBasic dragonInventory;
    public String prevArmorResLoc = "0|0|0|0";
    public String armorResLoc = "0|0|0|0";
    protected int flyHovering;
    protected IafDragonFlightManager flightManager;
    protected boolean hasHadHornUse = false;
    protected int fireTicks;
    protected int blockBreakCounter;
    private int prevFlightCycle;
    private boolean isSleeping;
    private boolean isSitting;
    private boolean isHovering;
    private boolean isFlying;
    private boolean isBreathingFire;
    private boolean isTackling;
    private boolean isModelDead;
    private int animationTick;
    private Animation currentAnimation;
    private float lastScale;
    private EntityDragonPart headPart;
    private EntityDragonPart neckPart;
    private EntityDragonPart rightWingUpperPart;
    private EntityDragonPart rightWingLowerPart;
    private EntityDragonPart leftWingUpperPart;
    private EntityDragonPart leftWingLowerPart;
    private EntityDragonPart tail1Part;
    private EntityDragonPart tail2Part;
    private EntityDragonPart tail3Part;
    private EntityDragonPart tail4Part;
    private boolean isOverAir;

    public EntityDragonBase(World world, DragonType type, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(world);
        this.initInventory();
        this.dragonType = type;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.minimumArmor = 1.0;
        this.maximumArmor = 20.0;
        ANIMATION_EAT = Animation.create((int)20);
        this.updateAttributes();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.pitch_buffer_body = new IFChainBuffer();
            this.turn_buffer = new ReversedBuffer();
            this.tail_buffer = new ChainBuffer();
        }
        this.legSolver = new LegSolverQuadruped(0.3f, 0.35f, 0.2f, 1.45f, 1.0f);
        this.flightManager = new IafDragonFlightManager(this);
        this.logic = this.createDragonLogic();
        this.field_70158_ak = true;
        this.switchNavigator(0);
        this.randomizeAttacks();
        this.resetParts(1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new DragonAIRide<EntityDragonBase>(this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DragonAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DragonAIEscort(this, 1.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DragonAIAttackMelee(this, 1.5, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AquaticAITempt((EntityCreature)this, 1.0, IafItemRegistry.fire_stew, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DragonAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new DragonAITargetNonTamed<EntityPlayer>(this, EntityPlayer.class, false, new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer entity) {
                return DragonUtils.canHostilesTarget((Entity)entity) && !entity.func_184812_l_();
            }
        }));
        this.field_70715_bh.func_75776_a(5, new DragonAITarget<Entity>(this, EntityLivingBase.class, true, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.canHostilesTarget(entity);
            }
        }));
        this.field_70715_bh.func_75776_a(6, new DragonAITargetItems((EntityCreature)this, false));
    }

    public void resetParts(float scale) {
        this.removeParts();
        this.headPart = new EntityDragonPart(this, 1.55f * scale, 0.0f, 0.6f * scale, 0.5f * scale, 0.35f * scale, 1.5f);
        this.neckPart = new EntityDragonPart(this, 0.85f * scale, 0.0f, 0.7f * scale, 0.5f * scale, 0.2f * scale, 1.0f);
        this.rightWingUpperPart = new EntityDragonPart(this, 1.0f * scale, 90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.rightWingLowerPart = new EntityDragonPart(this, 1.4f * scale, 100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.leftWingUpperPart = new EntityDragonPart(this, 1.0f * scale, -90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.leftWingLowerPart = new EntityDragonPart(this, 1.4f * scale, -100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.tail1Part = new EntityDragonPart(this, -0.75f * scale, 0.0f, 0.6f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail2Part = new EntityDragonPart(this, -1.15f * scale, 0.0f, 0.45f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail3Part = new EntityDragonPart(this, -1.5f * scale, 0.0f, 0.35f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail4Part = new EntityDragonPart(this, -1.95f * scale, 0.0f, 0.25f * scale, 0.45f * scale, 0.3f * scale, 1.5f);
    }

    public void removeParts() {
        if (this.headPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.headPart);
            this.headPart = null;
        }
        if (this.neckPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.neckPart);
            this.neckPart = null;
        }
        if (this.rightWingUpperPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.rightWingUpperPart);
            this.rightWingUpperPart = null;
        }
        if (this.rightWingLowerPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.rightWingLowerPart);
            this.rightWingLowerPart = null;
        }
        if (this.leftWingUpperPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.leftWingUpperPart);
            this.leftWingUpperPart = null;
        }
        if (this.leftWingLowerPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.leftWingLowerPart);
            this.leftWingLowerPart = null;
        }
        if (this.tail1Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail1Part);
            this.tail1Part = null;
        }
        if (this.tail2Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail2Part);
            this.tail2Part = null;
        }
        if (this.tail3Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail3Part);
            this.tail3Part = null;
        }
        if (this.tail4Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail4Part);
            this.tail4Part = null;
        }
    }

    public void updateParts() {
        if (this.headPart != null) {
            this.headPart.func_70071_h_();
        }
        if (this.neckPart != null) {
            this.neckPart.func_70071_h_();
        }
        if (this.rightWingUpperPart != null) {
            this.rightWingUpperPart.func_70071_h_();
        }
        if (this.rightWingLowerPart != null) {
            this.rightWingLowerPart.func_70071_h_();
        }
        if (this.leftWingUpperPart != null) {
            this.leftWingUpperPart.func_70071_h_();
        }
        if (this.leftWingLowerPart != null) {
            this.leftWingLowerPart.func_70071_h_();
        }
        if (this.tail1Part != null) {
            this.tail1Part.func_70071_h_();
        }
        if (this.tail2Part != null) {
            this.tail2Part.func_70071_h_();
        }
        if (this.tail3Part != null) {
            this.tail3Part.func_70071_h_();
        }
        if (this.tail4Part != null) {
            this.tail4Part.func_70071_h_();
        }
    }

    protected void updateBurnTarget() {
        if (!(this.burningTarget == null || this.isSleeping() || this.isModelDead() || this.func_70631_g_())) {
            if (this.field_70170_p.func_175625_s(this.burningTarget) != null && this.field_70170_p.func_175625_s(this.burningTarget) instanceof TileEntityDragonforgeInput && this.func_174818_b(this.burningTarget) < 300.0) {
                this.func_70671_ap().func_75650_a((double)this.burningTarget.func_177958_n() + 0.5, (double)this.burningTarget.func_177956_o() + 0.5, (double)this.burningTarget.func_177952_p() + 0.5, 180.0f, 180.0f);
                this.breathFireAtPos(this.burningTarget);
                this.setBreathingFire(true);
            } else {
                if (!this.field_70170_p.field_72995_K) {
                    IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageDragonSetBurnBlock(this.func_145782_y(), true, this.burningTarget));
                }
                this.burningTarget = null;
            }
        }
    }

    protected abstract void breathFireAtPos(BlockPos var1);

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateDragon(this, this.field_70170_p);
    }

    protected void switchNavigator(int navigatorType) {
        switch (navigatorType) {
            case 0: {
                this.field_70765_h = new IafDragonFlightManager.GroundMoveHelper((EntityLiving)this);
                this.field_70699_by = this.func_175447_b(this.field_70170_p);
                this.navigatorType = 0;
                break;
            }
            case 1: {
                this.field_70765_h = new IafDragonFlightManager.FlightMoveHelper(this);
                this.field_70699_by = new PathNavigateFlyingCreature((EntityLiving)this, this.field_70170_p);
                this.navigatorType = 1;
                break;
            }
            case 2: {
                this.field_70765_h = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityDragonBase>(this);
                this.field_70699_by = new PathNavigateFlyingCreature((EntityLiving)this, this.field_70170_p);
                this.navigatorType = 2;
                break;
            }
            default: {
                IceAndFire.logger.warn("Invalid navigator type " + navigatorType);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.breakBlock();
    }

    public boolean canDestroyBlock(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_177230_c().canEntityDestroy(this.field_70170_p.func_180495_p(pos), (IBlockAccess)this.field_70170_p, pos, (Entity)this);
    }

    @Override
    public boolean isMobDead() {
        return this.isModelDead();
    }

    public int func_184649_cE() {
        return 10 * this.getDragonStage() / 5;
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            playerEntity.openGui((Object)IceAndFire.INSTANCE, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public int func_70627_aG() {
        return 90;
    }

    protected void func_70609_aI() {
        this.field_70725_aQ = 0;
        if (!this.isModelDead() && !this.field_70170_p.field_72995_K && this.field_70718_bc > 0) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
        this.setModelDead(true);
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            this.func_70106_y();
            for (int k = 0; k < 40; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (!this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
            this.spawnDeathParticles();
        }
    }

    protected void spawnDeathParticles() {
    }

    protected void spawnBabyParticles() {
    }

    public void func_70106_y() {
        this.removeParts();
        super.func_70106_y();
    }

    protected int func_70693_a(EntityPlayer player) {
        switch (this.getDragonStage()) {
            case 2: {
                return 20;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 300;
            }
            case 5: {
                return 650;
            }
        }
        return 5;
    }

    public int getArmorOrdinal(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() != null) {
            if (stack.func_77973_b() == IafItemRegistry.dragon_armor_iron) {
                return 1;
            }
            if (stack.func_77973_b() == IafItemRegistry.dragon_armor_gold) {
                return 2;
            }
            if (stack.func_77973_b() == IafItemRegistry.dragon_armor_diamond) {
                return 3;
            }
            if (stack.func_77973_b() == IafItemRegistry.dragon_armor_silver) {
                return 4;
            }
            if (stack.func_77973_b() == IafItemRegistry.dragon_armor_dragonsteel_fire) {
                return 5;
            }
            if (stack.func_77973_b() == IafItemRegistry.dragon_armor_dragonsteel_ice) {
                return 6;
            }
        }
        return 0;
    }

    public boolean func_175446_cd() {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        return this.isModelDead() || properties == null || properties.isStone || super.func_175446_cd();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNGER, (Object)0);
        this.field_70180_af.func_187214_a(AGE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(FIREBREATHING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(HOVERING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(FLYING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(DEATH_STAGE, (Object)0);
        this.field_70180_af.func_187214_a(MODEL_DEAD, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(TACKLE, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(AGINGDISABLED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(DRAGON_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(CRYSTAL_BOUND, (Object)Boolean.FALSE);
    }

    @Override
    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean strike() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 4 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        this.func_70904_g(command == 1);
    }

    public float getDragonPitch() {
        return ((Float)this.field_70180_af.func_187225_a(DRAGON_PITCH)).floatValue();
    }

    public void setDragonPitch(float pitch) {
        this.field_70180_af.func_187227_b(DRAGON_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementDragonPitch(float pitch) {
        this.field_70180_af.func_187227_b(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() + pitch));
    }

    public void decrementDragonPitch(float pitch) {
        this.field_70180_af.func_187227_b(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() - pitch));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74768_a("AgeTicks", this.getAgeInTicks());
        compound.func_74757_a("Gender", this.isMale());
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Sleeping", this.isSleeping());
        compound.func_74757_a("TamedDragon", this.func_70909_n());
        compound.func_74757_a("FireBreathing", this.isBreathingFire());
        compound.func_74757_a("AttackDecision", this.usingGroundAttack);
        compound.func_74757_a("Hovering", this.isHovering());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("DeathStage", this.getDeathStage());
        compound.func_74757_a("ModelDead", this.isModelDead());
        compound.func_74776_a("DeadProg", this.modelDeadProgress);
        compound.func_74757_a("Tackle", this.isTackling());
        if (this.func_95999_t() != null && !this.func_95999_t().isEmpty()) {
            compound.func_74778_a("CustomName", this.func_95999_t());
        }
        compound.func_74757_a("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.func_74768_a("HomeAreaX", this.homePos.func_177958_n());
            compound.func_74768_a("HomeAreaY", this.homePos.func_177956_o());
            compound.func_74768_a("HomeAreaZ", this.homePos.func_177952_p());
        }
        compound.func_74757_a("AgingDisabled", this.isAgingDisabled());
        compound.func_74768_a("Command", this.getCommand());
        if (this.dragonInventory != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.dragonInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.dragonInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        compound.func_74757_a("CrystalBound", this.isBoundToCrystal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setAgeInTicks(compound.func_74762_e("AgeTicks"));
        this.setGender(compound.func_74767_n("Gender"));
        this.setVariant(compound.func_74762_e("Variant"));
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.func_70903_f(compound.func_74767_n("TamedDragon"));
        this.setBreathingFire(compound.func_74767_n("FireBreathing"));
        this.usingGroundAttack = compound.func_74767_n("AttackDecision");
        this.setHovering(compound.func_74767_n("Hovering"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setDeathStage(compound.func_74762_e("DeathStage"));
        this.setModelDead(compound.func_74767_n("ModelDead"));
        this.modelDeadProgress = compound.func_74760_g("DeadProg");
        if (!compound.func_74779_i("CustomName").isEmpty()) {
            this.func_96094_a(compound.func_74779_i("CustomName"));
        }
        this.hasHomePosition = compound.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new BlockPos(compound.func_74762_e("HomeAreaX"), compound.func_74762_e("HomeAreaY"), compound.func_74762_e("HomeAreaZ"));
        }
        this.setTackling(compound.func_74767_n("Tackle"));
        this.setAgingDisabled(compound.func_74767_n("AgingDisabled"));
        this.setCommand(compound.func_74762_e("Command"));
        if (this.dragonInventory != null) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j > 4) continue;
                this.dragonInventory.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        } else {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.dragonInventory.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        }
        this.setCrystalBound(compound.func_74767_n("CrystalBound"));
    }

    private void initInventory() {
        this.dragonInventory = new InventoryBasic("dragonInventory", false, 5);
        this.dragonInventory.func_110133_a(this.func_70005_c_());
        if (this.dragonInventory != null) {
            for (int j = 0; j < this.dragonInventory.func_70302_i_(); ++j) {
                ItemStack itemstack = this.dragonInventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.dragonInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer) || this.func_70638_az() == passenger) continue;
            EntityPlayer player = (EntityPlayer)passenger;
            if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public boolean isRidingPlayer(EntityPlayer player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Override
    @Nullable
    public EntityPlayer getRidingPlayer() {
        if (this.func_184179_bs() instanceof EntityPlayer) {
            return (EntityPlayer)this.func_184179_bs();
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)Math.min(2048, IceAndFire.CONFIG.dragonTargetSearchLength));
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    protected void updateAttributes() {
        this.prevArmorResLoc = this.armorResLoc;
        int armorHead = this.getArmorOrdinal(this.func_184582_a(EntityEquipmentSlot.HEAD));
        int armorNeck = this.getArmorOrdinal(this.func_184582_a(EntityEquipmentSlot.CHEST));
        int armorLegs = this.getArmorOrdinal(this.func_184582_a(EntityEquipmentSlot.LEGS));
        int armorFeet = this.getArmorOrdinal(this.func_184582_a(EntityEquipmentSlot.FEET));
        this.armorResLoc = this.dragonType.getName() + "|" + armorHead + "|" + armorNeck + "|" + armorLegs + "|" + armorFeet;
        IceAndFire.PROXY.updateDragonArmorRender(this.armorResLoc);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
        double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        if (this.getAgeInDays() <= 125) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(this.minimumHealth + healthStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(this.minimumDamage + attackStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.minimumSpeed + speedStep * (double)this.getAgeInDays());
            double oldValue = this.minimumArmor + armorStep * (double)this.getAgeInDays();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(oldValue + this.calculateArmorModifier());
        }
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)MathHelper.func_76125_a((int)hunger, (int)0, (int)100));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.field_70180_af.func_187225_a(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.field_70180_af.func_187227_b(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(GENDER);
    }

    public boolean isModelDead() {
        if (this.field_70170_p.field_72995_K) {
            this.isModelDead = (Boolean)this.field_70180_af.func_187225_a(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public void setModelDead(boolean modeldead) {
        this.field_70180_af.func_187227_b(MODEL_DEAD, (Object)modeldead);
        if (!this.field_70170_p.field_72995_K) {
            this.isModelDead = modeldead;
        }
    }

    @Override
    public boolean isHovering() {
        if (this.field_70170_p.field_72995_K) {
            this.isHovering = (Boolean)this.field_70180_af.func_187225_a(HOVERING);
            return this.isHovering;
        }
        return this.isHovering;
    }

    public void setHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(HOVERING, (Object)hovering);
        if (!this.field_70170_p.field_72995_K) {
            this.isHovering = hovering;
        }
    }

    @Override
    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public boolean useFlyingPathFinder() {
        return this.isFlying();
    }

    public void setGender(boolean male) {
        this.field_70180_af.func_187227_b(GENDER, (Object)male);
    }

    public boolean isSleeping() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSleeping;
            this.isSleeping = isSleeping = ((Boolean)this.field_70180_af.func_187225_a(SLEEPING)).booleanValue();
            return isSleeping;
        }
        return this.isSleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
        if (!this.field_70170_p.field_72995_K) {
            this.isSleeping = sleeping;
        }
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public boolean isBreathingFire() {
        if (this.field_70170_p.field_72995_K) {
            boolean breathing;
            this.isBreathingFire = breathing = ((Boolean)this.field_70180_af.func_187225_a(FIREBREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathingFire;
    }

    public void setBreathingFire(boolean breathing) {
        this.field_70180_af.func_187227_b(FIREBREATHING, (Object)breathing);
        if (!this.field_70170_p.field_72995_K) {
            this.isBreathingFire = breathing;
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void riderShootFire(Entity controller) {
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        this.setHunger(this.getHunger() + FoodUtils.getFoodPoints((Entity)entity));
    }

    private double calculateArmorModifier() {
        EntityEquipmentSlot[] slots;
        double val = 1.0;
        block8: for (EntityEquipmentSlot slot : slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET}) {
            switch (this.getArmorOrdinal(this.func_184582_a(slot))) {
                case 1: {
                    val += 2.0;
                    continue block8;
                }
                case 2: {
                    val += 3.0;
                    continue block8;
                }
                case 3: {
                    val += 5.0;
                    continue block8;
                }
                case 4: {
                    val += 3.0;
                    continue block8;
                }
                case 5: {
                    val += 10.0;
                    continue block8;
                }
                case 6: {
                    val += 10.0;
                }
            }
        }
        return val;
    }

    public boolean canMove() {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if (properties != null && properties.isStone) {
            return false;
        }
        return !this.func_70906_o() && !this.isSleeping() && this.func_184179_bs() == null && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == IafItemRegistry.dragon_horn) {
            return false;
        }
        int lastDeathStage = this.getAgeInDays() / 5;
        if (stack.func_77973_b() == IafItemRegistry.dragon_debug_stick) {
            this.logic.debug();
            return true;
        }
        if (this.isModelDead() && this.getDeathStage() < lastDeathStage && player.field_71075_bZ.field_75099_e) {
            if (!this.field_70170_p.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == Items.field_151069_bo && this.getDeathStage() < lastDeathStage / 2 && IceAndFire.CONFIG.dragonDropBlood) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.setDeathStage(this.getDeathStage() + 1);
                player.field_71071_by.func_70441_a(new ItemStack(this instanceof EntityFireDragon ? IafItemRegistry.fire_dragon_blood : IafItemRegistry.ice_dragon_blood, 1));
                return true;
            }
            if (!this.field_70170_p.field_72995_K && stack.func_190926_b() && IceAndFire.CONFIG.dragonDropSkull) {
                if (this.getDeathStage() == lastDeathStage - 1) {
                    ItemStack skull = this.getSkull().func_77946_l();
                    skull.func_77982_d(new NBTTagCompound());
                    skull.func_77978_p().func_74768_a("Stage", this.getDragonStage());
                    skull.func_77978_p().func_74768_a("DragonType", 0);
                    skull.func_77978_p().func_74768_a("DragonAge", this.getAgeInDays());
                    this.setDeathStage(this.getDeathStage() + 1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70099_a(skull, 1.0f);
                    }
                    this.func_70106_y();
                } else if (this.getDeathStage() == lastDeathStage / 2 - 1 && IceAndFire.CONFIG.dragonDropHeart) {
                    ItemStack heart = new ItemStack(this instanceof EntityFireDragon ? IafItemRegistry.fire_dragon_heart : IafItemRegistry.ice_dragon_heart, 1);
                    ItemStack egg = new ItemStack(this.getVariantEgg(this.field_70146_Z.nextInt(4)), 1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70099_a(heart, 1.0f);
                        if (!this.isMale() && this.getDragonStage() > 3) {
                            this.func_70099_a(egg, 1.0f);
                        }
                    }
                    this.setDeathStage(this.getDeathStage() + 1);
                } else {
                    this.setDeathStage(this.getDeathStage() + 1);
                    ItemStack drop = this.getRandomDrop();
                    if (!drop.func_190926_b() && !this.field_70170_p.field_72995_K) {
                        this.func_70099_a(drop, 1.0f);
                    }
                }
            }
            return true;
        }
        if (!this.isModelDead()) {
            if (stack.func_77973_b() == IafItemRegistry.creative_dragon_meal) {
                this.func_193101_c(player);
                this.setHunger(this.getHunger() + 20);
                this.func_70691_i(Math.min(this.func_110143_aJ(), (float)((int)(this.func_110138_aP() / 2.0f))));
                this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                this.spawnItemCrackParticles(stack.func_77973_b());
                this.spawnItemCrackParticles(Items.field_151103_aS);
                this.spawnItemCrackParticles(Items.field_151100_aR);
                this.eatFoodBonus(stack);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return true;
            }
            if (this.func_70877_b(stack) && this.isAdult()) {
                this.func_70873_a(0);
                this.func_175505_a(player, stack);
                this.func_146082_f(player);
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player)) {
                if (stack.func_77973_b() == this.getSummoningCrystal() && !ItemSummoningCrystal.hasDragon(stack)) {
                    this.setCrystalBound(true);
                    NBTTagCompound compound = stack.func_77978_p();
                    if (compound == null) {
                        compound = new NBTTagCompound();
                        stack.func_77982_d(compound);
                    }
                    NBTTagCompound dragonTag = new NBTTagCompound();
                    dragonTag.func_186854_a("DragonUUID", this.func_110124_au());
                    dragonTag.func_74778_a("CustomName", this.func_95999_t());
                    compound.func_74782_a("Dragon", (NBTBase)dragonTag);
                    this.func_184185_a(SoundEvents.field_187618_I, 1.0f, 1.0f);
                    player.func_184609_a(hand);
                    return true;
                }
                this.func_193101_c(player);
                StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
                if (stack.func_190926_b() && !player.func_70093_af()) {
                    if (this.getDragonStage() < 2) {
                        this.func_184205_a((Entity)player, true);
                    }
                    if (!this.hasHadHornUse && this.getDragonStage() > 2 && !player.func_184218_aH()) {
                        player.func_70095_a(false);
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_184205_a((Entity)this, true);
                        }
                        if (this.field_70170_p.field_72995_K) {
                            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageStartRidingMob(this.func_145782_y(), true));
                        }
                        this.setSleeping(false);
                    }
                    return true;
                }
                if (stack.func_190926_b() && player.func_70093_af()) {
                    this.openGUI(player);
                    return true;
                }
                int itemFoodAmount = FoodUtils.getFoodPoints(stack, true, this.dragonType.isPiscivore());
                if (itemFoodAmount > 0 && (this.getHunger() < 100 || this.func_110143_aJ() < this.func_110138_aP())) {
                    this.setHunger(this.getHunger() + itemFoodAmount);
                    this.func_70606_j(Math.min(this.func_110138_aP(), (float)((int)(this.func_110143_aJ() + (float)(itemFoodAmount / 10)))));
                    this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                    this.spawnItemCrackParticles(stack.func_77973_b());
                    this.eatFoodBonus(stack);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == IafItemRegistry.dragon_meal) {
                    this.growDragon(1);
                    this.setHunger(this.getHunger() + 20);
                    this.func_70691_i(Math.min(this.func_110143_aJ(), (float)((int)(this.func_110138_aP() / 2.0f))));
                    this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                    this.spawnItemCrackParticles(stack.func_77973_b());
                    this.spawnItemCrackParticles(Items.field_151103_aS);
                    this.spawnItemCrackParticles(Items.field_151100_aR);
                    this.eatFoodBonus(stack);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == IafItemRegistry.sickly_dragon_meal && !this.isAgingDisabled()) {
                    this.setHunger(this.getHunger() + 20);
                    this.func_70691_i(this.func_110138_aP());
                    this.func_184185_a(SoundEvents.field_187942_hp, this.func_70599_aP(), this.func_70647_i());
                    this.spawnItemCrackParticles(stack.func_77973_b());
                    this.spawnItemCrackParticles(Items.field_151103_aS);
                    this.spawnItemCrackParticles(Items.field_151100_aR);
                    this.spawnItemCrackParticles(Items.field_151170_bI);
                    this.spawnItemCrackParticles(Items.field_151170_bI);
                    this.setAgingDisabled(true);
                    this.eatFoodBonus(stack);
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                if (stack.func_77973_b() == IafItemRegistry.dragon_stick) {
                    if (player.func_70093_af()) {
                        BlockPos pos;
                        if (this.hasHomePosition) {
                            this.hasHomePosition = false;
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("dragon.command.remove_home", new Object[0]), true);
                            return true;
                        }
                        this.homePos = pos = new BlockPos((Entity)this);
                        this.hasHomePosition = true;
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("dragon.command.new_home", new Object[]{this.homePos.func_177958_n(), this.homePos.func_177956_o(), this.homePos.func_177952_p()}), true);
                        return true;
                    }
                    this.func_184185_a(SoundEvents.field_187945_hs, this.func_70599_aP(), this.func_70647_i());
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() > 2) {
                        this.setCommand(0);
                    }
                    String commandText = "stand";
                    if (this.getCommand() == 1) {
                        commandText = "sit";
                    }
                    if (this.getCommand() == 2) {
                        commandText = "escort";
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("dragon.command." + commandText, new Object[0]), true);
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected ItemStack getSkull() {
        return ItemStack.field_190927_a;
    }

    private ItemStack getRandomDrop() {
        ItemStack stack = this.getItemFromLootTable();
        if (stack.func_77973_b() == IafItemRegistry.dragonbone) {
            this.func_184185_a(SoundEvents.field_187854_fc, 1.0f, 1.0f);
        } else {
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
        }
        return stack;
    }

    public boolean canPositionBeSeen(double x, double y, double z) {
        return this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(x, y, z), false, true, false) == null;
    }

    public abstract ResourceLocation getDeadLootTable();

    public ItemStack getItemFromLootTable() {
        List loot;
        LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(this.getDeadLootTable());
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(DamageSource.field_76377_j);
        if (this.field_70717_bb != null) {
            lootcontext$builder = lootcontext$builder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
        }
        if ((loot = loottable.func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a())).isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)loot.get(0);
    }

    public void eatFoodBonus(ItemStack stack) {
    }

    protected void func_70623_bb() {
        if (!IceAndFire.CONFIG.canDragonsDespawn) {
            super.func_70623_bb();
        }
    }

    public void growDragon(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.func_98054_a(false);
        this.func_174829_m();
        if (this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float f = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
                float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
                float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
                if (this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ, new int[0]);
                }
                ++i;
            }
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.func_70681_au().nextGaussian() * 0.07;
            double motionY = this.func_70681_au().nextGaussian() * 0.07;
            double motionZ = this.func_70681_au().nextGaussian() * 0.07;
            Vec3d headVec = this.getHeadPosition();
            if (!this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c, motionX, motionY, motionZ, new int[]{Item.func_150891_b((Item)item)});
        }
    }

    public boolean isDaytime() {
        return this.field_70170_p.func_72935_r();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStuck() {
        if (this.isChained()) return false;
        if (this.func_70909_n()) return false;
        if (this.func_70661_as().func_75500_f()) return false;
        if (this.func_70661_as().func_75505_d() != null) {
            if (this.func_70661_as().func_75505_d().func_75870_c() == null) return false;
            BlockPos blockPos = new BlockPos(this.func_70661_as().func_75505_d().func_75870_c().field_75839_a, this.func_70661_as().func_75505_d().func_75870_c().field_75837_b, this.func_70661_as().func_75505_d().func_75870_c().field_75838_c);
            if (!(this.func_174818_b(blockPos) > 15.0)) return false;
        }
        if (this.ticksStill <= 80) return false;
        if (this.isHovering()) return false;
        if (!this.canMove()) return false;
        return true;
    }

    protected boolean isOverAir() {
        return this.isOverAir;
    }

    private boolean isOverAirLogic() {
        return this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v));
    }

    public boolean isDiving() {
        return false;
    }

    public boolean isBeyondHeight() {
        if (this.field_70163_u > (double)this.field_70170_p.func_72800_K()) {
            return true;
        }
        return this.field_70163_u > (double)IceAndFire.CONFIG.maxDragonFlight;
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0 || IceAndFire.CONFIG.dragonBreakBlockCooldown == 0) {
            int flightModifier;
            --this.blockBreakCounter;
            int bounds = 1;
            int n = flightModifier = this.isFlying() && this.func_70638_az() != null ? -1 : 1;
            if (!(this.blockBreakCounter != 0 && IceAndFire.CONFIG.dragonBreakBlockCooldown != 0 || !ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) || IceAndFire.CONFIG.dragonGriefing == 2 || this.func_70909_n() && !IceAndFire.CONFIG.tamedDragonGriefing)) {
                float hardness;
                float f = hardness = IceAndFire.CONFIG.dragonGriefing == 1 || this.getDragonStage() <= 3 ? 2.0f : 5.0f;
                if (!this.isModelDead() && this.getDragonStage() >= 3 && (this.canMove() || this.func_184179_bs() != null)) {
                    for (int a = (int)Math.floor(this.func_174813_aQ().field_72340_a) - bounds; a <= (int)Math.ceil(this.func_174813_aQ().field_72336_d) + bounds; ++a) {
                        for (int b = (int)Math.floor(this.func_174813_aQ().field_72338_b) + flightModifier; b <= (int)Math.ceil(this.func_174813_aQ().field_72337_e) + bounds + 1 && b <= 127; ++b) {
                            for (int c = (int)Math.floor(this.func_174813_aQ().field_72339_c) - bounds; c <= (int)Math.ceil(this.func_174813_aQ().field_72334_f) + bounds; ++c) {
                                BlockPos pos;
                                IBlockState state;
                                if (MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((EntityLiving)this, a, b, c)) || !(state = this.field_70170_p.func_180495_p(pos = new BlockPos(a, b, c))).func_185904_a().func_76230_c() || !(state.func_185887_b(this.field_70170_p, pos) >= 0.0f) || !(state.func_185887_b(this.field_70170_p, pos) <= hardness) || !DragonUtils.canDragonBreak(state.func_177230_c()) || !this.canDestroyBlock(pos)) continue;
                                this.field_70159_w *= 0.6;
                                this.field_70179_y *= 0.6;
                                if (this.field_70170_p.field_72995_K) continue;
                                this.field_70170_p.func_175655_b(pos, (double)this.field_70146_Z.nextFloat() <= IceAndFire.CONFIG.dragonBlockBreakingDropChance && DragonUtils.canDropFromDragonBlockBreak(state));
                            }
                        }
                    }
                }
            }
        }
    }

    public void spawnGroundEffects() {
        int i = 0;
        while ((float)i < this.getRenderSize()) {
            for (int i1 = 0; i1 < 20; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                BlockPos ground = this.getGround(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + extraX)), MathHelper.func_76128_c((double)(this.field_70163_u + extraY)) - 1, MathHelper.func_76128_c((double)(this.field_70161_v + extraZ))));
                IBlockState iblockstate = this.field_70170_p.func_180495_p(ground);
                if (iblockstate.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_175682_a(EnumParticleTypes.BLOCK_CRACK, true, this.field_70165_t + extraX, (double)ground.func_177956_o() + extraY, this.field_70161_v + extraZ, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
            ++i;
        }
    }

    private BlockPos getGround(BlockPos blockPos) {
        while (this.field_70170_p.func_175623_d(blockPos) && blockPos.func_177956_o() > 1) {
            blockPos = blockPos.func_177977_b();
        }
        return blockPos;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean isActuallyBreathingFire() {
        return this.fireTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        return this.flyTicks > 6000 || this.down() || this.flyTicks > 40 && this.flyProgress == 0.0f || properties != null && properties.isStone || this.isChained() && this.flyTicks > 100 || this.airAttack == IafDragonAttacks.Air.TACKLE && this.func_70638_az() != null;
    }

    public abstract String getVariantName(int var1);

    public boolean shouldRiderSit() {
        return this.func_184179_bs() != null;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            if (this.func_184179_bs() == null || !this.func_184179_bs().func_110124_au().equals(passenger.func_110124_au())) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.func_184210_p();
                }
                this.field_70761_aq = this.field_70177_z;
                this.field_70177_z = passenger.field_70177_z;
                Vec3d riderPos = this.getRiderPosition();
                passenger.func_70107_b(riderPos.field_72450_a, riderPos.field_72448_b + (double)passenger.field_70131_O, riderPos.field_72449_c);
                this.field_70138_W = 1.0f;
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        float bob = (float)(Math.sin(f * speed) * (double)f1 * (double)degree - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    protected void updatePreyInMouth(Entity prey) {
        this.setAnimation(ANIMATION_SHAKEPREY);
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null) {
            prey.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), prey instanceof EntityPlayer ? 17.0f : (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 4.0f);
            prey.func_184210_p();
        }
        this.field_70761_aq = this.field_70177_z;
        float modTick_0 = this.getAnimationTick() - 25;
        float modTick_1 = this.getAnimationTick() > 25 && this.getAnimationTick() < 55 ? 8.0f * MathHelper.func_76131_a((float)MathHelper.func_76126_a((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
        float modTick_2 = this.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, this.getAnimationTick() - 20);
        float radius = 0.75f * (0.6f * this.getRenderSize() / 3.0f) * -3.0f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f + modTick_1 * 2.0f * 0.015f;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(this.getRenderSize() / 3.0f));
        prey.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() < 4 && this.getDragonStage() > 2;
    }

    public boolean isAdult() {
        return this.getDragonStage() >= 4;
    }

    public boolean func_70631_g_() {
        return this.getDragonStage() < 2;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setGender(this.func_70681_au().nextBoolean());
        int age = this.func_70681_au().nextInt(80) + 1;
        this.growDragon(age);
        this.setVariant(new Random().nextInt(4));
        this.setSleeping(false);
        this.updateAttributes();
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.func_70691_i(Math.round(this.minimumHealth + healthStep * (double)age));
        this.usingGroundAttack = true;
        this.setHunger(50);
        return livingdata;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.isModelDead()) {
            return false;
        }
        if (this.func_184207_aI() && dmg.func_76346_g() != null && this.func_184179_bs() != null && dmg.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        if ((dmg.field_76373_n.contains("arrow") || this.func_184187_bx() != null && dmg.func_76346_g() != null && dmg.func_76346_g().func_70028_i(this.func_184187_bx())) && this.func_184218_aH()) {
            return false;
        }
        if (dmg == DamageSource.field_76368_d || dmg == DamageSource.field_82729_p) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && dmg.func_76346_g() != null && this.func_70681_au().nextInt(4) == 0) {
            this.roar();
        }
        if (i > 0.0f && this.isSleeping()) {
            this.setSleeping(false);
            if (!this.func_70909_n() && dmg.func_76346_g() instanceof EntityPlayer) {
                this.func_70624_b((EntityLivingBase)((EntityPlayer)dmg.func_76346_g()));
            }
        }
        return super.func_70097_a(dmg, i);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateParts();
        this.prevDragonPitch = this.getDragonPitch();
        this.func_98054_a(true);
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        this.field_70170_p.field_72984_F.func_76320_a("dragonLogic");
        this.isOverAir = this.isOverAirLogic();
        this.logic.updateDragonCommon();
        if (this.isModelDead()) {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v)) && this.field_70163_u > -1.0) {
                this.func_70091_d(MoverType.SELF, 0.0, -0.2f, 0.0);
            }
            this.setBreathingFire(false);
        } else if (this.field_70170_p.field_72995_K) {
            this.logic.updateDragonClient();
        } else {
            this.logic.updateDragonServer();
            this.logic.updateDragonAttack();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("dragonFlight");
        if (this.isFlying() && !this.field_70170_p.field_72995_K) {
            this.flightManager.update();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public void func_70636_d() {
        super.func_70636_d();
        float f = this.field_70138_W = this.getDragonStage() > 1 ? 1.5f : 1.0f;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (this.func_184207_aI() && this.isModelDead()) {
            this.func_184226_ay();
        }
        if (this.isModelDead()) {
            this.setHovering(false);
            this.setFlying(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.animationTick > this.getAnimation().getDuration() && !this.field_70170_p.field_72995_K) {
            this.animationTick = 0;
        }
    }

    public void func_98054_a(boolean par1) {
        float scale = Math.min(this.getRenderSize() * 0.35f, 7.0f);
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        float localWidth = this.field_70130_N;
        this.func_98055_j(scale);
        if (this.field_70130_N > localWidth && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
            this.func_70107_b(prevX, prevY, prevZ);
        }
        if (scale != this.lastScale) {
            this.resetParts(this.getRenderSize() / 3.0f);
        }
        this.lastScale = scale;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public float getRenderSize() {
        float step = (this.growth_stages[this.getDragonStage() - 1][1] - this.growth_stages[this.getDragonStage() - 1][0]) / 25.0f;
        if (this.getAgeInDays() > 125) {
            return this.growth_stages[this.getDragonStage() - 1][0] + step * 25.0f;
        }
        return this.growth_stages[this.getDragonStage() - 1][0] + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_70671_ap().func_75651_a(entityIn, 30.0f, 30.0f);
        if (this.isTackling()) {
            return false;
        }
        if (this.isModelDead()) {
            return false;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70098_U() {
        super.func_70098_U();
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity.field_70128_L) {
            this.func_184210_p();
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.func_184218_aH()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.func_184196_w((Entity)this) && riding instanceof EntityPlayer) {
            int i = riding.func_184188_bt().indexOf(this);
            float radius = (i == 2 ? -0.2f : 0.5f) + (float)(((EntityPlayer)riding).func_184613_cA() ? 2 : 0);
            float angle = (float)Math.PI / 180 * ((EntityPlayer)riding).field_70761_aq + (float)(i == 1 ? 90 : (i == 0 ? -90 : 0));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = (riding.func_70093_af() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.field_70759_as = ((EntityPlayer)riding).field_70759_as;
            this.field_70126_B = ((EntityPlayer)riding).field_70759_as;
            this.func_70080_a(riding.field_70165_t + extraX, riding.field_70163_u + extraY, riding.field_70161_v + extraZ, ((EntityPlayer)riding).field_70759_as, 0.0f);
            if ((riding.func_70093_af() || ((EntityPlayer)riding).func_184613_cA()) && !riding.func_184218_aH()) {
                this.func_184210_p();
                if (this.field_70170_p.field_72995_K) {
                    IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), this.getControlState(), this.field_70165_t, this.field_70163_u, this.field_70161_v));
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void func_70642_aH() {
        if (!(this.isSleeping() || this.isModelDead() || this.field_70170_p.field_72995_K)) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_70642_aH();
        }
    }

    protected void func_184581_c(DamageSource source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_184581_c(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal instanceof EntityDragonBase && otherAnimal != this && otherAnimal.getClass() == this.getClass()) {
            EntityDragonBase dragon = (EntityDragonBase)otherAnimal;
            return this.isMale() && !dragon.isMale() || !this.isMale() && dragon.isMale();
        }
        return false;
    }

    public EntityDragonEgg createEgg(EntityDragonBase ageable) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        EntityDragonEgg dragon = new EntityDragonEgg(this.field_70170_p);
        dragon.setType(EnumDragonEgg.byMetadata(MathHelper.func_76125_a((int)this.func_70681_au().nextInt(4), (int)0, (int)3) + this.getStartMetaForType()));
        dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
        return dragon;
    }

    public int getStartMetaForType() {
        return 0;
    }

    public boolean isTargetBlocked(Vec3d target) {
        RayTraceResult rayTrace;
        if (target != null && (rayTrace = this.field_70170_p.func_72901_a(new Vec3d((Vec3i)this.func_180425_c()), target, false)) != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (!this.field_70170_p.func_175623_d(sidePos)) {
                return true;
            }
            if (!this.field_70170_p.func_175623_d(pos)) {
                return true;
            }
            return rayTrace != null && rayTrace.field_72313_a != RayTraceResult.Type.BLOCK;
        }
        return false;
    }

    private double getFlySpeed() {
        return (2 + this.getAgeInDays() / 125 * 2) * (this.isTackling() ? 2 : 1);
    }

    public boolean isTackling() {
        if (this.field_70170_p.field_72995_K) {
            boolean tackling;
            this.isTackling = tackling = ((Boolean)this.field_70180_af.func_187225_a(TACKLE)).booleanValue();
            return tackling;
        }
        return this.isTackling;
    }

    public void setTackling(boolean tackling) {
        this.field_70180_af.func_187227_b(TACKLE, (Object)tackling);
        if (!this.field_70170_p.field_72995_K) {
            this.isTackling = tackling;
        }
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(AGINGDISABLED);
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.field_70180_af.func_187227_b(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public boolean isBoundToCrystal() {
        return (Boolean)this.field_70180_af.func_187225_a(CRYSTAL_BOUND);
    }

    public void setCrystalBound(boolean crystalBound) {
        this.field_70180_af.func_187227_b(CRYSTAL_BOUND, (Object)crystalBound);
    }

    public float getDistanceSquared(Vec3d vec3d) {
        float f = (float)(this.field_70165_t - vec3d.field_72450_a);
        float f1 = (float)(this.field_70163_u - vec3d.field_72448_b);
        float f2 = (float)(this.field_70161_v - vec3d.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    public abstract Item getVariantScale(int var1);

    public abstract Item getVariantEgg(int var1);

    public abstract Item getSummoningCrystal();

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((EntityPlayer)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(IafKeybindRegistry.dragon_down.func_151470_d());
            this.attack(IafKeybindRegistry.dragon_fireAttack.func_151470_d());
            this.strike(IafKeybindRegistry.dragon_strike.func_151470_d());
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_70906_o() && !this.func_184207_aI() || this.isModelDead();
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        if (this.getAnimation() == ANIMATION_SHAKEPREY || !this.canMove() && !this.func_184207_aI() || this.func_70906_o()) {
            strafe = 0.0f;
            forward = 0.0f;
            vertical = 0.0f;
            this.field_70701_bs = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            super.func_191986_a(strafe, forward, vertical);
            return;
        }
        super.func_191986_a(strafe, forward, vertical);
    }

    public void updateCheckPlayer() {
        double checklength = this.func_174813_aQ().func_72320_b() * 3.0;
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, checklength);
        if (this.isSleeping() && player != null && !this.func_152114_e((EntityLivingBase)player) && !player.func_184812_l_()) {
            this.setSleeping(false);
            this.func_70904_g(false);
            this.func_70624_b((EntityLivingBase)player);
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() != null) {
            // empty if block
        }
        super.func_70645_a(cause);
    }

    @Override
    public void onHearFlute(EntityPlayer player) {
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    public abstract SoundEvent getRoarSound();

    public void roar() {
        block9: {
            block8: {
                if (EntityGorgon.isStoneMob((EntityLivingBase)this)) {
                    return;
                }
                if (!this.field_70146_Z.nextBoolean()) break block8;
                if (this.getAnimation() != ANIMATION_EPIC_ROAR) {
                    this.setAnimation(ANIMATION_EPIC_ROAR);
                    this.func_184185_a(this.getRoarSound(), this.func_70599_aP() + 3.0f + (float)Math.max(0, this.getDragonStage() - 2), this.func_70647_i() * 0.7f);
                }
                if (this.getDragonStage() <= 3) break block9;
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof EntityLivingBase) || isStrongerDragon) continue;
                    EntityLivingBase living = (EntityLivingBase)entity;
                    if (this.func_152114_e(living) || this.isOwnersPet(living)) {
                        living.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 50 * size));
                        continue;
                    }
                    if (living.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == IafItemRegistry.earplugs) continue;
                    living.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 50 * size));
                }
                break block9;
            }
            if (this.getAnimation() != ANIMATION_ROAR) {
                this.setAnimation(ANIMATION_ROAR);
                this.func_184185_a(this.getRoarSound(), this.func_70599_aP() + 2.0f + (float)Math.max(0, this.getDragonStage() - 3), this.func_70647_i());
            }
            if (this.getDragonStage() > 3) {
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof EntityLivingBase) || isStrongerDragon) continue;
                    EntityLivingBase living = (EntityLivingBase)entity;
                    if (this.func_152114_e(living) || this.isOwnersPet(living)) {
                        living.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 30 * size));
                        continue;
                    }
                    living.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 30 * size));
                }
            }
        }
    }

    private boolean isOwnersPet(EntityLivingBase living) {
        return this.func_70909_n() && this.func_70902_q() != null && living instanceof EntityTameable && ((EntityTameable)living).func_70902_q() != null && this.func_70902_q().func_70028_i((Entity)((EntityTameable)living).func_70902_q());
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = entity.field_70170_p.func_147447_a(vec1, vec2, false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public void processArrows() {
        List entities = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ());
        for (Entity entity : entities) {
            if (!(entity instanceof EntityArrow)) continue;
        }
    }

    public boolean shouldRenderEyes() {
        return !this.isSleeping() && !this.isModelDead() && !this.isBlinking() && !EntityGorgon.isStoneMob((EntityLivingBase)this);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
    }

    public boolean isChained() {
        ChainEntityProperties chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, ChainEntityProperties.class);
        return chainProperties != null && chainProperties.isChained();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender(ICamera camera) {
        boolean render = false;
        return this.inFrustrum(camera, (Entity)this.headPart) || this.inFrustrum(camera, (Entity)this.neckPart) || this.inFrustrum(camera, (Entity)this.leftWingLowerPart) || this.inFrustrum(camera, (Entity)this.rightWingLowerPart) || this.inFrustrum(camera, (Entity)this.leftWingUpperPart) || this.inFrustrum(camera, (Entity)this.rightWingUpperPart) || this.inFrustrum(camera, (Entity)this.tail1Part) || this.inFrustrum(camera, (Entity)this.tail2Part) || this.inFrustrum(camera, (Entity)this.tail3Part) || this.inFrustrum(camera, (Entity)this.tail4Part);
    }

    private boolean inFrustrum(ICamera camera, Entity entity) {
        return camera != null && entity != null && camera.func_78546_a(entity.func_174813_aQ());
    }

    public RayTraceResult rayTraceRider(Entity rider, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = rider.func_174824_e(partialTicks);
        Vec3d vec3d1 = rider.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return this.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public Vec3d getRiderPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        float sleepProg = this.sleepProgress * -0.025f;
        float extraAgeScale = (float)Math.max(0, this.getAgeInDays() - 75) / 75.0f * 1.65f;
        float pitchX = 0.0f;
        float pitchY = 0.0f;
        float dragonPitch = this.getDragonPitch();
        if (dragonPitch > 0.0f) {
            pitchX = Math.min(dragonPitch / 90.0f, 0.3f);
            pitchY = -(dragonPitch / 90.0f) * 2.0f;
        }
        if (dragonPitch < 0.0f) {
            pitchY = dragonPitch / 90.0f * 0.1f;
            pitchX = Math.max(dragonPitch / 90.0f, -0.7f);
        }
        float xzMod = (0.15f + pitchX) * this.getRenderSize() + extraAgeScale;
        float headPosX = (float)(this.field_70165_t + (double)xzMod * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
        float headPosY = (float)(this.field_70163_u + (double)((0.7f + sitProg + hoverProg + deadProg + sleepProg + flyProg + pitchY) * this.getRenderSize() * 0.3f) + (double)extraAgeScale);
        float headPosZ = (float)(this.field_70161_v + (double)xzMod * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
        return new Vec3d((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public void func_174812_G() {
        this.func_70106_y();
        this.setDeathStage(this.getAgeInDays() / 5);
        this.setModelDead(false);
    }

    public Vec3d getHeadPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        int tick = 0;
        tick = this.getAnimationTick() < 10 ? this.getAnimationTick() : (this.getAnimationTick() > 50 ? 60 - this.getAnimationTick() : 10);
        float epicRoarProg = this.getAnimation() == ANIMATION_EPIC_ROAR ? (float)tick * 0.1f : 0.0f;
        float sleepProg = this.sleepProgress * -0.025f;
        float pitchMulti = 0.0f;
        float pitchAdjustment = 0.0f;
        float pitchMinus = 0.0f;
        float dragonPitch = -this.getDragonPitch();
        if (this.isFlying() || this.isHovering()) {
            pitchMulti = (float)Math.sin(Math.toRadians(dragonPitch));
            pitchAdjustment = 1.2f;
            if ((pitchMulti *= 2.1f * Math.abs(dragonPitch) / 90.0f) > 0.0f) {
                pitchMulti *= 1.5f - pitchMulti * 0.5f;
            }
            if (pitchMulti < 0.0f) {
                pitchMulti *= 1.3f - pitchMulti * 0.1f;
            }
            pitchMinus = 0.3f * Math.abs(dragonPitch / 90.0f);
            if (dragonPitch >= 0.0f) {
                pitchAdjustment = 0.6f * Math.abs(dragonPitch / 90.0f);
                pitchMinus = 0.95f * Math.abs(dragonPitch / 90.0f);
            }
        }
        float xzMod = 1.9f * this.getRenderSize() * 0.3f + this.getRenderSize() * (0.3f * (float)Math.sin((double)(dragonPitch + 90.0f) * Math.PI / 180.0) * pitchAdjustment - pitchMinus);
        float headPosX = (float)(this.field_70165_t + (double)xzMod * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
        float headPosY = (float)(this.field_70163_u + (double)((0.7f + sitProg + hoverProg + deadProg + epicRoarProg + sleepProg + flyProg + pitchMulti) * this.getRenderSize() * 0.3f));
        float headPosZ = (float)(this.field_70161_v + (double)xzMod * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
        return new Vec3d((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public abstract void stimulateFire(double var1, double var3, double var5, int var7);

    public void randomizeAttacks() {
        this.airAttack = IafDragonAttacks.Air.values()[this.func_70681_au().nextInt(IafDragonAttacks.Air.values().length)];
        this.groundAttack = IafDragonAttacks.Ground.values()[this.func_70681_au().nextInt(IafDragonAttacks.Ground.values().length)];
    }

    public abstract void tryScorchTarget();

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.flightManager.onSetAttackTarget(entitylivingbaseIn);
    }

    public boolean isPart(Entity entityHit) {
        return this.headPart != null && this.headPart.func_70028_i(entityHit) || this.neckPart != null && this.neckPart.func_70028_i(entityHit) || this.leftWingLowerPart != null && this.leftWingLowerPart.func_70028_i(entityHit) || this.rightWingLowerPart != null && this.rightWingLowerPart.func_70028_i(entityHit) || this.leftWingUpperPart != null && this.leftWingUpperPart.func_70028_i(entityHit) || this.rightWingUpperPart != null && this.rightWingUpperPart.func_70028_i(entityHit) || this.tail1Part != null && this.tail1Part.func_70028_i(entityHit) || this.tail2Part != null && this.tail2Part.func_70028_i(entityHit) || this.tail3Part != null && this.tail3Part.func_70028_i(entityHit) || this.tail4Part != null && this.tail4Part.func_70028_i(entityHit);
    }

    @Override
    public float getFlightSpeedModifier() {
        return 1.0f;
    }

    public boolean isAllowedToTriggerFlight() {
        return this.hasFlightClearance() && !this.func_70906_o() && this.func_184188_bt().isEmpty() && !this.func_70631_g_() && !this.isSleeping() && this.canMove() && this.field_70122_E;
    }

    public BlockPos getEscortPosition() {
        return this.func_70902_q() != null ? this.func_70902_q().func_180425_c() : this.func_180425_c();
    }

    public boolean shouldTPtoOwner() {
        return this.func_70902_q() != null && this.func_70032_d((Entity)this.func_70902_q()) > 10.0f;
    }

    public boolean isSkeletal() {
        return this.getDeathStage() >= this.getAgeInDays() / 5 / 2;
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        this.func_189511_e(compound);
        return true;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.field_187537_bA || soundIn == this.func_184639_G() || soundIn == this.func_184601_bQ(null) || soundIn == this.func_184615_bR() || soundIn == this.getRoarSound()) {
            if (!this.func_174814_R() && this.headPart != null) {
                this.field_70170_p.func_184148_a(null, this.headPart.field_70165_t, this.headPart.field_70163_u, this.headPart.field_70161_v, soundIn, this.func_184176_by(), volume, pitch);
            }
        } else {
            super.func_184185_a(soundIn, volume, pitch);
        }
    }

    public boolean hasFlightClearance() {
        BlockPos topOfBB = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72337_e, this.field_70161_v);
        for (int i = 1; i < 4; ++i) {
            if (this.field_70170_p.func_175623_d(topOfBB.func_177981_b(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        if (slotIn == EntityEquipmentSlot.OFFHAND) {
            return this.dragonInventory.func_70301_a(0);
        }
        if (slotIn == EntityEquipmentSlot.HEAD) {
            return this.dragonInventory.func_70301_a(1);
        }
        if (slotIn == EntityEquipmentSlot.CHEST) {
            return this.dragonInventory.func_70301_a(2);
        }
        if (slotIn == EntityEquipmentSlot.LEGS) {
            return this.dragonInventory.func_70301_a(3);
        }
        if (slotIn == EntityEquipmentSlot.FEET) {
            return this.dragonInventory.func_70301_a(4);
        }
        return super.func_184582_a(slotIn);
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.dragonInventory.func_70299_a(0, stack);
        } else if (slotIn == EntityEquipmentSlot.HEAD) {
            this.dragonInventory.func_70299_a(1, stack);
        } else if (slotIn == EntityEquipmentSlot.CHEST) {
            this.dragonInventory.func_70299_a(2, stack);
        } else if (slotIn == EntityEquipmentSlot.LEGS) {
            this.dragonInventory.func_70299_a(3, stack);
        } else if (slotIn == EntityEquipmentSlot.FEET) {
            this.dragonInventory.func_70299_a(4, stack);
        } else {
            super.func_184582_a(slotIn);
        }
        this.updateAttributes();
    }

    public float func_70647_i() {
        return super.func_70647_i();
    }

    public SoundEvent getBabyFireSound() {
        return SoundEvents.field_187646_bt;
    }

    protected boolean isPlayingAttackAnimation() {
        return this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_SHAKEPREY || this.getAnimation() == ANIMATION_WINGBLAST || this.getAnimation() == ANIMATION_TAILWHACK;
    }

    protected IafDragonLogic createDragonLogic() {
        return new IafDragonLogic(this);
    }

    protected float getFlightChancePerTick() {
        return IceAndFire.CONFIG.dragonFlightChance;
    }

    public void onRemovedFromWorld() {
        if (IceAndFire.CONFIG.chunkLoadSummonCrystal && this.isBoundToCrystal()) {
            DragonPosWorldData.get(this.field_70170_p).addDragon(this.func_110124_au(), this.func_180425_c());
        }
        super.onRemovedFromWorld();
    }
}

