/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.message.MessageAddChainedEntity;
import com.github.alexthe666.iceandfire.message.MessageRemoveChainedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.ilexiconn.llibrary.server.entity.EntityProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChainEntityProperties
extends EntityProperties<EntityLivingBase> {
    public List<Entity> connectedEntities = new ArrayList<Entity>();
    public boolean alreadyIgnoresCamera = false;
    public boolean wasJustDisconnected = false;
    private List<UUID> connectedEntityUUID = new ArrayList<UUID>();

    public int getTrackingTime() {
        return 20;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : this.connectedEntityUUID) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_186854_a("UUID", uuid);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("ConnectedEntities", (NBTBase)nbttaglist);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("ConnectedEntities", 10);
        this.connectedEntityUUID = new ArrayList<UUID>();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            this.connectedEntityUUID.add(nbttagcompound.func_186857_a("UUID"));
        }
        this.updateConnectedEntities(this.getEntity());
    }

    public void clearChained() {
        this.connectedEntities.clear();
        this.connectedEntityUUID.clear();
    }

    public boolean isChained() {
        return !this.connectedEntityUUID.isEmpty();
    }

    public void init() {
        this.updateConnectedEntities(this.getEntity());
        this.alreadyIgnoresCamera = ((EntityLivingBase)this.getEntity()).field_70158_ak;
    }

    public void addChain(Entity parent, Entity entity) {
        this.minimizeLists();
        if (!this.connectedEntityUUID.contains(entity.func_110124_au())) {
            this.connectedEntityUUID.add(entity.func_110124_au());
        }
        this.updateConnectedEntities(parent);
    }

    public void removeChain(Entity us, Entity entity) {
        this.minimizeLists();
        this.connectedEntityUUID.remove(entity.func_110124_au());
        this.connectedEntities.remove(entity);
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageRemoveChainedEntity(us.func_145782_y(), entity.func_145782_y()));
        }
        this.wasJustDisconnected = true;
    }

    public List<Entity> getCurrentConnectedEntities() {
        return this.connectedEntities;
    }

    public void minimizeLists() {
        ArrayList<UUID> noDupesUUID = new ArrayList<UUID>();
        for (UUID uuid : this.connectedEntityUUID) {
            if (noDupesUUID.contains(uuid)) continue;
            noDupesUUID.add(uuid);
        }
        this.connectedEntityUUID = noDupesUUID;
        ArrayList<Entity> noDupesEntity = new ArrayList<Entity>();
        ArrayList<UUID> addedUUIDs = new ArrayList<UUID>();
        for (Entity entity : this.connectedEntities) {
            if (addedUUIDs.contains(entity.func_110124_au())) continue;
            addedUUIDs.add(entity.func_110124_au());
            noDupesEntity.add(entity);
        }
        this.connectedEntities = noDupesEntity;
    }

    public void updateConnectedEntities(Entity toUpdate) {
        this.connectedEntities.clear();
        ArrayList<UUID> addedUUIDs = new ArrayList<UUID>();
        if (toUpdate != null) {
            World world = toUpdate.field_70170_p;
            if (!this.connectedEntityUUID.isEmpty() && world != null && !world.field_72995_K) {
                this.minimizeLists();
                for (UUID uuid : this.connectedEntityUUID) {
                    Entity entity;
                    if (world.func_73046_m() == null || (entity = world.func_73046_m().func_175576_a(uuid)) == null || addedUUIDs.contains(entity.func_110124_au())) continue;
                    addedUUIDs.add(entity.func_110124_au());
                    IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageAddChainedEntity(toUpdate.func_145782_y(), entity.func_145782_y()));
                    this.connectedEntities.add(entity);
                }
            }
        }
    }

    public String getID() {
        return "Ice And Fire - Chain Property Tracker";
    }

    public Class<EntityLivingBase> getEntityClass() {
        return EntityLivingBase.class;
    }

    public boolean isConnectedToEntity(Entity parent, Entity entity) {
        this.updateConnectedEntities(parent);
        return this.connectedEntities.contains(entity);
    }
}

