/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.compat.tinkers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.content.ContentListing;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.content.ContentModifier;
import slimeknights.tconstruct.library.book.content.ContentPageIconList;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;

public class IceAndFireBookTranformer
extends BookTransformer {
    public static List<ContentPageIconList> getPagesNeededForItemCount(int addLoc, int count, SectionData data, String title) {
        ArrayList listPages = Lists.newArrayList();
        while (count > 0) {
            ContentPageIconList overview = new ContentPageIconList();
            PageData page2 = new PageData(true);
            page2.source = data.source;
            page2.parent = data;
            page2.content = overview;
            page2.load();
            data.pages.add(addLoc, page2);
            overview.title = title;
            listPages.add(overview);
            count -= overview.getMaxIconCount();
        }
        if (listPages.size() > 1) {
            listPages.forEach(page -> {
                page.maxScale = 1.0f;
            });
        }
        return listPages;
    }

    public void transform(BookData book) {
        SectionData modifierSection = null;
        SectionData iafModifierSection = null;
        for (SectionData section : book.sections) {
            if (section.name.equals("modifiers")) {
                modifierSection = section;
            }
            if (!section.name.equals("iafmodifiers")) continue;
            iafModifierSection = section;
        }
        if (modifierSection != null && iafModifierSection != null) {
            for (PageData page : iafModifierSection.pages) {
                page.parent = modifierSection;
                modifierSection.pages.add(page);
            }
            PageData pageData = (PageData)modifierSection.pages.get(0);
            if (pageData.content instanceof ContentListing) {
                for (PageData page : iafModifierSection.pages) {
                    IModifier modifier;
                    page.parent = modifierSection;
                    if (!(page.content instanceof ContentModifier) || (modifier = TinkerRegistry.getModifier((String)((ContentModifier)page.content).modifierName)) == null) continue;
                    page.name = "iaf_" + modifier.getIdentifier();
                    ((ContentListing)pageData.content).addEntry(modifier.getLocalizedName(), page);
                }
            }
            iafModifierSection.pages.clear();
            book.sections.remove(iafModifierSection);
        }
    }

    protected PageData addPage(SectionData data, String name, String type, PageContent content) {
        PageData page = new PageData(true);
        page.source = data.source;
        page.parent = data;
        page.name = name;
        page.type = type;
        page.content = content;
        page.load();
        data.pages.add(page);
        return page;
    }

    protected PageContent getPageContent(Material material) {
        return new ContentMaterial(material);
    }
}

