/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.client.model.ModelDragonEgg;
import com.github.alexthe666.iceandfire.client.render.entity.RenderDragonEgg;
import com.github.alexthe666.iceandfire.client.render.entity.RenderMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPodium;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemDragonEgg;
import com.github.alexthe666.iceandfire.item.ItemMyrmexEgg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderPodium
extends TileEntitySpecialRenderer<TileEntityPodium> {
    protected static ResourceLocation getEggTexture(EnumDragonEgg type) {
        switch (type) {
            default: {
                return RenderDragonEgg.EGG_RED;
            }
            case GREEN: {
                return RenderDragonEgg.EGG_GREEN;
            }
            case BRONZE: {
                return RenderDragonEgg.EGG_BRONZE;
            }
            case GRAY: {
                return RenderDragonEgg.EGG_GREY;
            }
            case BLUE: {
                return RenderDragonEgg.EGG_BLUE;
            }
            case WHITE: {
                return RenderDragonEgg.EGG_WHITE;
            }
            case SAPPHIRE: {
                return RenderDragonEgg.EGG_SAPPHIRE;
            }
            case SILVER: 
        }
        return RenderDragonEgg.EGG_SILVER;
    }

    public void render(TileEntityPodium podium, double x, double y, double z, float f, int f1, float alpha) {
        ModelDragonEgg model = new ModelDragonEgg();
        if (!podium.func_70301_a(0).func_190926_b()) {
            if (podium.func_70301_a(0).func_77973_b() instanceof ItemDragonEgg) {
                ItemDragonEgg item = (ItemDragonEgg)podium.func_70301_a(0).func_77973_b();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.475f), (float)((float)z + 0.5f));
                GL11.glPushMatrix();
                this.func_147499_a(RenderPodium.getEggTexture(item.type));
                GL11.glPushMatrix();
                model.renderPodium();
                GL11.glPopMatrix();
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            } else if (podium.func_70301_a(0).func_77973_b() instanceof ItemMyrmexEgg) {
                boolean jungle = podium.func_70301_a(0).func_77973_b() == IafItemRegistry.myrmex_jungle_egg;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.475f), (float)((float)z + 0.5f));
                GL11.glPushMatrix();
                this.func_147499_a(jungle ? RenderMyrmexEgg.EGG_JUNGLE : RenderMyrmexEgg.EGG_DESERT);
                GL11.glPushMatrix();
                model.renderPodium();
                GL11.glPopMatrix();
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            } else if (!podium.func_70301_a(0).func_190926_b()) {
                GL11.glPushMatrix();
                float f2 = (float)podium.prevTicksExisted + (float)(podium.ticksExisted - podium.prevTicksExisted) * f;
                float f3 = MathHelper.func_76126_a((float)(f2 / 10.0f)) * 0.1f + 0.1f;
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.55f + f3), (float)((float)z + 0.5f));
                float f4 = f2 / 20.0f * 57.295776f;
                GlStateManager.func_179114_b((float)f4, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glPushMatrix();
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, podium.func_70301_a(0), ItemCameraTransforms.TransformType.GROUND);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
        }
    }
}

