/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.iceandfire.client.render.entity.RenderDragonBase;
import com.github.alexthe666.iceandfire.client.texture.ArrayLayeredTexture;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;

public class LayerDragonArmor
implements LayerRenderer<EntityDragonBase> {
    private static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    private final RenderDragonBase render;
    private static final Map<String, ResourceLocation> LAYERED_ARMOR_CACHE = Maps.newHashMap();

    public LayerDragonArmor(RenderDragonBase renderIn, boolean isFireDragon) {
        this.render = renderIn;
    }

    public void doRenderLayer(EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        int armorHead = dragon.getArmorOrdinal(dragon.func_184582_a(EntityEquipmentSlot.HEAD));
        int armorNeck = dragon.getArmorOrdinal(dragon.func_184582_a(EntityEquipmentSlot.CHEST));
        int armorLegs = dragon.getArmorOrdinal(dragon.func_184582_a(EntityEquipmentSlot.LEGS));
        int armorFeet = dragon.getArmorOrdinal(dragon.func_184582_a(EntityEquipmentSlot.FEET));
        String armorTexture = dragon.dragonType.getName() + "|" + armorHead + "|" + armorNeck + "|" + armorLegs + "|" + armorFeet;
        if (!armorTexture.equals(dragon.dragonType.getName() + "|0|0|0|0")) {
            ResourceLocation resourcelocation = LAYERED_ARMOR_CACHE.get(armorTexture);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation("iceandfiredragonArmor_" + armorTexture);
                ArrayList<String> tex = new ArrayList<String>();
                for (EntityEquipmentSlot slot : ARMOR_SLOTS) {
                    if (dragon.dragonType == DragonType.FIRE) {
                        tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EntityEquipmentSlot)slot).FIRETEXTURE.toString());
                        continue;
                    }
                    tex.add(EnumDragonTextures.Armor.getArmorForDragon((EntityDragonBase)dragon, (EntityEquipmentSlot)slot).ICETEXTURE.toString());
                }
                ArrayLayeredTexture layeredBase = new ArrayLayeredTexture(tex);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)layeredBase);
                LAYERED_ARMOR_CACHE.put(armorTexture, resourcelocation);
            }
            this.render.func_110776_a(resourcelocation);
            this.render.func_177087_b().func_78088_a((Entity)dragon, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public boolean func_177142_b() {
        return false;
    }

    public static void clearCache(String str) {
        LAYERED_ARMOR_CACHE.remove(str);
    }
}

