/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.event.ServerEvents;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderModCapes {
    public ResourceLocation redTex = new ResourceLocation("iceandfire", "textures/models/misc/cape_fire.png");
    public ResourceLocation redElytraTex = new ResourceLocation("iceandfire", "textures/models/misc/elytra_fire.png");
    public ResourceLocation blueTex = new ResourceLocation("iceandfire", "textures/models/misc/cape_ice.png");
    public ResourceLocation blueElytraTex = new ResourceLocation("iceandfire", "textures/models/misc/elytra_ice.png");
    public ResourceLocation betaTex = new ResourceLocation("iceandfire", "textures/models/misc/cape_beta.png");
    public ResourceLocation betaElytraTex = new ResourceLocation("iceandfire", "textures/models/misc/elytra_beta.png");
    public UUID[] redcapes = new UUID[]{UUID.fromString("59efccaf-902d-45da-928a-5a549b9fd5e0"), UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c")};
    public UUID[] bluecapes = new UUID[]{UUID.fromString("0ed918c8-d612-4360-b711-cd415671356f"), UUID.fromString("5d43896a-06a0-49fb-95c5-38485c63667f")};
    public UUID[] betatesters = new UUID[0];

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Pre event) {
        NetworkPlayerInfo info;
        if (event.getEntityPlayer() instanceof AbstractClientPlayer && (info = ((AbstractClientPlayer)event.getEntityPlayer()).func_175155_b()) != null) {
            Map textureMap = null;
            textureMap = info.field_187107_a;
            if (textureMap != null) {
                if (this.hasBetaCape(event.getEntityPlayer().func_110124_au())) {
                    textureMap.put(MinecraftProfileTexture.Type.CAPE, this.betaTex);
                    textureMap.put(MinecraftProfileTexture.Type.ELYTRA, this.betaElytraTex);
                }
                if (this.hasRedCape(event.getEntityPlayer().func_110124_au())) {
                    textureMap.put(MinecraftProfileTexture.Type.CAPE, this.redTex);
                    textureMap.put(MinecraftProfileTexture.Type.ELYTRA, this.redElytraTex);
                }
                if (this.hasBlueCape(event.getEntityPlayer().func_110124_au())) {
                    textureMap.put(MinecraftProfileTexture.Type.CAPE, this.blueTex);
                    textureMap.put(MinecraftProfileTexture.Type.ELYTRA, this.blueElytraTex);
                }
            }
        }
        if (event.getEntityPlayer().func_110124_au().equals(ServerEvents.ALEX_UUID)) {
            GL11.glPushMatrix();
            float f2 = (float)event.getEntityPlayer().field_70173_aa - 1.0f + event.getPartialRenderTick();
            GL11.glTranslatef((float)0.0f, (float)(1.3f * event.getEntityPlayer().field_70131_O), (float)0.0f);
            float f4 = f2 / 20.0f * 57.295776f;
            GlStateManager.func_179114_b((float)f4, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)1.4f, (float)1.4f, (float)1.4f);
            Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, new ItemStack(IafItemRegistry.weezer_blue_album), ItemCameraTransforms.TransformType.GROUND);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    private boolean hasRedCape(UUID uniqueID) {
        for (UUID uuid1 : this.redcapes) {
            if (!uniqueID.equals(uuid1)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBlueCape(UUID uniqueID) {
        for (UUID uuid1 : this.bluecapes) {
            if (!uniqueID.equals(uuid1)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBetaCape(UUID uniqueID) {
        for (UUID uuid1 : this.betatesters) {
            if (!uniqueID.equals(uuid1)) continue;
            return true;
        }
        return false;
    }
}

