/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ParticleDragonFlame
extends ParticleFlame {
    private static final ResourceLocation DRAGONFLAME = new ResourceLocation("iceandfire:textures/particles/flame.png");
    private final float dragonSize;
    private final double initialX;
    private final double initialY;
    private final double initialZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int touchedTime = 0;
    private final float speedBonus;
    @Nullable
    private EntityDragonBase dragon;

    @SideOnly(value=Side.CLIENT)
    public ParticleDragonFlame(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float dragonSize) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.field_70547_e = 30;
        this.initialX = xCoordIn;
        this.initialY = yCoordIn;
        this.initialZ = zCoordIn;
        this.targetX = xCoordIn + (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 1.75f * dragonSize);
        this.targetY = yCoordIn + (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 1.75f * dragonSize);
        this.targetZ = zCoordIn + (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 1.75f * dragonSize);
        this.func_187109_b(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        this.dragonSize = dragonSize;
        this.speedBonus = this.field_187136_p.nextFloat() * 0.015f;
    }

    public ParticleDragonFlame(World world, double x, double y, double z, double motX, double motY, double motZ, EntityDragonBase entityDragonBase, int startingAge) {
        this(world, x, y, z, motX, motY, motZ, MathHelper.func_76131_a((float)(entityDragonBase.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f));
        this.dragon = entityDragonBase;
        this.targetX = this.dragon.burnParticleX + (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 3.5;
        this.targetY = this.dragon.burnParticleY + (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 3.5;
        this.targetZ = this.dragon.burnParticleZ + (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 3.5;
        this.field_187126_f = x;
        this.field_187127_g = y;
        this.field_187128_h = z;
        this.field_70546_d = startingAge;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.field_70546_d > (this.dragon == null ? 10 : 30)) {
            this.func_187112_i();
        }
        this.field_70544_f = 5.0f * this.dragonSize;
        float f = (float)this.field_94054_b / 16.0f;
        float f1 = f + 0.0624375f;
        float f2 = (float)this.field_94055_c / 16.0f;
        float f3 = f2 + 0.0624375f;
        float f4 = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            f = this.field_187119_C.func_94209_e();
            f1 = this.field_187119_C.func_94212_f();
            f2 = this.field_187119_C.func_94206_g();
            f3 = this.field_187119_C.func_94210_h();
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleDragonFlame.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleDragonFlame.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleDragonFlame.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(DRAGONFLAME);
        GL11.glPushMatrix();
        buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        GL11.glPopMatrix();
    }

    public int func_189214_a(float partialTick) {
        return 240;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.dragon == null) {
            float distX = (float)(this.initialX - this.field_187126_f);
            float distZ = (float)(this.initialZ - this.field_187128_h);
            this.field_187129_i += (double)(distX * -0.01f * this.dragonSize * this.field_187136_p.nextFloat());
            this.field_187131_k += (double)(distZ * -0.01f * this.dragonSize * this.field_187136_p.nextFloat());
            this.field_187130_j += (double)(0.015f * this.field_187136_p.nextFloat());
        } else {
            double d2 = this.targetX - this.initialX;
            double d3 = this.targetY - this.initialY;
            double d4 = this.targetZ - this.initialZ;
            float speed = 0.015f + this.speedBonus;
            this.field_187129_i += d2 * (double)speed;
            this.field_187130_j += d3 * (double)speed;
            this.field_187131_k += d4 * (double)speed;
            if (this.touchedTime > 3) {
                this.func_187112_i();
            }
        }
    }

    public void func_187110_a(double x, double y, double z) {
        double d0 = y;
        double origX = x;
        double origZ = z;
        if (this.field_190017_n) {
            List list = this.field_187122_b.func_184144_a(null, this.func_187116_l().func_72321_a(x, y, z));
            for (AxisAlignedBB axisalignedbb : list) {
                y = axisalignedbb.func_72323_b(this.func_187116_l(), y);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB axisalignedbb1 : list) {
                x = axisalignedbb1.func_72316_a(this.func_187116_l(), x);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB axisalignedbb2 : list) {
                z = axisalignedbb2.func_72322_c(this.func_187116_l(), z);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
            if (!list.isEmpty()) {
                ++this.touchedTime;
            }
        } else {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        }
        this.func_187118_j();
        boolean bl = this.field_187132_l = d0 != y && d0 < 0.0;
        if (origX != x) {
            this.field_187129_i = 0.0;
        }
        if (origZ != z) {
            this.field_187131_k = 0.0;
        }
    }
}

