/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.iceandfire.client.model.animator.IceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.EnumSeaSerpentAnimations;
import com.github.alexthe666.iceandfire.client.model.util.IIceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import java.util.Arrays;
import java.util.List;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;

public class SeaSerpentTabulaModelAnimator
extends IceAndFireTabulaModelAnimator
implements IIceAndFireTabulaModelAnimator<EntitySeaSerpent> {
    public List<IceAndFireTabulaModel<EntitySeaSerpent>> swimPose;

    public SeaSerpentTabulaModelAnimator() {
        super(EnumSeaSerpentAnimations.T_POSE.seaserpent_model);
        this.swimPose = Arrays.asList(EnumSeaSerpentAnimations.SWIM1.seaserpent_model, EnumSeaSerpentAnimations.SWIM3.seaserpent_model, EnumSeaSerpentAnimations.SWIM4.seaserpent_model, EnumSeaSerpentAnimations.SWIM6.seaserpent_model);
    }

    @Override
    public void init(IceAndFireTabulaModel<EntitySeaSerpent> model) {
    }

    @Override
    public void setRotationAngles(IceAndFireTabulaModel<EntitySeaSerpent> model, EntitySeaSerpent entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.resetToDefaultPose();
        model.getCube((String)"BodyUpper").field_78797_d += 9.0f;
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, StoneEntityProperties.class);
        if (properties != null && properties.isStone) {
            return;
        }
        model.llibAnimator.update((IAnimatedEntity)entity);
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        int currentIndex = entity.swimCycle / 10;
        int prevIndex = currentIndex - 1;
        if (prevIndex < 0) {
            prevIndex = 3;
        }
        IceAndFireTabulaModel<EntitySeaSerpent> prevPosition = this.swimPose.get(prevIndex);
        IceAndFireTabulaModel<EntitySeaSerpent> currentPosition = this.swimPose.get(currentIndex);
        float delta = (float)entity.swimCycle / 10.0f % 1.0f + LLibrary.PROXY.getPartialTicks() / 10.0f;
        AdvancedModelRenderer[] tailParts = new AdvancedModelRenderer[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4"), model.getCube("Tail5"), model.getCube("Tail6")};
        AdvancedModelRenderer[] neckParts = new AdvancedModelRenderer[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Head")};
        for (AdvancedModelRenderer cube : model.getCubes().values()) {
            if (entity.jumpProgress > 0.0f && !this.isPartEqual(cube, EnumSeaSerpentAnimations.JUMPING2.seaserpent_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumSeaSerpentAnimations.JUMPING2.seaserpent_model.getCube(cube.field_78802_n), entity.jumpProgress, 5.0f, false);
            }
            if (entity.wantJumpProgress > 0.0f && !this.isPartEqual(cube, EnumSeaSerpentAnimations.JUMPING1.seaserpent_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumSeaSerpentAnimations.JUMPING1.seaserpent_model.getCube(cube.field_78802_n), entity.wantJumpProgress, 10.0f, false);
            }
            float prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
            float prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
            float prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
            float x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
            float y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
            float z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
            this.addToRotateAngle(cube, limbSwingAmount, prevX + delta * this.distance(prevX, x), prevY + delta * this.distance(prevY, y), prevZ + delta * this.distance(prevZ, z));
        }
        if (entity.breathProgress > 0.0f) {
            this.progressRotation(model.getCube("Head"), entity.breathProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
            this.progressRotation(model.getCube("HeadFront"), entity.breathProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
            this.progressRotation(model.getCube("Jaw"), entity.breathProgress, (float)Math.toRadians(60.0), 0.0f, 0.0f);
        }
        if (entity.jumpRot > 0.0f) {
            float turn = (float)entity.field_70181_x * -4.0f;
            model.getCube((String)"BodyUpper").field_78795_f += (float)Math.toRadians(22.5f * turn) * entity.jumpRot;
            model.getCube((String)"Tail1").field_78795_f -= (float)Math.toRadians(turn) * entity.jumpRot;
            model.getCube((String)"Tail2").field_78795_f -= (float)Math.toRadians(turn) * entity.jumpRot;
            model.getCube((String)"Tail3").field_78795_f -= (float)Math.toRadians(turn) * entity.jumpRot;
            model.getCube((String)"Tail4").field_78795_f -= (float)Math.toRadians(turn) * entity.jumpRot;
        }
        entity.tail_buffer.applyChainSwingBuffer((ModelRenderer[])tailParts);
        entity.roll_buffer.applyChainFlapBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
        entity.pitch_buffer.applyChainWaveBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
        entity.head_buffer.applyChainSwingBufferReverse((ModelRenderer[])neckParts);
    }

    public void progressRotation(AdvancedModelRenderer model, float progress, float rotX, float rotY, float rotZ) {
        model.field_78795_f += progress * (rotX - model.defaultRotationX) / 20.0f;
        model.field_78796_g += progress * (rotY - model.defaultRotationY) / 20.0f;
        model.field_78808_h += progress * (rotZ - model.defaultRotationZ) / 20.0f;
    }

    private void animate(IceAndFireTabulaModel<EntitySeaSerpent> model, EntitySeaSerpent entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.llibAnimator.setAnimation(EntitySeaSerpent.ANIMATION_SPEAK);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 25.0f, 0.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.setStaticKeyframe(5);
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntitySeaSerpent.ANIMATION_BITE);
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumSeaSerpentAnimations.BITE1.seaserpent_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumSeaSerpentAnimations.BITE2.seaserpent_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.setStaticKeyframe(2);
        model.llibAnimator.resetKeyframe(3);
        model.llibAnimator.setAnimation(EntitySeaSerpent.ANIMATION_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumSeaSerpentAnimations.ROAR1.seaserpent_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumSeaSerpentAnimations.ROAR2.seaserpent_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumSeaSerpentAnimations.ROAR3.seaserpent_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
    }
}

