/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.util.IAFMath;
import net.ilexiconn.llibrary.client.model.ModelAnimator;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class IceAndFireTabulaModelAnimator {
    protected IceAndFireTabulaModel<? extends Entity> baseModel;

    public IceAndFireTabulaModelAnimator(IceAndFireTabulaModel<? extends Entity> baseModel) {
        this.baseModel = baseModel;
    }

    public void setRotateAngle(AdvancedModelRenderer model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += limbSwingAmount * this.distance(model.field_78795_f, x);
        model.field_78796_g += limbSwingAmount * this.distance(model.field_78796_g, y);
        model.field_78808_h += limbSwingAmount * this.distance(model.field_78808_h, z);
    }

    public void addToRotateAngle(AdvancedModelRenderer model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationX, x);
        model.field_78796_g += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationY, y);
        model.field_78808_h += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationZ, z);
    }

    public boolean isPartEqual(AdvancedModelRenderer original, AdvancedModelRenderer pose) {
        return pose != null && pose.field_78795_f == original.defaultRotationX && pose.field_78796_g == original.defaultRotationY && pose.field_78808_h == original.defaultRotationZ;
    }

    public boolean isPositionEqual(AdvancedModelRenderer original, AdvancedModelRenderer pose) {
        return pose.field_78800_c == original.defaultPositionX && pose.field_78797_d == original.defaultPositionY && pose.field_78798_e == original.defaultPositionZ;
    }

    public void transitionTo(AdvancedModelRenderer from, AdvancedModelRenderer to, float timer, float maxTime, boolean oldFashioned) {
        if (oldFashioned) {
            from.field_78795_f += (to.field_78795_f - from.field_78795_f) / maxTime * timer;
            from.field_78796_g += (to.field_78796_g - from.field_78796_g) / maxTime * timer;
            from.field_78808_h += (to.field_78808_h - from.field_78808_h) / maxTime * timer;
        } else {
            this.transitionAngles(from, to, timer, maxTime);
        }
        from.field_78800_c += (to.field_78800_c - from.field_78800_c) / maxTime * timer;
        from.field_78797_d += (to.field_78797_d - from.field_78797_d) / maxTime * timer;
        from.field_78798_e += (to.field_78798_e - from.field_78798_e) / maxTime * timer;
        from.field_82906_o += (to.field_82906_o - from.field_82906_o) / maxTime * timer;
        from.field_82908_p += (to.field_82908_p - from.field_82908_p) / maxTime * timer;
        from.field_82907_q += (to.field_82907_q - from.field_82907_q) / maxTime * timer;
    }

    public void transitionAngles(AdvancedModelRenderer from, AdvancedModelRenderer to, float timer, float maxTime) {
        from.field_78795_f += this.distance(from.field_78795_f, to.field_78795_f) / maxTime * timer;
        from.field_78796_g += this.distance(from.field_78796_g, to.field_78796_g) / maxTime * timer;
        from.field_78808_h += this.distance(from.field_78808_h, to.field_78808_h) / maxTime * timer;
    }

    public float distance(float rotateAngleFrom, float rotateAngleTo) {
        return (float)IAFMath.atan2_accurate(MathHelper.func_76126_a((float)(rotateAngleTo - rotateAngleFrom)), MathHelper.func_76134_b((float)(rotateAngleTo - rotateAngleFrom)));
    }

    public void rotate(ModelAnimator animator, AdvancedModelRenderer model, float x, float y, float z) {
        animator.rotate((ModelRenderer)model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void moveToPose(IceAndFireTabulaModel<? extends Entity> model, IceAndFireTabulaModel<? extends Entity> modelTo) {
        for (AdvancedModelRenderer cube : model.getCubes().values()) {
            float toZ;
            float toY;
            float toX;
            if (!this.isPartEqual(this.baseModel.getCube(cube.field_78802_n), modelTo.getCube(cube.field_78802_n))) {
                toX = modelTo.getCube((String)cube.field_78802_n).field_78795_f;
                toY = modelTo.getCube((String)cube.field_78802_n).field_78796_g;
                toZ = modelTo.getCube((String)cube.field_78802_n).field_78808_h;
                model.llibAnimator.rotate((ModelRenderer)cube, this.distance(cube.field_78795_f, toX), this.distance(cube.field_78796_g, toY), this.distance(cube.field_78808_h, toZ));
            }
            if (this.isPositionEqual(this.baseModel.getCube(cube.field_78802_n), modelTo.getCube(cube.field_78802_n))) continue;
            toX = modelTo.getCube((String)cube.field_78802_n).field_78800_c;
            toY = modelTo.getCube((String)cube.field_78802_n).field_78797_d;
            toZ = modelTo.getCube((String)cube.field_78802_n).field_78798_e;
            model.llibAnimator.move((ModelRenderer)cube, this.distance(cube.field_78800_c, toX), this.distance(cube.field_78797_d, toY), this.distance(cube.field_78798_e, toZ));
        }
    }
}

