/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockVenerableStump
extends Block {
    public static final PropertyEnum<StumpPart> PART = PropertyEnum.func_177709_a((String)"part", StumpPart.class);

    public BlockVenerableStump() {
        super(Material.field_151575_d);
        this.func_149663_c("iceandfire.venerable_stump");
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(12.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(IceAndFire.TAB_BLOCKS);
        this.func_149713_g(0);
        this.func_149715_a(0.13333334f);
        Blocks.field_150480_ab.func_180686_a((Block)this, 15, 1);
        this.field_149785_s = true;
        this.field_149787_q = false;
        this.setRegistryName("iceandfire", "venerable_stump");
    }

    @ParametersAreNonnullByDefault
    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((StumpPart)((Object)state.func_177229_b(PART))).boundingBox;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return ((StumpPart)((Object)blockState.func_177229_b(PART))).boundingBox;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PART});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return meta < StumpPart.values().length ? this.func_176223_P().func_177226_a(PART, (Comparable)((Object)StumpPart.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return ((StumpPart)((Object)state.func_177229_b(PART))).ordinal();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockFrom, BlockPos posFrom) {
        IBlockState stateFrom = world.func_180495_p(posFrom);
        if (stateFrom.func_177230_c() == Blocks.field_150480_ab && posFrom.equals((Object)pos.func_177984_a())) {
            BlockPos center = pos.func_177973_b(((StumpPart)((Object)state.func_177229_b(PART))).getFromCenter());
            for (StumpPart part : StumpPart.values()) {
                BlockPos firePos = center.func_177971_a(part.getFromCenter()).func_177984_a();
                if (world.func_175727_C(firePos)) continue;
                int age = (Integer)stateFrom.func_177229_b((IProperty)BlockFire.field_176543_a) + world.field_73012_v.nextInt(5) / 4;
                if (age > 15) {
                    age = 15;
                }
                world.func_180501_a(firePos, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(age)), 2);
                if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)firePos, (IBlockState)world.func_180495_p(firePos), EnumSet.allOf(EnumFacing.class), (boolean)true).isCanceled()) {
                    return;
                }
                world.func_190524_a(firePos.func_177976_e(), (Block)Blocks.field_150480_ab, firePos);
                world.func_190524_a(firePos.func_177974_f(), (Block)Blocks.field_150480_ab, firePos);
                world.func_190524_a(firePos.func_177984_a(), (Block)Blocks.field_150480_ab, firePos);
                world.func_190524_a(firePos.func_177978_c(), (Block)Blocks.field_150480_ab, firePos);
                world.func_190524_a(firePos.func_177968_d(), (Block)Blocks.field_150480_ab, firePos);
            }
        } else if (blockFrom == this && stateFrom.func_177230_c() != this && posFrom.func_177956_o() == pos.func_177956_o()) {
            StumpPart part = (StumpPart)((Object)state.func_177229_b(PART));
            if (part == StumpPart.MIDDLE) {
                world.func_175698_g(pos);
                return;
            }
            if (MathHelper.func_76130_a((int)(part.getFromCenter().func_177958_n() + posFrom.func_177958_n() - pos.func_177958_n())) > 1) {
                return;
            }
            if (MathHelper.func_76130_a((int)(part.getFromCenter().func_177952_p() + posFrom.func_177952_p() - pos.func_177952_p())) > 1) {
                return;
            }
            world.func_175698_g(pos);
        }
    }

    public static enum StumpPart implements IStringSerializable
    {
        NORTH_WEST(new Vec3i(-1, 0, -1), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.875, 1.0)),
        WEST(new Vec3i(-1, 0, 0), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.875, 1.0)),
        SOUTH_WEST(new Vec3i(-1, 0, 1), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.875, 0.8125)),
        NORTH(new Vec3i(0, 0, -1), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.875, 1.0)),
        MIDDLE(new Vec3i(0, 0, 0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)),
        SOUTH(new Vec3i(0, 0, 1), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 0.8125)),
        NORTH_EAST(new Vec3i(1, 0, -1), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.875, 1.0)),
        EAST(new Vec3i(1, 0, 0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.875, 1.0)),
        SOUTH_EAST(new Vec3i(1, 0, 1), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.875, 0.8125));

        private final Vec3i fromCenter;
        private final AxisAlignedBB boundingBox;

        private StumpPart(Vec3i fromCenter, AxisAlignedBB boundingBox) {
            this.fromCenter = fromCenter;
            this.boundingBox = boundingBox;
        }

        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public Vec3i getFromCenter() {
            return this.fromCenter;
        }

        public AxisAlignedBB getBoundingBox() {
            return this.boundingBox;
        }
    }
}

