/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIceSpikes
extends BlockDirectional {
    protected static final double heightUpMin = 0.0;
    protected static final double heightUpMax = 0.6875;
    protected static final double heightDownMin = 0.3125;
    protected static final double heightDownMax = 1.0;
    protected static final double squareMin = 0.0625;
    protected static final double squareMax = 0.9375;
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.6875, 0.9375, 0.9375);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.3125, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.6875);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0625, 0.0625, 0.3125, 0.9375, 0.9375, 1.0);
    protected static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.6875, 0.9375);
    protected static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.0625, 0.3125, 0.0625, 0.9375, 1.0, 0.9375);
    public Item itemBlock;

    public BlockIceSpikes() {
        super(Material.field_151598_x);
        this.func_149711_c(2.5f);
        this.func_149663_c("iceandfire.dragon_ice_spikes");
        this.func_149647_a(IceAndFire.TAB_BLOCKS);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.UP));
        this.setRegistryName("iceandfire", "dragon_ice_spikes");
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (!(entityIn instanceof EntityIceDragon)) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
            if (entityIn instanceof EntityLivingBase && entityIn.field_70159_w != 0.0 && entityIn.field_70179_y != 0.0) {
                ((EntityLivingBase)entityIn).func_70653_a(entityIn, 0.5f, entityIn.field_70159_w, entityIn.field_70179_y);
            }
        }
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)(meta + 1)));
    }

    public int func_176201_c(IBlockState state) {
        return (((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a() + 5) % 6;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        switch (enumfacing) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            default: {
                return AABB_NORTH;
            }
            case UP: {
                return AABB_UP;
            }
            case DOWN: 
        }
        return AABB_DOWN;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockIceSpikes.canPlaceBlock(worldIn, pos, side);
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockIceSpikes.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!BlockIceSpikes.canPlaceBlock(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)field_176387_N))) {
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }
}

